<?php

/**
 *
 * Created by PhpStorm.
 * User: Erick Gómez (https://github.com/ErickGomez98)
 * Date: 08/12/2018
 * Time: 12:18 PM
 */
class renovaciones_sys extends sys_tools
{

    /**
     * renovaciones_sys constructor.
     * @param $tipo
     * @param $data
     */
    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_base':
                    try {
                        $this->reporte_base($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base');
                    }
                    break;
                case 'nueva_renovacion_form':
                    try {
                        $this->nueva_renovacion_form($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'nueva_renovacion_form');
                    }
                    break;
                case 'capturar_renovacion':
                    try {
                        $this->capturar_renovacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_renovacion');
                    }
                    break;
                case 'eliminar_renovacion':
                    try {
                        $this->eliminar_renovacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'eliminar_renovacion');
                    }
                    break;
                case 'reactivate_renovacion':
                    try {
                        $this->reactivate_renovacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reactivate_renovacion');
                    }
                    break;
                case 'vista_renovacion':
                    try {
                        $this->vista_renovacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_renovacion');
                    }
                    break;
                case 'update_status':
                    try {
                        $this->update_status($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'update_status');
                    }
                    break;
                case 'enviar_reporte_correo':
                    try {
                        $this->enviar_reporte_correo($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'enviar_reporte_correo');
                    }
                    break;
                case 'vista_convertir_cotizacion':
                    try {
                        $this->vista_convertir_cotizacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_convertir_cotizacion');
                    }
                    break;
                case 'capturar_convertir_cotizacion':
                    try {
                        $this->capturar_convertir_cotizacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_convertir_cotizacion');
                    }
                    break;
                case 'edit_renovacion':
                    try {
                        $this->edit_renovacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'edit_renovacion');
                    }
                    break;
                case 'update_fecha_dominio_web':
                    try {
                        $this->update_fecha_dominio_web($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'update_fecha_dominio_web');
                    }
                    break;
            }
        }
    }

    /**
     * @param $datos
     * @throws Exception
     */
    private function reporte_base($datos)
    {
        global $user;
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;

        $query = db_select('partners_renovaciones', 'pr');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pr.id_cliente');
        $query->innerJoin('taxonomy_term_data', 'pt', 'pt.tid = pr.id_tipo');
        $query->innerJoin('users', 'u', 'u.uid = pr.created_by');
        $query->fields('pr');
        $query->fields('pc', array('nombre_cliente', 'email'));
        $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pr.id_contacto');
        $query->addField('pcc', 'email', 'email_contacto');
        $query->addField('pt', 'name', 'nombre_tipo_renovacion');
        $query->addField('u', 'name', 'nombre_usuario');
        $query->addField('u', 'mail', 'email_user');
        $query->condition('pr.renovacion_eliminada', '1', '!=');

        // Filtros
        if ($f_inicio == $f_final) {
            $f_final_same_day = $f_inicio + 86040;
            if ($datos->filter->start_date) {
                $query->condition('pr.fecha_renovacion', array($f_inicio, $f_final_same_day), 'BETWEEN');
            }
        } else {
            if ($datos->filter->start_date) {
                $query->condition('pr.fecha_renovacion', array($f_inicio, $f_final), 'BETWEEN');
            }
        }

        // Filtro - Usuario
        if ($datos->filter->usuario != 0) {
            $query->condition('pr.created_by', $datos->filter->usuario);
        }

        // Filtro - Tipo
        if ($datos->filter->tipo_renovacion != 0) {
            $query->condition('pr.id_tipo', $datos->filter->tipo_renovacion);
        }


        // Filtro - Search Bar
        if ($datos->filter->search_bar != null) {
            $servicio_or = db_or()
                ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pr.producto_servicio', '%' . $datos->filter->search_bar . '%', 'LIKE');
            $query->condition($servicio_or);
        }

        // Solamente filtrará por área cuando no sea supervisor
        if (!user_access('renovaciones_administrador')) {
            $in_groups_permisisons = [];
            if (in_array("CCTV", user_load($user->uid)->roles)) {
                $in_groups_permisisons[] = 1;
            }
            if (in_array("Ventas", user_load($user->uid)->roles)) {
                $in_groups_permisisons[] = 3;
            }
            if (in_array("Web", user_load($user->uid)->roles)) {
                $in_groups_permisisons[] = 4;
            }
            if (in_array("Soporte", user_load($user->uid)->roles)) {
                $in_groups_permisisons[] = 2;
            }

            // Pertenece a varios grupos, entonces mostrar las renovaciones en base
            // a todos esas areas.
            if (count($in_groups_permisisons) > 1) {
                $query->condition('pr.id_area_renovacion', $in_groups_permisisons, 'IN');
            } else {
                // Solo tiene un solo permiso, mostrar renovaciones solo de esa area.
                $query->condition('pr.id_area_renovacion', $in_groups_permisisons[0]);
            }
        }

        $query->orderBy($datos->sort->sort_by, $datos->sort->order);

        $query_datos = $query->execute();

        $renovaciones = [];
        while ($row = $query_datos->fetchAssoc()) {
            $folio = array("data" => $row['id_renovacion'], "class" => array("cursor-pointer", "vista_renovacion"));    
            $fecha = array("data" => date('d/m/y', $row['fecha_renovacion']), " class" => array("cursor-pointer", "vista_renovacion"));
            $usuario = array("data" => $row['nombre_usuario'], "class" => array("cursor-pointer", "vista_renovacion"));
            $cliente = array("data" => mb_substr($row['nombre_cliente'], 0, 20, "utf-8"), "class" => array("cursor-pointer", "vista_renovacion"));
            $tipo_renovacion = array("data" => $row['nombre_tipo_renovacion'], "class" => array("cursor-pointer", "vista_renovacion"));
            $producto = array("data" => mb_substr($row['producto_servicio'], 0, 20, "utf-8"), "class" => array("cursor-pointer", "vista_renovacion"));
            $desc = "Renovación de " . $row['nombre_tipo_renovacion'] . " : " . $row['producto_servicio'] . " | " . $row['nombre_cliente'];
            $frecuencia_texto = '';
            switch ($row['frecuencia_tipo']) {
                case 'WEEKLY' :
                    if ($row['frecuencia_intervalo'] == 1) {
                        $frecuencia_texto = array("data" => "Semanal", "class" => array("cursor-pointer", "vista_renovacion"));
                    } else {
                        $frecuencia_texto = array("data" => 'Cada ' . $row['frecuencia_intervalo'] . ' Semanas', "class" => array("cursor-pointer", "vista_renovacion"));
                    }
                    break;
                case 'MONTHLY' :
                    if ($row['frecuencia_intervalo'] == 1) {
                        $frecuencia_texto = array("data" => "Mensual", "class" => array("cursor-pointer", "vista_renovacion"));
                    } else {
                        $frecuencia_texto = array("data" => 'Cada ' . $row['frecuencia_intervalo'] . ' Meses', "class" => array("cursor-pointer", "vista_renovacion"));
                    }
                    break;
                case 'YEARLY' :
                    if ($row['frecuencia_intervalo'] == 1) {
                        $frecuencia_texto = array("data" => "Anual", "class" => array("cursor-pointer", "vista_renovacion"));
                    } else {
                        $frecuencia_texto = array("data" => 'Cada ' . $row['frecuencia_intervalo'] . ' Años', "class" => array("cursor-pointer", "vista_renovacion"));
                    }
                    break;
            }

            // Autorizado
            // 0: No, 1: Autoriza, 2: Proceso
            if ($row['frecuencia_tipo'] == 'YEARLY') {
                if ($row['autorizado'] == 0) {
                    $autorizado = array("data" => "No", "class" => array("status-red", "text-center"));
                } else if ($row['autorizado'] == 1) {
                    $autorizado = array("data" => "Si", "class" => array("status-green", "text-center"));
                } else if ($row['autorizado'] == 2) {
                    $autorizado = array("data" => "Proceso", "class" => array("status-red", "text-center"));
                }
            } else {
                $autorizado = array("data" => "N/A", "class" => array("text-center", "status-green"));
            }

            // Pagado
            if ($row['frecuencia_tipo'] == 'YEARLY') {
                if ($row['id_relacion_cotizacion'] == 0) {
                    if (user_access("renovaciones_vista_ventas") || user_access("renovaciones_administrador")) {
                        if ($row['pagado'] == 0) {
                            $pagado = array("data" => "No", "class" => array("status_pagado", "status-red", "text-center", "cursor-pointer"));
                        } else if ($row['pagado'] == 1) {
                            $pagado = array("data" => "Pagado", "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
                        } else if ($row['pagado'] == 2) {
                            $pagado = array("data" => "Factura", "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
                        }
                    } else {
                        if ($row['pagado'] == 0) {
                            $pagado = array("data" => "No", "class" => array("status-red", "text-center"));
                        } else if ($row['pagado'] == 1) {
                            $pagado = array("data" => "Pagado", "class" => array("status-green", "text-center"));
                        } else if ($row['pagado'] == 2) {
                            $pagado = array("data" => "Factura", "class" => array("status-green", "text-center"));
                        }
                    }
                } else {
                    if ($row['pagado'] == 0) {
                        $pagado = array("data" => "No", "class" => array("status-red", "text-center"));
                    } else if ($row['pagado'] == 1) {
                        $pagado = array("data" => "Pagado", "class" => array("status-green", "text-center"));
                    } else if ($row['pagado'] == 2) {
                        $pagado = array("data" => "Factura", "class" => array("status-green", "text-center"));
                    }
                }
            } else {
                $pagado = array("data" => "N/A", "class" => array("status-green", "text-center"));
            }

            // Recordatorio
            if ($row['frecuencia_tipo'] == 'YEARLY') {
                $recordatorio = array("data" => ($row['recordatorio'] == 1 ? 'Envío Auto' : 'No'), "class" => array(($row['recordatorio'] == 1 ? 'status-purple' : 'status-red'), "text-center"));
            } else {
                $recordatorio = array("data" => "N/A", "class" => array("status-green", "text-center"));
            }

            // Observaciones | Notas internas
            if ($row['observaciones'] != null) {
                $obs = array("data" => 'Obs', "class" => array("status-yellow", "renovaciones-observaciones", "text-center", "cursor-pointer"));
            } else {
                $obs = array("data" => 'Obs', "class" => array("text-center", "renovaciones-observaciones", "cursor-pointer"));
            }

            $pendiente_admon = array("data" => "<i class='fa fa-user-plus' aria-hidden='true'></i>", "class" => array("text-center", "crear_pendiente_admon", "cursor-pointer"), "style" => array("color:#337ab7;"));
            $precio = array("data" => number_format($row['precio'], 2, '.', ','), "class" => array("text-right", "cursor-pointer", "vista_renovacion"));
            $reenviar = array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "reenviar_renovacion"));
            $borrar = array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "eliminar_renovacion"));

            if ($row['id_relacion_cotizacion'] == 0) {
                $convertir_cotizacion = array("data" => '<i class="fa fa-exchange" aria-hidden="true"></i>', "class" => array("cursor-pointer", "convertir_cotizacion", "text-center"), "style" => array("color:#337ab7;"));
            } else {
                $convertir_cotizacion = array("data" => 'Cotización: ' . $row['id_relacion_cotizacion'], "data-id-cotizacion" => $row['id_relacion_cotizacion'], "class" => array("cursor-pointer", "text-center", "relacion_cotizacion"));
            }

            $numero_factura = array("data" => $this->get_numero_factura('partners_renovaciones', $row['id_renovacion']), "class" => array(($this->get_numero_factura('partners_renovaciones', $row['id_renovacion'])) ? "text-right cursor-pointer ver_factura" : ""));
            if (user_access("renovaciones_vista_ventas") || user_access("renovaciones_administrador")) {
                $renovaciones[] = array(
                    "data" => array(
                        $folio,
                        $fecha,
                        $usuario,
                        $cliente,
                        $tipo_renovacion,
                        $producto,
                        $frecuencia_texto,
                        $precio,
                        $recordatorio,
                        $autorizado,
                        $pendiente_admon,
                        $pagado,
                        $numero_factura,
                        $obs,
                        $reenviar,
                        $convertir_cotizacion,
                        $borrar
                    ),
                    "data-id-renovacion" => $row['id_renovacion'],
                    "data-id-cliente" => $row['id_cliente'],
                    "data-desc-renovacion" => $desc,
                    "data-email-cliente" => $row['email'],
                    "data-email-contacto" => $row['email_contacto'],
                    "data-email-user" => $row['email_user']
                );
            } else {
                $renovaciones[] = array(
                    "data" => array(
                        $folio,
                        $fecha,
                        $usuario,
                        $cliente,
                        $tipo_renovacion,
                        $producto,
                        $frecuencia_texto,
                        $precio,
                        $recordatorio,
                        $autorizado,
                        $pendiente_admon,
                        $pagado,
                        $obs,
                        $reenviar,
                        $convertir_cotizacion,
                    ),
                    "data-id-renovacion" => $row['id_renovacion'],
                    "data-id-cliente" => $row['id_cliente'],
                    "data-desc-renovacion" => $desc,
                    "data-email-cliente" => $row['email'],
                    "data-email-contacto" => $row['email_contacto'],
                    "data-email-user" => $row['email_user']
                );
            }
        }

        if (user_access("renovaciones_vista_ventas") || user_access("renovaciones_administrador")) {
            $header_cols = array(
                array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
                array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Producto", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Frecuencia", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Precio", "class" => "filter-number"), "sortable" => 0),
                array("name" => array("data" => "Aviso Auto", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Autoriza", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Pendiente", "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => "Pagado", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "N. Fact", "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => "Cotización", "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
            );
        } else {
            $header_cols = array(
                array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
                array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Producto", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Frecuencia", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Precio", "class" => "filter-number"), "sortable" => 0),
                array("name" => array("data" => "Aviso Auto", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Autoriza", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Pendiente", "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => "Pagado", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => "Cotización", "class" => "dont-filter"), "sortable" => 0)
            );
        }

        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);

        $table = array(
            "header" => $header,
            "rows" => $renovaciones,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_renovaciones", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;

    }

    /**
     *
     */
    private function nueva_renovacion_form()
    {
        global $user;

        // Primero validar si el usuario es supervisor, en caso de serlo, mostrara todos los disponibles sin
        // importar sus otros roles. Si no, solamente mostrara los del rol al que pertenece
        if (in_array("Supervisor", user_load($user->uid)->roles)) {
            $vid_c = taxonomy_vocabulary_machine_name_load("renovaciones_cctv")->vid;
            $terms_c = taxonomy_get_tree($vid_c);
            foreach ($terms_c as $key => $val) {
                $datos[] = array("name" => $val->name, "tid" => $val->tid);
            }
            $vid_v = taxonomy_vocabulary_machine_name_load("renovaciones_ventas")->vid;
            $terms_v = taxonomy_get_tree($vid_v);
            foreach ($terms_v as $key => $val) {
                $datos[] = array("name" => $val->name, "tid" => $val->tid);
            }

            $vid_w = taxonomy_vocabulary_machine_name_load("renovaciones_web")->vid;
            $terms_w = taxonomy_get_tree($vid_w);
            foreach ($terms_w as $key => $val) {
                $datos[] = array("name" => $val->name, "tid" => $val->tid);
            }

            $vid_s = taxonomy_vocabulary_machine_name_load("renovaciones_soporte")->vid;
            $terms_s = taxonomy_get_tree($vid_s);
            foreach ($terms_s as $key => $val) {
                $datos[] = array("name" => $val->name, "tid" => $val->tid);
            }
        } else {
            if (in_array("CCTV", user_load($user->uid)->roles)) {
                $vid = taxonomy_vocabulary_machine_name_load("renovaciones_cctv")->vid;
                $terms = taxonomy_get_tree($vid);
                foreach ($terms as $key => $val) {
                    $datos[] = array("name" => $val->name, "tid" => $val->tid);
                }
            }
            if (in_array("Ventas", user_load($user->uid)->roles)) {
                $vid = taxonomy_vocabulary_machine_name_load("renovaciones_ventas")->vid;
                $terms = taxonomy_get_tree($vid);
                foreach ($terms as $key => $val) {
                    $datos[] = array("name" => $val->name, "tid" => $val->tid);
                }
            }
            if (in_array("Web", user_load($user->uid)->roles)) {
                $vid = taxonomy_vocabulary_machine_name_load("renovaciones_web")->vid;
                $terms = taxonomy_get_tree($vid);
                foreach ($terms as $key => $val) {
                    $datos[] = array("name" => $val->name, "tid" => $val->tid);
                }
            }
            if (in_array("Soporte", user_load($user->uid)->roles)) {
                $vid = taxonomy_vocabulary_machine_name_load("renovaciones_soporte")->vid;
                $terms = taxonomy_get_tree($vid);
                foreach ($terms as $key => $val) {
                    $datos[] = array("name" => $val->name, "tid" => $val->tid);
                }
            }
        }


        $template = render_template('php', 'renovaciones.nueva_renovacion_form', $datos);
        $this->throw_message('success', $template);
    }

    /**
     * @param $datos
     * @throws Exception
     */
    private function capturar_renovacion($datos)
    {
        global $user;
        $name_taxonomy = taxonomy_term_load($datos->tipo_renovacion)->name;
        $descripcion_pendiente = "Renovación de " . $name_taxonomy . " : " . $datos->producto_renovacion . " | " . $datos->detalle_producto_renovacion;
        $tid_vocavolary_name = taxonomy_term_load($datos->tipo_renovacion)->vocabulary_machine_name;
        $area_renovacion = 0;
        switch ($tid_vocavolary_name) {
            case 'renovaciones_web':
                $area_renovacion = 4;
                break;
            case 'renovaciones_cctv':
                $area_renovacion = 1;
                break;
            case 'renovaciones_soporte':
                $area_renovacion = 2;
                break;
            case 'renovaciones_ventas':
                $area_renovacion = 3;
                break;
        }

        $token = $this->getToken(10);
        $i = 0;
        foreach ($datos->fechas as $fecha) {
            $i++;
            db_insert('partners_renovaciones')
                ->fields(array(
                    'created_at' => REQUEST_TIME,
                    'created_by' => $user->uid,
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $user->uid,
                    'id_cliente' => $datos->id_cliente,
                    'id_contacto' => (isset($datos->id_contacto) && $datos->id_contacto != '') ? $datos->id_contacto : null,
                    'id_tipo' => $datos->tipo_renovacion,
                    'id_area_renovacion' => $area_renovacion,
                    'producto_servicio' => $datos->producto_renovacion,
                    'detalle' => $datos->detalle_producto_renovacion,
                    'fecha_inicio' => strtotime($datos->fecha_renovacion),
                    'fecha_renovacion' => $fecha,
                    'frecuencia_intervalo' => $datos->frecuencia_intervalo,
                    'frecuencia_tipo' => $datos->frecuencia_tipo,
                    'precio' => strtr($datos->precio_producto_renovacion, array(',' => '')),
                    'observaciones' => ($datos->notas_internas) ? $this->serialize_obs($datos->notas_internas, 1) : null,
                    'token_relacion_renovacion' => $token . $i
                ))
                ->execute();

            db_insert('partners_pendientes')
                ->fields(array(
                    'created_at' => REQUEST_TIME,
                    'created_by' => $user->uid,
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $user->uid,
                    'tipo_pendiente' => 3,
                    'area_pendiente' => $area_renovacion,
                    'id_cliente' => $datos->id_cliente,
                    'asignado_para' => $user->uid,
                    'fecha_pendiente' => $fecha,
                    'descripcion_pendiente' => $descripcion_pendiente,
                    'status' => 1,
                    'horario_pendiente' => '',
                    'prioridad_pendiente' => 5,
                    'que_llevar_pendiente' => '',
                    'token_relacion_renovacion' => $token . $i
                ))
                ->execute();
        }

        # Si se paso el id_dominio, entonces esta renovación viene del proceso de crear un nuevo dominio web,
        # entonces solo hay que vincular esta renovación con el id_dominio.
        if (isset($datos->id_dominio) && isset($datos->nombre_dominio)) {
            db_update('partners_dominios_web')
                ->fields(array(
                    'token_relacion_renovacion' => $token
                ))
                ->condition('id_dominio', $datos->id_dominio)
                ->execute();

            $this->register_log_actions('partners_dominios_web', 'update',
                "Se vinculó una renovación($token) con el dominio ($datos->id_dominio , $datos->nombre_dominio");
        }

        $this->register_log_actions('partners_renovaciones', 'insert', 'Se creó una renovación cada ' . $datos->frecuencia_intervalo . ' (' . $datos->frecuencia_tipo . ') junto con sus respectivos pendientes con la descripción: ' . $descripcion_pendiente);
        $this->throw_message('success', 'Renovación Creada Correctamente.');
    }

    /**
     * @param $id_renovacion
     * @throws Exception
     */
    private function eliminar_renovacion($id_renovacion)
    {
        $get_token = db_select('partners_renovaciones', 'pr')
            ->fields('pr', array('token_relacion_renovacion'))
            ->condition('id_renovacion', $id_renovacion)
            ->execute()->fetchField();

        $token = substr($get_token, 0, 10);
        $fecha_actual = REQUEST_TIME - 86400;
        db_update('partners_renovaciones')
            ->fields(array(
                'renovacion_eliminada' => 1
            ))
            ->condition('token_relacion_renovacion', '%' . $token . '%', 'LIKE')
            ->condition('fecha_renovacion', $fecha_actual, '>')
            ->execute();

        db_update('partners_pendientes')
            ->fields(array(
                'cancelado' => 1
            ))
            ->condition('token_relacion_renovacion', '%' . $token . '%', 'LIKE')
            ->condition('fecha_pendiente', $fecha_actual, '>')
            ->execute();


        $this->throw_message('success', 'Renovación Eliminada correctamente.');
        $this->register_log_actions('partners_renovaciones', 'delete', 'Se eliminaron las renovaciones con el token: ' . $token);

    }

    /**
     * @param $id_renovacion
     * @throws Exception
     */
    private function reactivate_renovacion($id_renovacion)
    {
        $get_token = db_select('partners_renovaciones', 'pr')
            ->fields('pr', array('token_relacion_renovacion'))
            ->condition('id_renovacion', $id_renovacion)
            ->execute()->fetchField();

        $token = substr($get_token, 0, 10);
        $fecha_actual = REQUEST_TIME - 86400;
        db_update('partners_renovaciones')
            ->fields(array(
                'renovacion_eliminada' => 0
            ))
            ->condition('token_relacion_renovacion', '%' . $token . '%', 'LIKE')
            ->condition('fecha_renovacion', $fecha_actual, '>')
            ->execute();

        db_update('partners_pendientes')
            ->fields(array(
                'cancelado' => 0
            ))
            ->condition('token_relacion_renovacion', '%' . $token . '%', 'LIKE')
            ->condition('fecha_pendiente', $fecha_actual, '>')
            ->execute();


        $this->throw_message('success', 'Renovación Reactivada correctamente.');
        $this->register_log_actions('partners_renovaciones', 'update', 'Se reactivaron las renovaciones con el token: ' . $token);
    }

    /**
     * @param $id_renovacion
     */
    private function vista_renovacion($id_renovacion)
    {
        $query = db_select('partners_renovaciones', 'pr');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pr.id_cliente');
        $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pr.id_contacto');
        $query->innerJoin('taxonomy_term_data', 'pt', 'pt.tid = pr.id_tipo');
        $query->leftJoin('field_data_field_nombre_completo', 'f', 'f.entity_id = pr.created_by');
        $query->fields('pr');
        $query->addField('f', 'field_nombre_completo_value', 'nombre_usuario');
        $query->fields('pc', array('nombre_cliente', 'tipo_clasificacion', 'credito', 'tipo_cliente'));
        $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $query->addField('pcc', 'tipo_cliente', 'tipo_contacto');
        $query->addField('pt', 'name', 'nombre_tipo_renovacion');
        $query->condition('pr.id_renovacion', $id_renovacion);
        $renovacion = $query->execute()->fetchAssoc();

        $frecuencia = $renovacion['frecuencia_tipo'];
        $intervalo = $renovacion['frecuencia_intervalo'];
        switch ($frecuencia) {
            case 'WEEKLY' :
                if ($intervalo == 1) {
                    $frecuencia_texto = 'Semanal';
                } else {
                    $frecuencia_texto = 'Cada ' . $intervalo . ' Semanas';
                }
                break;
            case 'MONTHLY' :
                if ($intervalo == 1) {
                    $frecuencia_texto = 'Mensual';
                } else {
                    $frecuencia_texto = 'Cada ' . $intervalo . ' Meses';
                }
                break;
            case 'YEARLY' :
                if ($intervalo == 1) {
                    $frecuencia_texto = 'Anual';
                } else {
                    $frecuencia_texto = 'Cada ' . $intervalo . ' Años';
                }
                break;
        }

        $datos['renovacion'] = $renovacion;
        $datos['frecuencia'] = $frecuencia_texto;
        $template = render_template('php', 'renovaciones.vista_renovacion', $datos);
        $this->throw_message('success', $template);
    }

    /**
     * @param $datos
     * @throws Exception
     */
    private function update_status($datos)
    {
        global $user;
        if (isset($datos->obs) && $datos->obs != '') {
            db_update('partners_renovaciones')
                ->fields(array(
                    $datos->col => $datos->new_val,
                    'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_renovaciones', 'id_renovacion', $datos->id_renovacion)
                ))
                ->condition('id_renovacion', $datos->id_renovacion)
                ->execute();
        } else {
            db_update('partners_renovaciones')
                ->fields(array(
                    $datos->col => $datos->new_val,
                ))
                ->condition('id_renovacion', $datos->id_renovacion)
                ->execute();
        }

        if (isset($datos->facturado) && $datos->facturado != '') {
            $this->track_down_facturado($datos->numero_factura, $datos->id_renovacion, "Renovaciones", "partners_renovaciones");
        }

        $this->register_log_actions('partners_renovacoines', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
        $this->throw_message('success', "Cambios Guardados");
    }

    /**
     * @param $datos
     * @throws Exception
     */
    private function enviar_reporte_correo($datos)
    {
        $query = db_select('partners_renovaciones', 'pr');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pr.id_cliente');
        $query->innerJoin('taxonomy_term_data', 'pt', 'pt.tid = pr.id_tipo');
        $query->innerJoin('users', 'u', 'u.uid = pr.created_by');
        $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pr.id_contacto');
        $query->innerJoin('field_data_field_nombre_completo', 'f', 'f.entity_id = pr.created_by');
        $query->addField('f', 'field_nombre_completo_value', 'nombre_usuario');
        $query->fields('pr');
        $query->fields('pc', array('nombre_cliente'));
        $query->addField('pt', 'name', 'nombre_tipo_renovacion');
        $query->addField('u', 'mail', 'email_user');
        $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $query->condition('pr.id_renovacion', $datos->id_renovacion);
        $renovacion = $query->execute()->fetchAssoc();

        $data['fecha_renovacion'] = $renovacion['fecha_renovacion'];
        $data['renovacion'] = "Renovación de " . $renovacion['nombre_tipo_renovacion'] . ': ' . $renovacion['producto_servicio'];
        $data['mail'] = $renovacion['email_user'];
        $data['body'] = $datos->body;

        $from = [$renovacion['email_user'] => 'Pc Partners - Renovaciones'];
        $to = $datos->to;
        $to[] = $renovacion['email_user'];
        if ($renovacion['id_contacto']) {
            $data['nombre'] = $renovacion['nombre_contacto'];
        } else {
            $data['nombre'] = $renovacion['nombre_cliente'];
        }

        $subject = 'Pc Partners - Recordatorio de Renovación';
        $this->send_mail('renovaciones.email_recordatorio', $data, $subject, $from, $to);
        $this->throw_message('success', 'Bien!');
    }

    /**
     * @param $id_renovacion
     */
    private function vista_convertir_cotizacion($id_renovacion)
    {
        $query = db_select('partners_renovaciones', 'pr');
        $query->fields('pr', array('id_renovacion', 'producto_servicio', 'precio', 'id_cliente', 'id_contacto'));
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pr.id_cliente');
        $query->fields('pc', array('nombre_cliente', 'tipo_cliente'));
        $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pr.id_contacto');
        $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $query->addField('pcc', 'tipo_cliente', 'tipo_contacto');
        $query->condition('id_renovacion', $id_renovacion);
        $renovacion = $query->execute()->fetchAssoc();


        $role = user_role_load_by_name('Todos');
        $query = 'SELECT ur.uid
        FROM {users_roles} AS ur
        WHERE ur.rid = :rid';
        $result = db_query($query, array(':rid' => $role->rid));
        $uids = $result->fetchCol();

        $usuarios = db_select('users', 'u')
            ->fields('u', array('uid', 'name'))
            ->condition('status', 1)
            ->condition('uid', $uids, 'IN')
            ->condition('uid', 26, '!=')
            ->orderBy('name', 'ASC')
            ->execute()->fetchAll(PDO::FETCH_ASSOC);
        $datos['usuarios'] = $usuarios;
        $datos['renovacion'] = $renovacion;
        $template = render_template('php', 'renovaciones.vista_convertir_cotizacion', $datos);
        $this->throw_message('success', $template);
    }

    /**
     * @param $datos
     * @throws Exception
     */
    private function capturar_convertir_cotizacion($datos)
    {
        global $user;
        $area = 0;
        if (in_array("CCTV", user_load($user->uid)->roles)) {
            $area = 1;
        } else if (in_array("Soporte", user_load($user->uid)->roles)) {
            $area = 2;
        } else if (in_array("Ventas", user_load($user->uid)->roles)) {
            $area = 3;
        } else if (in_array("Web", user_load($user->uid)->roles)) {
            $area = 4;
        } else if (in_array("Admon", user_load($user->uid)->roles)) {
            $area = 5;
        }
        $id_cotizacion = db_insert('partners_cotizaciones')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => $user->uid,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid,
                'id_cliente' => $datos->id_cliente,
                'id_contacto' => $datos->id_contacto,
                'cotizacion_compartida' => ($datos->radio_seleccion_cotizacion_compartida) ? $datos->radio_seleccion_cotizacion_compartida : 0,
                'cotizacion_compartida_con' => $datos->compartida_con,
                'notas' => $datos->notas_cotizacion,
                'iva_incluido' => ($datos->cotizacion_iva_incluido) ? $datos->cotizacion_iva_incluido : 0,
                'sin_sumatoria' => ($datos->sin_sumatoria) ? $datos->sin_sumatoria : 0,
                'tipo_cotizacion' => 1,
                'id_area' => $area,
                'id_relacion_renovacion' => $datos->id_renovacion
            ))
            ->execute();

        foreach ($datos->datos as $dato) {
            db_insert('partners_cotizaciones_datos')
                ->fields(array(
                    'id_cotizacion' => $id_cotizacion,
                    'cantidad' => $dato->cantidad,
                    'descripcion' => $dato->descripcion,
                    'precio' => $dato->precio,
                    'tipo' => 0
                ))
                ->execute();
        }

        db_update('partners_renovaciones')
            ->fields(array(
                'id_relacion_cotizacion' => $id_cotizacion
            ))
            ->condition('id_renovacion', $datos->id_renovacion)
            ->execute();
        $this->register_log_actions('partners_cotzaciones', 'insert', 'Se creó una cotización en base a la renovación: ' . $datos->id_renovacion);
        $this->throw_message('success', $id_cotizacion);

    }


    /**
     * Actualiza todas las renovaciones futuras en base a la que se está editando.
     * @param $datos
     */
    private function edit_renovacion($datos)
    {
        $get_token = db_select('partners_renovaciones', 'pr')
            ->fields('pr', array('token_relacion_renovacion'))
            ->condition('id_renovacion', $datos->edit_id)
            ->execute()->fetchField();

        $token = substr($get_token, 0, 10);

        db_update('partners_renovaciones')
            ->fields(array(
                $datos->edit_col => $datos->new_val
            ))
            ->condition('fecha_renovacion', REQUEST_TIME, '>')
            ->condition('token_relacion_renovacion', '%' . $token . '%', 'LIKE')
            ->execute();

        $this->throw_message('success', "Renovaciones futuras actualizadas.");
    }

    /**
     * Este método se ejecuta cuando en una renovación se hace un pago, con la finalidad de después
     * buscar en el panel de dominios_web, un dominio que este relacionado con esta renovación para
     * después poderle aumentar las fechas de expiración por un año más.
     * @param $id_renovacion
     * @throws Exception
     */
    private function update_fecha_dominio_web($id_renovacion)
    {
        # Sacar el token de renovacion
        $get_token = db_select('partners_renovaciones', 'pr')
            ->fields('pr', array('token_relacion_renovacion'))
            ->condition('id_renovacion', $id_renovacion)
            ->execute()->fetchField();

        $token = substr($get_token, 0, 10);

        # Buscar a ver si existe un registro en la tabla de dominios_web que tenga el token de esta renovación.
        $get_dominio = db_select('partners_dominios_web', 'pdw');
        $get_dominio->fields('pdw',
            array('id_dominio', 'fecha_expira_dominio', 'fecha_expira_hosting', 'dominio_partners'));
        $get_dominio->condition('token_relacion_renovacion', $token);
        $get_dominio->condition('dominio_eliminado', 1, '!=');
        $dominio = $get_dominio->execute()->fetchAssoc();

        if (!$dominio) {
            $this->throw_message('success', 'No existe ningún dominio activo para relacionar.');
        } else {

            if ($dominio['fecha_expira_hosting']) {
                $new_hosting_date = strtotime(date("Y-m-d", $dominio['fecha_expira_hosting']) . " + 365 day");

                # Solamente cuando nosotros tengamos el dominio se va a mover esta fecha también.
                if ($dominio['dominio_partners'] == 1) {
                    $new_domain_date = strtotime(date("Y-m-d", $dominio['fecha_expira_dominio']) . " + 365 day");
                } else {
                    $new_domain_date = $dominio['fecha_expira_dominio'];
                }

                # Ahora con las dos fechas modificadas, actualizarlas en el dominio que corresponde.
                db_update('partners_dominios_web')
                    ->fields(array(
                        'fecha_expira_hosting' => $new_hosting_date,
                        'fecha_expira_dominio' => $new_domain_date
                    ))
                    ->condition('id_dominio', $dominio['id_dominio'])
                    ->execute();

                $this->register_log_actions('partners_dominios_web',
                    'update', 'Se actualizaron las fechas de expiración del dominio: '
                    . $dominio['id_dominio'] . ' porque se pagó una renovación relacionada a este dominio.');

                $this->throw_message('success', 'Fechas de expiración del dominio actualizadas correctamente');
            }
        }
    }

}
