<?php

use PhpOffice\PhpSpreadsheet\Spreadsheet;

/**
 *
 * Created by PhpStorm.
 * User: Erick Gómez (https://github.com/ErickGomez98)
 * Date: 10/12/2018
 * Time: 06:44 PM
 */
class recibo_sys extends sys_tools
{

  /**
   * recibo_sys constructor.
   * @param $tipo
   * @param $data
   */
  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'reporte_base':
          try {
            $this->reporte_base($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base');
          }
          break;
        case 'capturar_recibo':
          try {
            $this->capturar_recibo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_recibo');
          }
          break;
        case 'render_vista':
          try {
            $this->render_recibo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'render_recibo');
          }
          break;
        case 'enviar_recibo_correo':
          try {
            $this->enviar_recibo_correo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'enviar_recibo_correo');
          }
          break;
        case 'update_status':
          try {
            $this->update_status($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'update_status');
          }
          break;
        case 'cancelar_recibo':
          try {
            $this->cancelar_recibo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'cancelar_recibo');
          }
          break;
        case 'reactivate_recibo':
          try {
            $this->reactivate_recibo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reactivate_recibo');
          }
          break;
        case 'export_excel':
          try {
            $this->export_excel($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'export_excel');
          }
          break;
        case 'export_excel_reporte':
          try {
            $this->export_excel_reporte($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'export_excel_reporte');
          }
          break;
        case 'reporte_base_reporte':
          try {
            $this->reporte_base_reporte($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base_reporte');
          }
          break;
        case 'vista_compras_producto':
          try {
            $this->vista_compras_producto($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_compras_producto');
          }
          break;
        case 'modificar_costo':
          try {
            $this->modificar_costo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'modificar_costo');
          }
          break;
        case 'change_status':
          try {
            $this->change_status($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'change_status');
          }
          break;
        case 'get_recibos':
          try {
            $this->get_recibos($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_recibos');
          }
          break;
        case 'get_liquidacion':
          try {
            $this->get_liquidacion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_liquidacion');
          }
          break;
        case 'marcar_facturado':
          try {
            $this->marcar_facturado($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'marcar_facturado');
          }
          break;
      }
    }
  }

  /**
   * @param $datos
   * @throws Exception
   */
  private function reporte_base($datos)
  {
    global $user;
    $fi = str_replace('/', '-', trim($datos->filter->start_date));
    $ff = str_replace('/', '-', trim($datos->filter->end_date));
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;

    $query = db_select('partners_recibo', 'pr');
    $query->fields('pr');
    $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = pr.id_cliente');
    $query->fields('pc', array('nombre_cliente', 'email'));
    $query->leftJoin('partners_recibo_datos', 'prd', 'prd.id_recibo = pr.id_recibo');
    $query->addExpression("GROUP_CONCAT(prd.descripcion SEPARATOR '|')", 'desc_piezas');
    // Filtros
    if ($f_inicio == $f_final) {
      $f_final_same_day = $f_inicio + 86040;
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_recibo', array($f_inicio, $f_final_same_day), 'BETWEEN');
      }
    } else {
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_recibo', array($f_inicio, $f_final), 'BETWEEN');
      }
    }

    // Filtro - Search Bar
    if ($datos->filter->search_bar != null) {
      $recibo_or = db_or()
        ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pr.id_recibo', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pr.concepto', '%' . $datos->filter->search_bar . '%', 'LIKE');
      $query->condition($recibo_or);
    }

    // Filtro - Usuario
    if ($datos->filter->usuario != 0) {
      $query->condition('pr.created_by', $datos->filter->usuario);
    }

    // Filtro - Agente
    if ($datos->filter->agente != 0) {
      $query->condition('pr.agente', $datos->filter->agente);
    }

    // Solamente filtrará personales cuando no se administre el panel
    if (!user_access('recibos_administrador') && !user_access('recibos_auxiliar')) {
      $query->condition('pr.created_by', $user->uid);
    }

    $query->orderBy($datos->sort->sort_by, $datos->sort->order);
    $query->groupBy('pr.id_recibo');
    $query_datos = $query->execute();
    $recibos = [];
    while ($row = $query_datos->fetchAssoc()) {
      switch ($row['agente']) {
        case 1:
          $agent = "Ventas";
          break;
        case 2:
          $agent = "Admon";
          //$agent = "Roberto";
          break;
        case 3:
          $agent = "CCTV";
          break;
        case 4:
          $agent = "Servicio";
          break;
        case 5:
          $agent = "Web";
          break;
      }
      $folio = array("data" => "R-" . $row['id_recibo'], "class" => array("cursor-pointer", "vista_recibo"));
      $fecha = array("data" => date('d/m/y', $row['fecha_recibo']), "class" => array("cursor-pointer", "vista_recibo"));
      $usuario = array("data" => user_load($row['created_by'])->name, "class" => array("cursor-pointer", "vista_recibo"));
      $agente = array("data" => $agent, "class" => array("cursor-pointer", "vista_recibo"));
      $cliente = array("data" => ($row['tipo_cliente'] == 1) ? mb_substr($row['nombre_cliente'], 0, 20, "utf-8") : mb_substr($row['otro_cliente'], 0, 20, "utf-8"), "class" => array("cursor-pointer", "vista_recibo"));
      if ($row['tipo_recibo'] == 1) {
        $concepto = array("data" => mb_substr($row['concepto'], 0, 50, "utf-8"), "class" => array("cursor-pointer", "vista_recibo"));
      } else {
        $concepto = array("data" => mb_substr($row['desc_piezas'], 0, 50, "utf-8"), "class" => array("cursor-pointer", "vista_recibo"));
      }
      $precio = array("data" => ($row['cantidad'] == 0 && $row['recibo_cancelado'] == 1) ? 'Cancelado' : number_format($row['cantidad'], 2, '.', ','), "class" => array("cursor-pointer", "vista_recibo", "text-right"));

      // Procesado
      switch ((int)$row['procesado']) {
        case 0:
          if ($row['cantidad'] == 0) {
            $procesado = array("data" => "Cancelado", "class" => array("status-red", "text-center"));
          } else {
            $procesado = array("data" => "No", "class" => array("status_procesado", "status-red", "text-center", "cursor-pointer"));
          }
          break;
        case 1:
          $procesado = array("data" => "Efectivo", "class" => array("status-green", "text-center")); // Recibo normal o liquidación
          break;
        case 2:
          $procesado = array("data" => "Cheque", "class" => array("status-green", "text-center"));
          break;
        case 3:
          $procesado = array("data" => "Tarjeta", "class" => array("status-green", "text-center"));
          break;
        case 4:
          $procesado = array("data" => "Otro", "class" => array("status-green", "text-center"));
          break;
        case 5:
          $procesado = array("data" => "Por facturar", "class" => array("status-red", "text-center", "servicio_facturado", "cursor-pointer")); // Recibo normal o liquidación
          break;
        case 6:
          $procesado = array("data" => "Pendiente", "class" => array("recibo_pagado", "cursor-pointer", "status-red", "text-center"));
          break;
        case 7:
          $procesado = array("data" => "Anticipo", "class" => array("status-green", "text-center")); // Anticipo en efectivo
          break;
        case 8:
          $procesado = array("data" => "Por facturar", "class" => array("status-red", "text-center",  "servicio_facturado", "cursor-pointer")); // Anticipo con tarjeta
          break;
        case 9: // Tarjeta, ligado a una factura
          $procesado = array("data" => $row['folio_factura'], "class" => array("status-green", "text-center", "cursor-pointer", "ver_factura")); // Anticipo con tarjeta
          break;
        case 10: // Por cobrar con tarjeta (por facturar)
          $procesado = array("data" => "Pendiente", "class" => array("recibo_pagado_tarjeta", "cursor-pointer", "status-red", "text-center"));
          break;
      }

      // Reporte
      // Se removio la clase status_reporte (que cambiaba el valor)
      if ($row['reporte'] == 1) {
        $reporte = array("data" => "Si", "class" => array("status-green",  "text-center"));
      } else if ($row['reporte'] == 0) {
        $reporte = array("data" => "No", "class" => array("status-red",  "text-center"));
      }

      // Observaciones | Notas internas
      if ($row['observaciones'] != null) {
        $obs = array("data" => 'Obs', "class" => array("status-yellow", "recibo-observaciones", "text-center", "cursor-pointer"));
      } else {
        $obs = array("data" => 'Obs', "class" => array("text-center", "recibo-observaciones", "cursor-pointer"));
      }
      $anticipo = false;
      if ($row['liquidado'] == 0) {
        $cant_abono = $row['cantidad_anticipo'];
        if (!((float)$cant_abono > 0) && $row['proceso'] < 7) {
          $anticipo = array("data" => "NA", "class" => array("text-right"));
        } else {
          $anticipo = array("data" => (number_format($row['cantidad_anticipo'], 2, '.', ',')), "class" => array("text-right"));
        }
      } else if ($row['liquidado'] == 1 && $row['id_liquidado'] != 0) {
        $anticipo = array("data" => "Liquidado", "class" => array("text-center", "cursor-pointer", "vista_liquidacion"), "data-id-liquidado" => $row['id_liquidado'], "data-id-recibo" => $row['id_recibo']);
      } else {
        $anticipo = array("data" => "NA", "class" => array("text-right"));
      }

      $reenviar = array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "reenviar_recibo"));
      $cancelar = array("data" => '<i class="fa fa-ban" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "cancelar_recibo"));


      // Control Absoluto
      if (user_access('recibos_administrador')) {
        $recibos[] = array(
          "data" => array(
            $folio,
            $fecha,
            $usuario,
            $agente,
            $cliente,
            $concepto,
            $precio,
            $anticipo,
            $procesado,
            $reporte,
            $obs,
            $reenviar,
            $cancelar
          ),
          "data-id-recibo" => $row['id_recibo'],
          "data-id-cliente" => $row['id_cliente'],
          "data-nombre-cliente" => ($row['tipo_cliente'] == 1) ? $row['nombre_cliente'] : $row['otro_cliente'],
          "data-cantidad" => $row['cantidad'],
          "data-reporte" => $row['reporte'],
          "data-email-cliente" => $row['email'],
          "data-email-user" => $user->mail
        );
      } else if (user_access('recibos_auxiliar')) {
        // Sin posibilidad de cancelar
        $recibos[] = array(
          "data" => array(
            $folio,
            $fecha,
            $usuario,
            $agente,
            $cliente,
            $concepto,
            $precio,
            $anticipo,
            $procesado,
            $reporte,
            $obs,
            $reenviar,
          ),
          "data-id-recibo" => $row['id_recibo'],
          "data-id-cliente" => $row['id_cliente'],
          "data-nombre-cliente" => ($row['tipo_cliente'] == 1) ? $row['nombre_cliente'] : $row['otro_cliente'],
          "data-cantidad" => $row['cantidad'],
          "data-reporte" => $row['reporte'],
          "data-email-cliente" => $row['email'],
          "data-email-user" => $user->mail
        );
      } else {
        // Recibos Personales
        $recibos[] = array(
          "data" => array(
            $folio,
            $fecha,
            $usuario,
            $agente,
            $cliente,
            $concepto,
            $precio,
            $anticipo,
            $obs,
            $reenviar
          ),
          "data-id-recibo" => $row['id_recibo'],
          "data-id-cliente" => $row['id_cliente'],
          "data-nombre-cliente" => ($row['tipo_cliente'] == 1) ? $row['nombre_cliente'] : $row['otro_cliente'],
          "data-cantidad" => $row['cantidad'],
          "data-reporte" => $row['reporte'],
          "data-email-cliente" => $row['email'],
          "data-email-user" => $user->mail
        );
      }
    }

    // Header -- Sort
    if (user_access('recibos_administrador')) {
      $header_cols = array(
        array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Agente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Concepto", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cantidad", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Anticipo", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Procesado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Reporte", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-ban" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
      );
    } else if (user_access('recibos_auxiliar')) {
      // Sin posibilidad de cancelar
      $header_cols = array(
        array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Agente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Concepto", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cantidad", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Anticipo", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Procesado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Reporte", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
      );
    } else {
      // Recibos Personales
      $header_cols = array(
        array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Agente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Concepto", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cantidad", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Anticipo", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
      );
    }

    $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);

    $table = array(
      "header" => $header,
      "rows" => $recibos,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_recibo", "class" => array("table-sm"))
    );

    $result = theme('table', $table);

    echo $result;
  }

  /**
   * @param $datos
   * @throws Exception
   */
  private function capturar_recibo($datos)
  {
    global $user, $base_root;
    // El area de ventas es el unico que pasa la columna "reporte" en Si, dependiendo de los criterios
    $proceso = $datos->tipo_proceso;
    $area = $datos->agente_recibo;
    $enviar_mail = false;
    $tipo_pago = $datos->tipo_pago; // 1 : efectivo, 2 : tarjeta
    $cantidad = $datos->cantidad_recibo;
    $cantidad_total = $datos->cantidad_total;
    $cantidad_anticipo = $datos->cantidad_anticipo;
    $cantidad_abono = $datos->cantidad_abono;
    $anticipo = false;
    switch ($proceso) {
      case '1': // Recibo
        // Efectivo pone "procesado" en verde, envia a caja y pone "reporte" en si
        $reporte = 1; // marcar columna reporte en verde con SI

        if ($tipo_pago == 1) {
          $procesado = 1; // En DB procesado = 1 : Efectivo
        }
        // Tarjeta no envia a caja y todo es rojo, envia correo
        else if ($tipo_pago == 2) {
          $procesado = 5; // En DB procesado = 5 : Por facturar - Tarjeta
          $reporte = 0;
          $enviar_mail = true;
        }
        break;
      case '2': // Por Cobrar
        $procesado = $tipo_pago == 1 ? 6 : 10; // En DB procesado = 6 : Por cobrar, 10: Por cobrar con tarjeta
        $reporte = 0;
        break;
      case '3': // Anticipo
        $reporte = 0;
        $anticipo = true;
        if ($tipo_pago == 1) {
          $procesado = 7; // En DB procesado = 7 : Efectivo, como anticipo
        }
        // Tarjeta no envia a caja y todo es rojo, envia correo
        else if ($tipo_pago == 2) {
          $procesado = 8; // En DB procesado = 8 : Por facturar, anticipo con tarjeta
          $enviar_mail = true;
        }
        break;
      case '4': // Liquidacion
        if ($tipo_pago == 1) {
          $procesado = 1; // Efectivo
          $reporte = 1;
        } else if ($tipo_pago == 2) {
          $reporte = 0;
          $procesado = 5; // Tarjeta
        }
        $cantidad = $cantidad_total;
        // Sumar lo del recibo anterior

        // Si tiene piezas, el precio será la suma de las piezas*cantidad_pieza
        if ($datos->tipo_recibo > 1) {
          $cantidad = 0;
          foreach ($datos->datos as $pieza) {
            $cantidad += (float)$pieza->venta * (int)$pieza->cantidad;
          }
        }

        break;
    }
    if ($area != '1') {
      $reporte = 0;
    }

    $id_recibo = db_insert('partners_recibo')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'fecha_recibo' => strtotime($datos->fecha_recibo),
        'id_cliente' => (isset($datos->id_cliente) && $datos->id_cliente != '') ? $datos->id_cliente : null,
        'otro_cliente' => $datos->otro_cliente,
        'concepto' => $datos->concepto_recibo,
        'observaciones' => ($datos->notas_internas) ? $this->serialize_obs($datos->notas_internas, 1) : null,
        'cantidad' => strtr(($anticipo ? $cantidad_total : $cantidad), array(',' => '')),
        'tipo_cliente' => $datos->tipo_cliente,
        'procesado' => $procesado, // dependerá del caso (Solo si es ventas y en efectivo)
        'agente' => $datos->agente_recibo,
        'tipo_recibo' => $datos->tipo_recibo,
        'cantidad_anticipo' => strtr(($anticipo ? $cantidad_abono : 0.0), array(',' => '')),
        'reporte' => ($area == 1) ? $reporte : 0,
        'liquidado' => $proceso == 4 ? 1 : 0
      ))
      ->execute();
    // Marcar como liquidado
    if ($proceso == 4) {
      db_update('partners_recibo')
        ->fields(array(
          'id_liquidado' => $id_recibo,
          'liquidado' => 1,
          'cantidad' => $cantidad
        ))
        ->condition('id_recibo', $datos->id_anticipo)
        ->execute();
    }
    // Piezas
    if ($datos->tipo_recibo == 2) {
      foreach ($datos->datos as $dato) {
        db_insert('partners_recibo_datos')
          ->fields(array(
            'id_recibo' => $id_recibo,
            'cantidad' => $dato->cantidad,
            'upc' => $dato->upc,
            'descripcion' => $dato->descripcion,
            'serie' => $dato->serie,
            'costo' => ($dato->costo == '') ? 0 : $dato->costo,
            'venta' => $dato->venta
          ))
          ->execute();
      }
    }
    // Enviar a Caja
    if ($area != 2 && $datos->tipo_pago == 1 && $proceso != 2) {
      // Verificar si es una liquidacion
      $cant = $proceso != 4
        ? ($anticipo ? str_replace(",", "", $cantidad_abono) : str_replace(",", "", $cantidad))
        : (str_replace(",", "", $cantidad_total) - str_replace(",", "", $cantidad_anticipo));
      db_insert('partners_caja')
        ->fields(array(
          'created_by' => $user->uid,
          'created_at' => REQUEST_TIME,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid,
          'concepto' => 'Registro de Recibo: R-' . $id_recibo . ' | ' . $user->name,
          'cantidad' => str_replace(",", "", $cant)
        ))->execute();
      $this->register_log_actions('partners_caja', 'insert', 'Se capturó un ingreso recibo de dinero: ' . $id_recibo);
    }
    if ($enviar_mail) {
      $data['cliente'] = db_query('select id_cliente, nombre_cliente, email from partners_clientes where id_cliente = ' . $datos->id_cliente)->fetchAssoc();
      $data['id_recibo'] = $id_recibo;
      $to = ["administracion@pcpartners.com.mx" => ['Rocío Haro']]; // Cambiar por el correo de Chio
      $from = ["administracion@pcpartners.com.mx" => "Pc Partners - Nuevo"];
      $transport = new Swift_SendmailTransport();
      $mailer = new Swift_Mailer($transport);
      $body = render_template('php', 'recibo.mail_por_facturar', $data); //nuevo tpl para el correo de aviso
      $message = (new Swift_Message())
        ->setSubject("Recibo por facturar")
        ->setFrom($from)
        ->setBody($body, 'text/html');
      $failedRecipients = [];
      $numSent = 0;

      foreach ($to as $dir => $name) {
        if (is_int($dir)) {
          $message->setTo($name);
        } else {
          $message->setTo([$dir => $name]);
        }
        try {
          $numSent += $mailer->send($message, $failedRecipients);
          db_insert("partners_log_actions")
            ->fields(array(
              'timestamp' => REQUEST_TIME,
              'uid' => $user->uid,
              'hostname' => ip_address(),
              'location' => $base_root . request_uri(),
              'table_at' => 'partners_recibo',
              'type' => 'recibo_por_facturar',
              'message' => 'Se envió un recordatorio de recibo por facturar :' . $name . '(' . $dir . ') en relación al recibo: ' . $id_recibo
            ))->execute();
        } catch (Exception $e) {
          db_insert('partners_log_actions')
            ->fields(array(
              'timestamp' => REQUEST_TIME,
              'uid' => $user->uid,
              'hostname' => ip_address(),
              'location' => $base_root . request_uri(),
              'table_at' => 'partners_polizas',
              'type' => 'recordatorio_saldo_poliza',
              'message' => 'Hubo un error al enviar el correo automático: ' . $e
            ))->execute();
        }
      }
    }

    $this->register_log_actions('partners_recibo', 'insert', 'Se capturó un nuevo recibo de dinero: ' . $id_recibo);
    $this->throw_message('success', $id_recibo);
  }

  /**
   * @param $datos
   * @return array
   * @throws MpdfException
   */
  private function render_recibo($datos)
  {
    setlocale(LC_TIME, "es_MX");
    $id_recibo = $datos['id_recibo'];
    if ($datos['type']) {
      $type = $datos['type'];
    } else {
      $type = null;
    }

    $query = db_select('partners_recibo', 'pr');
    $query->fields('pr');
    $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = pr.id_cliente');
    $query->addField('pc', 'nombre_cliente');
    $query->condition('pr.id_recibo', $id_recibo);
    $recibo = $query->execute()->fetchAssoc();
    $data['recibo'] = $recibo;
    $data['nombre_usuario'] = user_load($recibo['created_by'])->field_nombre_completo['und'][0]['value'];
    $query_datos = db_select('partners_recibo_datos', 'prd');
    $query_datos->fields('prd');
    $query_datos->addExpression('SUM(cantidad * venta)', 'subtotal');
    $query_datos->condition('id_recibo', $id_recibo);
    $query_datos->groupBy('id_dato');
    $recibo_datos = $query_datos->execute()->fetchAll(PDO::FETCH_ASSOC);
    $data['precio_text'] = $this->numtoletras($recibo['cantidad']);
    $data['precio_text_anticipo'] = $this->numtoletras($recibo['cantidad_anticipo']);
    $data['recibo']['saldo'] = $recibo['cantidad'] - $recibo['cantidad_anticipo'];
    if ($recibo['procesado'] < 6 && $recibo['liquidado'] > 0) { // Si es una liquidacion
      $ant = db_query("select * from partners_recibo where id_liquidado = " . $recibo['id_recibo'] . " LIMIT 1");
      $anticipo = $ant->fetchAssoc();
      $data['recibo']['anticipo'] = $anticipo;
      $data['recibo']['anticipo']['saldo'] = $data['recibo']['anticipo']['cantidad'] - $data['recibo']['anticipo']['cantidad_anticipo'];
      $data['recibo']['anticipo']['saldo_text'] = $this->numtoletras($data['recibo']['anticipo']['saldo']);
      // Si es un recibo con piezas
      if ($recibo['tipo_recibo'] > 1) {
        $data['recibo']['anticipo']['saldo'] = 0;
        foreach ($recibo_datos as $pieza) {
          $data['recibo']['anticipo']['saldo'] += (float)$pieza['venta'] * (int)$pieza['cantidad'];
        }
        // Restar el abono realizado
        $data['recibo']['anticipo']['saldo'] -= $anticipo['cantidad_anticipo'];
        $data['recibo']['anticipo']['saldo_text'] = $this->numtoletras($data['recibo']['anticipo']['saldo']);

        // Agregar el abono a la cuenta
        array_push(
          $recibo_datos,
          array(
            "cantidad" => 1,
            "descripcion" => "Anticipo realizado",
            "venta" => (-$anticipo['cantidad_anticipo']),
            "subtotal" => (-$anticipo['cantidad_anticipo'])
          )
        );
      }
    }
    $data['recibo_datos'] = $recibo_datos;
    $html = render_template('php', 'recibo.render_reporte', $data);
    $footer = render_template('php', 'system.footer_reporte');
    if ($recibo['recibo_cancelado'] == 1) {
      $watermark = '/intranet/sites/default/files/img/cancelado.png';
    } else {
      $watermark = NULL;
    }
    if ($type == null) {
      $this->generate_pdf($html, 'Recibo ' . $id_recibo, 'recibo_' . $id_recibo, 1, $footer, $watermark);
    } else {
      return array("pdf_string" => $this->generate_pdf($html, $id_recibo, 'recibo_' . $id_recibo, 2, $footer, $watermark), "attach_title" => 'recibo_' . $id_recibo);
    }
  }

  /**
   * @param $xcifra
   * @return string
   */
  private function numtoletras($xcifra)
  {
    $xarray = array(
      0 => "Cero",
      1 => "UN", "DOS", "TRES", "CUATRO", "CINCO", "SEIS", "SIETE", "OCHO", "NUEVE",
      "DIEZ", "ONCE", "DOCE", "TRECE", "CATORCE", "QUINCE", "DIECISEIS", "DIECISIETE", "DIECIOCHO", "DIECINUEVE",
      "VEINTI", 30 => "TREINTA", 40 => "CUARENTA", 50 => "CINCUENTA", 60 => "SESENTA", 70 => "SETENTA", 80 => "OCHENTA", 90 => "NOVENTA",
      100 => "CIENTO", 200 => "DOSCIENTOS", 300 => "TRESCIENTOS", 400 => "CUATROCIENTOS", 500 => "QUINIENTOS", 600 => "SEISCIENTOS", 700 => "SETECIENTOS", 800 => "OCHOCIENTOS", 900 => "NOVECIENTOS"
    );
    $xcifra = trim($xcifra);
    $xlength = strlen($xcifra);
    $xpos_punto = strpos($xcifra, ".");
    $xaux_int = $xcifra;
    $xdecimales = "00";
    if (!($xpos_punto === false)) {
      if ($xpos_punto == 0) {
        $xcifra = "0" . $xcifra;
        $xpos_punto = strpos($xcifra, ".");
      }
      $xaux_int = substr($xcifra, 0, $xpos_punto); // obtengo el entero de la cifra a covertir
      $xdecimales = substr($xcifra . "00", $xpos_punto + 1, 2); // obtengo los valores decimales
    }
    $XAUX = str_pad($xaux_int, 18, " ", STR_PAD_LEFT); // ajusto la longitud de la cifra, para que sea divisible por centenas de miles (grupos de 6)
    $xcadena = "";
    for ($xz = 0; $xz < 3; $xz++) {
      $xaux = substr($XAUX, $xz * 6, 6);
      $xi = 0;
      $xlimite = 6; // inicializo el contador de centenas xi y establezco el límite a 6 dígitos en la parte entera
      $xexit = true; // bandera para controlar el ciclo del While
      while ($xexit) {
        if ($xi == $xlimite) { // si ya llegó al límite máximo de enteros
          break; // termina el ciclo
        }
        $x3digitos = ($xlimite - $xi) * -1; // comienzo con los tres primeros digitos de la cifra, comenzando por la izquierda
        $xaux = substr($xaux, $x3digitos, abs($x3digitos)); // obtengo la centena (los tres dígitos)
        for ($xy = 1; $xy < 4; $xy++) { // ciclo para revisar centenas, decenas y unidades, en ese orden
          switch ($xy) {
            case 1: // checa las centenas
              if (substr($xaux, 0, 3) < 100) { // si el grupo de tres dígitos es menor a una centena ( < 99) no hace nada y pasa a revisar las decenas
              } else {
                $key = (int)substr($xaux, 0, 3);
                if (TRUE === array_key_exists($key, $xarray)) {  // busco si la centena es número redondo (100, 200, 300, 400, etc..)
                  $xseek = $xarray[$key];
                  $xsub = $this->subfijo($xaux); // devuelve el subfijo correspondiente (Millón, Millones, Mil o nada)
                  if (substr($xaux, 0, 3) == 100)
                    $xcadena = " " . $xcadena . " CIEN " . $xsub;
                  else
                    $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                  $xy = 3; // la centena fue redonda, entonces termino el ciclo del for y ya no reviso decenas ni unidades
                } else { // entra aquí si la centena no fue numero redondo (101, 253, 120, 980, etc.)
                  $key = (int)substr($xaux, 0, 1) * 100;
                  $xseek = $xarray[$key]; // toma el primer caracter de la centena y lo multiplica por cien y lo busca en el arreglo (para que busque 100,200,300, etc)
                  $xcadena = " " . $xcadena . " " . $xseek;
                } // ENDIF ($xseek)
              } // ENDIF (substr($xaux, 0, 3) < 100)
              break;
            case 2: // checa las decenas (con la misma lógica que las centenas)
              if (substr($xaux, 1, 2) < 10) {
              } else {
                $key = (int)substr($xaux, 1, 2);
                if (TRUE === array_key_exists($key, $xarray)) {
                  $xseek = $xarray[$key];
                  $xsub = $this->subfijo($xaux);
                  if (substr($xaux, 1, 2) == 20)
                    $xcadena = " " . $xcadena . " VEINTE " . $xsub;
                  else
                    $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
                  $xy = 3;
                } else {
                  $key = (int)substr($xaux, 1, 1) * 10;
                  $xseek = $xarray[$key];
                  if (20 == substr($xaux, 1, 1) * 10)
                    $xcadena = " " . $xcadena . " " . $xseek;
                  else
                    $xcadena = " " . $xcadena . " " . $xseek . " Y ";
                } // ENDIF ($xseek)
              } // ENDIF (substr($xaux, 1, 2) < 10)
              break;
            case 3: // checa las unidades
              if (substr($xaux, 2, 1) < 1) { // si la unidad es cero, ya no hace nada
              } else {
                $key = (int)substr($xaux, 2, 1);
                $xseek = $xarray[$key]; // obtengo directamente el valor de la unidad (del uno al nueve)
                $xsub = $this->subfijo($xaux);
                if ($xcifra[0] == '1') {
                  if ($xseek == 'UN') {
                    $xseek = '';
                  }
                }
                $xcadena = " " . $xcadena . " " . $xseek . " " . $xsub;
              } // ENDIF (substr($xaux, 2, 1) < 1)
              break;
          } // END SWITCH
        } // END FOR
        $xi = $xi + 3;
      } // ENDDO
      if (substr(trim($xcadena), -5, 5) == "ILLON") // si la cadena obtenida termina en MILLON o BILLON, entonces le agrega al final la conjuncion DE
        $xcadena .= " DE";
      if (substr(trim($xcadena), -7, 7) == "ILLONES") // si la cadena obtenida en MILLONES o BILLONES, entoncea le agrega al final la conjuncion DE
        $xcadena .= " DE";
      // ----------- esta línea la puedes cambiar de acuerdo a tus necesidades o a tu país -------
      if (trim($xaux) != "") {
        switch ($xz) {
          case 0:
            if (trim(substr($XAUX, $xz * 6, 6)) == "1")
              $xcadena .= "UN BILLON ";
            else
              $xcadena .= " BILLONES ";
            break;
          case 1:
            if (trim(substr($XAUX, $xz * 6, 6)) == "1")
              $xcadena .= "UN MILLON ";
            else
              $xcadena .= " MILLONES ";
            break;
          case 2:
            if ($xcifra < 1) {
              $xcadena = "CERO PESOS $xdecimales/100 M.N.";
            }
            if ($xcifra >= 1 && $xcifra < 2) {
              $xcadena = "UN PESO $xdecimales/100 M.N. ";
            }
            if ($xcifra >= 2) {
              $xcadena .= " PESOS $xdecimales/100 M.N. "; //
            }
            break;
        } // endswitch ($xz)
      } // ENDIF (trim($xaux) != "")
      // ------------------      en este caso, para México se usa esta leyenda     ----------------
      $xcadena = str_replace("VEINTI ", "VEINTI", $xcadena); // quito el espacio para el VEINTI, para que quede: VEINTICUATRO, VEINTIUN, VEINTIDOS, etc
      $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
      $xcadena = str_replace("UN UN", "UN", $xcadena); // quito la duplicidad
      $xcadena = str_replace("  ", " ", $xcadena); // quito espacios dobles
      $xcadena = str_replace("BILLON DE MILLONES", "BILLON DE", $xcadena); // corrigo la leyenda
      $xcadena = str_replace("BILLONES DE MILLONES", "BILLONES DE", $xcadena); // corrigo la leyenda
      $xcadena = str_replace("DE UN", "UN", $xcadena); // corrigo la leyenda
    } // ENDFOR ($xz)
    return trim($xcadena);
  }

  /**
   * @param $xx
   * @return string
   */
  private function subfijo($xx)
  { // esta función regresa un subfijo para la cifra
    $xx = trim($xx);
    $xstrlen = strlen($xx);
    if ($xstrlen == 1 || $xstrlen == 2 || $xstrlen == 3)
      $xsub = "";
    //
    if ($xstrlen == 4 || $xstrlen == 5 || $xstrlen == 6)
      $xsub = "MIL";
    //
    return $xsub;
  }

  /**
   * @param $datos
   * @throws MpdfException
   */
  private function enviar_recibo_correo($datos)
  {
    global $user;
    $data = [];
    $data['id_recibo'] = $datos->id_recibo;
    $data['user_mail'] = $user->mail;
    $data['body'] = $datos->body;

    $datos_recibo = db_select('partners_recibo', 'pr')
      ->fields('pr', array('id_cliente', 'tipo_cliente', 'otro_cliente'))
      ->condition('id_recibo', $datos->id_recibo)
      ->execute()->fetchAssoc();

    if ($datos_recibo['tipo_cliente'] == 1) {
      $nombre = db_select('partners_clientes', 'pc')
        ->fields('pc', array('nombre_cliente'))
        ->condition('id_cliente', $datos_recibo['id_cliente'])
        ->execute()->fetchField();
    } else {
      $nombre = $datos_recibo['otro_cliente'];
    }

    $data['nombre_cliente'] = $nombre;

    $from = [$user->mail => 'Pc Partners - Recibo de Dinero'];

    $to = $datos->to;
    $to[] = $user->mail;
    $subject = 'Recibo de Dinero: ' . $datos->id_recibo;
    $data_to_render = [];
    $data_to_render['id_recibo'] = $datos->id_recibo;
    // Type 1: = Return String to mail
    $data_to_render['type'] = 1;

    $attachment_data = $this->render_recibo($data_to_render);
    $attachment = $attachment_data['pdf_string'];
    $attachment_title = $attachment_data['attach_title'];
    $this->send_mail('recibo.mail_enviar_recibo', $data, $subject, $from, $to, $attachment, $attachment_title);

    $this->throw_message('success', 'Bien!');
  }

  /**
   * @param $datos
   * @throws Exception
   */
  private function update_status($datos)
  {
    global $user;
    $cliente = db_query("select agente, procesado from partners_recibo where id_recibo = " . $datos->id_recibo)->fetch();
    if ($cliente->agente == 1 && $cliente->procesado == 6) {
      db_update('partners_recibo')
        ->fields(array(
          'reporte' => 1,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid
        ))
        ->condition('id_recibo', $datos->id_recibo)
        ->execute();
    }
    if ($datos->obs) {
      db_update('partners_recibo')
        ->fields(array(
          $datos->col => $datos->new_val,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid,
          'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_recibo', 'id_recibo', $datos->id_recibo)
        ))
        ->condition('id_recibo', $datos->id_recibo)
        ->execute();
    } else {
      db_update('partners_recibo')
        ->fields(array(
          $datos->col => $datos->new_val,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid
        ))
        ->condition('id_recibo', $datos->id_recibo)
        ->execute();
    }

    if (isset($datos->capturar_caja) && $datos->capturar_caja != '') {
      $this->capturar_entrada_caja($datos->concepto_capturar_caja, $datos->cantidad_capturar_caja);
    }

    $this->register_log_actions('partners_recibo', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
    $this->throw_message('success', "Cambios Guardados");
  }

  /**
   * @param $datos
   * @throws Exception
   */
  private function cancelar_recibo($datos)
  {
    db_update('partners_recibo')
      ->fields(array(
        'recibo_cancelado' => 1,
        'cantidad' => 0,
        'observaciones' => $this->serialize_obs("Se canceló el recibo por el motivo: " . $datos->obs, 2, 'partners_recibo', 'id_recibo', $datos->id_recibo)
      ))
      ->condition('id_recibo', $datos->id_recibo)
      ->execute();

    $this->throw_message('success', 'Recibo Eliminado correctamente.');
    $this->register_log_actions('partners_recibo', 'delete', 'Se eliminó el recibo: ' . $datos->id_recibo);
  }

  /**
   * @param $datos
   * @throws Exception
   */
  private function reactivate_recibo($datos)
  {
    db_update('partners_recibo')
      ->fields(array(
        'recibo_cancelado' => 0,
        'cantidad' => $datos->cantidad
      ))
      ->condition('id_recibo', $datos->id_recibo)
      ->execute();


    $this->throw_message('success', 'Recibo Reactivado correctamente.');
    $this->register_log_actions('partners_recibo', 'update', 'Se reactivó el recibo: ' . $datos->id_recibo);
  }

  /**
   * Genera un archivo de excel con todos los datos necesarios para generar un reporte de los recibos de dinero.
   * @param $datos
   * @throws \PhpOffice\PhpSpreadsheet\Exception
   */
  private function export_excel($datos)
  {
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setCellValue('A1', 'Folio')->getColumnDimension('A')->setAutoSize(true);
    $sheet->setCellValue('B1', 'Fecha')->getColumnDimension('B')->setAutoSize(true);
    $sheet->setCellValue('C1', 'Usuario')->getColumnDimension('C')->setAutoSize(true);
    $sheet->setCellValue('D1', 'Agente')->getColumnDimension('D')->setAutoSize(true);
    $sheet->setCellValue('E1', 'Cliente')->getColumnDimension('E')->setAutoSize(true);
    $sheet->setCellValue('F1', 'Cantidad')->getColumnDimension('F')->setAutoSize(true);
    $sheet->setCellValue('G1', 'Concepto')->getColumnDimension('G')->setAutoSize(true);

    $fi = trim($datos->filter->start_date);
    $ff = trim($datos->filter->end_date);
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;

    $query = db_select('partners_recibo', 'pr');
    $query->fields('pr');
    $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = pr.id_cliente');
    $query->fields('pc', array('nombre_cliente', 'email'));
    // Filtros
    if ($f_inicio == $f_final) {
      $f_final_same_day = $f_inicio + 86040;
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_recibo', array($f_inicio, $f_final_same_day), 'BETWEEN');
      }
    } else {
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_recibo', array($f_inicio, $f_final), 'BETWEEN');
      }
    }

    // Filtro - Search Bar
    if ($datos->filter->search_bar != null) {
      $recibo_or = db_or()
        ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pr.id_recibo', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pr.concepto', '%' . $datos->filter->search_bar . '%', 'LIKE');
      $query->condition($recibo_or);
    }

    // Filtro - Usuario
    if ($datos->filter->usuario != 0) {
      $query->condition('pr.created_by', $datos->filter->usuario);
    }

    // Filtro - Agente
    if ($datos->filter->agente != 0) {
      $query->condition('pr.agente', $datos->filter->agente);
    }

    $query->condition('pr.reporte', 1);

    $query->orderBy($datos->sort->sort_by, $datos->sort->order);

    $query_datos = $query->execute();

    $rowCount = 2;
    while ($row = $query_datos->fetchAssoc()) {
      $agent = "";
      switch ($row['agente']) {
        case 1:
          $agent = "Ventas";
          break;
        case 2:
          $agent = "Admon";
          break;
        case 3:
          $agent = "CCTV";
          break;
        case 4:
          $agent = "Servicio";
          break;
        case 5:
          $agent = "Web";
          break;
      }
      $folio = "R-" . $row['id_recibo'];
      $fecha = date('d/m/Y', $row['fecha_recibo']);
      $usuario = user_load($row['created_by'])->name;
      $agente = $agent;
      $cliente = ($row['tipo_cliente'] == 1) ? $row['nombre_cliente'] : $row['otro_cliente'];
      if ($row['concepto'] == '') {
        $get_concepto = db_select('partners_recibo_datos', 'prd');
        $get_concepto->addExpression("concat_ws(' | ',descripcion,upc,serie)", 'concepto');
        $get_concepto->condition('id_recibo', $row['id_recibo']);
        $g_concepto = $get_concepto->execute();
        $concepto = '';
        $get_precio = db_select('partners_recibo_datos', 'prd');
        $get_precio->addExpression('SUM(venta  * cantidad)', 'total');
        $get_precio->condition('id_recibo', $row['id_recibo']);
        $g_precio = $get_precio->execute()->fetchField();
        $precio = (float)$g_precio;

        while ($row = $g_concepto->fetchAssoc()) {
          $concepto .= $row['concepto'] . '   ';
        }
      } else {
        // quitar html del concepto (evitar errores)
        $con = $row['concepto'];
        $con = str_replace("\n", '', $con);
        $con = str_replace("<br />", "", $con);
        $con = str_replace('<table style="width: 40%;">', "", $con);
        $con = str_replace("<tbody>", "", $con);
        $con = str_replace("<td>", "", $con);
        $con = str_replace('<th align="left">', "", $con);
        $con = str_replace("<th>", "", $con);
        $con = str_replace("<tr>", "", $con);
        $con = str_replace("</table>", "", $con);
        $con = str_replace("</tbody>", "", $con);
        $con = str_replace("</td>", "", $con);
        $con = str_replace('</th align="left">', "", $con);
        $con = str_replace("</th>", "", $con);
        $con = str_replace("</tr>", "", $con);
        $con = trim($con);
        $concepto = $con;
        $precio = ($row['cantidad'] == 0 && $row['recibo_cancelado'] == 1) ? 'Cancelado' : $row['cantidad'];
      }

      $sheet->setCellValue('A' . $rowCount, $folio);
      $sheet->setCellValue('B' . $rowCount, $fecha);
      $sheet->setCellValue('C' . $rowCount, $usuario);
      $sheet->setCellValue('D' . $rowCount, $agente);
      $sheet->setCellValue('E' . $rowCount, $cliente);
      $sheet->setCellValue('F' . $rowCount, $precio)
        ->getStyle('F' . $rowCount)
        ->getNumberFormat()
        ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
      $sheet->setCellValue('G' . $rowCount, $concepto);

      $rowCount++;
    }

    $writter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");

    /** LINEAS LOCALES
     *
     *  $writter->save(HOME_SERVER . 'interno/reportes_recibo_dinero_partners/Reporte_' . *  date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');
     *  $this->throw_message('success', '/reportes_recibo_dinero_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');

     */

    /** LINEAS PARTNERSINTERNO
     * */
    $writter->save(HOME_SERVER . 'public_html/intranet/reportes_recibo_dinero_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');
    $this->throw_message('success', '/reportes_recibo_dinero_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');
    /*
     */
    /** LINEAS PRODUCCION */
    // $writter->save(HOME_SERVER . 'public_html/reportes_recibo_dinero_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');
    // $this->throw_message('success', '/reportes_recibo_dinero_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');


  }

  /**
   * Genera un archivo de excel con todos los datos necesarios para generar un reporte de los recibos de dinero.
   * @param $datos
   * @throws \PhpOffice\PhpSpreadsheet\Exception
   */
  private function export_excel_reporte($datos)
  {
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setCellValue('A1', 'Folio')->getColumnDimension('A')->setAutoSize(true);
    $sheet->setCellValue('B1', 'Fecha')->getColumnDimension('B')->setAutoSize(true);
    $sheet->setCellValue('C1', 'Usuario')->getColumnDimension('C')->setAutoSize(true);
    $sheet->setCellValue('D1', 'Código Producto')->getColumnDimension('D')->setAutoSize(true);
    $sheet->setCellValue('E1', 'Producto')->getColumnDimension('E')->setAutoSize(true);
    $sheet->setCellValue('F1', 'Unidades')->getColumnDimension('F')->setAutoSize(true);
    $sheet->setCellValue('G1', 'Precio')->getColumnDimension('G')->setAutoSize(true);
    $sheet->setCellValue('H1', 'Venta')->getColumnDimension('H')->setAutoSize(true);
    $sheet->setCellValue('I1', 'Sin Iva')->getColumnDimension('I')->setAutoSize(true);
    $sheet->setCellValue('J1', 'Costo Total')->getColumnDimension('J')->setAutoSize(true);
    $sheet->setCellValue('K1', 'Utilidad')->getColumnDimension('K')->setAutoSize(true);
    $sheet->setCellValue('L1', '% Utilidad')->getColumnDimension('L')->setAutoSize(true);

    $fi = trim($datos->filter->start_date);
    $ff = trim($datos->filter->end_date);
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;

    $query = db_select('partners_recibo', 'pr');
    $query->innerJoin('partners_recibo_datos', 'prd', 'prd.id_recibo = pr.id_recibo');
    $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = pr.id_cliente');
    $query->fields('prd');
    $query->fields('pc', array('nombre_cliente'));
    $query->fields('pr', array('otro_cliente', 'tipo_cliente', 'fecha_recibo'));
    // Filtros
    if ($f_inicio == $f_final) {
      $f_final_same_day = $f_inicio + 86040;
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_recibo', array($f_inicio, $f_final_same_day), 'BETWEEN');
      }
    } else {
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_recibo', array($f_inicio, $f_final), 'BETWEEN');
      }
    }

    $query->condition('pr.reporte', 1);
    $query->condition('pr.recibo_cancelado', 0);
    $query->orderBy($datos->sort->sort_by, $datos->sort->order);
    $query_datos = $query->execute();

    $rowCount = 2;
    $utilidadTotal = $costoTotal = $totalSinIva = 0;
    while ($row = $query_datos->fetchAssoc()) {
      $fecha = date('d/m/y', $row['fecha_recibo']);
      $folio = "R-" . $row['id_recibo'];
      $nombre = ($row['tipo_cliente'] == 1) ? $row['nombre_cliente'] : $row['otro_cliente'];
      $codProd = "'" . $row['upc'];
      $prod = $row['descripcion'];
      $unidades = $row['cantidad'];
      $precio = number_format($row['venta'], 2, '.', ',');
      $venta = number_format(($row['cantidad'] * $row['venta']), 2, '.', ',');
      $costoN = $row['costo'];
      $sinIva = ($row['cantidad'] * $row['venta']) / 1.16;
      if ($row['costo_modificado'] == 0) {
        if ($costoN < 0.01) {
          $getCosto = $this->conseguir_costo_producto($row['id_recibo'], $codProd, $row['cantidad'], date('m/d/y',  $row['fecha_recibo']));
          $costoN = $getCosto['costo'];
        }
        $costoTotal += $costoN;
        $util = $sinIva - $costoN;
        $utilPor = ($util / $sinIva) * 100;
      } else { # Ya modificaron el costo original.
        $costoTotal += $row['costo_modificado'];
        $util = $sinIva - $row['costo_modificado'];
        $utilPor = ($util / $sinIva) * 100;
      }
      $utilidadTotal += $util;
      $totalSinIva += $sinIva;

      $porcentajeUtilidad = number_format($utilPor, 0, '', '') . "%";

      $sheet->setCellValue('A' . $rowCount, $folio);
      $sheet->setCellValue('B' . $rowCount, $fecha);
      $sheet->setCellValue('C' . $rowCount, $nombre);
      $sheet->setCellValue('D' . $rowCount, $codProd);
      $sheet->setCellValue('E' . $rowCount, $prod);
      $sheet->setCellValue('F' . $rowCount, $unidades);
      $sheet->setCellValue('G' . $rowCount, $precio)->getStyle('G' . $rowCount)
        ->getNumberFormat()
        ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
      $sheet->setCellValue('H' . $rowCount, $venta)->getStyle('H' . $rowCount)
        ->getNumberFormat()
        ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
      $sheet->setCellValue('I' . $rowCount, $sinIva)->getStyle('I' . $rowCount)
        ->getNumberFormat()
        ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
      $sheet->setCellValue('J' . $rowCount, $util)->getStyle('J' . $rowCount)
        ->getNumberFormat()
        ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
      $sheet->setCellValue('K' . $rowCount, $porcentajeUtilidad);

      $rowCount++;
    }

    $writter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");


    /** LINEAS LOCALES
     *
     *  $writter->save(HOME_SERVER . 'interno/reportes_recibo_dinero_reporte_partners/Reporte_' . *  date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');
     *  $this->throw_message('success', '/reportes_recibo_dinero_reporte_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');

     */

    /** LINEAS PARTNERSINTERNO
     * */
    $writter->save(HOME_SERVER . 'public_html/intranet/reportes_recibo_dinero_reporte_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');
    $this->throw_message('success', '/reportes_recibo_dinero_reporte_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');
    /*
     */
    /** LINEAS PRODUCCION */
    // $writter->save(HOME_SERVER . 'public_html/reportes_recibo_dinero_reporte_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');
    // $this->throw_message('success', '/reportes_recibo_dinero_reporte_partners/Reporte_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');
  }
  /**
   *
   * Método para generar un reporte de los productos de los recibos de dinero
   * @param $datos
   * @throws  Exception
   */


  private function reporte_base_reporte($datos)
  {
    date_default_timezone_set('America/Mexico_City');
    $fi = str_replace('/', '-', trim($datos->filter->start_date));
    $ff = str_replace('/', '-', trim($datos->filter->end_date));
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;

    $query = db_select('partners_recibo', 'pr');
    $query->innerJoin('partners_recibo_datos', 'prd', 'prd.id_recibo = pr.id_recibo');
    $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = pr.id_cliente');
    $query->fields('prd');
    $query->fields('pc', array('nombre_cliente'));
    $query->fields('pr', array('otro_cliente', 'tipo_cliente', 'fecha_recibo'));
    // Filtros
    if ($f_inicio == $f_final) {
      $f_final_same_day = $f_inicio + 86040;
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_recibo', array($f_inicio, $f_final_same_day), 'BETWEEN');
      }
    } else {
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_recibo', array($f_inicio, $f_final), 'BETWEEN');
      }
    }

    $query->condition('pr.reporte', 1);
    $query->condition('pr.recibo_cancelado', 0);
    $query->orderBy($datos->sort->sort_by, $datos->sort->order);
    $query_datos = $query->execute();
    $recibos = [];
    $utilidadTotal = $ventaTotal = $costoTotal = $totalSinIva = 0;
    while ($row = $query_datos->fetchAssoc()) {
      $fecha = date('d/m/y', $row['fecha_recibo']);
      $folio = array("data" => "R-" . $row['id_recibo'], "class" => array("cursor-pointer", "vista_recibo"));
      $nombre = ($row['tipo_cliente'] == 1) ? $row['nombre_cliente'] : $row['otro_cliente'];
      $codProd = $row['upc'];
      $prod = $row['descripcion'];
      $unidades = $row['cantidad'];
      $precio = array("data" => number_format($row['venta'], 2, '.', ','), "class" => array("text-right"));
      $venta = array("data" => number_format(($row['cantidad'] * $row['venta']), 2, '.', ','), "class" => array("text-right"));
      $ventaTotal += number_format(($row['cantidad'] * $row['venta']), 2, '.', '');
      $costoN = $row['costo'];
      $statusReporte = $row['status_reporte'];
      // venta sin iva
      $sinIva = ($row['cantidad'] * $row['venta']) / 1.16;
      $ventaSinIva = array("data" => number_format($sinIva, 2, '.', ','), "class" => array("text-right"));

      # NO ha sido modificado el costo
      if ($row['costo_modificado'] == 0) {
        if ($costoN < 0.01) {
          $getCosto = $this->conseguir_costo_producto($row['id_recibo'], $codProd, $row['cantidad'], date('m/d/y',  $row['fecha_recibo']));
          $costoN = $getCosto['costo'];
          $statusReporte = $getCosto['status'];
        }
        $costo = array("data" => number_format($costoN, 2, '.', ','), "class" => array("text-right", "vista_compras_producto", "cursor-pointer"));
        //$utilidad = array("data" => number_format((($row['cantidad'] * $row['venta']) - $costoN), 2, '.', ','), "class" => array("text-right"));
        //$utilidadNumero = number_format((($row['cantidad'] * $row['venta']) - $costoN), 2, '.', '');
        $costoTotal += $costoN;
        // utilidad = sin iva - total
        $util = $sinIva - $costoN;
        $utilidadCol = array("data" => number_format($util, 2, '.', ','), "class" => array("text-right"));
        // % utilidad = sin iva / utilidad
        $utilPor = ($util / $sinIva) * 100;
      } else { # Ya modificaron el costo original.
        $costo = array("data" => number_format($row['costo_modificado'], 2, '.', ','), "class" => array("text-right", "vista_compras_producto", "cursor-pointer", "status-yellow"));
        //$utilidad = array("data" => number_format((($row['cantidad'] * $row['venta']) - $row['costo_modificado']), 2, '.', ','), "class" => array("text-right"));
        //$utilidadNumero = number_format((($row['cantidad'] * $row['venta']) - $row['costo_modificado']), 2, '.', '');
        $costoTotal += $row['costo_modificado'];
        // utilidad = sin iva - total
        $util = $sinIva - $row['costo_modificado'];
        $utilidadCol = array("data" => number_format($util, 2, '.', ','), "class" => array("text-right"));
        // % utilidad = sin iva / utilidad
        $utilPor = ($util / $sinIva) * 100;
      }


      //$utilidadTotal += $utilidadNumero;
      $utilidadTotal += $util;

      $totalSinIva += $sinIva;

      $status = 0;
      if ($statusReporte == 0) {
        $status = array("data" => "", "class" => array("text-center", "cambiar_status", "cursor-pointer"));
      } else if ($statusReporte == 1) {
        $status = array("data" => "Ok", "class" => array("text-center", "cambiar_status", "cursor-pointer", "status-green"));
      } else if ($statusReporte == 2) {
        $status = array("data" => "Revisar", "class" => array("text-center", "cambiar_status", "cursor-pointer", "status-red"));
      }

      // $utilidadPorcentajeN = ($utilidadNumero / $row['venta']) * 100;
      // $utilidadPorcentajeN = (($utilidadPorcentajeN < 0) ? 0 : $utilidadPorcentajeN);
      // if ($utilidadPorcentajeN <= 15) {
      //   $classPorcent = "status-red";
      // } else if ($utilidadPorcentajeN >= 50) {
      //   $classPorcent = "status-yellow";
      // } else {
      //   $classPorcent = "";
      // }
      // $utilidadPorcentaje = array("data" => number_format($utilidadPorcentajeN, 0, '', '') . "%", "class" => array("text-right", $classPorcent));

      // % utilidad = sin iva / utilidad
      if ($utilPor <= 15) {
        $utilClass = "status-red";
      } else if ($utilPor >= 50) {
        $utilClass = "status-yellow";
      } else {
        $utilClass = "";
      }
      $porcentajeUtilidad = array("data" => number_format($utilPor, 0, '', '') . "%", "class" => array("text-right", $utilClass));


      $recibos[] = array(
        "data" => array(
          $fecha,
          $folio,
          $nombre,
          $codProd,
          $prod,
          $unidades,
          $precio,
          $venta,
          $ventaSinIva,
          $costo,
          $status,
          $utilidadCol,
          $porcentajeUtilidad,
          //$utilidad,
          //$utilidadPorcentaje
        ),
        "data-codigo-producto" => $row['upc'],
        "data-id-dato" => $row['id_dato'],
        "data-fecha" => date('d/m/y', $row['fecha_recibo']),
        "data-cantidad" => $row['cantidad'],
        "data-costo" => ($row['costo_modificado'] == 0) ? $costoN : $row['costo_modificado'],
        "data-producto" => $row['descripcion'],
        "data-status" => $row['status_reporte'],
        "data-id-recibo" => $row['id_recibo']
      );
    }

    //$utilidadPorcentajeTotalN = number_format(($utilidadTotal / $ventaTotal) * 100, 0);
    $utilidadPorcentajeTotalN = number_format(($utilidadTotal / $costoTotal) * 100, 0);
    if ($utilidadPorcentajeTotalN <= 15) {
      $classPorcentTotal = "status-red";
    } else if ($utilidadPorcentajeTotalN >= 50) {
      $classPorcentTotal = "status-yellow";
    } else {
      $classPorcentTotal = "";
    }
    $utilidadPorcentajetotal = array("data" => $utilidadPorcentajeTotalN . "%", "class" => array("text-right", "font-weight-bold", $classPorcentTotal));

    $ventaTotalS = array("data" => number_format($ventaTotal, 2, '.', ','), "class" => array("text-right", "font-weight-bold"));
    $utilidadTotalS = array("data" => number_format($utilidadTotal, 2, '.', ','), "class" => array("text-right", "font-weight-bold"));
    $costoTotalS = array("data" => number_format($costoTotal, 2, '.', ','), "class" => array("text-right", "font-weight-bold"));
    $sinIvaS = array("data" => number_format($totalSinIva, 2, '.', ','), "class" => array("text-right", "font-weight-bold"));

    $recibos[] = array(
      "data" => array(
        array("data" => "TOTALES:", "colspan" => 7, "class" => array("text-right", "font-weight-bold")),
        $ventaTotalS,
        // Venta total sin iva
        $sinIvaS,
        $costoTotalS,
        array("data" => ""),
        $utilidadTotalS,
        $utilidadPorcentajetotal
      ),
    );

    $header_cols = array(
      array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
      array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Nombre", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Código Producto", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Producto", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Unidades", "class" => "filter-number"), "sortable" => 0),
      array("name" => array("data" => "Precio", "class" => "filter-number text-right"), "sortable" => 0),
      array("name" => array("data" => "Venta", "class" => "filter-number text-right"), "sortable" => 0),
      array("name" => array("data" => "Sin Iva", "class" => "filter-number text-right"), "sortable" => 0),
      array("name" => array("data" => "Costo Total", "class" => "filter-number text-right"), "sortable" => 0),
      array("name" => array("data" => "Status", "class" => "filter-number text-right"), "sortable" => 0),
      //array("name" => array("data" => "UtilidadN", "class" => "filter-number text-right"), "sortable" => 0),
      //array("name" => array("data" => "%N", "class" => "dont-filter text-right"), "sortable" => 0),
      array("name" => array("data" => "Utilidad", "class" => "filter-number text-right"), "sortable" => 0),
      array("name" => array("data" => "%", "class" => "dont-filter text-right"), "sortable" => 0),
    );


    $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


    $table = array(
      "header" => $header,
      "rows" => $recibos,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_recibo_reporte", "class" => array("table-sm"))
    );


    $result = theme('table', $table);

    echo $result;
  }

  private function conseguir_costo_producto($idRecibo, $upc, $cantidad, $fecha)
  {
    $access_credentials = db_select('partners_sql_connections', 'psc')
      ->fields('psc')
      ->execute()->fetchAssoc();
    $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
    $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
    $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
    $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);

    // $objConnect = mssql_connect($server_access, $user_access, $pass_access);
    // mssql_select_db($server_db_access);
    $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);
    if ($objConnect) {
      $query = "SELECT TOP 1 admProductos.CCODIGOPRODUCTO AS 'CODIGO',admProductos.CNOMBREPRODUCTO AS 'PRODUCTO',CASE admDocumentos.CIDDOCUMENTODE WHEN 19 THEN 'COMPRA' END AS 'TIPO',admDocumentos.CSERIEDOCUMENTO AS 'SERIE',admDocumentos.CFOLIO AS 'FOLIO',admDocumentos.CIDCLIENTEPROVEEDOR AS 'CODIGOCLIENTEPROVEEDOR',admClientes.CRAZONSOCIAL AS 'NOMBRE',admMovimientos.CFECHA AS 'FECHA',admMovimientos.CPRECIO AS 'PRECIO',admMovimientos.CCOSTOESPECIFICO AS 'COSTO',admMovimientos.CUNIDADES AS 'UNIDADES' FROM admClientes admClientes, admDocumentos admDocumentos, admMovimientos admMovimientos, admProductos admProductos WHERE admMovimientos.CIDDOCUMENTO = admDocumentos.CIDDOCUMENTO AND admMovimientos.CIDPRODUCTO = admProductos.CIDPRODUCTO AND admClientes.CIDCLIENTEPROVEEDOR = admDocumentos.CIDCLIENTEPROVEEDOR AND admDocumentos.CIDDOCUMENTODE = 19 AND admProductos.CCODIGOPRODUCTO= '$upc' AND admMovimientos.CFECHA <= '$fecha' ORDER BY admMovimientos.CFECHA DESC";
      // $r = mssql_query($query);
      // if (!$r) {
      //     echo mssql_get_last_message();
      // }
      //$obj = mssql_fetch_object($r);
      $r = sqlsrv_query($objConnect, $query);
      if (!$r) {
        $err = sqlsrv_errors();
        echo sqlsrv_errors();
      }
      $obj = sqlsrv_fetch_object($r);

      if ($obj === false) {
        $costo = 0;
        $status = 2;
        db_update("partners_recibo_datos")
          ->fields(array(
            "status_reporte" => $status
          ))
          ->condition("upc", $upc)
          ->condition("id_recibo", $idRecibo)
          ->execute();
      } else {
        $costo = number_format($obj->PRECIO * $cantidad, 2, '.', '');
        $status = 1;
        db_update("partners_recibo_datos")
          ->fields(array(
            "status_reporte" => $status,
            "costo" => $costo
          ))
          ->condition("upc", $upc)
          ->condition("id_recibo", $idRecibo)
          ->execute();
      }
      return array(
        "costo" => $costo,
        "status" => $status
      );
    } else {
      $this->throw_message('error', "Not Connected");
    }
  }

  /**
   * Método para generar una vista de todas las compras de un producto en especifico.
   * @param $datos
   * @throws Exception
   */
  private function vista_compras_producto($datos)
  {
    $access_credentials = db_select('partners_sql_connections', 'psc')
      ->fields('psc')
      ->execute()->fetchAssoc();
    $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
    $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
    $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
    $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);

    //$objConnect = mssql_connect($server_access, $user_access, $pass_access);
    //mssql_select_db($server_db_access);
    $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);

    if ($objConnect) {
      $query = "
                SELECT TOP 10 admProductos.CCODIGOPRODUCTO AS 'CODIGO',
                  admProductos.CNOMBREPRODUCTO AS 'PRODUCTO',
                  CASE admDocumentos.CIDDOCUMENTODE WHEN 19 THEN 'COMPRA' END AS 'TIPO',
                  admDocumentos.CSERIEDOCUMENTO AS 'SERIE',
                  admDocumentos.CFOLIO AS 'FOLIO',
                  admDocumentos.CIDCLIENTEPROVEEDOR AS 'CODIGOCLIENTEPROVEEDOR',
                  admClientes.CRAZONSOCIAL AS 'NOMBRE',
                  admMovimientos.CFECHA AS 'FECHA',
	              admMovimientos.CPRECIO AS 'PRECIO',
	              admMovimientos.CCOSTOESPECIFICO AS 'COSTO',
	              admMovimientos.CUNIDADES AS 'UNIDADES'
                FROM admClientes admClientes,
                  admDocumentos admDocumentos,
                  admMovimientos admMovimientos,
                  admProductos admProductos
                WHERE admMovimientos.CIDDOCUMENTO = admDocumentos.CIDDOCUMENTO
                    AND admMovimientos.CIDPRODUCTO = admProductos.CIDPRODUCTO
                    AND admClientes.CIDCLIENTEPROVEEDOR = admDocumentos.CIDCLIENTEPROVEEDOR
                    AND admDocumentos.CIDDOCUMENTODE = 19
                    AND admProductos.CCODIGOPRODUCTO= '$datos->codigo'
                ORDER BY admMovimientos.CFECHA DESC";

      //$r = mssql_query($query);

      //if (!$r) {
      //echo mssql_get_last_message();
      //while ($obj = mssql_fetch_object($r)) {
      $result = sqlsrv_query($objConnect, $query);
      if (!$result) {

        echo sqlsrv_errors();
      }

      while ($obj = sqlsrv_fetch_object($result)) {
        $x = gettype($obj->FECHA) == "string" ? new DateTime($obj->FECHA) : $obj->FECHA;
        $f = $x->getTimestamp();
        $compras_productos[] = array(
          "data" => array(
            $obj->TIPO,
            $obj->SERIE,
            $obj->FOLIO,
            $obj->CODIGOCLIENTEPROVEEDOR,
            utf8_encode($obj->NOMBRE),
            date('d/m/y', $f),
            array("data" => number_format($obj->PRECIO, 2, '.', ','), "class" => "text-right cursor-pointer modificar_costo"),
            array("data" => $obj->UNIDADES, "class" => "text-right"),
            array("data" => number_format($obj->COSTO, 2, '.', ','), "class" => "text-right"),
          ),
          "data-id-movimiento" => $datos->id_movimiento,
        );
      }

      $header_cols = array(
        array("name" => "Tipo", "sortable" => 0),
        array("name" => "Serie", "sortable" => 0),
        array("name" => "Folio", "sortable" => 0),
        array("name" => "Código", "sortable" => 0),
        array("name" => "Nombre", "sortable" => 0),
        array("name" => "Fecha", "sortable" => 0),
        array("name" => "Precio", "sortable" => 0),
        array("name" => "Unidades", "sortable" => 0),
        array("name" => "Costo Total", "sortable" => 0)
      );

      $header = sys_tools::sort_table("CFECHA", "DESC", $header_cols);

      $table = array(
        "header" => $header,
        "rows" => $compras_productos,
        "sticky" => false,
        "attributes" => array("class" => array("table-sm"))
      );


      $result = theme('table', $table);
      $data['table'] = $result;
      $data['id_movimiento'] = $datos->id_movimiento;
      $data['status'] = $datos->status;
      $html = render_template('php', 'reporte_ventas.vista_compras_producto', $data);
      $this->throw_message('success', $html);
    } else {
      $this->throw_message('error', "Not Connected");
    }
  }


  /**
   * Método para modificar el costo de un producto de un recibo de dinero.
   * @param $datos
   * @throws Exception
   */
  private function modificar_costo($datos)
  {
    db_update('partners_recibo_datos')
      ->fields(array(
        'costo_modificado' => $datos->costo,
        'status_reporte' => 1 # Deberá poner por default el status en 1
      ))
      ->condition('id_dato', $datos->id_dato)
      ->execute();

    $this->throw_message('success', 'Se cambió el costo correctamente.');
    $this->register_log_actions('partners_recibo_datos', 'update', 'Se cambió un costo sobre el dato: ' . $datos->id_dato);
  }

  /**
   * Método para cambiar el status_reporte de un producto de un recibo de dinero.
   * @param $datos
   * @throws Exception
   */
  private function change_status($datos)
  {
    db_update('partners_recibo_datos')
      ->fields(array(
        'status_reporte' => $datos->new_val
      ))
      ->condition('id_dato', $datos->id_dato)
      ->execute();

    $this->throw_message('success', 'Se cambió el status correctamente.');
    $this->register_log_actions('partners_recibo_datos', 'update', 'Se cambió el status sobre el dato: ' . $datos->id_dato);
  }

  private function get_recibos($data)
  {
    $r = db_query('select * from partners_recibo where id_cliente =' . $data->id_cliente . ' and recibo_cancelado = 0 and liquidado = 0 and procesado > 6');
    $resultado = $r->fetchAll();
    $resultado = json_encode($resultado);
    $this->throw_message('success', $resultado);
  }

  private function get_liquidacion($data)
  {
    $r = db_query('select * from partners_recibo where id_recibo =' . $data->id_anticipo);
    $a = $r->fetchAll();
    $r = db_query('select * from partners_recibo where id_recibo =' . $data->id_liquidado);
    $l = $r->fetchAll();
    $this->throw_message('success', [$a[0], $l[0]]);
  }

  private function marcar_facturado($datos)
  {
    $name_factura = $datos->rfc_cliente . 'FE00000' . $datos->folio_factura;
    $folio = $datos->folio_factura;
    if (file_exists(HOME_SERVER . 'facturas/' . $name_factura . '.zip')) {
      db_update("partners_recibo")->fields(array("folio_factura" => $folio, "procesado" => 9))->condition("id_recibo", $datos->folio_servicio)->execute();
      $this->throw_message('success', "Factura ligada");
    } else {
      $this->throw_message('error', "No se  encuentra la factura en el servidor, primero subela y repite este proceso.");
    }
  }
}
