<?php

class prepago_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_base':
                    try {
                        $this->reporte_base($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base');
                    }
                    break;
                case 'cancelar_orden':
                    try {
                        $this->cancelar_orden($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'cancelar_orden');
                    }
                    break;
                case 'pagar_orden':
                    try {
                        $this->pagar_orden($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'pagar_orden');
                    }
                    break;
                case 'pagar_orden_simple':
                    try {
                        $this->pagar_orden_simple($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'pagar_orden_simple');
                    }
                    break;
            }
        }
    }

    private function reporte_base($datos)
    {
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;

        $query = db_select('partners_prepago_ordenes', 'ppo');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = ppo.id_cliente');
        $query->fields('pc', array(
            'nombre_cliente'
        ));
        $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = ppo.id_contacto');
        $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $query->innerJoin('users', 'u', 'u.uid = ppo.created_by');
        $query->addField('u', 'name');
        $query->fields('ppo');

        // Filtros
        if ($f_inicio == $f_final) {
            $f_final_same_day = $f_inicio + 86040;
            if ($datos->filter->start_date) {
                $query->condition('ppo.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
            }
        } else {
            if ($datos->filter->start_date) {
                $query->condition('ppo.created_at', array($f_inicio, $f_final), 'BETWEEN');
            }
        }

        $query->orderBy($datos->sort->sort_by, $datos->sort->order);

        $query_datos = $query->execute();

        $prepagos = [];
        while ($row = $query_datos->fetchAssoc()) {

            // User
            if ($row['created_by'] == 0) {
                $user = array("data" => "Prepago", "class" => "text-center");
            } else {
                // Creado por un usuario del sistema, entonces es una orden generada manualmente.
                $user = array("data" => $row['name'], "class" => "text-center");
            }
            // Observaciones | Notas internas
            if ($row['observaciones'] != null) {
                $obs = array("data" => 'Obs', "class" => array("status-yellow", "prepago-observaciones", "text-center", "cursor-pointer"));
            } else {
                $obs = array("data" => 'Obs', "class" => array("text-center", "prepago-observaciones", "cursor-pointer"));
            }

            // Si tiene created_by y no tiene horas, entonces es una orden generada por un usuario, por lo tanto no se
            // le debe de dar el mismo tratamiento.
            $class_status = ($row['created_by'] != 0 && $row['horas_prepagadas'] == 0) ? "status-pagado-simple" : "status-pagado";
            // Pagado
            if ($row['pagado'] == null) {
                if ($row['orden_cancelada'] == 1) {
                    $pagado = array("data" => 'No', "class" => array("status-red", "text-center"));
                } else {
                    $pagado = array("data" => 'No', "class" => array("status-red", "text-center", "cursor-pointer", $class_status));
                }
            } else if ($row['pagado'] == 1) {
                $pagado = array("data" => "Si", "class" => array("status-green", "text-center"));
            } else if ($row['pagado'] == 2) {
                if ($row['orden_cancelada'] == 1) {
                    $pagado = array("data" => "PayPal", "class" => array("status-red", "text-center"));
                } else {
                    $pagado = array("data" => "PayPal", "class" => array("status-red", "text-center", $class_status, "cursor-pointer"));
                }
            } else if ($row['pagado'] == 3) {
                if ($row['orden_cancelada'] == 1) {
                    $pagado = array("data" => "PayU", "class" => array("status-red", "text-center"));
                } else {
                    $pagado = array("data" => "PayU", "class" => array("status-red", "text-center", $class_status, "cursor-pointer"));
                }
            }

            // Método de Pago

            switch ($row['metodo_pago']) {
                case 1:
                    $metodo_pago = array("data" => "Tarjeta de Crédito", "class" => array("text-center", "status-green"));
                    break;
                case 2:
                    $metodo_pago = array("data" => "Tarjeta de Débito", "class" => array("text-center", "status-green"));
                    break;
                case 3:
                    $metodo_pago = array("data" => "Efectivo", "class" => array("text-center", "status-green"));
                    break;
                case 4:
                    $metodo_pago = array("data" => "PayPal", "class" => array("text-center", "status-green"));
                    break;
                case 5:
                    $metodo_pago = array("data" => "Transferencia", "class" => array("text-center", "status-green"));
                    break;
                case 6:
                    $metodo_pago = array("data" => "PayU", "class" => array("text-center", "status-green"));
                    break;
                default:
                    $metodo_pago = array("data" => "N/A", "class" => array("text-center", "status-green"));
            }

            // Tipo de Servicio
            // 1) Remoto
            // 2) Domicilio
            if ($row['tipo_servicio'] == 1) {
                $tipo_servicio = array("data" => "Remoto", "class" => array("text-center", "status-green"));
            } else if ($row['tipo_servicio'] == 2) {
                $tipo_servicio = array("data" => "Domicilio", "class" => array("text-center", "status-green"));
            } else if ($row['tipo_servicio'] == 0 && $row['created_by'] != 0 && $row['horas_prepagadas'] == 0) {
                // Es una orden generada
                $tipo_servicio = array("data" => "Orden de Pago", "class" => array("text-center", "status-green"));
            }

            // Horas
            $horas = array("data" => $row['horas_prepagadas'], "class" => array("text-right"));

            // Total
            $total = array("data" => number_format($row['total'], 2, '.', ','), "class" => array("text-right"));


            // Cancelar orden
            if ($row['orden_cancelada'] == 1) {
                $cancelar = array("data" => '<i class="fas fa-ban"></i>', "class" => array("text-danger", "text-center"));
            } else {
                $cancelar = array("data" => '<i class="fas fa-ban"></i>', "class" => array("text-danger", "text-center", "cursor-pointer", "cancelar-orden-prepago"));
            }


            $prepagos[] = array(
                "data" => array(
                    "P-" . $row['id_orden'],
                    $user,
                    date('d/m/y', $row['created_at']),
                    $row['nombre_cliente'],
                    $row['nombre_contacto'],
                    $horas,
                    $total,
                    $tipo_servicio,
                    $metodo_pago,
                    $pagado,
                    $obs,
                    $cancelar
                ),
                "data-id-orden" => $row['id_orden'],
                "data-id-pendiente" => $row['id_pendiente'],
                "class" => ($row['orden_cancelada'] == 1) ? 'cancelled_row' : ''
            );
        }

        $header_cols = array(
            array("name" => array("data" => "ID Orden", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => "Usuario", "class" => "filter-text text-center"), "sortable" => 0),
            array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Nombre Cliente", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Nombre Contacto", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Horas", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Total", "class" => "filter-number text-right col-total"), "sortable" => 0),
            array("name" => array("data" => "Tipo Servicio", "class" => "filter-text text-center"), "sortable" => 0),
            array("name" => array("data" => "Método de Pago", "class" => "filter-text text-center"), "sortable" => 0),
            array("name" => array("data" => "Pagado", "class" => "filter-text text-center"), "sortable" => 0),
            array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable text-center" => 0),
            array("name" => array("data" => '<i class="fas fa-ban"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
        );

        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


        $table = array(
            "header" => $header,
            "rows" => $prepagos,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_prepago", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;
    }


    /**
     * Cancela una orden, a su vez elimina el pendiente relacionado a esta orden y deja un comentario del porque se cancelo.
     * @param $datos
     * @throws Exception
     */
    private function cancelar_orden($datos)
    {
        db_update('partners_prepago_ordenes')
            ->fields(array(
                'orden_cancelada' => 1,
                'observaciones' => $this->serialize_obs("Se canceló la orden por el motivo: " . $datos->obs, 2, 'partners_prepago_ordenes', 'id_orden', $datos->id_orden)
            ))
            ->condition('id_orden', $datos->id_orden)
            ->execute();

        $this->throw_message('success', 'Orden Eliminada correctamente.');
        $this->register_log_actions('partners_prepago_ordenes', 'delete', 'Se eliminó la orden: ' . $datos->id_orden);


        // Cancelar los pendientes
        db_update('partners_pendientes')
            ->fields(array(
                'cancelado' => 1
            ))
            ->condition('id_pendiente', $datos->id_pendiente)
            ->execute();

        $this->register_log_actions('partners_pendientes', 'delete', 'Se ha eliminado un pendiente porque la orden de prepago relacionada a este se ha cancelado.');
    }


    /**
     * Marca la orden como pagada, captura quien fue el que realizó el pago, y además actualiza el pendiente relacionado a esta orden para que se le pueda
     * seguir dando seguimiento.
     * @param $datos
     * @throws Exception
     */
    private function pagar_orden($datos)
    {
        global $user;
        db_update('partners_prepago_ordenes')
            ->fields(array(
                'pagado' => 1,
                'observaciones' => $this->serialize_obs("Se marcó  la orden como pagada con el motivo: " . $datos->obs, 2, 'partners_prepago_ordenes', 'id_orden', $datos->id_orden),
                'pagado_user' => $user->uid // Capturar el uid del user que marcó la orden como pagada.
            ))
            ->condition('id_orden', $datos->id_orden)
            ->execute();

        $this->register_log_actions('partners_prepago_ordenes', 'update', 'Se marcó la orden de prepago(' . $datos->id_orden . ') como pagada.');

        db_update('partners_pendientes')
            ->fields(array(
                'tipo_pendiente' => 2, // Poner que es tipo pendiente de soporte para que le puedan seguir dando seguimiento
                'id_orden_prepago' => $datos->id_orden, // Marcar con el id_orden para indicar que la orden ya ha sido pagada
                'allow_editar' => 1
            ))
            ->condition('id_pendiente', $datos->id_pendiente)
            ->execute();
        $this->register_log_actions('partners_pendientes', 'update', 'Se actualizaron los datos del pendiente de prepago: ' . $datos->id_pendiente . " para que se le pueda dar el seguimiento como un pendiente de soporte normal ");

        $this->throw_message('success', 'Se marcó la orden como pagada correctamente.');
    }


    /**
     * Marca la orden como pagada, captura quien fue el que realizó el pago.
     * seguir dando seguimiento.
     * @param $datos
     * @throws Exception
     */
    private function pagar_orden_simple($datos)
    {
        global $user;
        db_update('partners_prepago_ordenes')
            ->fields(array(
                'pagado' => 1,
                'observaciones' => $this->serialize_obs("Se marcó  la orden como pagada con el motivo: " . $datos->obs, 2, 'partners_prepago_ordenes', 'id_orden', $datos->id_orden),
                'pagado_user' => $user->uid // Capturar el uid del user que marcó la orden como pagada.
            ))
            ->condition('id_orden', $datos->id_orden)
            ->execute();

        $this->register_log_actions('partners_prepago_ordenes', 'update', 'Se marcó la orden de prepago(' . $datos->id_orden . ') como pagada.');

        $this->throw_message('success', 'Se marcó la orden como pagada correctamente.');
    }


}