<?php


use Defuse\Crypto\Crypto;

class polizas_sys extends sys_tools
{
  /**
   * polizas_sys constructor.
   * @param $tipo
   * @param $data
   */
  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'reporte_base':
          try {
            $this->reporte_base($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base');
          }
          break;

        case 'nueva_poliza_form':
          try {
            $this->nueva_poliza_form($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'nueva_poliza_form');
          }

          break;
        case 'polizas_vista':
          try {
            $this->polizas_vista($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'polizas_vista');
          }
        case 'get_paquetes_polizas':
          try {
            $this->get_paquetes_polizas($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_paquetes_polizas');
          }
          break;

        case 'capturar_poliza':
          try {
            $this->capturar_poliza($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_poliza');
          }
          break;
        case 'get_poliza_activa':
          try {
            $this->get_poliza_activa($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_poliza_activa');
          }
          break;
        case 'eliminar_poliza':
          try {
            $this->eliminar_poliza($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'eliminar_poliza');
          }
          break;
        case 'vista_paquete':
          try {
            $this->vista_paquete($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_paquete');
          }
          break;

        case 'vista_paquete_cliente':
          try {
            $this->vista_paquete_cliente($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_paquete_cliente');
          }
          break;
        case 'generar_token_reporte':
          try {
            $this->generar_token_reporte($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'generar_token_reporte');
          }
          break;
        case 'enviar_reporte_paquete':
          try {
            $this->enviar_reporte_paquete($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'enviar_reporte_paquete');
          }
          break;
        case 'procesar_token':
          try {
            $this->procesar_token($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'procesar_token');
          }
          break;
        case 'generar_reporte_servicios':
          try {
            $this->generar_reporte_servicios($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'generar_reporte_servicios');
          }
          break;
        case 'update_status':
          try {
            $this->update_status($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'update_status');
          }
          break;
        case 'marcar_facturado':
          try {
            $this->marcar_facturado($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'marcar_facturado');
          }
          break;
      }
    }
  }

  public function reporte_base($data)
  {
    global $user;
    //var_dump($data);

    $fi = str_replace('/', '-', trim($data->filter->start_date));
    $ff = str_replace('/', '-', trim($data->filter->end_date));
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;

    $registros = db_select('partners_polizas', 'pp');
    $registros->fields('pp');
    $registros->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pp.id_cliente');

    //Filtro paquetes inactivos
    $filtro_inactivos = ($data->filter->filtro_inactivos == 1 ? 1 : 0);

    //Filtro tecnico
    if ($data->filter->usuario != null and $data->filter->usuario != 0) {
      $registros->condition('pp.id_tecnico', $data->filter->usuario);
    }

    //Filtro Tipo de Póliza
    if ($data->filter->tipo_poliza != null and $data->filter->tipo_poliza != 0) {
      $registros->condition('pp.tipo_poliza', $data->filter->tipo_poliza);
    }

    //Filtro de Seleccionar Fecha
    // if ($f_inicio == $f_final) {
    //   $f_final_same_day = $f_inicio + 86040;
    //   if ($data->filter->start_date) {
    //     $registros->condition('pp.fecha', array($f_inicio, $f_final_same_day), 'BETWEEN');
    //   }
    // } else {
    //   if ($data->filter->start_date) {
    //     $registros->condition('pp.fecha', array($f_inicio, $f_final), 'BETWEEN');
    //   }
    // }

    //Filtro de Search bar
    if ($data->filter->search_bar != null) {
      $servicio_or = db_or()
        ->condition('pc.nombre_cliente', '%' . $data->filter->search_bar . '%', 'LIKE')
        ->condition('pc.nombre_cliente', '%' . $data->filter->search_bar . '%', 'LIKE');
      $registros->condition($servicio_or);
    }
    // ordenar desc
    $registros->orderBy('fecha', 'desc');
    $registrosD = $registros->execute();
    $registros = $registrosD->fetchAll();

    $registros_polizas = [];
    foreach ($registros as $registro) {
      if (($filtro_inactivos == 0 ? $registro->eliminada != 1 and $registro->estado != 0 : $registro->eliminada != 1)) {
        /// Datos de tablas extenas
        $t = db_query('SELECT name FROM users WHERE uid = :uid', array('uid' => $registro->id_tecnico));
        $c = db_query('SELECT nombre_cliente FROM partners_clientes WHERE id_cliente= :id', array(':id' => $registro->id_cliente));
        $s = db_query('SELECT saldo_horas FROM partners_clientes WHERE id_cliente= :id', array(':id' => $registro->id_cliente));
        $tc = db_query('SELECT tipo_cliente FROM partners_clientes WHERE id_cliente= :id', array(':id' => $registro->id_cliente));
        $tecnico = $t->fetchCol()[0];
        $usuario = $c->fetchCol()[0];
        $saldo = $s->fetchCol()[0];
        $tipo_cliente = $tc->fetchCol()[0];

        //Obtener los datos del paquete correspondiente a la poliza
        $datosPaquetes = db_select('partners_paquetes_polizas', 'ppp')
          ->fields('ppp')
          ->condition('ppp.tid', $registro->tipo_poliza)
          ->execute();
        $d = $datosPaquetes->fetch();

        //Mostrar los datos
        $paquete = array("data" => $d->nombre, "class" => array("cursor-pointer", "vista_paquete"));
        $folio = array("data" => $registro->id_poliza, "class" => array("cursor-pointer", "vista_poliza"));
        $empleado = array("data" => $tecnico);
        $cliente = array(
          "data" => '<style>a{ color:black;} a:hover{ color: black; text-decoration: none;}</style><a target="_blank"
                href="/clientes?id_cliente=' . $registro->id_cliente . '&type=' . $tipo_cliente . '" >' . $usuario . "</a>",
          "class" => array("cursor-pointer", "vista_cliente")
        );
        $horas_incluidas = array("data" => $d->horas, "class" => array(""));
        $horas_utilizadas = array("data" => $registro->horas_usadas, "class" => array(""));
        $saldo_cliente = array("data" => $saldo, "class" => array(""));
        $fecha_poliza = array("data" => date('d/m/Y', $registro->fecha), "class" => array(""));
        $fecha_vencimiento = array("data" => date('d/m/Y', $registro->vencimiento), "class" => array(""));

        //Observaciones, borrar
        if ($registro->observaciones != null && $registro->observaciones != "") {
          $obs = array("data" => 'Obs', "class" => array("status-yellow", "polizas-observaciones", "cursor-pointer"));
        } else {
          $obs = array("data" => 'Obs', "class" => array("polizas-observaciones", "cursor-pointer"));
        }
        $borrar = array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "eliminar_poliza"));
        // boton de vista de paquete del cliente (estado de cuenta para paquetes)
        $vista_paquete = array("data" => '<i class="fa fa-solid fa-eye"></i>', "class" => array("cursor-pointer", "text-center", "vista_paquete_cliente"));
        // boton para enviar reporte por correo
        $enviar = array("data" => '<i class="fas fa-envelope"></i>', "class" => array("cursor-pointer", "text-center", "enviar_reporte_paquete"));
        // visualizacion de estado
        $estado = array("data" => ($registro->estado == 1 ? "Activo" : "Inactivo"), "class" => array("cursor-pointer", "text-center", ($registro->estado == 1 ? "status-green" : "status-red")));

        // Forma de pago & Factura
        $tp = null;
        $tpc = null;
        $fact = null;
        if ($registro->forma_pago == 0) {
          $tp = "No";
          $tpc = array("status-red", "text-center", "status_pagado", "cursor-pointer");
          $fact = array("status-red", "text-center");
        } else if ($registro->forma_pago == 1) {
          $tp = "Efectivo";
          $tpc = array("status-green", "text-center", "status_pagado", "cursor-pointer");
          $fact = array("status-red", "text-center");
        } else {
          $tp = "Factura";
          $tpc = array("status-green", "text-center", "status_pagado", "cursor-pointer", "facturado");
          if (!$this->validate_factura_pagada($registro->forma_pago)) {
            $fact = array("status-green", "text-center", "vista_factura", "cursor-pointer");
          } else {
            $fact = array("status-red", "text-center", "vista_factura", "cursor-pointer");
          }
        }
        $pago = array("data" => $tp, "class" => $tpc);
        $factura = array("data" => $registro->forma_pago > 1 ? $registro->forma_pago : "No", "class" => $fact);

        /// insertar al array
        if (in_array('Supervisor', array_values($user->roles))) {

          $registros_polizas[] = array(
            "data" => array(
              $folio,
              $paquete,
              $empleado,
              $cliente,
              $horas_incluidas,
              $horas_utilizadas,
              $registro->estado == 1 ? $saldo_cliente : 0,
              $fecha_poliza,
              $fecha_vencimiento,
              $estado,
              $pago,
              $factura,
              $obs,
              $vista_paquete,
              $enviar,
              $borrar
            ),
            "data-id-poliza" => $registro->id_poliza,
            "data-id-tecnico" => $registro->id_tecnico,
            "data-tipo-poliza" => $registro->tipo_poliza,
            "data-id-cliente" => $registro->id_cliente,
            "data-nombre-cliente" => $usuario,
            "data-folio-factura" => ($tp == "Factura" ? $registro->forma_pago : 0)
          );
        } else {
          $registros_polizas[] = array(
            "data" => array(
              $folio,
              $paquete,
              $empleado,
              $cliente,
              $horas_incluidas,
              $horas_utilizadas,
              $registro->estado == 1 ? $saldo_cliente : 0,
              $fecha_poliza,
              $fecha_vencimiento,
              $estado,
              $pago,
              $factura,
              $obs,
              $vista_paquete,
              $enviar,
            ),
            "data-id-poliza" => $registro->id_poliza,
            "data-id-tecnico" => $registro->id_tecnico,
            "data-tipo-poliza" => $registro->tipo_poliza,
            "data-id-cliente" => $registro->id_cliente,
            "data-nombre-cliente" => $usuario,
            "data-folio-factura" => ($tp == "Factura" ? $registro->forma_pago : 0)
          );
        }
      } //end if

    } //end for
    if (in_array('Supervisor', array_values($user->roles))) {
      $header_cols = array(
        array("name" => array("data" => "Folio", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Paquete", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Empleado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Horas incluidas", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Horas usadas", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Saldo", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Vencimiento", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Estado", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Pago", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "N. Factura", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Vista", "class" => "dont-filter text-center"), "sortable" => 0),
        array("name" => array("data" => "Enviar", "class" => "dont-filter text-center"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
      );
    } else {
      $header_cols = array(
        array("name" => array("data" => "Folio", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Paquete", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Empleado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Horas incluidas", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Horas usadas", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Saldo", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Vencimiento", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Estado", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Pago", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "N. Factura", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Vista", "class" => "dont-filter text-center"), "sortable" => 0),
        array("name" => array("data" => "Enviar", "class" => "dont-filter text-center"), "sortable" => 0),
      );
    }

    $header = sys_tools::sort_table($data->sort->sort_by, $data->sort->order, $header_cols);

    $table = array(
      "header" => $header,
      "rows" => $registros_polizas,
      "sticky" => true,
      "attributes" => array("id" => "table_reporteador_polizas", "class" => array("table-sm"))
    );

    $result = theme('table', $table);
    echo $result;
  }

  public function nueva_poliza_form()
  {
    $data = db_select('partners_paquetes_polizas', 'p')
      ->fields('p', array('tid', 'nombre', 'horas', 'precio_hora'))
      ->orderBy('nombre', 'ASC')
      ->execute()->fetchAll(PDO::FETCH_ASSOC);
    //var_dump($data);
    $template = render_template('php', 'polizas.nueva_poliza_form', $data);
    $this->throw_message('success', $template);
  }

  public function capturar_poliza($data)
  {
    global $user;
    // $data = id_cliente, tipo_poliza, horas
    $data->id_tecnico = $user->uid;
    $clasificacion = db_query(
      "SELECT tipo_clasificacion FROM partners_clientes where id_cliente = " . $data->id_cliente
    )
      ->fetchField();
    //Cambiar clasificación de cliente a tipo "P" si no lo es
    if (strtoupper($clasificacion) != "P") {
      db_update("partners_clientes")
        ->fields(
          array(
            'id_cliente' => $data->id_cliente,
            'tipo_clasificacion' => 'p'
          )
        )
        ->condition('id_cliente', $data->id_cliente, '=')
        ->execute();
    }
    //agregar horas al cliente
    $result = false;
    if ($data->horas > 0) {
      $saldo_inicial = db_query("SELECT saldo_horas FROM partners_clientes where id_cliente = " . $data->id_cliente)->fetchField();
      $horas_incluidas = db_query("SELECT horas from partners_paquetes_polizas where tid = " . $data->tipo_poliza)->fetchField();
      $saldo = $saldo_inicial + $horas_incluidas;
      // El trigger set_horas_poliza realiza automaticamente este procedimiento en la BD, solo funciona en local
      $result = db_update("partners_clientes")
        ->fields(
          array(
            'saldo_horas' => $saldo
          )
        )
        ->condition('id_cliente', $data->id_cliente, '=')
        ->execute();


      // Obtener el id de la ultima poliza del cliente
      $last_poliza = db_query("SELECT id_poliza FROM partners_polizas where id_cliente = :id_cliente ORDER BY id_poliza DESC LIMIT 1", array(":id_cliente" => $data->id_cliente))->fetch();

      // desactivar la ultima poliza del cliente
      db_update("partners_polizas")
        ->fields(array('estado' => 0))
        ->condition('id_poliza', $last_poliza->id_poliza)
        ->execute();

      //insertar a la base de datos la nueva poliza
      $result = db_insert("partners_polizas")
        ->fields(
          array(
            'fecha' => REQUEST_TIME,
            'id_tecnico' => $data->id_tecnico,
            'id_cliente' => $data->id_cliente,
            'tipo_poliza' => $data->tipo_poliza,
            'horas_incluidas' => $horas_incluidas,
            'horas_usadas' => 0,
            'vencimiento' => strtotime(date('Y-m-d', REQUEST_TIME) . "+ 1 year"),
            'estado' => 1,
          )
        )->execute();

      // Igualar la cantidad del saldo del cliente en todas las pólizas
      db_update("partners_polizas")
        ->fields(array('saldo_cliente' => $saldo))
        ->condition('id_cliente', $data->id_cliente, '=')
        ->execute();
    } else {
      $this->throw_message('error', "Error");
    }
    $res = '';
    if ($result) {
      $res = 'Éxito';
    }
    $this->throw_message('success', $res);
  }

  public function get_paquetes_polizas($paquete, $tipo = null)
  {
    $data = db_select('partners_paquetes_polizas', 'p')
      ->fields('p', array('horas', 'precio_hora'))
      ->condition('p.tid', (int) $paquete)
      ->execute()->fetchAll(PDO::FETCH_ASSOC);
    if ($tipo == 2) {
      return $data[0];
    }
    $this->throw_message('success', $data[0]);
  }

  /**
   * @param $id
   * @throws Exception
   */
  private function eliminar_poliza($id)
  {
    // Obtener datos de la poliza
    $data = db_select('partners_polizas', 'pp')->fields('pp')->condition('pp.id_poliza', (int) $id);
    $poliza = $data->execute()->fetchObject();

    // Restarle al saldo del cliente
    if ($poliza->id_cliente) {
      $horas_restantes = $poliza->horas_incluidas - $poliza->horas_usadas;
      $saldo = $poliza->saldo_cliente - $horas_restantes;
      db_update("partners_polizas")
        ->fields(array('saldo_cliente' => $saldo))->condition('id_cliente', $poliza->id_cliente)->execute();
      db_update("partners_clientes")
        ->fields(array('saldo_horas' => $saldo))->condition('id_cliente', $poliza->id_cliente)->execute();
    }
    // Actualizar el estado de la poliza
    db_update('partners_polizas')
      ->fields(
        array(
          'eliminada' => 1
        )
      )
      ->condition('id_poliza', $id)
      ->execute();
    $this->throw_message('success', 'Paquete Eliminado correctamente.');
    $this->register_log_actions('partners_renovaciones', 'delete', 'Se eliminó el paquete con el folio: ' . $id);
  }

  /**
   * @param $id
   * @throws Exception
   * @return array polizas
   * Regresa un array con las polizas activas del cliente, empezando por la mas vieja
   */
  public function get_poliza_activa($data)
  {
    try {
      if ($data->id) {
        $result = db_select('partners_polizas', 'pp')
          ->fields('pp', array('fecha', 'horas_incluidas', 'horas_usadas', 'saldo_cliente', 'vencimiento', 'id_poliza', 'tipo_poliza'));
        $result->condition('pp.id_cliente', $data->id);
        $result->condition('pp.estado', '1');
        $result->condition('pp.eliminada', '0');
        $result->condition('pp.vencimiento', REQUEST_TIME, '>');
        $result->orderBy('pp.fecha', 'asc');

        $result = $result->execute();
        $polizas = $result->fetchAll();

        if ($polizas) {
          $this->throw_message('success', $polizas);
        } else {
          $this->throw_message('error', ['Sin paquete']);
        }
      }
    } catch (Exception $e) {
      $this->throw_message('error', $e->getMessage());
    }
  }

  public function vista_paquete($data)
  {
    try {
      if ($data) {
        // $data->tid;
        $res = db_select("partners_paquetes_polizas", "ppp")
          ->fields("ppp")
          ->condition('tid', $data->tid)
          ->execute();
        // Obtiene los datos del paquete
        $data = $res->fetchAssoc();
        $result = render_template('php', 'polizas.vista_poliza', $data);

        $this->throw_message('success', $result);
      }
    } catch (Exception $e) {
      $this->throw_message("error", $e->getMessage());
    }
  }

  public function vista_paquete_cliente($data, $t = null)
  {
    try {
      if ($data) {
        $res = db_select("partners_polizas", "pp")
          ->fields("pp")
          ->condition("id_poliza", (int) $data->id_poliza)
          ->execute();
        $res = $res->fetchAssoc();
        $tp = db_query("select nombre, horas from partners_paquetes_polizas where tid = " . $res['tipo_poliza'])->fetchAssoc();
        $res['tipo_poliza'] = $tp['nombre'];
        $cliente = db_query("select nombre_cliente from partners_clientes where id_cliente = " . $res['id_cliente'])->fetchAssoc();
        $res['nombre_cliente'] = $cliente['nombre_cliente'];
        $res['vencimiento'] = date('d/M/Y', $res['vencimiento']);
        $res['saldo_inicial'] = (int) $res['horas_usadas'] + (int) $res['saldo_cliente'];
        $res['horas_heredadas'] = (int) $res['saldo_inicial'] > (int) $res['horas_incluidas']
          ? (int) $res['saldo_inicial'] - (int) $res['horas_incluidas']
          : 0;
        (int) $res['horas_usadas'] < 1 ? "Ninguna" : $res['horas_usadas'];
        if ((int) $res['estado'] == 0) {
          $res['saldo_cliente'] = 0;
        }
        $result = render_template('php', 'polizas.vista_paquete_cliente', $res);

        if ($t != null || $data->t != null) {
          return $res;
        } else {
          $this->throw_message('success', $result);
        }
      }
    } catch (Exception $e) {
      $this->throw_message("error", $e->getMessage());
    }
  }

  public function generar_token_reporte($data)
  {
    $key = $this->loadEncryptionKeyFromConfig();
    $ciphertext = Crypto::encrypt((string) $data, $key);
    $url = "http://" . $_SERVER['HTTP_HOST'] . '/estado_paquete?token=' . $ciphertext;
    $this->throw_message('success', $url);
  }

  public function procesar_token($data)
  {
    $key = $this->loadEncryptionKeyFromConfig();
    $datos = new stdClass();
    if ($data->t) {
      $datos->id_poliza = Crypto::decrypt($data->id_poliza, $key);
      // if ((int)$data->t == 2) {
      //   return $datos->id_poliza;
      // }
    } else {
      $datos->id_poliza = Crypto::decrypt($data, $key);
    }

    $estado = $this->vista_paquete_cliente($datos, 1);
    // Prevenir enviar datos nulos o no definidos
    $null = array_search(array(null, "undefined"), $estado);
    unset($estado[$null]);

    // datos de servicios

    $estado['servicios_poliza'] = db_query(
      "select * from partners_servicios_polizas
      where id_poliza = " . $datos->id_poliza
    )->fetchAssoc();

    if ($data->t) {
      return $estado;
    } else {
      $this->throw_message('success', $datos->id_poliza);
    }
    //render_template('php', 'polizas.index_estado_paquete', $estado);
  }

  public function enviar_reporte_paquete($datos)
  {

    $data = $this->vista_paquete_cliente($datos, 1);
    $data['email_user'] = (db_query("select mail from users where uid = " . $data['id_tecnico'])->fetchAssoc())['mail'];
    $data['mail'] = $data['email_user'];
    // contactos
    // $data['contactos'] = db_query(
    //   "select * from partners_clientes where id_padre = " . $data['id_cliente'])
    //   ->fetchAssoc();

    //

    //$this->throw_message("success", $data);
    $data['body'] = $datos->body;

    $from = [$data['email_user'] => 'Pc Partners - Paquetes'];
    $to = $datos->to;
    $to[] = $data['email_user'];
    $data['nombre'] = $data['nombre_cliente'];
    $data['url_token'] = $datos->url_token;
    $subject = 'Pc Partners - Estado de paquete';
    $this->send_mail('polizas.email_paquete', $data, $subject, $from, $to);
    $this->throw_message('success', 'Bien!');
  }

  public function generar_reporte_servicios($data)
  {
    // obtener los servicios por id_poliza
    $query = db_select("partners_servicios_polizas", "pp")->fields('pp');
    $query->condition("id_poliza", (int) $data->poliza);
    $qe = $query->execute();
    $registros = $qe->fetchAll();


    $registros_polizas = [];
    foreach ($registros as $registro) {
      $detalles_q = db_query("select detalle_servicio, fecha_reporte, created_by from partners_servicios where id_servicio = " . $registro->id_servicio)->fetchAssoc();
      $detalles = array("data" => $detalles_q['detalle_servicio'], "class" => array("cursor-pointer"));
      $tec = (db_query("select name from users where uid = " . $detalles_q['created_by'])->fetchAssoc())['name'];
      $fec = date('d-m-Y', $detalles_q['fecha_reporte']);
      // Poner como link para mostrar el servicio correspondiente (abrir aparte o en modal)
      $servicio = array("data" => '<a href="#" class="ver_servicio" data-servicio="' . $registro->id_servicio . '">P-' . $registro->id_servicio . "</a>", "class" => array("cursor-pointer", "vista_servicio", "text-center"));

      $horas = array("data" => $registro->horas_usadas, "class" => array("text-center"));
      $saldo_inicial = array("data" => $registro->saldo_inicial, "class" => array("text-center"));
      $calculo = (int) $registro->saldo_inicial - (int) $registro->horas_usadas;
      $saldo_final = array("data" => $calculo, "class" => array("text-center"));
      //$descarga = array("data" =>  '<i class="fas fa-print"></i', "class" => array("cursor-pointer", "descarga_servicio"));
      $tecnico = array("data" => $tec, "class" => array("text-center"));
      $fecha = array("data" => $fec, "class" => array("text-center"));
      // con los datos, generar registros para tabla
      // agregar el registro
      $registros_polizas[] = array(
        "data" => array(
          $fecha,
          $tecnico,
          $servicio,
          $detalles,
          $saldo_inicial,
          $horas,
          $saldo_final,
          //$descarga
        ),
        "data-id-poliza" => $registro->id_poliza,
        "data-id-servicio" => $registro->id_servicio
      );
    }

    // Encabezados de la tabla
    $header_cols = array(
      array("name" => array("data" => "Fecha", "class" => array("filter-date", "col-md-1", "text-center")), "sortable" => 0),
      array("name" => array("data" => "Tecnico", "class" => array("filter-text", "col-md-1", "text-center")), "sortable" => 0),
      array("name" => array("data" => "Ver Servicio", "class" => array("filter-text", "col-md-1", "text-center")), "sortable" => 0),
      array("name" => array("data" => "Detalles", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Saldo incial", "class" => array("filter-number", "text-center", "col-md-1")), "sortable" => 0),
      array("name" => array("data" => "Horas utilizadas", "class" => array("filter-number", "text-center", "col-md-1")), "sortable" => 0),
      array("name" => array("data" => "Saldo final", "class" => array("filter-number", "text-center", "col-md-1")), "sortable" => 0),
      //array("name" => array("data" => "Descargar", "class" => "dont-filter"), "sortable" => 0),
    );
    $header = sys_tools::sort_table($data->sort->sort_by, $data->sort->order, $header_cols);

    $table = array(
      "header" => $header,
      "rows" => $registros_polizas,
      "sticky" => true,
      "attributes" => array("id" => "table_reporteador_servicio", "class" => array("table-hover", "table-sm"))
    );

    $result = theme('table', $table);
    $this->throw_message('success', $result);
  }

  private function update_status($datos)
  {
    global $user;
    if ($datos->obs) {
      db_update('partners_polizas')
        ->fields(
          array(
            $datos->col => $datos->new_val,
            'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_polizas', 'id_poliza', $datos->id_servicio)
          )
        )
        ->condition('id_poliza', $datos->id_poliza)
        ->execute();
    } else {
      db_update('partners_polizas')
        ->fields(
          array(
            $datos->col => $datos->new_val,
          )
        )
        ->condition('id_poliza', $datos->id_poliza)
        ->execute();
    }

    if (isset($datos->capturar_caja) && $datos->capturar_caja != '') {
      $this->capturar_entrada_caja($datos->concepto_capturar_caja, $datos->cantidad_capturar_caja);
    }

    $this->register_log_actions('partners_polizas', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
    $this->throw_message('success', "Cambios Guardados");
  }

  /**
   * Se marca como facturado el servicio, y aparte, mete la factura al zip de la factura para después
   * ser enviada.
   * @param $datos
   */
  private function marcar_facturado($datos)
  {
    $name_factura = $datos->rfc_cliente . 'FE00000' . $datos->folio_factura;
    if (file_exists(HOME_SERVER . 'facturas/' . $name_factura . '.zip')) {
      $zip = new ZipArchive;
      if ($zip->open(HOME_SERVER . 'facturas/' . $name_factura . '.zip') === TRUE) {
        $zip->close();
        db_update('partners_polizas')
          ->fields(
            array(
              'forma_pago' => $datos->folio_factura,
            )
          )
          ->condition('id_poliza', $datos->id_poliza)
          ->execute();
        $this->throw_message('success', 'Servicio marcado como facturado correctamente.');
      } else {
        $this->throw_message('error', 'Ocurrio un error al tratar de abrir el zip de la factura.');
      }
    } else {
      $this->throw_message('error', "No se  encuentra la factura en el servidor, primero subela y repite este proceso.");
    }
  }
}