<?php

class pendientes_sys extends sys_tools
{
    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_pendientes':
                    try {
                        $this->reporte_pendientes($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'cargar_lista_pendientes_reporte');
                    }
                    break;
                case 'lista_usuarios':
                    try {
                        $this->lista_usuarios($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'cargar_lista_usuarios_form_capturar_pendiente');
                    }
                    break;
                case 'new_pendiente':
                    try {
                        $this->new_pendiente($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_nuevo_pendiente');
                    }
                    break;
                case 'finalizar_pendiente':
                    try {
                        $this->finalizar_pendiente($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'finalizar_pendiente');
                    }
                    break;
                case 'telegram':
                    try {
                        $this->telegram_bot($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'telegram_bot_send_message');
                    }
                    break;
                case 'delete_pendiente':
                    try {
                        $this->eliminar_pendiente($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'eliminar_pendiente');
                    }
                    break;
                case 'autorizar_cancelacion':
                    try {
                        $this->autorizar_cancelacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'autorizar_cancelacion');
                    }
                    break;
                case 'finalizar_pendiente_renovacion':
                    try {
                        $this->finalizar_pendiente_renovacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'finalizar_pendiente_renovacion');
                    }
                    break;
                case 'new_pendiente_ventas':
                    try {
                        $this->new_pendiente_ventas($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'new_pendiente_ventas');
                    }
                    break;
            }
        }
    }

    private function reporte_pendientes($datos)
    {
        $pendientes_query = db_select('partners_pendientes', 'pp');
        $pendientes_query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = pp.id_cliente');
        $pendientes_query->fields('pc', array('nombre_cliente', 'tipo_clasificacion'));
        $pendientes_query->leftJoin('partners_colores_areas', 'pca', 'pca.id_area = pp.area_pendiente');
        $pendientes_query->fields('pca', array('color_area'));
        $pendientes_query->leftJoin('partners_colores_prioridades', 'pcp', 'pcp.id_prioridad = pp.prioridad_pendiente');
        $pendientes_query->fields('pcp', array('color_prioridad'));
        $pendientes_query->leftJoin('users', 'u', 'u.uid  = pp.asignado_para');
        $pendientes_query->fields('u', array('name'));
        $pendientes_query->fields('pp');
        $pendientes_query->condition('pp.cancelado', 1, '!=');
        $pendientes_query->condition('pp.fecha_pendiente', array(substr($datos->from, 0, -3), substr($datos->to, 0, -3)), 'BETWEEN');

        // Filtros
        if ($datos->area != 0) {
            $pendientes_query->condition('pp.area_pendiente', $datos->area);
        }
        if ($datos->filtrado_usuario != 0) {
            $pendientes_query->condition('pp.asignado_para', $datos->filtrado_usuario);
        }
        if ($datos->id_usuario_sesion != 0) {
            $pendientes_query->condition('pp.asignado_para', $datos->id_usuario_sesion);
        }
        if ($datos->nombre) {
            $pendientes_query->condition('pc.nombre_cliente', '%' . $datos->nombre . '%', 'LIKE');
        }

        $pendientes_query->orderBy('pp.id_pendiente', 'ASC');
        $pendientes = $pendientes_query->execute();


        $p = array();
        while ($row = $pendientes->fetchAssoc()) {
            if ($row['solicitar_cancelacion'] == 1 && $row['status'] == 1) {
                $class = 'bg-danger';
            } else if ($row['status'] == 0) {
                $class = 'status_off';
            } else if (($row['tipo_pendiente'] == 5)) {
                $class = 'glowing';
            } else if (($row['tipo_pendiente'] == 2 && $row['id_orden_prepago'] != 0)) {
                // Cuando los pendientes de prepago ya han sido pagados.
                $class = 'glowing-red';
                if ($row['asignado_para'] == 0) {
                    $row['name'] = 'PAGADO';
                }
            } else {
                $class = '';
            }

            if ($row['id_cliente'] == 0) {
                $pendiente_titulo = $row['pendiente_otro'];
            } else {
                $pendiente_titulo = $row['nombre_cliente'];
            }

            $p[] = array(
                'id' => $row['id_pendiente'],
                'title_name' => $row['name'],
                'title_description' => $pendiente_titulo,
                'start' => $row['fecha_pendiente'] . '000',
                'end' => $row['fecha_pendiente'] + 86000 . '000',
                'color_area' => $row['color_area'],
                'color_prioridad' => $row['color_prioridad'],
                'estatus' => $row['status'],
                'pagado' => $row['pagado'],
                'pendiente_ventas_cotizacion' => $row['pendiente_ventas_cotizacion'],
                'class_status' => $class,
                'tipo_pendiente' => $row['tipo_pendiente'],
                'tipo_clasificacion' => $row['tipo_clasificacion']
            );
        }
        $this->throw_message('success', $p);
    }

    private function lista_usuarios($area)
    {
        $get_rid = db_select('role', 'r')
            ->fields('r', array('rid'))
            ->condition('name', $area, 'LIKE')
            ->execute()->fetchField();
        $get_users = db_select('users_roles', 'ur');
        $get_users->leftJoin('users', 'u', 'u.uid = ur.uid');
        $get_users->fields('ur', array('uid'));
        $get_users->fields('u', array('uid', 'name'));
        $get_users->condition('u.uid', 26, '!=');
        $get_users->condition('u.status', 1);
        $get_users->condition('rid', $get_rid);
        $users = $get_users->execute()->fetchAll(PDO::FETCH_ASSOC);

        $users_in_role = array();
        foreach ($users as $row) {
            $users_in_role[] = array(
                'uid' => $row['uid'],
                'name' => $row['name']
            );
        }

        if (!$users_in_role) {
            $this->throw_message('error', 'No hay usuarios para cargar en el área de ' . $area);
        } else {
            $this->throw_message('success', json_encode($users_in_role));
        }
    }

    private function new_pendiente($datos)
    {
        global $user;
        $pagado = "";
        if ($datos->area_pendiente == 9 || $datos->area_pendiente == 10) {
            $pagado = 1;
        } else {
            $pagado = ($datos->pagado) ? $datos->pagado : null;
        }
        $capturar_pendiente = db_insert('partners_pendientes')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => $user->uid,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid,
                'tipo_pendiente' => $datos->tipo_pendiente,
                'area_pendiente' => $datos->area_pendiente,
                'id_cliente' => $datos->id_cliente,
                'asignado_para' => $datos->id_usuario_asignado,
                'fecha_pendiente' => strtotime($datos->fecha_pendiente),
                'descripcion_pendiente' => $datos->problema_solicitud,
                'horario_pendiente' => $datos->horario,
                'prioridad_pendiente' => $datos->radio_prioridad_pendiente,
                'que_llevar_pendiente' => $datos->observaciones_que_llevar,
                'quien_reporta_pendiente' => $datos->quien_reporta,
                'pagado' => $pagado,
                'pendiente_otro' => (isset($datos->pendiente_otro) && $datos->pendiente_otro != '') ? $datos->pendiente_otro : null
            ))
            ->execute();

        // Solamente si si asignado a alguien
        if ($datos->id_usuario_asignado != 0) {
            $this->telegram_bot($capturar_pendiente);
        }

        $this->register_log_actions('partners_pendientes', 'insert', 'Se capturó el pendiente ' . $capturar_pendiente . ' correctamente.');
        $this->throw_message('success', 'Pendiente creado correctamente.');
    }

    private function telegram_bot($datos)
    {

        $api_url = 'https://api.telegram.org/bot689905640:AAEOS35vFV4OA2ZDf_Ha9pGGZ8a2emhVVsY/';
        if (isset($datos->edit_id) && $datos->edit_id != '') {
            $id_pendiente = $datos->edit_id;
        } else {
            $id_pendiente = $datos;
        }

        $query = db_select('partners_pendientes', 'pp');
        $query->fields('pp', array('fecha_pendiente', 'id_cliente', 'descripcion_pendiente', 'pendiente_otro', 'id_pendiente', 'asignado_para'));
        $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = pp.id_cliente');
        $query->fields('pc', array('nombre_cliente'));
        $query->leftJoin('partners_telegram', 'pt', 'pt.uid = pp.asignado_para');
        $query->fields('pt', array('chat_id'));
        $query->condition('pp.id_pendiente', $id_pendiente);
        $data = $query->execute()->fetchAssoc();

        $pendiente = [];
        $pendiente['pendiente'] = $data;

        $msg = render_template('php', 'pendientes.telegram_message', $pendiente);

        $queryArray = [
            'chat_id' => $data['chat_id'],
            'text' => $msg,
            'parse_mode' => 'HTML',
        ];
        $url = $api_url . 'sendMessage?' . http_build_query($queryArray);
        file_get_contents($url);

        if (isset($datos->edit_id) && $datos->edit_id != '') {
            $this->throw_message('success', 'Se envió una notificación por Telegram');
        }
        $this->register_log_actions('partners_pendientes', 'telegram', 'Se notificó al usuario ' . $data['asignado_para'] . ' sobre un pendiente (' . $id_pendiente . ') asignado para él.');
    }

    private function finalizar_pendiente($datos)
    {
        global $user;
        $update = db_update('partners_pendientes')
            ->fields(array(
                'status' => $datos->val,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid
            ))
            ->condition('id_pendiente', $datos->id_pendiente)
            ->execute();

        ($datos->val == 1) ? $this->register_log_actions('partners_pendientes', 'update', 'Se reactivó el pendiente ' . $datos->id_pendiente . ' correctamente.') : $this->register_log_actions('partners_pendientes', 'update', 'Se finalizó el pendiente ' . $datos->id_pendiente . ' correctamente.');
        $this->throw_message('success', ($datos->val == 1) ? 'Pendiente Reactivado' : 'Pendiente Finalizado');
    }

    private function eliminar_pendiente($datos)
    {
        //Pendiente Normal y Pendiente Renovación
        if ($datos->type == 1 || $datos->type == 3) {
            db_update('partners_pendientes')
                ->fields(array(
                    'cancelado' => 1
                ))
                ->condition('id_pendiente', $datos->id_pendiente)
                ->execute();

            $this->register_log_actions('partners_pendientes', 'update', 'Pendiente ' . $datos->id_pendiente . ' cancelado');

            $this->throw_message('success', 'Pendiente eliminado correctamente.');
        } else if ($datos->type == 2 || $datos->type == 4) {
            $this->solicitar_cancelacion($datos->motivo, $datos->id_pendiente);
            $this->throw_message('success', 'Se envió tu solicitud para cancelar el servicio ' . $datos->motivo);
        }
    }

    private function solicitar_cancelacion($motivo, $id_pendiente)
    {
        db_update('partners_pendientes')
            ->fields(array(
                'solicitar_cancelacion_motivo' => $motivo,
                'solicitar_cancelacion' => 1
            ))
            ->condition('id_pendiente', $id_pendiente)
            ->execute();

        // Ahora solamente necesita hacer el update, no es necesario notificar.
    }

    private function autorizar_cancelacion($datos)
    {
        db_update('partners_pendientes')
            ->fields(array(
                'status' => 0,
                'solicitud_cancelacion_revisada' => 1
            ))
            ->condition('id_pendiente', $datos)
            ->execute();

        $this->throw_message('success', 'Solicitud Revisada, pendiente finalizado.');
        $this->register_log_actions('partners_pendientes', 'update', 'Solicitud de cancelación de pendiente: ' . $datos->id_pendiente . ' decision: ' . $datos->decision);
    }

    /**
     * @param $datos ->type 1:Autorizada, 2:No Autorizada
     */
    private function finalizar_pendiente_renovacion($datos)
    {
        global $user;
        if ($datos->type == 1) {
            $token = db_select('partners_pendientes', 'pp')
                ->fields('pp', array('token_relacion_renovacion'))
                ->condition('id_pendiente', $datos->id_pendiente)
                ->execute()->fetchField();

            db_update('partners_renovaciones')
                ->fields(array(
                    'autorizado' => 1
                ))
                ->condition('token_relacion_renovacion', $token)
                ->execute();

            db_update('partners_pendientes')
                ->fields(array(
                    'status' => 0,
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $user->uid
                ))
                ->condition('id_pendiente', $datos->id_pendiente)
                ->execute();
            $this->register_log_actions('partners_pendientes', 'update', 'Se finalizó el pendiente de renovación: ' . $datos->id_pendiente . ', se autorizó la renovación con el token: ' . $token);
            $this->throw_message('success', 'Bien');
        } else if ($datos->type == 2) {

            $token = db_select('partners_pendientes', 'pp')
                ->fields('pp', array('token_relacion_renovacion'))
                ->condition('id_pendiente', $datos->id_pendiente)
                ->execute()->fetchField();

            db_update('partners_renovaciones')
                ->fields(array(
                    'autorizado' => 0,
                    'observaciones' => $this->serialize_obs($datos->motivo, 2, 'partners_renovaciones', 'token_relacion_renovacion', $token)
                ))
                ->condition('token_relacion_renovacion', $token)
                ->execute();

            db_update('partners_pendientes')
                ->fields(array(
                    'status' => 0,
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $user->uid
                ))
                ->condition('id_pendiente', $datos->id_pendiente)
                ->execute();
            $this->register_log_actions('partners_pendientes', 'update', 'Se finalizó el pendiente de renovación: ' . $datos->id_pendiente . ', no se autorizó la renovación con el token: ' . $token);
            $this->throw_message('success', 'Bien');
        }
    }

    public static function vista_pendiente($id_pendiente)
    {
        global $user;
        $query = db_select('partners_pendientes', 'pp');
        $query->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = pp.id_cliente');
        $query->fields('pc', array('nombre_cliente', 'tipo_cliente', 'credito', 'tipo_clasificacion', 'saldo_horas'));
        $query->leftJoin('partners_areas', 'pa', 'pa.id_area = pp.area_pendiente');
        $query->fields('pa', array('area'));
        $query->leftJoin('users', 'u', 'u.uid = pp.created_by');
        $query->fields('u', array('name'));
        $query->leftJoin('users', 'uup', 'uup.uid = pp.updated_by');
        $query->addField('uup', 'name', 'name_updated_by');
        $query->leftJoin('users', 'uu', 'uu.uid = pp.asignado_para');
        $query->addField('uu', 'name', 'asignado_para');
        $query->leftJoin('partners_prioridades', 'ppr', 'ppr.id_prioridad = pp.prioridad_pendiente');
        $query->fields('ppr', array('prioridad'));
        $query->fields('pp');
        $query->addField('pp', 'asignado_para', 'id_asignado_para');
        $query->leftJoin('partners_servicios', 'ps', 'ps.id_servicio = pp.closed_by_report');
        $query->addExpression("CASE ps.tipo_servicio WHEN 1 THEN 'Remoto' WHEN 2 THEN 'Interno' WHEN 3 THEN 'Actividad' WHEN 4 THEN 'Domicilio' END ", "tipo_reporte_servicio");
        $query->condition('pp.id_pendiente', $id_pendiente);
        $pendiente = $query->execute()->fetchAssoc();

        //Prioridades Pendiente
        $prioridades = db_select('partners_prioridades', 'pp')
            ->fields('pp')
            ->execute()->fetchAll(PDO::FETCH_ASSOC);

        //Usuarios del Área
        $pendiente['area_pendiente'] = $pendiente['area_pendiente'] == 9 ? 2 : $pendiente['area_pendiente'];
        $area_name = db_select('partners_areas', 'pa')
            ->fields('pa', array('area'))
            ->condition('id_area', $pendiente['area_pendiente'])
            ->execute()->fetchField();

        $get_rid_name = db_select('role', 'r')
            ->fields('r', array('rid'))
            ->condition('name', $area_name);

        $get_uid = db_select('users_roles', 'ur')
            ->fields('ur', array('uid'))
            ->condition('ur.rid', $get_rid_name, 'IN');

        $get_users = db_select('users', 'u')
            ->fields('u')
            ->condition('u.uid', $get_uid, 'IN')
            ->condition('status', 1)
            ->condition('uid', 26, '!=')
            ->orderBy('name', 'ASC')
            ->execute()->fetchAll(PDO::FETCH_ASSOC);


        //Return

        $d['pendiente'] = $pendiente;
        $d['prioridades'] = $prioridades;
        $saldo = $d['pendiente']['saldo_horas'];
        $d['plural'] = false;
        if ($saldo > 1 || $saldo < 1) {
            $d['plural'] = true;
        }
        $d['usuarios_area'] = $get_users;
        $d['user'] = $user->uid;
        $d['authorized_user'] = user_has_role(10, $user);
        return $d;
    }

    /**
     * @param $datos
     * @throws Exception
     */
    private function new_pendiente_ventas($datos)
    {
        global $user;
        $capturar_pendiente = db_insert('partners_pendientes')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => $user->uid,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid,
                'tipo_pendiente' => $datos->tipo_pendiente,
                'area_pendiente' => $datos->area_pendiente,
                'asignado_para' => 0,
                'id_cliente' => $datos->id_cliente,
                'fecha_pendiente' => strtotime($datos->fecha_pendiente),
                'descripcion_pendiente' => 'Cotizar: ' . $datos->problema_solicitud,
                'horario_pendiente' => '',
                'prioridad_pendiente' => 1,
                'quien_reporta_pendiente' => '',
                'pendiente_otro' => null,
                'pendiente_ventas_cotizacion' => 1 // Cuando es un pendiente tipo solicitar cotización
            ))
            ->execute();


        $this->register_log_actions('partners_pendientes', 'insert', 'Se capturó el pendiente de ventas ' . $capturar_pendiente . ' correctamente.');
        $this->throw_message('success', 'Pendiente creado correctamente.');
    }
}
