<?php

class mercancia_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_base':
                    try {
                        $this->reporte_base($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base');
                    }
                    break;
                case 'capturar_salida':
                    try {
                        $this->capturar_salida($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'capturar_nueva_salida');
                    }
                    break;
                case 'render_vista':
                    try {
                        $this->render_salida($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'render_salida');
                    }
                    break;
                case 'update_status':
                    try {
                        $this->update_status($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'update_status');
                    }
                    break;
                case 'editar_mercancia':
                    try {
                        $this->editar_mercancia($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'editar_mercancia');
                    }
                    break;
                case 'eliminar_salida':
                    try {
                        $this->eliminar_salida($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'eliminar_salida');
                    }
                    break;
                case 'reactivate_salida':
                    try {
                        $this->reactivate_salida($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reactivate_salida');
                    }
                    break;
                case 'vista_detallada_salida':
                    try {
                        $this->vista_detallada_salida($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_detallada_salida');
                    }
                    break;
                case 'get_folios_centrodeservicio':
                    try {
                        $this->get_folios_centrodeservicio($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'get_folios_centrodeservicio');
                    }
                    break;
                case 'get_folios_cotizaciones':
                    try {
                        $this->get_folios_cotizaciones($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'get_folios_cotizaciones');
                    }
                    break;
                case 'vincular_piezas_centrodeservicio':
                    try {
                        $this->vincular_piezas_centrodeservicio($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vincular_piezas_centrodeservicio');
                    }
                    break;
                case 'ventas_user_list':
                    try {
                        $this->ventas_user_list($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'ventas_user_list');
                    }
                    break;
            }
        }
    }

    private function reporte_base($datos)
    {
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;
        $query = db_select('partners_mercancia', 'pm');
        $query->innerJoin('users', 'u', 'pm.id_usuario_solicito = u.uid');
        $query->innerJoin('partners_mercancia_productos', 'pmp', 'pmp.id_salida = pm.id_salida');
        $query->leftJoin('partners_clientes', 'pc', 'pm.id_cliente = pc.id_cliente ');
        $query->addExpression('SUM(pmp.costo)', 'costo');
        $query->addExpression('SUM(pmp.venta)', 'venta');
        $query->fields('u', array('name'));
        $query->fields('pm');
        $query->fields('pmp', array('nombre_producto', 'upc_producto', 'serie_producto'));
        $query->fields('pc', array('nombre_cliente'));
        $query->groupBy('pm.id_salida');

        // Filtros
        if ($f_inicio == $f_final) {
            $f_final_same_day = $f_inicio + 86040;
            if ($datos->filter->start_date) {
                $query->condition('pm.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
            }
        } else {
            if ($datos->filter->start_date) {
                $query->condition('pm.created_at', array($f_inicio, $f_final), 'BETWEEN');
            }
        }

        // Filtro - Search Bar
        if ($datos->filter->search_bar != null) {
            $salida_or = db_or()
                ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pm.detalle_salida', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pmp.nombre_producto', '%' . $datos->filter->search_bar . '%', 'LIKE');
            $query->condition($salida_or);
        }

        // Filtro - Usuario Solicito
        if ($datos->filter->usuario != 0) {
            $query->condition('pm.id_usuario_solicito', $datos->filter->usuario);
        }

        // Filtro - Procesado
        if ($datos->filter->procesado != null) {
            $query->condition('pm.procesado', $datos->filter->procesado);
        }

        $query->condition('pm.salida_eliminada', 1, '!=');
        $query->orderBy($datos->sort->sort_by, $datos->sort->order);

        $query_datos = $query->execute();

        $salidas = [];
        while ($row = $query_datos->fetchAssoc()) {
            $fecha = date('d/m/y', $row['created_at']);
            # $check_area = $this->check_area_salida($row['id_usuario_solicito']);
            if ($row['procesado'] == 0) {
                if ($row['reporte_procesado'] == 0 && $row['tipo_salida'] == 2) { // Solo aplica para las salidas de soporte
                    $procesado = array("data" => 'No', "class" => array("status_procesar", 'status-red', "text-center", "cursor-pointer"), "data-reject" => 1);
                } else {
                    $procesado = array("data" => 'No', "class" => array("status_procesar", 'status-red', "text-center", "cursor-pointer"));
                }
            } else if ($row['procesado'] == 1) {
                if ($row['reporte_procesado'] == 0 && $row['tipo_salida'] == 2) { // Solo aplica para las salidas de soporte
                    $procesado = array("data" => 'Si', "class" => array("status_procesar", 'status-green', "text-center", "cursor-pointer"), "data-reject" => 1);
                } else {
                    $procesado = array("data" => 'Si', "class" => array("status_procesar", 'status-green', "text-center", "cursor-pointer"));
                }
            } else if ($row['procesado'] == 2) {
                if ($row['reporte_procesado'] == 0 && $row['tipo_salida'] == 2) { // Solo aplica para las salidas de soporte
                    $procesado = array("data" => 'Regresado', "class" => array("status_procesar", 'status-green', "text-center", "cursor-pointer"), "data-reject" => 1);
                } else {
                    $procesado = array("data" => 'Regresado', "class" => array("status_procesar", 'status-green', "text-center", "cursor-pointer"));
                }
            } else if ($row['procesado'] == 3) {
                if ($row['reporte_procesado'] == 0 && $row['tipo_salida'] == 2) { // Solo aplica para las salidas de soporte
                    $procesado = array("data" => 'Especial', "class" => array("status_procesar", 'status-purple', "text-center", "cursor-pointer"), "data-reject" => 1);
                } else {
                    $procesado = array("data" => 'Especial', "class" => array("status_procesar", 'status-purple', "text-center", "cursor-pointer"));
                }
            }


            // Tipo salida
            if ($row['tipo_salida'] == 1) {
                $tipo_salida = array("data" => "CTS", "class" => "text-center");
            } else if ($row['tipo_salida'] == 2) {
                $tipo_salida = array("data" => "Soporte", "class" => "text-center");
            } else if ($row['tipo_salida'] == 3) {
                $tipo_salida = array("data" => "ML", "class" => "text-center");
            } else if ($row['tipo_salida'] == 4) {
                $tipo_salida = array("data" => "Linio", "class" => "text-center");
            } else if ($row['tipo_salida'] == 5) {
                $tipo_salida = array("data" => "Otro", "class" => "text-center");
            } else if ($row['tipo_salida'] == 6) {
                $tipo_salida = array("data" => "CCTV", "class" => "text-center");
            } else {
                $tipo_salida = array("data" => "N/A", "class" => "text-center");

            }


            $ver = array("data" => "<i class='fa fa-print' aria-hidden='true'></i>", "class" => array("text-center", "vista_salida", "cursor-pointer"));

            // Observaciones | Notas internas
            if ($row['observaciones'] != null) {
                $observaciones = array("data" => 'Obs', "class" => array("status-yellow", "status_obs", "text-center", "cursor-pointer"));
            } else {
                $observaciones = array("data" => 'Obs', "class" => array("text-center", "status_obs", "cursor-pointer"));
            }

            $cant_prod = db_select('partners_mercancia_productos', 'pmp')
                ->fields('pmp', array('id_salida'))
                ->condition('id_salida', $row['id_salida'])
                ->execute();
            $cant_prod = $cant_prod->rowCount();
            //cuando hay solo uno
            if ($cant_prod == 1) {
                $codigo = $row['upc_producto'];
                $serie = $row['serie_producto'];
            } else {
                //cuando hay varios
                $codigo = array("data" => $row['upc_producto'], "class" => array("cursor-pointer", "vista_detalle_salida"));
                $serie = array("data" => $row['serie_producto'], "class" => array("cursor-pointer", "vista_detalle_salida"));
            }

            $costo = array("data" => number_format($row['costo'], 2, '.', ','), "class" => "text-right");
            $precio = array("data" => number_format($row['venta'], 2, '.', ','), "class" => "text-right");
            $borrar = array("data" => '<i class="fas fa-trash-alt"></i>', "class" => array("cursor-pointer", "text-center", "eliminar_salida", "text-danger"));
            $editar = array("data" => '<i class="fas fa-pencil-alt"></i>', "class" => array("cursor-pointer", "text-center", "editar_salida"));


            // En base al usuario que solicitó la salida, ver si está en el área de CCTV o Soporte, y si lo está, entonces solo a esas
            // las podrán proocesar con especial. REVISAR CON ROBERTO A VER SI ESTÁ CORRECTO DE ESTA MANERA
            $cctv_rid = array_search('CCTV', user_roles());
            $soporte_rid = array_search('Soporte', user_roles());
            $user_solicito = user_load($row['id_usuario_solicito']);
            if (user_has_role($cctv_rid, $user_solicito) || user_has_role($soporte_rid, $user_solicito)) {
                $allow_especial = true;
            } else {
                $allow_especial = false;
            }
            $salidas[] = array(
                "data" => array(
                    $row['id_salida'],
                    $fecha,
                    mb_substr($row['nombre_cliente'], 0, 20, "utf-8"),
                    $row['name'],
                    mb_substr($row['nombre_producto'], 0, 20, "utf-8"),
                    $row['detalle_salida'],
                    $codigo,
                    $serie,
                    $costo,
                    $precio,
                    $tipo_salida,
                    $procesado,
                    $ver,
                    $observaciones,
                    $editar,
                    $borrar,
                ),
                "data-id-salida" => $row['id_salida'],
                "data-is-supervisor" => user_has_role(10),
                "data-is-reporte" => $allow_especial
            );


        }


        // Header -- Sort
        $header_cols = array(
            array("name" => array("data" => "Vale", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Solicitó", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Pieza", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Código", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Serie", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
            array("name" => array("data" => "Venta", "class" => "filter-number col-venta"), "sortable" => 0),
            array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Procesado", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Ver", "class" => "dont-filter"), "sortable" => 0),
            array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
            array("name" => array("data" => '<i class="fas fa-pencil-alt"></i>', "class" => "dont-filter"), "sortable" => 0),
            array("name" => array("data" => '<i class="fas fa-trash-alt"></i>', "class" => "dont-filter"), "sortable" => 0),
        );


        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


        $table = array(
            "header" => $header,
            "rows" => $salidas,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_mercancia", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;

    }

    private function check_area_salida($uid)
    {
        $role_soporte = user_role_load_by_name('Soporte');
        $role_cctv = user_role_load_by_name('CCTV');
        $uid = user_load($uid);
        $check = 0;
        if (user_has_role($role_soporte->rid, $uid) || user_has_role($role_cctv->rid, $uid)) {
            $check++;
        }
        return $check;
    }

    private function capturar_salida($datos)
    {
        global $user;
        $new_salida = db_insert('partners_mercancia')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => $user->uid,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid,
                'id_usuario_solicito' => $datos->usuario_solicita_salida,
                'id_cliente' => $datos->id_cliente,
                'detalle_salida' => $datos->detalle,
                'vinculacion_cotizacion' => (isset($datos->id_cotizacion) && $datos->id_cotizacion != '') ? $datos->id_cotizacion : null,
                'tipo_salida' => $datos->tipo_salida
            ))
            ->execute();

        if (isset($datos->id_cotizacion) && $datos->id_cotizacion != '') {
            db_update('partners_cotizaciones')
                ->fields(array(
                    'cotizacion_vinculada' => 1
                ))
                ->condition('id_cotizacion', $datos->id_cotizacion)
                ->execute();
        }

        foreach ($datos->productos as $producto) {
            db_insert('partners_mercancia_productos')
                ->fields(array(
                    'id_salida' => $new_salida,
                    'nombre_producto' => $producto->producto_name,
                    'upc_producto' => $producto->producto_upc,
                    'serie_producto' => $producto->producto_serie,
                    'costo' => strtr($producto->producto_costo, array(',' => '')),
                    'venta' => strtr($producto->producto_venta, array(',' => ''))
                ))
                ->execute();
        }


        $this->register_log_actions('partners_mercancia', 'insert', 'Se capturó una salida de mercancia (id: ' . $new_salida . ')');
        $this->throw_message('success', $new_salida);
    }

    /**
     * @param $datos ->type 1 :Interno, 2: Cliente
     * @throws MpdfException
     */
    private function render_salida($datos)
    {
        $id_servicio = $datos['id_salida'];
        $type = $datos['type'];

        $productos = db_select('partners_mercancia_productos', 'pmp')
            ->fields('pmp')
            ->condition('id_salida', $id_servicio)
            ->execute()->fetchAll(PDO::FETCH_ASSOC);
        $salida_query = db_select('partners_mercancia', 'pm');
        $salida_query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pm.id_cliente');
        $salida_query->fields('pc', array('nombre_cliente'));
        $salida_query->fields('pm');
        $salida = $salida_query->condition('id_salida', $id_servicio)
            ->execute()->fetchAssoc();

        $user_name = user_load($salida['id_usuario_solicito'])->name;
        $datos['productos'] = $productos;
        $datos['salida'] = $salida;
        $datos['type'] = $type;
        $datos['user_name'] = $user_name;
        $html = render_template('php', 'mercancia.reporte_salida', $datos);
        $this->generate_pdf($html, ($type == 1) ? 'Vale Interno' : 'Vale Cliente', 'cscs', 1);
    }

    private function update_status($datos)
    {
        global $user;
        if ($datos->obs) {
            db_update('partners_mercancia')
                ->fields(array(
                    $datos->col => $datos->new_val,
                    'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_mercancia', 'id_salida', $datos->id_salida)
                ))
                ->condition('id_salida', $datos->id_salida)
                ->execute();
        } else {
            db_update('partners_mercancia')
                ->fields(array(
                    $datos->col => strtr($datos->new_val, array(',' => '')),
                ))
                ->condition('id_salida', $datos->id_salida)
                ->execute();
        }
        $this->register_log_actions('partners_mercancia', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
        $this->throw_message('success', "Cambios Guardados");
    }

    /**
     * Genera la vista para modificar una salida de mercancia y aparte genera la edición de una salida.
     * @param $datos ->type 1: Vista, 2: Capturar
     * @throws Exception
     */
    private function editar_mercancia($datos)
    {
        global $user;
        if ($datos->type == 1) {

            $get_salida = db_select('partners_mercancia_productos', 'pmp')
                ->fields('pmp')
                ->condition('id_salida', $datos->id_salida)
                ->execute()->fetchAll(PDO::FETCH_ASSOC);
            $get_salida2 = db_select('partners_mercancia', 'pm')
              ->fields('pm', array('detalle_salida', 'tipo_salida'))
              ->condition('id_salida', $datos->id_salida)
              ->execute()->fetchAll(PDO::FETCH_ASSOC);
            $folio = 0;
            $get_salida2 = $get_salida2[0];
            if($get_salida2['tipo_salida'] == 1){
              $folio = (int)substr($get_salida2['detalle_salida'], 6, strlen($get_salida2['detalle_salida']) - 6);
              if(!is_int($folio)){
                $folio = 0;
              }
            }
            $data['folio'] = $folio;
            $data['salida'] = $get_salida;
            $data['id_salida'] = $datos->id_salida;
            $template = render_template('php', 'mercancia.editar_salida', $data);
            $this->throw_message('success', $template);
        } else if ($datos->type == 2) {
            // Registrar que se editó
            db_update('partners_mercancia')
                ->fields(array(
                    'updated_at' => REQUEST_TIME,
                    'updated_by' => $user->uid
                ))
                ->condition('id_salida', $datos->id_salida)
                ->execute();
            if ($datos->deleted_elements) {
                foreach ($datos->deleted_elements as $producto) {
                    $get_pieza = db_select('partners_mercancia_productos', 'pmp');
                    $get_pieza->fields('pmp');
                    $get_pieza->condition('id_producto', $producto->id_pieza);
                    $pieza = $get_pieza->execute()->fetchAssoc();

                    $obs_txt = 'Se eliminó la pieza: ' . $pieza['upc_producto'] . ' | ' . $pieza['nombre_producto'] . ' | '
                        . $pieza['serie_producto'] . ' | costo: ' . number_format($pieza['costo'], 2, '.', ',')
                        . ' | venta: ' . number_format($pieza['venta'], 2, '.', ',')
                        . ' | por el motivo: ' . $producto->motivo;

                    $obs = $this->serialize_obs($obs_txt, 2, 'partners_mercancia', 'id_salida', $pieza['id_salida']);

                    # Caputrar la nueva observacion
                    db_update('partners_mercancia')
                        ->fields(array(
                            'observaciones' => $obs
                        ))
                        ->condition('id_salida', $pieza['id_salida'])
                        ->execute();

                    # Después de haber guardado en bitacora, ahora si eliminar la pieza.
                    db_delete('partners_mercancia_productos')
                        ->condition('id_producto', $producto->id_pieza)
                        ->execute();
                }
            }
            if ($datos->new_elements) {
                foreach ($datos->new_elements as $new_element) {
                    db_insert('partners_mercancia_productos')
                        ->fields(array(
                            'id_salida' => $datos->id_salida,
                            'nombre_producto' => $new_element->producto,
                            'upc_producto' => $new_element->upc,
                            'serie_producto' => $new_element->serie,
                            'costo' => $new_element->costo,
                            'venta' => $new_element->venta,
                        ))
                        ->execute();
                }
            }

            $this->throw_message('success', 'Mercancia editada correctamente');
            $this->register_log_actions('partners_mercancia', 'update', 'Se editó la salida de mercancia: ' . $datos->id_salida);
        }
    }


    private function eliminar_salida($datos)
    {
        db_update('partners_mercancia')
            ->fields(array(
                'salida_eliminada' => 1
            ))
            ->condition('id_salida', $datos)
            ->execute();
        $this->throw_message('success', 'Eliminada correctamente.');
        $this->register_log_actions('partners_mercancia', 'delete', 'Se eliminó la salida de mercancia: ' . $datos);
    }

    private function reactivate_salida($datos)
    {
        db_update('partners_mercancia')
            ->fields(array(
                'salida_eliminada' => 0
            ))
            ->condition('id_salida', $datos)
            ->execute();
        $this->throw_message('success', 'Reactivado correctamente.');
        $this->register_log_actions('partners_mercancia', 'update', 'Se reactivó la salida de mercancia: ' . $datos);
    }

    private function vista_detallada_salida($datos)
    {
        $salida = db_select('partners_mercancia_productos', 'pmp')
            ->fields('pmp')
            ->condition('id_salida', $datos)
            ->execute()->fetchAll(PDO::FETCH_ASSOC);
        $data['salida'] = $salida;
        $template = render_template('php', 'mercancia.vista_detallada', $data);

        $this->throw_message('success', $template);
    }

    private function get_folios_centrodeservicio($id_cliente)
    {
        $query = db_select('partners_taller', 'pt')
            ->fields('pt', array('id_registro'))
            ->condition('servicio_entregado', 1, '!=')
            ->condition('presupuesto', 2)
            ->condition('id_cliente', $id_cliente);
        $folios = $query->execute();

        while ($row = $folios->fetchAssoc()) {
            $data[] = $row['id_registro'];
        }
        $this->throw_message('success', $data);
    }

    private function get_folios_cotizaciones($datos)
    {
        $query = db_select('partners_cotizaciones', 'pc')
            ->fields('pc', array('id_cotizacion'))
            ->condition('cotizacion_vinculada', 1, '!=')
            ->condition('created_by', $datos->uid)
            ->condition('cotizacion_eliminada', 1, '!=')
            ->condition('id_cliente', $datos->id_cliente);
        $folios = $query->execute();
        $data = [];
        while ($row = $folios->fetchAssoc()) {
            $data[] = $row['id_cotizacion'];
        }
        $this->throw_message('success', $data);
    }

    /**
     * @param $datos ->1 : Render template, 2:capturar
     */
    private function vincular_piezas_centrodeservicio($datos)
    {
        if ($datos->tipo == 1) {
            $query_mercancia = db_select('partners_mercancia_productos', 'pmp')
                ->fields('pmp', array('id_producto', 'nombre_producto', 'costo'))
                ->condition('id_salida', $datos->id_vale)
                ->execute()->fetchAll(PDO::FETCH_ASSOC);
            $id_presupuesto = db_select('partners_taller', 'pt')
                ->fields('pt', array('id_presupuesto'))
                ->condition('id_registro', $datos->id_folio)
                ->execute()->fetchField();
            $query_folio = db_select('partners_taller_presupuesto_datos', 'ptpd')
                ->fields('ptpd', array('id_dato', 'descripcion'))
                ->condition('autorizacion', 1)
                ->condition('tipo', 1)
                ->condition('id_presupuesto', $id_presupuesto);
            $folio_piezas = $query_folio->execute()->fetchAll(PDO::FETCH_ASSOC);

            $data['piezas_mercancia'] = $query_mercancia;
            $data['piezas_folio'] = $folio_piezas;
            $data['id_vale'] = $datos->id_vale;
            $data['id_folio'] = $datos->id_folio;
            $template = render_template('php', 'mercancia.vincular_piezas', $data);
            $this->throw_message('success', $template);
        } else {
            foreach ($datos->datos as $pieza) {
                db_update('partners_taller_presupuesto_datos')
                    ->fields(array(
                        'costo' => $pieza->costo
                    ))
                    ->condition('id_dato', $pieza->id_pieza)
                    ->execute();
            }

            // Se procesa automáticamente la salida de mercancia
            db_update('partners_mercancia')
                ->fields(array(
                    'reporte_procesado' => 1,
                    'observaciones' => $this->serialize_obs("Piezas ya vínculadas en el Centro de Servicio con el Folio: " . $datos->id_folio, 2, 'partners_mercancia', 'id_salida', $datos->id_vale)
                ))
                ->condition('id_salida', $datos->id_vale)
                ->execute();

            $this->throw_message('success', 'Salida de mercancia generada y vinculada correctamente.');
            $this->register_log_actions('partners_taller_presupuesto_datos', 'update', 'Se vinculo el costo de las piezas con una salida de mercancia, Folio Centro de servicio: ' . $datos->id_folio . ' | Salida de mercancia: ' . $datos->id_vale);
        }
    }

    /**
     * Regresa una lista de usuarios filtrados por cierto Rol.
     * @param $rol
     */
    private function ventas_user_list($rol)
    {
        $role = user_role_load_by_name($rol);
        $query = 'SELECT ur.uid
        FROM {users_roles} AS ur
        WHERE ur.rid = :rid';
        $result = db_query($query, array(':rid' => $role->rid));
        $uids = $result->fetchCol();

        $usuarios = db_select('users', 'u')
            ->fields('u', array('uid', 'name'))
            ->condition('status', 1)
            ->condition('uid', $uids, 'IN')
            ->condition('uid', 26, '!=')// Soporte Recepción
            ->orderBy('name', 'ASC')
            ->execute()->fetchAll(PDO::FETCH_ASSOC);

        $users = $usuarios;


        $users_in_role = array();
        foreach ($users as $row) {
            $users_in_role[] = array(
                'uid' => $row['uid'],
                'name' => $row['name']
            );
        }

        $this->throw_message('success', json_encode($users_in_role));
    }


}
