<?php

use Partners\Cliente\ClienteController;

class log_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_base':
                    try {
                        $this->reporte_base($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base');
                    }
                    break;
                case 'fix_clientes_revisar':
                    try {
                        $this->fix_clientes_revisar($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'fix_clientes_revisar');
                    }
                    break;
                case 'fix_clientes_mover':
                    try {
                        $this->fix_clientes_mover($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'fix_clientes_mover');
                    }
                    break;
                case 'comparar_precios':
                    try {
                        $this->comparar_precios($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'comparar_precios');
                    }
                    break;
                case 'reporte_base_solicitud_reclasificacion':
                    try {
                        $this->reporte_base_solicitud_reclasificacion($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base_solicitud_reclasificacion');
                    }
                    break;
                case 'update_status_sugerencia':
                    try {
                        $this->update_status_sugerencia($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'update_status_sugerencia');
                    }
                    break;
                case 'reporte_base_reporte_clientes_nuevos':
                    try {
                        $this->reporte_base_reporte_clientes_nuevos($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base_reporte_clientes_nuevos');
                    }
                    break;
            }
        }
    }

    /**
     * @param $datos
     * @throws Exception
     */
    private function reporte_base($datos)
    {
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;
        $query = db_select('partners_log_actions', 'pl');
        $query->innerJoin('users', 'u', 'u.uid = pl.uid');
        $query->fields('pl');
        $query->fields('u', array('name'));
        // Filtros
        if ($f_inicio == $f_final) {
            $f_final_same_day = $f_inicio + 86040;
            if ($datos->filter->start_date) {
                $query->condition('pl.timestamp', array($f_inicio, $f_final_same_day), 'BETWEEN');
            }
        } else {
            if ($datos->filter->start_date) {
                $query->condition('pl.timestamp', array($f_inicio, $f_final), 'BETWEEN');
            }
        }
        $query->orderBy($datos->sort->sort_by, $datos->sort->order);
        $query_datos = $query->execute();
        while ($row = $query_datos->fetchAssoc()) {
            $fecha = date('d/m/y H:i:s', $row['timestamp']);
            $log[] = array(
                "data" => array(
                    $row['id_action'],
                    $fecha,
                    ($row['name']) ? $row['name'] : "SYSTEM",
                    $row['hostname'],
                    $row['table_at'],
                    $row['type'],
                    $row['message']
                )
            );
        }
        $header_cols = array(
            array("name" => array("data" => "ID", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "IP", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Tabla", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0)
        );
        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);
        $table = array(
            "header" => $header,
            "rows" => $log,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_log", "class" => array("table-sm"))
        );
        $result = theme('table', $table);
        echo $result;
    }

    /**
     * Revisa todos los registros existentes con los dos clientes que se pasan aquí y regresarlos para confirmar el movimiento
     * @param $datos
     * @throws Exception
     */
    private function fix_clientes_revisar($datos)
    {

        $table_A = [];
        $table_B = [];
        $tabla_a = "Sin Registros";
        $tabla_b = "Sin Registros";
        $header_cols = array(
            array("name" => array("data" => "ID Registro", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => "Fecha Creación", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Tabla", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0)
        );

        $header = sys_tools::sort_table('', '', $header_cols);

        // Validar que exista el cliente A
        $get_nombre_cliente_a = db_select('partners_clientes', 'pc');
        $get_nombre_cliente_a->fields('pc', array('nombre_cliente'));
        $get_nombre_cliente_a->condition('id_cliente', $datos->from);
        $get_nombre_cliente_a->condition('cancelado', 0);
        $nombre_cliente_a = $get_nombre_cliente_a->execute()->fetchField();

        if ($nombre_cliente_a) {
            // Buscar Contactos
            $get_contactos_a = db_select('partners_clientes', 'pc');
            $get_contactos_a->fields('pc', array('id_cliente', 'created_at', 'nombre_cliente'));
            $get_contactos_a->condition('pc.id_padre', $datos->from);
            $contactos_a = $get_contactos_a->execute();
            while ($row = $contactos_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_cliente'],
                        date('d-m-Y', $row['created_at']),
                        'partners_clientes',
                        'Contacto: ' . $row['nombre_cliente']
                    )
                );
            }

            // Buscar Pendientes
            $get_pendientes_a = db_select('partners_pendientes', 'pp');
            $get_pendientes_a->fields('pp', array('id_pendiente', 'created_at'));
            $get_pendientes_a->condition('pp.id_cliente', $datos->from);
            $pendientes_a = $get_pendientes_a->execute();

            while ($row = $pendientes_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_pendiente'],
                        date('d-m-Y', $row['created_at']),
                        'partners_pendientes',
                        'Registro de Pendiente'
                    )
                );
            }


            // Buscar CCTV
            $get_cctv_a = db_select('partners_cctv', 'pcc');
            $get_cctv_a->fields('pcc', array('id_proyecto', 'created_at'));
            $get_cctv_a->condition('pcc.id_cliente', $datos->from);
            $cctv_a = $get_cctv_a->execute();

            while ($row = $cctv_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_proyecto'],
                        date('d-m-Y', $row['created_at']),
                        'partners_cctv',
                        'Registro de Proyecto CCTV'
                    )
                );
            }

            // Buscar Cotizaciones
            $get_cotizacion_a = db_select('partners_cotizaciones', 'pc');
            $get_cotizacion_a->fields('pc', array('id_cotizacion', 'created_at'));
            $get_cotizacion_a->condition('pc.id_cliente', $datos->from);
            $cotizacion_a = $get_cotizacion_a->execute();

            while ($row = $cotizacion_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_cotizacion'],
                        date('d-m-Y', $row['created_at']),
                        'partners_cotizaciones',
                        'Cotización'
                    )
                );
            }


            // Buscar Mercancia
            $get_mercancia_a = db_select('partners_mercancia', 'pm');
            $get_mercancia_a->fields('pm', array('id_salida', 'created_at'));
            $get_mercancia_a->condition('pm.id_cliente', $datos->from);
            $mercancia_a = $get_mercancia_a->execute();

            while ($row = $mercancia_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_salida'],
                        date('d-m-Y', $row['created_at']),
                        'partners_mercancia',
                        'Salida de Mercancía'
                    )
                );
            }

            // Buscar Orden de Prepago
            $get_prepago_a = db_select('partners_prepago_ordenes', 'pp');
            $get_prepago_a->fields('pp', array('id_orden', 'created_at'));
            $get_prepago_a->condition('pp.id_cliente', $datos->from);
            $prepago_a = $get_prepago_a->execute();

            while ($row = $prepago_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_orden'],
                        date('d-m-Y', $row['created_at']),
                        'partners_prepago_ordenes',
                        'Orden de Prepago'
                    )
                );
            }

            // Buscar Recibos de Dinero
            $get_recibo_a = db_select('partners_recibo', 'pr');
            $get_recibo_a->fields('pr', array('id_recibo', 'created_at'));
            $get_recibo_a->condition('pr.id_cliente', $datos->from);
            $recibo_a = $get_recibo_a->execute();

            while ($row = $recibo_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_recibo'],
                        date('d-m-Y', $row['created_at']),
                        'partners_recibo',
                        'Recibo de Dinero'
                    )
                );
            }

            // Buscar Renovaciones
            $get_renovacion_a = db_select('partners_renovaciones', 'pr');
            $get_renovacion_a->fields('pr', array('id_renovacion', 'created_at'));
            $get_renovacion_a->condition('pr.id_cliente', $datos->from);
            $renovacion_a = $get_renovacion_a->execute();

            while ($row = $renovacion_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_renovacion'],
                        date('d-m-Y', $row['created_at']),
                        'partners_renovacion',
                        'Renovación'
                    )
                );
            }

            // Buscar Servicios
            $get_servicio_a = db_select('partners_servicios', 'ps');
            $get_servicio_a->fields('ps', array('id_servicio', 'created_at'));
            $get_servicio_a->condition('ps.id_cliente', $datos->from);
            $servicio_a = $get_servicio_a->execute();

            while ($row = $servicio_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_servicio'],
                        date('d-m-Y', $row['created_at']),
                        'partners_servicios',
                        'Registro de Servicio '
                    )
                );
            }

            // Buscar Taller
            $get_taller_a = db_select('partners_taller', 'pt');
            $get_taller_a->fields('pt', array('id_registro', 'created_at'));
            $get_taller_a->condition('pt.id_cliente', $datos->from);
            $taller_a = $get_taller_a->execute();

            while ($row = $taller_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_registro'],
                        date('d-m-Y', $row['created_at']),
                        'partners_taller',
                        'Registro de Centro de Servicio'
                    )
                );
            }

            // Buscar Web
            $get_web_a = db_select('partners_web', 'pw');
            $get_web_a->fields('pw', array('id_proyecto', 'created_at'));
            $get_web_a->condition('pw.id_cliente', $datos->from);
            $web_a = $get_web_a->execute();

            while ($row = $web_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_proyecto'],
                        date('d-m-Y', $row['created_at']),
                        'partners_web',
                        'Proyecto Web'
                    )
                );
            }

            if (!empty($table_A)) {
                $tablea = array(
                    "header" => $header,
                    "rows" => $table_A,
                    "sticky" => false,
                    "attributes" => array("id" => "table_reporteador_cliente_from", "class" => array("table-sm"))
                );
                $tabla_a = theme('table', $tablea);
            }
        }


        // Validar que exista el cliente B
        $get_nombre_cliente_b = db_select('partners_clientes', 'pc');
        $get_nombre_cliente_b->fields('pc', array('nombre_cliente'));
        $get_nombre_cliente_b->condition('id_cliente', $datos->to);
        $get_nombre_cliente_b->condition('cancelado', 0);
        $nombre_cliente_b = $get_nombre_cliente_b->execute()->fetchField();

        if ($nombre_cliente_b) {
            // Buscar Contactos
            $get_contactos_b = db_select('partners_clientes', 'pc');
            $get_contactos_b->fields('pc', array('id_cliente', 'created_at', 'nombre_cliente'));
            $get_contactos_b->condition('pc.id_padre', $datos->to);
            $contactos_b = $get_contactos_b->execute();
            while ($row = $contactos_b->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_cliente'],
                        date('d-m-Y', $row['created_at']),
                        'partners_clientes',
                        'Contacto: ' . $row['nombre_cliente']
                    )
                );
            }

            // Buscar Pendientes
            $get_pendientes_b = db_select('partners_pendientes', 'pp');
            $get_pendientes_b->fields('pp', array('id_pendiente', 'created_at'));
            $get_pendientes_b->condition('pp.id_cliente', $datos->to);
            $pendientes_a = $get_pendientes_b->execute();
            while ($row = $pendientes_a->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_pendiente'],
                        date('d-m-Y', $row['created_at']),
                        'partners_pendientes',
                        'Registro de Pendiente'
                    )
                );
            }


            // Buscar CCTV
            $get_cctv_b = db_select('partners_cctv', 'pcc');
            $get_cctv_b->fields('pcc', array('id_proyecto', 'created_at'));
            $get_cctv_b->condition('pcc.id_cliente', $datos->to);
            $cctv_b = $get_cctv_b->execute();

            while ($row = $cctv_b->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_proyecto'],
                        date('d-m-Y', $row['created_at']),
                        'partners_cctv',
                        'Registro de Proyecto CCTV'
                    )
                );
            }

            // Buscar Cotizaciones
            $get_cotizacion_b = db_select('partners_cotizaciones', 'pc');
            $get_cotizacion_b->fields('pc', array('id_cotizacion', 'created_at'));
            $get_cotizacion_b->condition('pc.id_cliente', $datos->to);
            $cotizacion_b = $get_cotizacion_b->execute();

            while ($row = $cotizacion_b->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_cotizacion'],
                        date('d-m-Y', $row['created_at']),
                        'partners_cotizaciones',
                        'Cotización'
                    )
                );
            }


            // Buscar Mercancia
            $get_mercancia_b = db_select('partners_mercancia', 'pm');
            $get_mercancia_b->fields('pm', array('id_salida', 'created_at'));
            $get_mercancia_b->condition('pm.id_cliente', $datos->to);
            $mercancia_b = $get_mercancia_b->execute();

            while ($row = $mercancia_b->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_salida'],
                        date('d-m-Y', $row['created_at']),
                        'partners_mercancia',
                        'Salida de Mercancía'
                    )
                );
            }

            // Buscar Orden de Prepago
            $get_prepago_a = db_select('partners_prepago_ordenes', 'pp');
            $get_prepago_a->fields('pp', array('id_orden', 'created_at'));
            $get_prepago_a->condition('pp.id_cliente', $datos->from);
            $prepago_a = $get_prepago_a->execute();

            while ($row = $prepago_a->fetchAssoc()) {
                $table_A[] = array(
                    "data" => array(
                        $row['id_orden'],
                        date('d-m-Y', $row['created_at']),
                        'partners_prepago_ordenes',
                        'Orden de Prepago'
                    )
                );
            }

            // Buscar Recibos de Dinero
            $get_recibo_b = db_select('partners_recibo', 'pr');
            $get_recibo_b->fields('pr', array('id_recibo', 'created_at'));
            $get_recibo_b->condition('pr.id_cliente', $datos->to);
            $recibo_b = $get_recibo_b->execute();

            while ($row = $recibo_b->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_recibo'],
                        date('d-m-Y', $row['created_at']),
                        'partners_recibo',
                        'Recibo de Dinero'
                    )
                );
            }

            // Buscar Renovaciones
            $get_renovacion_b = db_select('partners_renovaciones', 'pr');
            $get_renovacion_b->fields('pr', array('id_renovacion', 'created_at'));
            $get_renovacion_b->condition('pr.id_cliente', $datos->to);
            $renovacion_b = $get_renovacion_b->execute();

            while ($row = $renovacion_b->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_renovacion'],
                        date('d-m-Y', $row['created_at']),
                        'partners_renovacion',
                        'Renovación'
                    )
                );
            }

            // Buscar Servicios
            $get_servicio_b = db_select('partners_servicios', 'ps');
            $get_servicio_b->fields('ps', array('id_servicio', 'created_at'));
            $get_servicio_b->condition('ps.id_cliente', $datos->to);
            $servicio_b = $get_servicio_b->execute();

            while ($row = $servicio_b->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_servicio'],
                        date('d-m-Y', $row['created_at']),
                        'partners_servicios',
                        'Registro de Servicio '
                    )
                );
            }

            // Buscar Taller
            $get_taller_b = db_select('partners_taller', 'pt');
            $get_taller_b->fields('pt', array('id_registro', 'created_at'));
            $get_taller_b->condition('pt.id_cliente', $datos->to);
            $taller_b = $get_taller_b->execute();

            while ($row = $taller_b->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_registro'],
                        date('d-m-Y', $row['created_at']),
                        'partners_taller',
                        'Registro de Centro de Servicio'
                    )
                );
            }

            // Buscar Web
            $get_web_b = db_select('partners_web', 'pw');
            $get_web_b->fields('pw', array('id_proyecto', 'created_at'));
            $get_web_b->condition('pw.id_cliente', $datos->to);
            $web_b = $get_web_b->execute();

            while ($row = $web_b->fetchAssoc()) {
                $table_B[] = array(
                    "data" => array(
                        $row['id_proyecto'],
                        date('d-m-Y', $row['created_at']),
                        'partners_web',
                        'Proyecto Web'
                    )
                );
            }

            if (!empty($table_B)) {
                $tableb = array(
                    "header" => $header,
                    "rows" => $table_B,
                    "sticky" => false,
                    "attributes" => array("id" => "table_reporteador_cliente_to", "class" => array("table-sm"))
                );

                $tabla_b = theme('table', $tableb);
            }

        }

        $data = array(
            "success_from" => ($nombre_cliente_a) ? "true" : "false",
            "success_to" => ($nombre_cliente_b) ? "true" : "false",
            "nombre_from" => $nombre_cliente_a,
            "nombre_to" => $nombre_cliente_b,
            "tabla_from" => $tabla_a,
            "tabla_to" => $tabla_b
        );

        $this->throw_message('success', json_encode($data));
    }

    /**
     * Mueve todos los datos que tenga un cliente a otro. De esta manera se puede "limpiar" la base de datos
     * de Clientes al elegir los datos correoctos.
     * @param $datos
     */
    private function fix_clientes_mover($datos)
    {

        // Buscar Contactos
        db_update('partners_clientes')
            ->fields(
                array(
                    'id_padre' => $datos->to
                )
            )
            ->condition('id_padre', $datos->from)
            ->execute();


        // Buscar Pendientes
        db_update('partners_pendientes')
            ->fields(
                array(
                    'id_cliente' => $datos->to
                )
            )
            ->condition('id_cliente', $datos->from)
            ->execute();


        // Buscar CCTV
        db_update('partners_cctv')
            ->fields(
                array(
                    'id_cliente' => $datos->to
                )
            )
            ->condition('id_cliente', $datos->from)
            ->execute();

        // Buscar Cotizaciones
        db_update('partners_cotizaciones')
            ->fields(
                array(
                    'id_cliente' => $datos->to
                )
            )
            ->condition('id_cliente', $datos->from)
            ->execute();


        // Buscar Mercancia
        db_update('partners_mercancia')
            ->fields(
                array(
                    'id_cliente' => $datos->to
                )
            )
            ->condition('id_cliente', $datos->from)
            ->execute();

        /*
         // Buscar Orden de Prepago
         db_update('partners_prepago_ordenes')
            ->fields(array(
                'id_cliente' => $datos->to
            ))
            ->condition('id_cliente', $datos->from)
            ->execute();
        */

        // Buscar Recibos de Dinero
        db_update('partners_recibo')
            ->fields(
                array(
                    'id_cliente' => $datos->to
                )
            )
            ->condition('id_cliente', $datos->from)
            ->execute();

        // Buscar Renovaciones
        db_update('partners_renovaciones')
            ->fields(
                array(
                    'id_cliente' => $datos->to
                )
            )
            ->condition('id_cliente', $datos->from)
            ->execute();

        // Buscar Servicios
        db_update('partners_servicios')
            ->fields(
                array(
                    'id_cliente' => $datos->to
                )
            )
            ->condition('id_cliente', $datos->from)
            ->execute();

        // Buscar Taller
        db_update('partners_taller')
            ->fields(
                array(
                    'id_cliente' => $datos->to
                )
            )
            ->condition('id_cliente', $datos->from)
            ->execute();

        // Buscar Web
        db_update('partners_web')
            ->fields(
                array(
                    'id_cliente' => $datos->to
                )
            )
            ->condition('id_cliente', $datos->from)
            ->execute();


        $this->throw_message('success', 'Datos de Clientes actualizados correctamente.');

    }


    /**
     * Buscar un producto en especifico por texto en la descripción, básicamente es lo mismo que si usará la función de
     * ObtenerArticulo, a diferencia de que si esto se va a hacer por cada producto, en un punto se
     * van a tener muchos productos, y por cada producto haría una consulta, entonces de está forma
     * solo se hace una sola consulta, y después se hace la búsqueda con un ciclo.
     * @param $data
     * @param $descripcion
     * @return array
     */
    private function search_product_item_pch(&$data, $descripcion)
    {
        $item = [];
        foreach ($data as $struct) {
            if (strpos(strtoupper($struct->descripcion), strtoupper($descripcion)) !== false) {
                $item[] = $struct;
            }
        }
        return $item;
    }


    /**
     * Busca el producto en PCH y en CVA y devuelve los datos que se hayan encontrado sobre el producto con la
     * finalidad de facilitar la busqueda de un producto en lugar de hacerlo manualmente en los sistemas de
     * los proveedores.
     * @param $datos
     */
    private function comparar_precios($datos)
    {
        $sku = $datos->skuProducto;

        $found_on_pch = false;
        $error_pch = '';
        if ($datos->searchBy == 'desc') {
            # Buscar por descripción PCH
            try {
                $client = new SoapClient("http://serviciosmayoristas.pchmayoreo.com/servidor.php?wsdl", array("cache_wsdl" => WSDL_CACHE_NONE));
                $result = $client->__soapCall(
                    "ObtenerListaArticulos",
                    array(
                        5476,
                        //NUMERO DE CLIENTE
                        512244 //CLAVE DE ACCESO
                    )
                );

                if ($result->estatus) {
                    $data = $result->datos;
                } else {
                    $error_pch = $result->mensaje;
                }

            } catch (Exception $ex) {
                $error_pch = $ex->getMessage();
            }

            if ($error_pch != '') {
                $items_pch = $this->search_product_item_pch($data, $sku);

                foreach ($items_pch as $item) {
                    # Sacar existencias de inventarios
                    $gdl = 0;
                    $df = 0;
                    if (isset($item->inventario[0]->almacen) && $item->inventario[0]->almacen == 1) {
                        # GDL
                        $gdl = $item->inventario[0]->existencia;
                    } else if (isset($item->inventario[0]->almacen) && $item->inventario[0]->almacen == 7) {
                        # DF
                        $df = $item->inventario[0]->existencia;
                    }

                    if (isset($item->inventario[1]->almacen) && $item->inventario[1]->almacen == 1) {
                        # GDL
                        $gdl = $item->inventario[1]->existencia;

                    } else if (isset($item->inventario[1]->almacen) && $item->inventario[1]->almacen == 7) {
                        # DF
                        $df = $item->inventario[1]->existencia;
                    }
                    $found_on_pch[] = array(
                        "clave" => $item->sku,
                        "descripcion" => $item->descripcion,
                        "skuFabricante" => $item->skuFabricante,
                        "marca" => $item->marca,
                        "precio" => $item->precio,
                        "moneda" => $item->moneda,
                        "inventario" => array(
                            "gdl" => $gdl,
                            "df" => $df
                        )
                    );
                }
            }


            # Busqueda por Descripción en CVA
            $found_on_cva = false;
            $error_cva = '';
            try {
                $path = "https://www.grupocva.com/catalogo_clientes_xml/lista_precios.xml?cliente=12181&desc=$sku";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $path);
                curl_setopt($ch, CURLOPT_FAILONERROR, 1);
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_TIMEOUT, 15);
                $sXML = curl_exec($ch);
                curl_close($ch);


                $oXML = new SimpleXMLElement($sXML);
                $i = 0;
                foreach ($oXML->item as $oEntry) {
                    $found_on_cva[] = array(
                        "clave" => (string) $oEntry->clave,
                        "descripcion" => (string) $oEntry->descripcion,
                        "skuFabricante" => (string) $oEntry->codigo_fabricante,
                        "marca" => (string) $oEntry->marca,
                        "precio" => (float) $oEntry->precio,
                        "moneda" => (string) $oEntry->moneda,
                        "inventario" => array(
                            "gdl" => (int) $oEntry->disponible,
                            "df" => (int) $oEntry->disponibleCD
                        )
                    );
                    $i++;
                }

                # No se encontraron artíuclos
                if ($i == 0) {
                    $error_cva = 'No se encontraron artículos';
                }
            } catch (Exception $ex) {
                $error_cva = $ex->getMessage();
            }


        } else {
            # BUSCAR POR SKU
            try {
                $client = new SoapClient("http://serviciosmayoristas.pchmayoreo.com/servidor.php?wsdl", array("cache_wsdl" => WSDL_CACHE_NONE));
                $result = $client->__soapCall(
                    "ObtenerArticulo",
                    array(
                        5476,
                        //NUMERO DE CLIENTE
                        512244,
                        //CLAVE DE ACCESO
                        $sku
                    )
                );

                if ($result->estatus) {
                    $dato = $result->datos;

                    # Sacar existencias de inventarios
                    $gdl = 0;
                    $df = 0;
                    if (isset($dato->inventario[0]->almacen) && $dato->inventario[0]->almacen == 1) {
                        # GDL
                        $gdl = $dato->inventario[0]->existencia;
                    } else if (isset($dato->inventario[0]->almacen) && $dato->inventario[0]->almacen == 7) {
                        # DF
                        $df = $dato->inventario[0]->existencia;
                    }

                    if (isset($dato->inventario[1]->almacen) && $dato->inventario[1]->almacen == 1) {
                        # GDL
                        $gdl = $dato->inventario[1]->existencia;

                    } else if (isset($dato->inventario[1]->almacen) && $dato->inventario[1]->almacen == 7) {
                        # DF
                        $df = $dato->inventario[1]->existencia;
                    }
                    $found_on_pch[] = array(
                        "clave" => $dato->sku,
                        "descripcion" => $dato->descripcion,
                        "skuFabricante" => $dato->skuFabricante,
                        "marca" => $dato->marca,
                        "precio" => $dato->precio,
                        "moneda" => $dato->moneda,
                        "inventario" => array(
                            "gdl" => $gdl,
                            "df" => $df
                        )
                    );
                } else {
                    $error_pch = $result->mensaje;
                }

            } catch (Exception $ex) {
                $error_pch = $ex->getMessage();
            }


            # Busqueda por SKU en cva
            $found_on_cva = false;
            $error_cva = '';
            try {
                $path = "https://www.grupocva.com/catalogo_clientes_xml/lista_precios.xml?cliente=12181&codigo=$sku";
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $path);
                curl_setopt($ch, CURLOPT_FAILONERROR, 1);
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_TIMEOUT, 15);
                $sXML = curl_exec($ch);
                curl_close($ch);


                $oXML = new SimpleXMLElement($sXML);
                $i = 0;
                foreach ($oXML->item as $oEntry) {
                    $found_on_cva[] = array(
                        "clave" => (string) $oEntry->clave,
                        "descripcion" => (string) $oEntry->descripcion,
                        "skuFabricante" => (string) $oEntry->codigo_fabricante,
                        "marca" => (string) $oEntry->marca,
                        "precio" => (float) $oEntry->precio,
                        "moneda" => (string) $oEntry->moneda,
                        "inventario" => array(
                            "gdl" => (int) $oEntry->disponible,
                            "df" => (int) $oEntry->disponibleCD
                        )
                    );
                    $i++;
                }

                # No se encontraron artíuclos
                if ($i == 0) {
                    $error_cva = 'No se encontraron artículos';
                }
            } catch (Exception $ex) {
                $error_cva = $ex->getMessage();
            }

        }


        $data = array(
            "pch" => array(
                "message" => $error_pch,
                "data" => $found_on_pch
            ),
            "cva" => array(
                "message" => $error_cva,
                "data" => $found_on_cva
            )
        );

        $this->throw_message('success', $data);
    }

    private function reporte_base_solicitud_reclasificacion($datos)
    {
        $query = db_select('partners_clientes_sugerencias_reclasificacion', 'pcsr');
        $query->innerJoin('users', 'u', 'u.uid = pcsr.created_by');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pcsr.id_cliente');
        $query->fields('pcsr');
        $query->fields('u', array('name'));
        $query->fields('pc', array('nombre_cliente'));


        $query->orderBy($datos->sort->sort_by, $datos->sort->order);
        $query_datos = $query->execute();
        $sugerencias = [];
        while ($row = $query_datos->fetchAssoc()) {
            $fecha = date('d/m/y', $row['created_at']);

            $sugerencia = array("data" => ($row['sugerencia_atendida'] != 0) ? 'Si' : 'No', "class" => array("cursor-pointer", "text-center", "cambiar_status_sugerencia", ($row['sugerencia_atendida'] != 0) ? 'status-green' : 'status-red'));


            $sugerencias[] = array(
                "data" => array(
                    $row['id_sugerencia'],
                    $fecha,
                    $row['name'],
                    $row['nombre_cliente'],
                    array("data" => $row['clasificacion_from'], "class" => "text-center"),
                    array("data" => $row['clasificacion_to'], "class" => "text-center"),
                    $row['motivo_sugerencia'],
                    $sugerencia
                ),
                "data-id-sugerencia" => $row['id_sugerencia'],
                "data-sugerencia-atendida" => $row['sugerencia_atendida']
            );
        }
        $header_cols = array(
            array("name" => array("data" => "ID", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Clasificación Actual", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Clasificación Sugerida", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Motivo", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Atendida", "class" => "filter-text"), "sortable" => 0),
        );
        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);
        $table = array(
            "header" => $header,
            "rows" => $sugerencias,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_sugerencias", "class" => array("table-sm"))
        );
        $result = theme('table', $table);
        echo $result;
    }

    /**
     * Método para actualizar el status de una sugerencia de reclasificación.
     * @param $datos
     */
    private function update_status_sugerencia($datos)
    {
        db_update('partners_clientes_sugerencias_reclasificacion')
            ->fields(
                array(
                    'sugerencia_atendida' => $datos->newVal
                )
            )
            ->condition('id_sugerencia', $datos->idSugerencia)
            ->execute();
        $this->throw_message('success', 'Estatus cambiado correctamente.');
    }

    private function reporte_base_reporte_clientes_nuevos($datos)
    {
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;

        if (count($datos->users) < 1) {
            echo "Seleccione al menos un usuario.";
            return;
        }
        $query = db_select('partners_clientes', 'pc');
        $query->leftJoin('partners_taller', 'pt', 'pc.id_cliente = pt.id_cliente');
        $query->leftJoin('partners_taller', 'ptt', 'pc.id_cliente = ptt.id_contacto');
        $query->addField('pc', 'nombre_cliente');
        $query->addField('pc', 'id_cliente');
        $query->addField('pc', 'created_by');
        $query->addField('pc', 'created_at');
        $query->addField('pt', 'id_registro', 'id_registro_taller_cliente');
        $query->condition('pc.created_by', $datos->users, 'IN');
        $query->condition('pc.tipo_cliente', 1);
        $query->condition('pc.cancelado', 1, '!=');

        if ($f_inicio == $f_final) {
            $f_final_same_day = $f_inicio + 86040;
            if ($datos->filter->start_date) {
                $query->condition('pc.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
            }
        } else {
            if ($datos->filter->start_date) {
                $query->condition('pc.created_at', array($f_inicio, $f_final), 'BETWEEN');
            }
        }


        $query->orderBy($datos->sort->sort_by, $datos->sort->order);
        $query->groupBy('pc.id_cliente');
        $query_datos = $query->execute();
        $data = [];
        while ($row = $query_datos->fetchAssoc()) {
            $data[] = array(
                "data" => array(
                    date('d-m-Y', $row['created_at']),
                    $row['id_cliente'],
                    user_load($row['created_by'])->name,
                    $row['nombre_cliente'],
                    $row['id_registro_taller_cliente'],
                ),
                "data-id-sugerencia" => $row['id_sugerencia'],
                "data-sugerencia-atendida" => $row['sugerencia_atendida']
            );
        }
        $header_cols = array(
            array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "ID Cliente", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => "Usuario Creó", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Nombre Cliente", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "ID Taller Cliente", "class" => "filter-number"), "sortable" => 0),
        );
        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);
        $table = array(
            "header" => $header,
            "rows" => $data,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_reporte_nuevos_clientes", "class" => array("table-sm"))
        );
        $result = theme('table', $table);
        echo $result;
    }

}