<?php

use PhpOffice\PhpSpreadsheet\Spreadsheet;

class facturas_web_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_base':
                    try {
                        $this->reporte_base($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base');
                    }
                    break;
                case 'cobranza_observaciones':
                    try {
                        $this->cobranza_observaciones($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'cobranza_observaciones');
                    }
                    break;
                case 'cobranza_factura_enviada':
                    try {
                        $this->cobranza_factura_enviada($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'cobranza_factura_enviada');
                    }
                    break;
                case 'cobranza_factura_pagada':
                    try {
                        $this->cobranza_factura_pagada($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'cobranza_factura_pagada');
                    }
                    break;
                case 'enviar_solo_factura':
                    try {
                        $this->enviar_solo_factura($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'enviar_solo_factura');
                    }
                    break;
                case 'vista_content_zip':
                    try {
                        $this->vista_content_zip($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_content_zip');
                    }
                    break;
                case 'vista_content_zip_adjuntar':
                    try {
                        $this->vista_content_zip_adjuntar($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_content_zip_adjuntar');
                    }
                    break;
                case 'export_excel':
                    try {
                        $this->export_excel($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'export_excel');
                    }
                    break;
            }
        }
    }

    private function reporte_base($datos)
    {
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;

        $n = 0;
        $facturas_web[] = array();
        $get_facturas_w = db_select('partners_servicios', 'ps');
        $get_facturas_w->fields('ps',
            array('factura_w_nombre_facturacion',
                'servicio_facturado',
                'factura_w_fecha',
                'factura_w_total',
                'id_servicio',
                'factura_w_servicio',
                'factura_w_correos_enviados',
                'pagado_cobranza',
                'pagado_cobranza_otro',
                'fecha_pagado_cobranza')
        );
        $get_facturas_w->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = ps.id_cliente');
        $get_facturas_w->fields('pc', array('credito'));
        $get_facturas_w->condition('servicio_facturado', 0, '!=');

        // Filtro - Search Bar, tiene prioridad sobre la fecha, lo cual significa que si este campo trae texto, debe ignorar la fecha.
        if (strlen(trim($datos->filter->search_bar)) > 0) {
            $factura_w_or = db_or()
                ->condition('ps.factura_w_nombre_facturacion', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('ps.servicio_facturado', '%' . $datos->filter->search_bar . '%', 'LIKE');
            $get_facturas_w->condition($factura_w_or);
        } else {
            // Si este campo viene vacio, entonces ahora si filtrar por fecha
            if ($f_inicio == $f_final) {
                $f_final_same_day = $f_inicio + 86040;
                if ($datos->filter->start_date) {
                    $get_facturas_w->condition('ps.fecha_pagado_cobranza', array($f_inicio, $f_final_same_day), 'BETWEEN');
                }
            } else {
                if ($datos->filter->start_date) {
                    $get_facturas_w->condition('ps.fecha_pagado_cobranza', array($f_inicio, $f_final), 'BETWEEN');
                }
            }
        }


        $get_facturas_w->orderBy('servicio_facturado', 'DESC');
        $facturas_w = $get_facturas_w->execute();
        while ($row = $facturas_w->fetchAssoc()) {
            $n++;
            // Observaciones | Notas internas
            if ($this->cobranza_observaciones($row['servicio_facturado'], 'W') != null) {
                $observaciones = array("data" => 'Obs', "class" => array("status-yellow", "status_obs_w", "text-center", "cursor-pointer"));
            } else {
                $observaciones = array("data" => 'Obs', "class" => array("text-center", "status_obs_w", "cursor-pointer"));
            }


            // Factura enviada
            if ($this->cobranza_factura_enviada($row['servicio_facturado'], 'W') != 0) {
                $factura_enviada = array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => array("text-center"));
            } else {
                $factura_enviada = '';
            }

            // Factura pagada
            if ($this->cobranza_factura_pagada($row['servicio_facturado'], 'W') == 1) {
                $factura_pagada = array("data" => 'PayPal', "class" => array("text-center"));
            } else if ($this->cobranza_factura_pagada($row['servicio_facturado'], 'W') == 2) {
                $factura_pagada = array("data" => 'PayU', "class" => array("text-center"));
            } else {
                $factura_pagada = array("data" => '0', "class" => array("text-center"));
            }


            $w_pagada = "";

            // Servicio pagado en efectivo
            if ($row['pagado_cobranza'] == 1) {
                $w_pagada = array("data" => "Efectivo", "class" => array("status-green", "text-center", "w-25"));
            } else if ($row['pagado_cobranza'] == 2) {
                // Servicio pagado otro
                $w_pagada = array("data" =>
                    ($row['pagado_cobranza_otro'] == null) ? "Cancelado" : $row['pagado_cobranza_otro'],
                    "class" => array("status-green", "text-center", "w-25"));
            } else if ($row['pagado_cobranza'] == 3) {
                $w_pagada = array("data" => "Banamex", "class" => array("status-green", "text-center", "w-25"));
            } else if ($row['pagado_cobranza'] == 4) {
                $w_pagada = array("data" => "HSBC", "class" => array("status-green", "text-center", "w-25"));
            } else if ($row['pagado_cobranza'] == 5) {
                $w_pagada = array("data" => "PayPal", "class" => array("status-green", "text-center", "w-25"));
            } else if ($row['pagado_cobranza'] == 6) {
                $w_pagada = array("data" => "PayU", "class" => array("status-green", "text-center", "w-25"));
            } else if ($row['pagado_cobranza'] == 0) {
                // Aún no está pagada.
                $w_pagada = array("data" => "No", "class" => array("status-red", "text-center", "w-25"));
            }

            // Fecha factura pagada
            if ($row['fecha_pagado_cobranza'] == 0) {
                $w_fecha_pagada = "";
            } else {
                $w_fecha_pagada = array("data" => date('d/m/Y', $row['fecha_pagado_cobranza']), "class" => array("text-center"));
            }

            $enviar_factura = array("data" => '<i class="fa fa-paper-plane" aria-hidden="true"></i>', "class" => array("text-center", "enviar_factura", "cursor-pointer"));


            // Metodo Pago
            $metodoPago = array("data" => $this->getFacturaMetodoPago($row['factura_w_servicio']));

            $notas = array("data" => (($row['credito'] == 1) ? 'A' : 'B') . '-' . $row['id_servicio'], "class" => array("text-center", "cursor-pointer", "vista_servicios_relacionados"));
            $facturas_web[] = array(
                "data" => array(
                    $n,
                    $row['factura_w_nombre_facturacion'],
                    array("data" => $row['servicio_facturado'], "class" => array("ver_factura", "cursor-pointer", "text-right", "status-blue")),
                    $metodoPago,
                    date('d/m/y', $row['factura_w_fecha']),
                    $w_pagada,
                    $w_fecha_pagada,
                    array("data" => number_format($row['factura_w_total'], 2, '.', ''), "class" => "text-right"),
                    $notas,
                    $observaciones,
                    $factura_enviada,
                    $factura_pagada,
                    $enviar_factura
                ),
                "data-folio" => $row['servicio_facturado'],
                "data-nombre-cliente" => $row['factura_w_nombre_facturacion'],
                "data-factura" => $row['factura_w_servicio'],
                "data-exists-factura" => 1,
                "data-codigo-cliente" => 1,
                "data-emails" => $row['factura_w_correos_enviados'],
                "data-serie" => 'W',
                "data-id-servicio" => $row['id_servicio'],
                "data-folio-servicio" => (($row['credito'] == 1) ? 'A' : 'B') . '-' . $row['id_servicio'],
                "data-nombre-cliente" => $row['factura_w_nombre_facturacion'],
                "data-total-servicio" => $row['factura_w_total'],
            );
        }

        $header_cols = array(
            array("name" => array("data" => "N°", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Folio", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => "Método", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Pagada", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => "Fecha Pago", "class" => "filter-date"), "sortable" => 0),
            array("name" => array("data" => "Total", "class" => "filter-number total-col"), "sortable" => 0),
            array("name" => array("data" => "Notas", "class" => "filter-text"), "sortable" => 0),
            array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
            array("name" => array("data" => "FE", "class" => "dont-filter"), "sortable" => 0),
            array("name" => array("data" => "P", "class" => "filter-number"), "sortable" => 0),
            array("name" => array("data" => '<i class="fa fa-paper-plane" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
        );


        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);

        $table = array(
            "header" => $header,
            "rows" => $facturas_web,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_facturas_web", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;
    }


    /**
     * Regresa las observaciones en caso de existir
     * @param $folio
     * @param $serie
     * @return null
     */
    private function cobranza_observaciones($folio, $serie)
    {
        $obs = db_select('partners_cobranza', 'pc')
            ->fields('pc', array('observaciones'))
            ->condition('folio', $folio)
            ->condition('serie', $serie)
            ->execute()->fetchField();

        return ($obs) ? $obs : null;
    }

    /**
     * Validar si la factura ya ha sido enviada
     * @param $folio
     * @param $serie
     * @return mixed
     */
    private function cobranza_factura_enviada($folio, $serie)
    {
        $factura_enviada = db_select('partners_cobranza', 'pc')
            ->fields('pc', array('factura_enviada'))
            ->condition('folio', $folio)
            ->condition('serie', $serie)
            ->execute()->fetchField();

        return $factura_enviada;
    }

    /**
     * Valida si la factura ya ha sido pagada
     * @param $folio
     * @param $serie
     * @return mixed
     */
    private function cobranza_factura_pagada($folio, $serie)
    {
        $factura_pagada = db_select('partners_cobranza', 'pc')
            ->fields('pc', array('factura_pagada'))
            ->condition('folio', $folio)
            ->condition('serie', $serie)
            ->execute()->fetchField();

        return $factura_pagada;
    }


    /**
     * Solo recibe los datos del la factura/cliente para que sean enviados mediante $this->enviar_correos_factura()
     * @param $datos
     * @throws Exception
     */
    private function enviar_solo_factura($datos)
    {
        $data['emails'] = $datos->emails;
        $data['ruta'] = HOME_SERVER . 'facturas/' . $datos->factura . '.zip';
        $data['num_factura'] = substr($datos->factura, -5);
        $data['factura_name'] = $datos->factura;
        $data['deleted_files'] = $datos->deleted_files;
        self::enviar_correos_factura($data);
    }

    /**
     * Envia los correos con el archivo de factura adjunto.
     * @param $datos
     * @throws Exception
     */
    public static function enviar_correos_factura($datos)
    {
        global $user, $base_root;
        // Si hay archivos a eliminar, eliminarlos mediante su index.
        if (count($datos['deleted_files']) > 0) {
            $zip = new ZipArchive;
            if ($zip->open($datos['ruta']) === TRUE) {
                for ($i = 0; $i < count($datos['deleted_files']); $i++) {
                    $zip->deleteIndex($datos['deleted_files'][$i]);
                }
            }
            $zip->close();
        }


        $to = explode(",", $datos['emails']);
        $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];
        $transport = new Swift_SendmailTransport();
        $mailer = new Swift_Mailer($transport);

        // Traer los datos de la factura
        $zip = new ZipArchive;
        if ($zip->open($datos['ruta']) === TRUE) {
            $file = $zip->getFromName($datos['factura_name'] . '.xml');
        }
        $zip->close();

        // Si pudo encontrar el xml para sacar los datos, entonces proceder y enviar los correos con los datos extraidos del xml, sino, tirar error de que
        // no pudo encontrar el xml.
        if ($file) {
            $datos_template = [];
            $factura = new SimpleXMLElement($file);
            $datos_template['Serie'] = $factura[0]['Serie'];
            $datos_template['Folio'] = $factura[0]['Folio'];
            $datos_template['Total'] = (float)$factura[0]['Total'];
            $datos_template['Moneda'] = $factura[0]['Moneda'];

            $datos_template['send_paypal'] = encrypt_decrypt('encrypt', $factura[0]['Serie'] . '~' . $factura[0]['Folio'] . '~' . $factura[0]['Total']);
            if ($user->uid == 1 || $user->uid == 8) {
                $datos_template['send_payu'] = encrypt_decrypt('encrypt', $factura[0]['Serie'] . '~' . $factura[0]['Folio'] . '~' . $factura[0]['Total']);
            }
            $body = render_template('php', 'cobranza.mail_enviar_factura', $datos_template);
            $message = (new Swift_Message())
                ->setSubject('Factura ' . $datos_template['Serie'] . $datos_template['Folio'])
                ->setFrom($from)
                ->setBody($body, 'text/html');
            $failedRecipients = [];
            $numSent = 0;
            $attachment = Swift_Attachment::fromPath($datos['ruta'], 'application/zip');
            $message->attach($attachment);

            foreach ($to as $address => $name) {
                if (is_int($address)) {
                    $message->setTo($name);
                } else {
                    $message->setTo([$address => $name]);
                }
                db_insert('partners_log_actions')
                    ->fields(array(
                        'timestamp' => REQUEST_TIME,
                        'uid' => $user->uid,
                        'hostname' => ip_address(),
                        'location' => $base_root . request_uri(),
                        'table_at' => 'partners_cobranza',
                        'type' => 'mail',
                        'message' => 'Se envió la factura ' . $datos_template['Serie'] . $datos_template['Folio'] . ' a: ' . $name
                    ))
                    ->execute();
                $numSent += $mailer->send($message, $failedRecipients);
            }

            $check_exists = db_select('partners_cobranza', 'pc')
                ->fields('pc', array('folio'))
                ->condition('folio', $datos['num_factura'])
                ->execute()->fetchField();

            if ($check_exists > 0) {
                db_update('partners_cobranza')
                    ->fields(array(
                        'factura_enviada' => 1
                    ))
                    ->condition('folio', $datos['num_factura'])
                    ->execute();
            } else {
                db_insert('partners_cobranza')
                    ->fields(array(
                        'folio' => $datos['num_factura'],
                        'apoyo' => 0,
                        'factura_enviada' => 1
                    ))
                    ->execute();
            }

            echo json_encode(array(
                "status" => "success",
                "message" => "Factura enviada correctamente a todos los correos."
            ));
        } else {
            echo json_encode(array(
                "status" => "error",
                "message" => "No se pudieron obtener los datos del xml de la factura."
            ));
        }
    }

    /**
     * Renderiza la vista de los archivos que hay dentro del pdf, para cuando se envie solo la factura sin adjuntar nada.
     * @param $datos
     */
    private function vista_content_zip($datos)
    {
        global $user;
        $zip = new ZipArchive();
        $data['datos'] = [];
        if ($zip->open(HOME_SERVER . 'facturas/' . $datos->factura . '.zip') === TRUE) {
            for ($i = 0; $i < $zip->numFiles; $i++) {
                $stat = $zip->statIndex($i);
                if ($datos->serie == 'E') {
                    if (strpos($stat['name'], "FE000") === false) {
                        $is_factura = true;
                    } else {
                        $is_factura = false;
                    }
                    $data['datos'][] = array("name" => $stat['name'], "delete" => $is_factura);
                } else {
                    if (strpos($stat['name'], "FW000") === false) {
                        $is_factura = true;
                    } else {
                        $is_factura = false;
                    }
                    $data['datos'][] = array("name" => $stat['name'], "delete" => $is_factura);
                }

            }
        }

        $data['emails'] = $datos->emails;
        $data['nombre_cliente'] = $datos->nombre_cliente;
        $data['folio_factura'] = $datos->folio_factura;
        $data['factura'] = $datos->factura;
        $data['cod_cliente'] = $datos->cod_cliente;
        $data['user_email'] = $user->mail;
        $tmpl = render_template('php', 'cobranza.vista_contenido_factura', $data);
        $this->throw_message('success', $tmpl);
    }

    /**
     * Renderiza la vista de los archivos que hay dentro del pdf, para cuando se adjunte un archivo  a la factura.
     * @param $datos
     */
    private function vista_content_zip_adjuntar($datos)
    {
        global $user;
        $zip = new ZipArchive();
        $data['datos'] = [];
        if ($zip->open(HOME_SERVER . 'facturas/' . $datos->factura . '.zip') === TRUE) {
            for ($i = 0; $i < $zip->numFiles; $i++) {
                $stat = $zip->statIndex($i);

                if ($datos->serie == 'E') {
                    if (strpos($stat['name'], "FE000") === false) {
                        $is_factura = true;
                    } else {
                        $is_factura = false;
                    }
                    $data['datos'][] = array("name" => $stat['name'], "delete" => $is_factura);
                } else {
                    if (strpos($stat['name'], "FW000") === false) {
                        $is_factura = true;
                    } else {
                        $is_factura = false;
                    }
                    $data['datos'][] = array("name" => $stat['name'], "delete" => $is_factura);
                }
            }
        }

        $data['emails'] = $datos->emails;
        $data['nombre_cliente'] = $datos->nombre_cliente;
        $data['folio_factura'] = $datos->folio_factura;
        $data['factura'] = $datos->factura;
        $data['cod_cliente'] = $datos->cod_cliente;
        $data['user_email'] = $user->mail;
        $tmpl = render_template('php', 'cobranza.vista_contenido_factura_adjuntar', $data);
        $this->throw_message('success', $tmpl);
    }

    /**
     * Metodo para Regresar el UUID de una factura
     * @param $factura
     * @return string
     */
    private function getFacturaUUID($factura)
    {
        $uuid = '';
        $zip = new ZipArchive;
        $file = false;
        if ($zip->open(HOME_SERVER . 'facturas/' . $factura . '.zip') === TRUE) {
            $file = $zip->getFromName($factura . '.xml');
        }
        $zip->close();

        if ($file) {
            $factura = new SimpleXMLElement($file);
            $uuid = (string)$factura->xpath('//cfdi:Comprobante//cfdi:Complemento//*')[0]['UUID'];
        }
        return $uuid;
    }


    /**
     * Metodo para Regresar el Metodo de Pago de una factura
     * @param $factura
     * @return string
     */
    private function getFacturaMetodoPago($factura)
    {
        $metodoPago = '';
        $zip = new ZipArchive;
        $file = false;
        if ($zip->open(HOME_SERVER . 'facturas/' . $factura . '.zip') === TRUE) {
            $file = $zip->getFromName($factura . '.xml');
        }
        $zip->close();

        if ($file) {
            $factura = new SimpleXMLElement($file);
            $metodoPago = (string)$factura->xpath('//cfdi:Comprobante')[0]['MetodoPago'];
        }
        return $metodoPago;
    }

    /**
     * Metodo para regresar el RFC al cual se hizó la factura.
     * @param $factura
     * @return string
     */
    private function getFacturaRFC($factura){
       $rfc = '';
        $zip = new ZipArchive;
        $file = false;
        if ($zip->open(HOME_SERVER . 'facturas/' . $factura . '.zip') === TRUE) {
            $file = $zip->getFromName($factura . '.xml');
        }
        $zip->close();

        if ($file) {
            $factura = new SimpleXMLElement($file);
            $rfc = (string)$factura->xpath('//cfdi:Comprobante//cfdi:Receptor')[0]['Rfc'];
        }
       return $rfc;
    }

    /**
     * Metodo para exportar el reportador en su estado actual a un archivo de excel.
     * @param $datos
     * @throws \PhpOffice\PhpSpreadsheet\Exception
     * @throws \PhpOffice\PhpSpreadsheet\Writer\Exception
     */
    private function export_excel($datos)
    {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A1', 'N°')->getColumnDimension('A')->setAutoSize(true);
        $sheet->setCellValue('B1', 'Cliente')->getColumnDimension('B')->setAutoSize(true);
        $sheet->setCellValue('C1', 'RFC')->getColumnDimension('C')->setAutoSize(true);
        $sheet->setCellValue('D1', 'Folio')->getColumnDimension('C')->setAutoSize(true);
        $sheet->setCellValue('E1', 'Método')->getColumnDimension('E')->setAutoSize(true);
        $sheet->setCellValue('F1', 'Fecha')->getColumnDimension('F')->setAutoSize(true);
        $sheet->setCellValue('G1', 'Pagada')->getColumnDimension('G')->setAutoSize(true);
        $sheet->setCellValue('H1', 'Fecha Pago')->getColumnDimension('H')->setAutoSize(true);
        $sheet->setCellValue('I1', 'Total')->getColumnDimension('I')->setAutoSize(true);
        $sheet->setCellValue('J1', 'UUID')->getColumnDimension('J')->setAutoSize(true);

        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;

        $n = 0;
        $facturas_web[] = array();
        $get_facturas_w = db_select('partners_servicios', 'ps');
        $get_facturas_w->fields('ps',
            array('factura_w_nombre_facturacion',
                'servicio_facturado',
                'factura_w_fecha',
                'factura_w_total',
                'id_servicio',
                'factura_w_servicio',
                'factura_w_correos_enviados',
                'pagado_cobranza',
                'pagado_cobranza_otro',
                'fecha_pagado_cobranza')
        );
        $get_facturas_w->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = ps.id_cliente');
        $get_facturas_w->fields('pc', array('credito'));
        $get_facturas_w->condition('servicio_facturado', 0, '!=');

        // Filtro - Search Bar, tiene prioridad sobre la fecha, lo cual significa que si este campo trae texto, debe ignorar la fecha.
        if (strlen(trim($datos->filter->search_bar)) > 0) {
            $factura_w_or = db_or()
                ->condition('ps.factura_w_nombre_facturacion', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('ps.servicio_facturado', '%' . $datos->filter->search_bar . '%', 'LIKE');
            $get_facturas_w->condition($factura_w_or);
        } else {
            // Si este campo viene vacio, entonces ahora si filtrar por fecha
            if ($f_inicio == $f_final) {
                $f_final_same_day = $f_inicio + 86040;
                if ($datos->filter->start_date) {
                    $get_facturas_w->condition('ps.fecha_pagado_cobranza', array($f_inicio, $f_final_same_day), 'BETWEEN');
                }
            } else {
                if ($datos->filter->start_date) {
                    $get_facturas_w->condition('ps.fecha_pagado_cobranza', array($f_inicio, $f_final), 'BETWEEN');
                }
            }
        }


        $get_facturas_w->orderBy('servicio_facturado', 'DESC');
        $facturas_w = $get_facturas_w->execute();
        $rowCount = 2;
        while ($row = $facturas_w->fetchAssoc()) {
            $n++;

            $w_pagada = "";



            // Servicio pagado en efectivo
            if ($row['pagado_cobranza'] == 1) {
                $w_pagada = "Efectivo";
            } else if ($row['pagado_cobranza'] == 2) {
                // Servicio pagado otro
                $w_pagada = ($row['pagado_cobranza_otro'] == null) ? "Cancelado" : $row['pagado_cobranza_otro'];
            } else if ($row['pagado_cobranza'] == 3) {
                $w_pagada = "Banamex";
            } else if ($row['pagado_cobranza'] == 4) {
                $w_pagada = "HSBC";
            } else if ($row['pagado_cobranza'] == 5) {
                $w_pagada = "PayPal";
            } else if ($row['pagado_cobranza'] == 6) {
                $w_pagada = "PayU";
            } else if ($row['pagado_cobranza'] == 0) {
                // Aún no está pagada.
                $w_pagada = "No";
            }

            // Fecha factura pagada
            if ($row['fecha_pagado_cobranza'] == 0) {
                $w_fecha_pagada = "";
            } else {
                $w_fecha_pagada = date('d/m/Y', $row['fecha_pagado_cobranza']);
            }


            // Metodo Pago
            $metodoPago = $this->getFacturaMetodoPago($row['factura_w_servicio']);


            // UUID
            $uuid = $this->getFacturaUUID($row['factura_w_servicio']);

            // RFC
            $rfc = $this->getFacturaRFC($row['factura_w_servicio']);


            $sheet->setCellValue('A' . $rowCount, $n);
            $sheet->setCellValue('B' . $rowCount, $row['factura_w_nombre_facturacion']);
            $sheet->setCellValue('C' . $rowCount, $rfc);
            $sheet->setCellValue('D' . $rowCount, $row['servicio_facturado']);
            $sheet->setCellValue('E' . $rowCount, $metodoPago);
            $sheet->setCellValue('F' . $rowCount, date('d/m/y', $row['factura_w_fecha']));
            $sheet->setCellValue('G' . $rowCount, $w_pagada);
            $sheet->setCellValue('H' . $rowCount, $w_fecha_pagada);
            $sheet->setCellValue('I' . $rowCount, (float)$row['factura_w_total'])
                ->getStyle('I' . $rowCount)
                ->getNumberFormat()
                ->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_CURRENCY_USD_SIMPLE);
            $sheet->setCellValue('J' . $rowCount, $uuid);

            $rowCount++;

        }

        $writter = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, "Xlsx");
        $writter->save(HOME_SERVER . 'public_html/reportes_recibo_dinero_partners/Reporte_FW_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');

        $this->throw_message('success', '/reportes_recibo_dinero_partners/Reporte_FW_' . date("d_m_Y", $f_inicio) . '__' . date("d_m_Y", $f_final) . '.xlsx');

    }
}