<?php

use Partners\Cliente\ClienteController;

class cotizaciones_sys extends sys_tools
{

  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'reporte_base':
          try {
            $this->reporte_base($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base');
          }
          break;
        case 'nueva_cotizacion':
          try {
            $this->nueva_cotizacion();
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'nueva_cotizacion');
          }
          break;
        case 'nueva_cotizacion_proyecto':
          try {
            $this->nueva_cotizacion_proyecto();
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'nueva_cotizacion_proyecto');
          }
          break;
        case 'capturar_cotizacion':
          try {
            $this->capturar_cotizacion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_cotizacion');
          }
          break;
        case 'capturar_cotizacion_proyecto':
          try {
            $this->capturar_cotizacion_proyecto($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_cotizacion_proyecto');
          }
          break;
        case 'enviar_cotizacion_correo':
          try {
            $this->enviar_cotizacion_correo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'enviar_cotizacion_correo');
          }
          break;
        case 'render_vista':
          try {
            $this->render_cotizacion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'render_cotizacion');
          }
          break;
        case 'update_status':
          try {
            $this->update_status($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'update_status');
          }
          break;
        case 'eliminar_cotizacion':
          try {
            $this->eliminar_cotizacion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'eliminar_cotizacion');
          }
          break;
        case 'reactivate_cotizacion':
          try {
            $this->reactivate_cotizacion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reactivate_cotizacion');
          }
          break;
        case 'vista_convertir_proyecto':
          try {
            $this->vista_convertir_proyecto($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_convertir_proyecto');
          }
          break;
        case 'capturar_convertir_cotizacion':
          try {
            $this->capturar_convertir_cotizacion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_convertir_cotizacion');
          }
          break;
        case 'informacion_sin_procesar':
          try {
            $this->informacion_sin_procesar($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'informacion_sin_procesar');
          }
          break;
        case 'vista_panel_ventas':
          try {
            $this->vista_panel_ventas($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_datos_cliente');
          }
          break;
        case 'agregar_nueva_licencia':
          try {
            $this->agregar_nueva_licencia($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'agregar_nueva_licencia');
          }
          break;
        case 'eliminar_licencia':
          try {
            $this->eliminar_licencia($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'eliminar_licencia');
          }
          break;
        case 'vista_previa_cotizacion':
          try {
            $this->vista_previa_cotizacion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_previa_cotizacion');
          }
          break;
      }
    }
  }

  private function reporte_base($datos)
  {
    global $user;
    $fi = str_replace('/', '-', trim($datos->filter->start_date));
    $ff = str_replace('/', '-', trim($datos->filter->end_date));
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;


    $query = db_select('partners_cotizaciones', 'pc');
    $query->fields('pc');
    $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pc.id_cliente');
    $query->fields('pcc', array('nombre_cliente', 'email'));
    $query->leftJoin('partners_clientes', 'pcontactos', 'pcontactos.id_cliente = pc.id_contacto');
    $query->addField('pcontactos', 'email', 'email_contacto');
    $query->leftJoin('partners_cotizaciones_datos', 'pcd', 'pcd.id_cotizacion = pc.id_cotizacion');
    $query->addExpression('SUM(pcd.cantidad * pcd.precio)', 'subtotal');
    $query->addExpression("GROUP_CONCAT(pcd.descripcion SEPARATOR '|')", 'desc_cotizacion');


    // Filtro - Search Bar
    if ($datos->filter->search_bar != null) {
      $on_products = db_select('partners_cotizaciones_datos', 'pcd')
        ->fields('pcd', array('id_cotizacion'))
        ->where('pc.id_cotizacion= pcd.id_cotizacion')
        ->condition('pcd.descripcion', '%' . $datos->filter->search_bar . '%', 'LIKE');
      $salida_or = db_or()
        ->condition('pcc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pc.id_cotizacion', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pc.id_cotizacion', $on_products, 'IN');
      $query->condition($salida_or);
    }

    // Filtro - Usuario
    if ($datos->filter->usuario != 0) {
      $query->condition('pc.created_by', $datos->filter->usuario);
    }

    // Filtro - Sin Procesar
    if ($datos->filter->sin_procesar != 0) {
      $query->where('pc.venta is null');
    } else {
      // Filtros
      if ($f_inicio == $f_final) {
        $f_final_same_day = $f_inicio + 86040;
        if ($datos->filter->start_date) {
          $query->condition('pc.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
        }
      } else {
        if ($datos->filter->start_date) {
          $query->condition('pc.created_at', array($f_inicio, $f_final), 'BETWEEN');
        }
      }
    }

    // Solamente filtrará por área cuando no sea supervisor o para Admon en general
    /**
    if (!user_access('cotizaciones_administrador') && !in_array("Admon", user_load($user->uid)->roles)) {
      if (in_array("CCTV", user_load($user->uid)->roles)) {
        $query->condition('pc.id_area', 1);
      }
      if (in_array("Ventas", user_load($user->uid)->roles)) {
        $query->condition('pc.id_area', 3);
      }
      if (in_array("Web", user_load($user->uid)->roles)) {
        $query->condition('pc.id_area', 4);
      }
      if (in_array("Soporte", user_load($user->uid)->roles)) {
        $query->condition('pc.id_area', 2);
      }
    }
    **/

    $query->condition('pc.cotizacion_eliminada', 1, '!=');
    $query->orderBy($datos->sort->sort_by, $datos->sort->order);
    $query->groupBy('pc.id_cotizacion');

    $cotizaciones = [];
    $n = 0;
    $query_datos = $query->execute();
    while ($row = $query_datos->fetchAssoc()) {
      $folio = array("data" => $row['id_cotizacion'], "class" => array("cursor-pointer", "vista_cotizacion"));
      $fecha = array("data" => date('d/m/y', $row['created_at']), "class" => array("cursor-pointer", "vista_cotizacion"));
      $usuario = array("data" => user_load($row['created_by'])->name, "class" => array("cursor-pointer", "vista_cotizacion"));
      $cliente = array("data" => mb_substr($row['nombre_cliente'], 0, 20, "utf-8"), "class" => array("cursor-pointer", "vista_venta_cliente"));
      $desc = array("data" => mb_substr($row['desc_cotizacion'], 0, 50, "utf-8"), "class" => array("cursor-pointer", "vista_cotizacion"));

      // Observaciones | Notas internas
      if ($row['observaciones'] != null) {
        $obs = array("data" => 'Obs', "class" => array("status-yellow", "cotizaciones-observaciones", "text-center", "cursor-pointer"));
      } else {
        $obs = array("data" => 'Obs', "class" => array("text-center", "cotizaciones-observaciones", "cursor-pointer"));
      }

      // Enviado
      if ($row['enviado'] == 0) {
        $enviado = array("data" => "No", "class" => array("status_enviado", "status-red", "text-center", "cursor-pointer"));
      } else {
        $enviado = array("data" => "Si", "class" => array("status_enviado", "status-green", "text-center", "cursor-pointer"));
      }


      // Recibido
      if ($row['recibido'] == 0) {
        $recibido = array("data" => "No", "class" => array("status_recibido", "status-red", "text-center", "cursor-pointer"));
      } else {
        $recibido = array("data" => "Si", "class" => array("status_recibido", "status-green", "text-center", "cursor-pointer"));
      }

      // Venta
      if ($row['venta'] == 0) {
        $venta = array("data" => "Proceso", "class" => array("status_venta", "status-red", "text-center", "cursor-pointer"));
      } else if ($row['venta'] == 1) {
        $venta = array("data" => "No", "class" => array("status_venta", "status-red", "text-center", "cursor-pointer"));
      } else if ($row['venta'] == 2) {
        $venta = array("data" => "Si", "class" => array("status_venta", "status-green", "text-center", "cursor-pointer"));
      }

      // Compra
      if ($row['venta'] == 2) { // si es igual a si en venta
        if ($row['compra'] == 0) {
          $compra = array("data" => "No", "class" => array("status_compra", "status-red", "text-center", "cursor-pointer"));
        } else {
          $compra = array("data" => "Si", "class" => array("status_compra", "status-green", "text-center", "cursor-pointer"));
        }
      } else {
        $compra = array("data" => "N/A", "class" => array("text-center"));
      }


      // Facturado
      if ($row['id_relacion_renovacion'] == 0) {
        if ($row['venta'] == 2) {
          if ($row['facturado'] == 0) {
            $pagado = array("data" => "No", "class" => array("status_pagado", "status-red", "text-center", "cursor-pointer"));
          } else if ($row['facturado'] == 1) {
            $pagado = array("data" => "Pagado", "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
          } else if ($row['facturado'] == 2) {
            $pagado = array("data" => "Factura", "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
          }
        } else {
          $pagado = array("data" => "N/A", "class" => array("text-center"));
        }
      } else {
        if ($row['venta'] == 2) {
          if ($row['facturado'] == 0) {
            $pagado = array("data" => "No", "data-id-relacion-renovacion" => $row['id_relacion_renovacion'], "class" => array("status_pagado", "status-red", "text-center", "cursor-pointer"));
          } else if ($row['facturado'] == 1) {
            $pagado = array("data" => "Pagado", "data-id-relacion-renovacion" => $row['id_relacion_renovacion'], "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
          } else if ($row['facturado'] == 2) {
            $pagado = array("data" => "Factura", "data-id-relacion-renovacion" => $row['id_relacion_renovacion'], "class" => array("status_pagado", "status-green", "text-center", "cursor-pointer"));
          }
        } else {
          $pagado = array("data" => "N/A", "class" => array("text-center"));
        }
      }


      // Entregado
      if ($row['venta'] == 2) {
        if ($row['entregado'] == 0) {
          $entregado = array("data" => "No", "class" => array("status_entregado", "status-red", "text-center", "cursor-pointer"));
        } else {
          $entregado = array("data" => "Si", "class" => array("status_entregado", "status-green", "text-center", "cursor-pointer"));
        }
      } else {
        $entregado = array("data" => "N/A", "class" => array("text-center"));
      }

      $reenviar = array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "reenviar_cotizacion"));
      $borrar = array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => array("cursor-pointer", "text-center", "eliminar_cotizacion"));

      if ($row['cotizacion_compartida'] == 1) {
        $user_compartido_con = user_load($row['cotizacion_compartida_con'])->name;
        $precio = array("data" => number_format($row['subtotal'], 2, '.', ','), "data-compartido-con" => $user_compartido_con, "data-current-text" => number_format($row['subtotal'], 2, '.', ','), "class" => array("cursor-pointer", "vista_cotizacion", "text-right", "status-blue", "show_compartido_con"));
      } else {
        $precio = array("data" => number_format($row['subtotal'], 2, '.', ','), "class" => array("cursor-pointer", "vista_cotizacion", "text-right"));
      }

      if ($row['facturado'] != 0) {
        $numero_factura = array("data" => $this->get_numero_factura('partners_cotizaciones', $row['id_cotizacion']), "class" => array(($this->get_numero_factura('partners_cotizaciones', $row['id_cotizacion'])) ? "text-right cursor-pointer ver_factura" : ""));
      }else{
        $numero_factura = array("data" => '', "class" => array("text-right cursor-pointer"));
      }
      $n++;

      if (user_access("cotizaciones_administrador")) {
        $cotizaciones[] = array(
          "data" => array(
            $n,
            $folio,
            $fecha,
            $usuario,
            $cliente,
            $desc,
            $precio,
            $enviado,
            $recibido,
            $venta,
            $compra,
            $pagado,
            $numero_factura,
            $entregado,
            $reenviar,
            $obs,
            $borrar,

          ),
          "data-id-cotizacion" => $row['id_cotizacion'],
          "data-tipo-cotizacion" => $row['tipo_cotizacion'],
          "data-enviado" => $row['enviado'],
          "data-recibido" => $row['recibido'],
          "data-compra" => $row['compra'],
          "data-entregado" => $row['entregado'],
          "data-email-cliente" => $row['email'],
          "data-email-contacto" => $row['email_contacto'],
          "data-email-user" => $user->mail,
          "data-id-cliente" => $row['id_cliente']
        );
      } else {
        $cotizaciones[] = array(
          "data" => array(
            $n,
            $folio,
            $fecha,
            $usuario,
            $cliente,
            $desc,
            $precio,
            $enviado,
            $recibido,
            $venta,
            $compra,
            $pagado,
            $entregado,
            $reenviar,
            $obs,
          ),
          "data-id-cotizacion" => $row['id_cotizacion'],
          "data-tipo-cotizacion" => $row['tipo_cotizacion'],
          "data-enviado" => $row['enviado'],
          "data-recibido" => $row['recibido'],
          "data-compra" => $row['compra'],
          "data-entregado" => $row['entregado'],
          "data-email-cliente" => $row['email'],
          "data-email-contacto" => $row['email_contacto'],
          "data-email-user" => $user->mail,
          "data-id-cliente" => $row['id_cliente']
        );
      }
    }


    // Header -- Sort
    if (user_access("cotizaciones_administrador")) {
      $header_cols = array(
        array("name" => array("data" => "N", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Total", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Enviado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Recibido", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Venta", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Compra", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Facturado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Fact", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Entregado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
      );
    } else {
      $header_cols = array(
        array("name" => array("data" => "N", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
        array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Total", "class" => "filter-number"), "sortable" => 0),
        array("name" => array("data" => "Enviado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Recibido", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Venta", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Compra", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Facturado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => "Entregado", "class" => "filter-text"), "sortable" => 0),
        array("name" => array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0),
        array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
      );
    }

    $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


    $table = array(
      "header" => $header,
      "rows" => $cotizaciones,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_cotizaciones", "class" => array("table-sm"))
    );


    $result = theme('table', $table);

    echo $result;
  }

  private function nueva_cotizacion()
  {
    global $user;
    $role = user_role_load_by_name('Todos');
    $query = 'SELECT ur.uid
        FROM {users_roles} AS ur
        WHERE ur.rid = :rid';
    $result = db_query($query, array(':rid' => $role->rid));
    $uids = $result->fetchCol();

    $usuarios = db_select('users', 'u')
      ->fields('u', array('uid', 'name'))
      ->condition('status', 1)
      ->condition('uid', $uids, 'IN')
      ->condition('uid', 26, '!=')
      ->orderBy('name', 'ASC')
      ->execute()->fetchAll(PDO::FETCH_ASSOC);
    $datos['usuarios'] = $usuarios;
    $datos['email_user'] = $user->mail;
    $template = render_template('php', 'cotizaciones.nueva_cotizacion', $datos);
    $this->throw_message('success', $template);
  }

  private function nueva_cotizacion_proyecto()
  {
    global $user;
    $role = user_role_load_by_name('Todos');
    $query = 'SELECT ur.uid
        FROM {users_roles} AS ur
        WHERE ur.rid = :rid';
    $result = db_query($query, array(':rid' => $role->rid));
    $uids = $result->fetchCol();

    $usuarios = db_select('users', 'u')
      ->fields('u', array('uid', 'name'))
      ->condition('status', 1)
      ->condition('uid', $uids, 'IN')
      ->condition('uid', 26, '!=')
      ->orderBy('name', 'ASC')
      ->execute()->fetchAll(PDO::FETCH_ASSOC);
    $datos['usuarios'] = $usuarios;
    $datos['email_user'] = $user->mail;
    $template = render_template('php', 'cotizaciones.nueva_cotizacion_proyecto', $datos);
    $this->throw_message('success', $template);
  }

  private function capturar_cotizacion($datos)
  {
    global $user;
    $area = 0;
    if (in_array("CCTV", user_load($user->uid)->roles)) {
      $area = 1;
    } else if (in_array("Soporte", user_load($user->uid)->roles)) {
      $area = 2;
    } else if (in_array("Ventas", user_load($user->uid)->roles)) {
      $area = 3;
    } else if (in_array("Web", user_load($user->uid)->roles)) {
      $area = 4;
    } else if (in_array("Admon", user_load($user->uid)->roles)) {
      $area = 5;
    }

    // Cuando es array, trae imagenes
    if (is_array($datos)) {
      $data = (object)$datos['data'];
      $id_cotizacion = db_insert('partners_cotizaciones')
        ->fields(array(
          'created_at' => REQUEST_TIME,
          'created_by' => $user->uid,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid,
          'id_cliente' => $data->id_cliente,
          'id_contacto' => (isset($data->id_contacto) && $data->id_contacto != '') ? $data->id_contacto : null,
          'cotizacion_compartida' => (isset($data->radio_seleccion_cotizacion_compartida) && $data->radio_seleccion_cotizacion_compartida != '') ? $data->radio_seleccion_cotizacion_compartida : 0,
          'cotizacion_compartida_con' => (isset($data->compartida_con) && $data->compartida_con != '') ? $data->compartida_con : null,
          'notas' => $data->notas_cotizacion,
          'texto_correo' => $data->texto_extra_correo_cotizacion,
          'iva_incluido' => (isset($data->cotizacion_iva_incluido) && $data->cotizacion_iva_incluido != '') ? $data->cotizacion_iva_incluido : 0,
          'sin_sumatoria' => (isset($data->sin_sumatoria) && $data->sin_sumatoria != '') ? $data->sin_sumatoria : 0,
          'tipo_cotizacion' => 1,
          'id_area' => $area
        ))
        ->execute();

      $datosP = json_decode($data->datos);
      // $imgFolder = HOME_SERVER . 'sites/default/files/cotizaciones_img/';
      $imgFolder = HOME_SERVER . 'public_html/intranet/sites/default/files/cotizaciones_img/';
      // var_dump($imgFolder);
      foreach ($datosP as $dato) {
        if ($dato->img) {
          $imgI = str_replace('.', '_', $dato->img);
          $tmpImg = $datos['files'][$imgI];
          $name = REQUEST_TIME . '_' . $tmpImg['name'];
          if (move_uploaded_file($tmpImg['tmp_name'], $imgFolder . $name)) {
            db_insert('partners_cotizaciones_datos')
              ->fields(array(
                'id_cotizacion' => $id_cotizacion,
                'cantidad' => $dato->cantidad,
                'descripcion' => $dato->descripcion,
                'precio' => $dato->precio,
                'tipo' => 1,
                'img' => $name
              ))
              ->execute();
          }
        } else {
          db_insert('partners_cotizaciones_datos')
            ->fields(array(
              'id_cotizacion' => $id_cotizacion,
              'cantidad' => $dato->cantidad,
              'descripcion' => $dato->descripcion,
              'precio' => $dato->precio,
              'tipo' => 1
            ))
            ->execute();
        }
      }

      if (isset($data->finish_pendiente) && $data->finish_pendiente != '') {
        db_update('partners_pendientes')
          ->fields(array(
            'status' => 0
          ))
          ->condition('id_pendiente', $data->finish_pendiente)
          ->execute();
      }

      $this->register_log_actions('partners_cotizaciones', 'insert', 'Se creó una nueva cotización: ' . $id_cotizacion);
      $this->throw_message('success', $id_cotizacion);
    } else {
      // No es array, no trae imagenes.

      $id_cotizacion = db_insert('partners_cotizaciones')
        ->fields(array(
          'created_at' => REQUEST_TIME,
          'created_by' => $user->uid,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid,
          'id_cliente' => $datos->id_cliente,
          'id_contacto' => (isset($datos->id_contacto) && $datos->id_contacto != '') ? $datos->id_contacto : null,
          'cotizacion_compartida' => (isset($datos->radio_seleccion_cotizacion_compartida) && $datos->radio_seleccion_cotizacion_compartida != '') ? $datos->radio_seleccion_cotizacion_compartida : 0,
          'cotizacion_compartida_con' => (isset($datos->compartida_con) && $datos->compartida_con != '') ? $datos->compartida_con : null,
          'notas' => $datos->notas_cotizacion,
          'texto_correo' => $datos->texto_extra_correo_cotizacion,
          'iva_incluido' => (isset($datos->cotizacion_iva_incluido) && $datos->cotizacion_iva_incluido != '') ? $datos->cotizacion_iva_incluido : 0,
          'sin_sumatoria' => (isset($datos->sin_sumatoria) && $datos->sin_sumatoria != '') ? $datos->sin_sumatoria : 0,
          'tipo_cotizacion' => 1,
          'id_area' => $area
        ))
        ->execute();

      foreach ($datos->datos as $dato) {
        db_insert('partners_cotizaciones_datos')
          ->fields(array(
            'id_cotizacion' => $id_cotizacion,
            'cantidad' => $dato->cantidad,
            'descripcion' => $dato->descripcion,
            'precio' => $dato->precio,
            'tipo' => 1
          ))
          ->execute();
      }

      if (isset($datos->finish_pendiente) && $datos->finish_pendiente != '') {
        db_update('partners_pendientes')
          ->fields(array(
            'status' => 0
          ))
          ->condition('id_pendiente', $datos->finish_pendiente)
          ->execute();
      }

      $this->register_log_actions('partners_cotizaciones', 'insert', 'Se creó una nueva cotización: ' . $id_cotizacion);
      $this->throw_message('success', $id_cotizacion);
    }
  }

  private function capturar_cotizacion_proyecto($datos)
  {
    global $user;
    $area = 0;
    if (in_array("CCTV", user_load($user->uid)->roles)) {
      $area = 1;
    } else if (in_array("Soporte", user_load($user->uid)->roles)) {
      $area = 2;
    } else if (in_array("Ventas", user_load($user->uid)->roles)) {
      $area = 3;
    } else if (in_array("Web", user_load($user->uid)->roles)) {
      $area = 4;
    } else if (in_array("Admon", user_load($user->uid)->roles)) {
      $area = 5;
    }
    $id_cotizacion = db_insert('partners_cotizaciones')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'id_cliente' => $datos->id_cliente,
        'id_contacto' => $datos->id_contacto,
        'cotizacion_compartida' => (isset($datos->radio_seleccion_cotizacion_compartida_proyecto) && $datos->radio_seleccion_cotizacion_compartida_proyecto != '') ? $datos->radio_seleccion_cotizacion_compartida_proyecto : 0,
        'cotizacion_compartida_con' => (isset($datos->compartida_con) && $datos->compartida_con != '') ? $datos->compartida_con : null,
        'notas' => $datos->notas_cotizacion_proyecto,
        'texto_correo' => $datos->texto_extra_correo_cotizacion,
        'iva_incluido' => ($datos->cotizacion_iva_incluido_proyecto) ? $datos->cotizacion_iva_incluido_proyecto : 0,
        'sin_sumatoria' => ($datos->sin_sumatoria_proyecto) ? $datos->sin_sumatoria_proyecto : 0,
        'tipo_cotizacion' => 2,
        'id_area' => $area
      ))
      ->execute();

    foreach ($datos->datos as $dato) {
      db_insert('partners_cotizaciones_datos')
        ->fields(array(
          'id_cotizacion' => $id_cotizacion,
          'cantidad' => $dato->cantidad,
          'descripcion' => $dato->descripcion,
          'precio' => $dato->precio,
          'tipo' => $dato->tipo
        ))
        ->execute();
    }

    if (isset($datos->finish_pendiente) && $datos->finish_pendiente != '') {
      db_update('partners_pendientes')
        ->fields(array(
          'status' => 0
        ))
        ->condition('id_pendiente', $datos->finish_pendiente)
        ->execute();
    }


    $this->register_log_actions('partners_cotizaciones', 'insert', 'Se creó una nueva cotización: ' . $id_cotizacion);
    $this->throw_message('success', $id_cotizacion);
  }

  private function enviar_cotizacion_correo($datos)
  {
    global $user;
    $data = [];
    $data['id_cotizacion'] = $datos->id_cotizacion;
    $data['user_mail'] = $user->mail;
    $data['texto_extra'] = false;

    $datos_cotizacion = db_select('partners_cotizaciones', 'pc')
      ->fields('pc', array('id_cliente', 'id_contacto', 'texto_correo'))
      ->condition('id_cotizacion', $datos->id_cotizacion)
      ->execute()->fetchAssoc();

    if (!empty($datos_cotizacion['texto_correo'])) $data['texto_extra'] = $datos_cotizacion['texto_correo'];

    if ($datos_cotizacion['id_contacto']) {
      $nombre = db_select('partners_clientes', 'pc')
        ->fields('pc', array('nombre_cliente'))
        ->condition('id_cliente', $datos_cotizacion['id_contacto'])
        ->execute()->fetchField();
    } else {
      $nombre = db_select('partners_clientes', 'pc')
        ->fields('pc', array('nombre_cliente'))
        ->condition('id_cliente', $datos_cotizacion['id_cliente'])
        ->execute()->fetchField();
    }

    $data['nombre_cliente'] = $nombre;
    $data['body'] = $datos->body;

    $from = [$user->mail => 'Pc Partners - Cotizaciones'];

    $to = $datos->to;
    $to[] = $user->mail;
    $subject = 'Cotización Solicitada Folio: ' . $datos->id_cotizacion;
    $data_to_render = [];
    $data_to_render['id_cotizacion'] = $datos->id_cotizacion;
    // Type 1: = Return String to mail
    $data_to_render['type'] = 1;

    $attachment_data = $this->render_cotizacion($data_to_render);
    $attachment = $attachment_data['pdf_string'];
    $attachment_title = $attachment_data['attach_title'];
    $this->send_mail('cotizaciones.mail_enviar_cotizacion', $data, $subject, $from, $to, $attachment, $attachment_title);


    // Se actualiza el status de enviado, no importa si se envió al momento de capturar la cotización o ya después que está
    // creada, lo marcará de todas formas.
    db_update('partners_cotizaciones')
      ->fields(array(
        'enviado' => 1
      ))
      ->condition('id_cotizacion', $datos->id_cotizacion)
      ->execute();
    $this->throw_message('success', 'Bien!');
  }

  private function render_cotizacion($datos)
  {
    setlocale(LC_TIME, "es_MX");
    $id_cotizacion = $datos['id_cotizacion'];
    if ($datos['type']) {
      $type = $datos['type'];
    } else {
      $type = null;
    }

    $query = db_select('partners_cotizaciones', 'pc');
    $query->fields('pc');
    $query->innerJoin('partners_clientes', 'pclientes', 'pclientes.id_cliente = pc.id_cliente');
    $query->addField('pclientes', 'nombre_cliente');
    $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pc.id_contacto');
    $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
    $query->condition('pc.id_cotizacion', $id_cotizacion);
    $cotizacion = $query->execute()->fetchAssoc();
    $data['cotizacion'] = $cotizacion;
    $data['user_name'] = user_load($cotizacion['created_by'])->field_nombre_completo['und'][0]['value'];
    $data['user_puesto'] = user_load($cotizacion['created_by'])->field_puesto['und'][0]['value'];

    $query_datos = db_select('partners_cotizaciones_datos', 'pcd');
    $query_datos->fields('pcd');
    $query_datos->addExpression('SUM(cantidad * precio)', 'subtotal');
    $query_datos->condition('id_cotizacion', $id_cotizacion);
    $query_datos->groupBy('id_dato');
    $cotizacion_datos = $query_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

    // Agregar imagenes
    $cotizacion_d = [];

    // Contador de imágenes, en caso de que exista mas de una imagen, usar el nuevo
    // formato impreso que ya trae el espacio para imágenes.
    $imagenesExistentes = 0;
    foreach ($cotizacion_datos as $cotizacionDato) {
      if ($cotizacionDato['img']) {
        $imgFolder = 'cotizaciones_img/';
        $fileUri = file_build_uri($imgFolder . $cotizacionDato['img']);
        $imgUrl = image_style_url('img_cotizacion_60x60', $fileUri);
        $cotizacionDato['img'] = $imgUrl;
        $imagenesExistentes++;
      }

      $cotizacion_d[] = $cotizacionDato;
    }

    $total = db_select('partners_cotizaciones_datos', 'pcd');
    $total->addExpression('SUM(cantidad * precio)', 'total');
    $total->condition('id_cotizacion', $id_cotizacion);
    $total_cotizacion = $total->execute()->fetchField();
    $data['subtotal_cotizacion'] = $total_cotizacion;
    $data['iva'] = $total_cotizacion * 0.16;
    $data['total_cotizacion'] = ($total_cotizacion * 1.16);
    $data['cotizacion_datos'] = $cotizacion_d;
    $footer = render_template('php', 'cotizaciones.footer_reporte');
    if ($imagenesExistentes > 0) {
      $html = render_template('php', 'cotizaciones.render_reporte_con_imagenes', $data);
    } else {
      $html = render_template('php', 'cotizaciones.render_reporte', $data);
    }
    if ($type == null) {
      $this->generate_pdf($html, 'Cotización ' . $id_cotizacion, 'cotizacion_' . $id_cotizacion, 1, $footer);
    } else {
      return array("pdf_string" => $this->generate_pdf($html, $id_cotizacion, 'cotizacion_' . $id_cotizacion, 2, $footer), "attach_title" => 'cotizacion_' . $id_cotizacion);
    }
  }

  private function update_status($datos)
  {
    global $user;
    if (isset($datos->obs) && $datos->obs != '') {
      db_update('partners_cotizaciones')
        ->fields(array(
          $datos->col => $datos->new_val,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid,
          'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_cotizaciones', 'id_cotizacion', $datos->id_cotizacion)
        ))
        ->condition('id_cotizacion', $datos->id_cotizacion)
        ->execute();
    } else {
      db_update('partners_cotizaciones')
        ->fields(array(
          $datos->col => $datos->new_val,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid
        ))
        ->condition('id_cotizacion', $datos->id_cotizacion)
        ->execute();
    }

    if (isset($datos->id_relacion_renovacion) && $datos->id_relacion_renovacion != '') {
      db_update('partners_renovaciones')
        ->fields(array(
          'pagado' => $datos->new_val
        ))
        ->condition('id_renovacion', $datos->id_relacion_renovacion)
        ->execute();
    }

    if (isset($datos->facturado) && $datos->facturado != '') {
      if ($datos->facturado != 'undefined') {
        $this->track_down_facturado($datos->numero_factura, $datos->id_cotizacion, "Cotizaciones", "partners_cotizaciones", "F-" . $datos->factura);
      }
    }

    $this->register_log_actions('partners_cotizaciones', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
    $this->throw_message('success', "Cambios Guardados");
  }

  private function eliminar_cotizacion($id_cotizacion)
  {
    db_update('partners_cotizaciones')
      ->fields(array(
        'cotizacion_eliminada' => 1
      ))
      ->condition('id_cotizacion', $id_cotizacion)
      ->execute();

    $this->throw_message('success', 'Cotización Eliminada correctamente.');
    $this->register_log_actions('partners_cotizaciones', 'delete', 'Se eliminó la cotización: ' . $id_cotizacion);
  }

  private function reactivate_cotizacion($id_cotizacion)
  {
    db_update('partners_cotizaciones')
      ->fields(array(
        'cotizacion_eliminada' => 0
      ))
      ->condition('id_cotizacion', $id_cotizacion)
      ->execute();


    $this->throw_message('success', 'Cotización Reactivada correctamente.');
    $this->register_log_actions('partners_cotizaciones', 'update', 'Se reactivó la cotización: ' . $id_cotizacion);
  }

  private function vista_convertir_proyecto($id_cotizacion)
  {
    $query = db_select('partners_cotizaciones', 'pc');
    $query->innerJoin('partners_clientes', 'pcl', 'pcl.id_cliente = pc.id_cliente');
    $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pc.id_contacto');
    $query->fields('pcl', array('nombre_cliente', 'tipo_cliente', 'tipo_clasificacion', 'credito'));
    $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
    $query->addField('pcc', 'tipo_cliente', 'tipo_contacto');
    $query->fields('pc', array('id_cliente', 'id_contacto'));
    $query->condition('pc.id_cotizacion', $id_cotizacion);
    $cliente = $query->execute()->fetchAssoc();

    $d_query = db_select('partners_cotizaciones_datos', 'pcd');
    $d_query->fields('pcd');
    $d_query->addExpression('SUM(cantidad * precio)', 'subtotal');
    $d_query->condition('id_cotizacion', $id_cotizacion);
    $d_query->groupBy('id_dato');
    $datos_cotizacion = $d_query->execute()->fetchAll(PDO::FETCH_ASSOC);
    $datos['cliente'] = $cliente;
    $datos['datos'] = $datos_cotizacion;
    $datos['id_cotizacion'] = $id_cotizacion;
    $template = render_template('php', 'cotizaciones.vista_convertir_cotizacion', $datos);
    $this->throw_message('success', $template);
  }

  private function capturar_convertir_cotizacion($datos)
  {
    global $user;

    db_update('partners_cotizaciones')
      ->fields(array(
        'venta' => 2
      ))
      ->condition('id_cotizacion', $datos->id_cotizacion)
      ->execute();

    $id_proyecto = db_insert('partners_cctv')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'id_cotizacion' => $datos->id_cotizacion,
        'id_cliente' => $datos->id_cliente,
        'id_contacto' => ($datos->id_contacto) ? $datos->id_contacto : null,
        'notas_proyecto' => $datos->notas_cotizacion_convertir,
      ))
      ->execute();

    foreach ($datos->datos as $dato) {
      db_insert('partners_cctv_datos')
        ->fields(array(
          'id_proyecto' => $id_proyecto,
          'descripcion' => $dato->descripcion,
          'precio' => $dato->precio,
          'cantidad' => $dato->cantidad,
          'tipo' => $dato->tipo
        ))
        ->execute();
    }

    $this->register_log_actions('partners_cctv', 'insert', 'Se capturó un nuevo proyecto CCTV: ' . $id_proyecto);
    $this->throw_message('success', 'Cotización Convertida correctamente');
  }

  /**
   * Metodo para consultar la cantidad de cotizaciones que hay sin procesar tanto en el mes como en total.
   * @param $datos
   */
  private function informacion_sin_procesar($datos)
  {
    global $user;
    $fi = str_replace('/', '-', trim($datos->start_date));
    $ff = str_replace('/', '-', trim($datos->end_date));
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;


    $query = db_select('partners_cotizaciones', 'pc');
    $query->fields('pc', array('id_cotizacion'));

    // Filtros
    if ($f_inicio == $f_final) {
      $f_final_same_day = $f_inicio + 86040;
      if ($datos->start_date) {
        $query->condition('pc.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
      }
    } else {
      if ($datos->start_date) {
        $query->condition('pc.created_at', array($f_inicio, $f_final), 'BETWEEN');
      }
    }

    // Filtro - Usuario
    if ($datos->usuario != 0) {
      $query->condition('pc.created_by', $datos->usuario);
    }

    $query->where('pc.venta is null');
    $totalMonth = $query->execute()->rowCount();

    $q = db_select('partners_cotizaciones', 'pc');
    $q->fields('pc', array('id_cotizacion'));
    $q->where('pc.venta is null');

    // Filtro - Usuario
    if ($datos->usuario != 0) {
      $q->condition('pc.created_by', $datos->usuario);
    }

    // Solamente filtrará por área cuando no sea supervisor o para Admon en general
    /**
    if (!user_access('cotizaciones_administrador') && !in_array("Admon", user_load($user->uid)->roles)) {
      if (in_array("CCTV", user_load($user->uid)->roles)) {
        $q->condition('pc.id_area', 1);
      }
      if (in_array("Ventas", user_load($user->uid)->roles)) {
        $q->condition('pc.id_area', 3);
      }
      if (in_array("Web", user_load($user->uid)->roles)) {
        $q->condition('pc.id_area', 4);
      }
      if (in_array("Soporte", user_load($user->uid)->roles)) {
        $q->condition('pc.id_area', 2);
      }
    }
    **/

    $total = $q->execute()->rowCount();

    $this->throw_message('success', ["totalMonth" => $totalMonth, "total" => $total]);
  }

  /**
   * @param $idCliente
   */
  private function vista_panel_ventas($idCliente)
  {
    $clienteController = new ClienteController();

    try {
      $this->throw_message('success', $clienteController->generarVistaVentas($idCliente));
    } catch (Exception $e) {
    }
  }

  /**
   * Agrega una nueva licencia relacionada con el cliente, aparecerá en el panel de Ventas del Cliente
   * @param $datos
   * @throws Exception
   */
  private function agregar_nueva_licencia($datos)
  {
    global $user;

    $bitacora = null;
    if (trim($datos->observaciones_licencia) != '') {
      $bitacora = $this->serialize_obs($datos->observaciones_licencia, 1);
    }
    $id_licencia = db_insert('partners_clientes_licencias')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'id_cliente' => $datos->id_cliente,
        'fecha_compra_licencia' => strtotime($datos->fecha_compra),
        'producto' => $datos->producto,
        'serie_licencia' => $datos->serie_licencia,
        'observaciones' => $bitacora
      ))
      ->execute();

    // Actualizar la tabla de clientes con has_licencia = 1, este campo será utilizado después
    // debido a un filtrado, y se hace de esta manera para hacer la consulta de clientes más eficiente y no tener que
    // hacer una consulta en cada cliente para ir a verificar a la otra tabla de licencias a ver si tiene alguna licencia.
    // De esta manera ya no se tendrá que hacer una consulta extra por cada cliente, porque lo estaría guardando en la tabla de clientes
    // y no en otra tabla diferente.
    db_update('partners_clientes')
      ->fields(array(
        'has_licencia' => 1
      ))
      ->condition('id_cliente', $datos->id_cliente)
      ->execute();

    $this->register_log_actions('partners_clientes_licencias', 'insert', "Se capturó una nueva licencia ($id_licencia) al cliente: $datos->id_cliente ");
    $this->throw_message('success', "Bien, Licencia agregada correctamente.");
  }

  /**
   * Elimina una licencia de un Cliente.
   * @param $datos
   * @throws Exception
   */
  private function eliminar_licencia($datos)
  {
    db_delete('partners_clientes_licencias')
      ->condition('id_licencia', $datos->id_licencia)
      ->execute();

    // Deberá de verificar si aún existen licencias con este cliente, en caso de que si existan licencias todavía
    // no pasa nada, pero si ya no existen licencias, deberá de actualizar la tabla de clientes con has_licecia = 0
    $get = db_select('partners_clientes_licencias', 'pc');
    $get->fields('pc', array('id_licencia'));
    $get->condition('id_cliente', $datos->id_cliente);
    $validate = $get->execute()->rowCount();

    if ($validate == 0) {
      db_update('partners_clientes')
        ->fields(array(
          'has_licencia' => 0
        ))
        ->condition('id_cliente', $datos->id_cliente)
        ->execute();
    }

    $this->register_log_actions('partners_clientes_licencias', 'delete', "Se eliminó una licencia ($datos->id_licencia) del cliente: $datos->id_cliente ");
    $this->throw_message('success', "Bien, Licencia eliminada correctamente.");
  }

  /**
   * Método para generar una vista previa de una cotización.
   * @param $datos
   * @throws MpdfException
   */
  private function vista_previa_cotizacion($datos)
  {
    global $user;
    setlocale(LC_TIME, "es_MX");

    $getCliente = db_select('partners_clientes', 'pc');
    $getCliente->addField('pc', 'nombre_cliente');
    $getCliente->condition('id_cliente', $datos->id_cliente);
    $cliente = $getCliente->execute()->fetchField();

    $getConctacto = db_select('partners_clientes', 'pc');
    $getConctacto->addField('pc', 'nombre_cliente');
    $getConctacto->condition('id_cliente', $datos->id_contacto);
    $contacto = $getConctacto->execute()->fetchField();


    $data['cotizacion'] = json_decode(json_encode($datos), true);

    $data['cotizacion']['nombre_cliente'] = $cliente;
    $data['cotizacion']['nombre_contacto'] = $contacto;
    $data['cotizacion']['id_cotizacion'] = '0000';
    $data['cotizacion']['created_at'] = REQUEST_TIME;
    $data['cotizacion']['notas'] = $datos->notas_cotizacion;
    $data['cotizacion']['iva_incluido'] = $datos->cotizacion_iva_incluido;

    $data['user_name'] = user_load($user->uid)->field_nombre_completo['und'][0]['value'];
    $data['user_puesto'] = user_load($user->uid)->field_puesto['und'][0]['value'];

    $cotizacion_datos = [];
    $total_cotizacion = 0;
    $totalImg = 0;
    foreach ($datos->datos as $dato) {
      $tmpDato = (array)$dato;
      $newDato = $tmpDato;
      $subtotal = $tmpDato['cantidad'] * $tmpDato['precio'];
      $newDato['subtotal'] = $subtotal;
      $total_cotizacion += $subtotal;
      $cotizacion_datos[] = $newDato;
      if ($newDato['img']) $totalImg++;
    }

    $data['subtotal_cotizacion'] = $total_cotizacion;
    $data['iva'] = $total_cotizacion * 0.16;
    $data['total_cotizacion'] = ($total_cotizacion * 1.16);
    $data['cotizacion_datos'] = $cotizacion_datos;
    $footer = render_template('php', 'cotizaciones.footer_reporte');
    if ($totalImg > 0) {
      $html = render_template('php', 'cotizaciones.render_reporte_con_imagenes', $data);
    } else {
      $html = render_template('php', 'cotizaciones.render_reporte', $data);
    }
    $pdf = $this->generate_pdf($html, 'Vista Previa Cotización', 'cotizacion_vista_previa', 2, $footer);

    $this->throw_message('success', base64_encode($pdf));
  }
}
