<?php

use Defuse\Crypto\Crypto;

include drupal_get_path('module', 'partners') . '/lib/classes/facturas_web/class.facturas_web.php';

class cobranza_sys extends sys_tools
{

  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'reporte_base':
          try {
            $this->reporte_base($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base');
          }
          break;
        case 'reporte_base_2':
          try {
            $this->reporte_base_2($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base_2');
          }
          break;
        case 'status_apoyo':
          try {
            $this->status_apoyo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'status_apoyo');
          }
          break;
        case 'status_especial':
          try {
            $this->status_especial($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'status_especial');
          }
          break;
        case 'enviar_solo_factura':
          try {
            $this->enviar_solo_factura($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'enviar_solo_factura');
          }
          break;
        case 'vista_content_zip':
          try {
            $this->vista_content_zip($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_content_zip');
          }
          break;
        case 'vista_content_zip_adjuntar':
          try {
            $this->vista_content_zip_adjuntar($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_content_zip_adjuntar');
          }
          break;
        case 'status_pagado_otro':
          try {
            $this->status_pagado_otro($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'status_pagado_otro');
          }
          break;
        case 'update_status':
          try {
            $this->update_status($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'update_status');
          }
          break;
        case 'generar_estado_cuenta':
          try {
            $this->generar_estado_cuenta($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'generar_estado_cuenta');
          }
          break;
        case 'proccess_solicitud_archivo':
          try {
            $this->proccess_solicitud_archivo($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'proccess_solicitud_archivo');
          }
          break;
        case 'download_cobranza_file':
          try {
            $this->download_cobranza_file($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'download_cobranza_file');
          }
          break;
        case 'cobranza_process_estado_cuenta':
          try {
            $this->cobranza_process_estado_cuenta($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'cobranza_process_estado_cuenta');
          }
          break;
        case 'descargar_estado_cuenta':
          try {
            $this->descargar_estado_cuenta($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'descargar_estado_cuenta');
          }
          break;
        case 'get_file_estado_cuenta':
          try {
            $this->get_file_estado_cuenta($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_file_estado_cuenta');
          }
          break;
        case 'get_token_rfc_url':
          try {
            $this->get_token_rfc_url($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_token_rfc_url');
          }
          break;
        case 'get_contactos_cliente_by_rfc':
          try {
            $this->get_contactos_cliente_by_rfc($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_contactos_cliente_by_rfc');
          }
          break;
        case 'vista_pagar_servicio_w':
          try {
            $this->vista_pagar_servicio_w($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_pagar_servicio_w');
          }
          break;
        case 'reporte_base_rep':
          try {
            $this->reporte_base_rep($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base_rep');
          }
          break;
        case 'vista_enviar_rep':
          try {
            $this->vista_enviar_rep($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_enviar_rep');
          }
          break;
        case 'vista_clientes':
          try {
            $this->vista_cliente($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_clientes');
          }
          break;
        case 'enviar_correo_rep':
          try {
            $this->enviar_correo_rep($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'enviar_correo_rep');
          }
          break;
      }
    }
  }

  private function reporte_base($datos)
  {
    $access_credentials = db_select('partners_sql_connections', 'psc')
      ->fields('psc')
      ->execute()->fetchAssoc();
    $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
    $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
    $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
    $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);
    $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);
    //$objConnect = mssql_connect($server_access, $user_access, $pass_access);
    //mssql_select_db($server_db_access);

    // Filtro - Más 15 días
    $cond = '';
    if ($datos->filter->filtro_15 != 0) {
      $days_15 = date('m/d/Y', strtotime('-15 day'));
      $days_40 = date('m/d/Y', strtotime('-40 day'));
      $cond = " AND (a.CFECHAVENCIMIENTO <= '$days_15' AND a.CFECHAVENCIMIENTO >= '$days_40')";
    }
    // Filtro - Más de 40 días
    if ($datos->filter->filtro_40 != 0) {
      $days_40 = date('m/d/Y', strtotime('-40 day'));
      $days_15 = date('m/d/Y', strtotime('-15 day'));
      if ($datos->filter->filtro_15 != 0) {
        $cond = " AND (a.CFECHAVENCIMIENTO < '$days_15')";
      } else {
        $cond = " AND (a.CFECHAVENCIMIENTO < '$days_40')";
      }
    }
    if ($objConnect) {
      if (trim($datos->filter->search_bar) != null) {
        $search = $datos->filter->search_bar;
        $query = "SELECT a.CRAZONSOCIAL AS 'CLIENTE',
                        a.CSERIEDOCUMENTO AS 'SERIE',
                        a.CFOLIO AS 'FOLIO',
                        a.CFECHA AS 'FECHA',
                        a.CFECHAVENCIMIENTO AS 'VENCIMIENTO',
                        a.CTOTAL AS 'TOTAL',
                        a.CPENDIENTE AS 'SALDO',
                        a.CNUMEROGUIA AS 'NOTAS',
                        a.CRFC,
                        a.CCANTPARCI,
                        a.CMETODOPAG
                      FROM admDocumentos a
                      WHERE ((a.CFOLIO LIKE '%$search%') or (a.CRAZONSOCIAL LIKE '%$search%'))
                      AND (a.CIDDOCUMENTODE=4)
                      AND (a.CSERIEDOCUMENTO='E')
                      AND (a.CCANCELADO=0)
                      AND (a.CPENDIENTE >= 0.1)
                      ORDER BY a.CFOLIO DESC";
      } else {
        $query = "SELECT a.CRAZONSOCIAL AS 'CLIENTE',
                a.CSERIEDOCUMENTO AS 'SERIE',
                a.CFOLIO AS 'FOLIO',
                a.CFECHA AS 'FECHA',
                a.CFECHAVENCIMIENTO AS 'VENCIMIENTO',
                a.CTOTAL AS 'TOTAL',
                a.CPENDIENTE AS 'SALDO',
                a.CNUMEROGUIA AS 'NOTAS',
                a.CRFC,
                a.CCANTPARCI,
                a.CMETODOPAG
              FROM admDocumentos a
              WHERE (a.CIDDOCUMENTODE=4)
                AND (a.CSERIEDOCUMENTO='E')
                AND (a.CCANCELADO=0)
                AND (a.CPENDIENTE>0)
                $cond
              ORDER BY a.CFOLIO DESC";
      }
      $result = sqlsrv_prepare($objConnect, $query);
      sqlsrv_execute($result);
      //$result = mssql_query($query);

      $n = 0;
      $filas = [];
      $rr = array();
      $total = 0.0;
      $totalS = 0.0;

      while ($row = sqlsrv_fetch_object($result)) {
        //while ($row = mssql_fetch_object($result)) {\

        if ($row->CCANTPARCI == 1) {
          $metodoPago = 'PUE';
        } else if ($row->CCANTPARCI == 2) {
          $metodoPago = 'PPD';
        }
        $mp = '';
        if ($row->CMETODOPAG == '99' && $metodoPago != 'PPD') {
          $mp = 'status-red';
        } else if ($metodoPago == 'PUE') {
          $mp = ($row->CMETODOPAG == '99' ? 'status-red' : '');
        }
        if ($this->cobranza_observaciones($row->FOLIO, 'E') != null) {
          $observaciones = 'status-yellow status_obs text-center cursor-pointer';
        } else {
          $observaciones = 'text-center status_obs cursor-pointer';
        }
        $correos = '';
        if (trim($row->CEMAIL1) != '') {
          $correos .= $row->CEMAIL1;
        }
        if (trim($row->CEMAIL2) != '') {
          $correos .= ',' . $row->CEMAIL2;
        }
        if (trim($row->CEMAIL3) != '') {
          $correos .= ',' . $row->CEMAIL3;
        }
        //especial
        $especial = '';
        $cesp = '';
        $get_status_especial = $this->cobranza_especial($row->FOLIO, 'E');
        if ($get_status_especial == 0) {
          $especial = 'status_especial text-center cursor-pointer';
        } else if ($get_status_especial == 1) {
          $cesp = '<i class="fas fa-exclamation-triangle"></i>';
          $especial = 'status_especial text-center cursor-pointer text-danger';
        }
        //factura
        $factura_exists = $this->check_zip_exists($row->CRFC, $row->FOLIO, 'E') ==  true ? 1 : 0;
        $factura_enviada = $this->cobranza_factura_enviada($row->FOLIO, 'E');
        $cenv = "text-center";
        $factura_enviada == 0 ? $env = '' : $env = '<i class="fa fa-envelope aria-hidden="true"></i>';
        $factura_pagada = $this->cobranza_factura_pagada($row->FOLIO, 'E');
        $apC = '';
        $apoyo = '';
        if ($this->cobranza_apoyo($row->FOLIO, 'E') == 0) {
          $apC = "status_apoyo text-center cursor-pointer";
          $apoyo = '';
        } else if ($this->cobranza_apoyo($row->FOLIO, 'E') == 1) {
          $apoyo = '<i class="fa fa-phone" aria-hidden="true"></i>';
          $apC = "status_apoyo text-center cursor-pointer text-danger";
        } else if ($this->cobranza_apoyo($row->FOLIO, 'E') == 2) {
          $apoyo = '<i class="fa fa-phone" aria-hidden="true"></i>';
          $apC = "text-center text-success";
        }

        $date1 = $row->VENCIMIENTO;
        $date2 = new DateTime(date("Y-m-d"));
        $d = $date1->diff($date2)->format("%r%a");
        $diff = ($d < 15 ? '' : ($d < 40 ? 'status-yellow' : 'status-red'));
        $total += $row->TOTAL;
        $totalS += $row->SALDO;

        $nn = array("data" => '<strong>' . ++$n . "</strong>", "class" => array("text-center"));
        $cliente = array("data" => $row->CLIENTE, "class" => array("vista_cliente_c", "cursor-pointer"), "style" => "padding-left: 1%");
        $c = array("data" => $this->get_clasificacion_cliente_by_rfc($row->CRFC)[0], "class" => array("colum", "vista_cliente_c", "cursor-pointer"));
        $folio = array("data" => $row->FOLIO, "class" => array("colum ver_factura cursor-pointer"));
        $metp = array("data" => $metodoPago, "class" => array($mp));
        $forp = array("data" => $row->CMETODOPAG, "class" => array($mp));
        $fecha = array("data" => ($row->FECHA != null ? date_format($row->FECHA, 'd/m/Y') : ''), "class" => array("colum text-center"));
        $vencimiento = array("data" => date_format($row->VENCIMIENTO, 'd/m/Y'), "class" => array($diff, "colum"));
        $tot = array("data" => number_format($row->TOTAL, 2, '.', ','), "style" => array("text-align: right"));
        $saldo = array("data" => number_format($row->SALDO, 2, '.', ','), "style" => array("text-align: right"));
        if ($this->cobranza_notas($row->FOLIO) == NULL) {
          $notas = array("data" => $row->NOTAS, "class" => array("text-center"));
        } else {
          $notas = array("data" => $this->cobranza_notas($row->FOLIO), "class" => array("text-center", "vista_servicios_relacionados", "cursor-pointer"));
        }
        $apoyot = array("data" => $apoyo, "class" => array($apC));
        $espe = array("data" => $cesp, "class" => array($especial));
        $obs = array("data" => "Obs", "class" => array($observaciones));
        $exist = array("data" => $factura_exists, "class" => array("colum"));
        $enviada = array("data" => $env, "class" => array("colum", $cenv));
        $pagada = array("data" => $factura_pagada, "class" => array("colum text-center"));
        $enviar = array("data" => '<i class="fa fa-paper-plane" aria-hidden="true"></i>', "class" => array("enviar_factura cursor-pointer"));

        $rr[] = array(
          "data" => array(
            $nn,
            $cliente,
            $c,
            $folio,
            $metp,
            $forp,
            $fecha,
            $vencimiento,
            $tot,
            $saldo,
            $notas,
            $apoyot,
            $espe,
            $obs,
            $exist,
            $enviada,
            $pagada,
            $enviar
          ),
          "data-codigo-cliente" => $row->CCODIGOCLIENTE,
          "data-folio" => $row->FOLIO,
          "data-factura" => $row->CRFC . 'FE00000' . $row->FOLIO,
          "data-nombre-cliente" => $row->CLIENTE,
          "data-serie" => $row->SERIE,
          "data-emails" => $correos,
          "data-rfc" => $row->CRFC,
          "data-apoyo" => $this->cobranza_apoyo($row->folio, 'E'),
          //"data-tipo-cliente" => $tipo_cliente,
          //"data-id-cliente" => $id_cliente

        );
      }
      $head = array(
        array("data" => '<strong>N°</strong>', "class" => array("colu", "filter-text"), "sortable" => 0),
        array("data" => "Cliente", "class"  => array("colu", "filter-text"), "sortable" => 0),
        array("data" => "C", "class" => array("colu", "filter-text"), "sortable" => 0),
        array("data" => "Folio", "class" => array("colu", "filter-number"), "sortable" => 0),
        array("data" => "MP", "class" => array("colu", "filter-text"), "sortable" => 0),
        array("data" => "FP", "class" => array("colu", "filter-text"), "sortable" => 0),
        array("data" => "Fecha", "class" => array("colu", "filter-date"), "sortable" => 0),
        array("data" => "Vencimiento", "class" => array("colu", "filter-date"), "sortable" => 0),
        array("data" => "Total", "class" => array("colu", "filter-number", "total-col"), "sortable" => 0),
        array("data" => "Saldo", "class" => array("colu", "filter-number", "saldo-col"), "sortable" => 0),
        array("data" => "Notas", "class" => "filter-text text-center", "style" => "width: auto",  "sortable" => 0),
        array("data" => "Apoyo", "class" => array("colu", "dont-filter"), "sortable" => 0),
        array("data" => '<i class="fas fa-exclamation-triangle"></i>', "class" => array("colu", "dont-filter"), "sortable" => 0),
        array("data" => 'Obs', "class" => array("colu", "dont-filter"), "sortable" => 0),
        array("data" => 'F', "class" => array("colu", "filter-number"), "sortable" => 0),
        array("data" => 'FE', "class" => array("colu", "dont-filter"), "sortable" => 0),
        array("data" => 'P', "class" => array("colu", "dont-filter"), "sortable" => 0),
        array("data" => '<i class="fa fa-paper-plane" aria-hidden="true"></i>', "class" => array("colu", "dont-filter"), "sortable" => 0)
      );


      echo theme('table', array('header' => $head, 'rows' => $rr, "attributes" => array("id" => "table_reporteador_cobranza", "class" => array("table-sm"))));

      //Mostrar los datos en la tabla
      echo '
            <style>
            table tr th:nth-child(11){
                width: 10px;
              }
            .colu{
                text-align: center;
                font-weight: bold;

            }
            .colum{
                text-align: center;
            }

            </style>';

      $n = 0;
    } else {
      echo print_r(sqlsrv_errors());
      //echo print_r(mssql_get_last_message());
    }
  }

  private function reporte_base_2($datos)
  {

    // Sacar Lista de los puros RFC porque en base a ese se agruparán
    $get_facturas_w = db_select('partners_servicios', 'ps');
    $get_facturas_w->fields('ps', array('factura_w_nombre_facturacion', 'servicio_facturado', 'factura_w_fecha', 'factura_w_total', 'id_servicio', 'factura_w_servicio', 'factura_w_correos_enviados'));
    $get_facturas_w->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = ps.id_cliente');
    $get_facturas_w->fields('pc', array('credito', 'tipo_clasificacion'));
    $get_facturas_w->condition('pagado_cobranza', 0); // es diferente a la de pagado admon, esta es para controlar los pagos en cobranza
    $get_facturas_w->condition('servicio_facturado', 0, '!='); // La columna esta solo aplica para servicios con factura W
    $get_facturas_w->orderBy('servicio_facturado', 'DESC');
    $q = $get_facturas_w->execute();
    $total_general_final = 0;
    $saldo_general_final = 0;

    while ($fw = $q->fetchAssoc()) {
      $rfc = substr($fw['factura_w_servicio'], 0, -12);
      $facturas_reporte_comercial[$rfc]['nombre_cliente'] = $fw['factura_w_nombre_facturacion'];
      $facturas_reporte_comercial[$rfc]['rfc'] = $rfc;
      $facturas_reporte_comercial[$rfc]['clasificacion'] = strtoupper($fw['tipo_clasificacion']);
      $current_total = &$facturas_reporte_comercial[$rfc]['total_total'];
      $facturas_reporte_comercial[$rfc]['total_total'] = $facturas_reporte_comercial[$rfc]['total_saldo'] = $current_total + $fw['factura_w_total'];
      $total_general_final += $fw['factura_w_total'];
      $saldo_general_final += $fw['factura_w_total'];


      // Apoyo
      if ($this->cobranza_apoyo($fw['servicio_facturado'], 'W') == 0) {
        $apoyo = array("data" => '', "class" => array("status_apoyo", "text-center", "cursor-pointer"));
      } else if ($this->cobranza_apoyo($fw['servicio_facturado'], 'W') == 1) {
        $apoyo = array(
          "data" => '<i class="fa fa-phone" aria-hidden="true"></i>',
          "class" => array("status_apoyo", "text-center", "cursor-pointer", "text-danger")
        );
      } else if ($this->cobranza_apoyo($fw['servicio_facturado'], 'W') == 2) {
        $apoyo = array(
          "data" => '<i class="fa fa-phone" aria-hidden="true"></i>',
          "class" => array("text-center", "text-success")
        );
      } else {
        $apoyo = array("data" => "", "class" => []);
      }

      // Especial
      $get_status_especial = $this->cobranza_especial($fw['servicio_facturado'], 'W');
      if ($get_status_especial == 0) {
        $especial = array("data" => '', "class" => array("status_especial", "text-center", "cursor-pointer"));
      } else if ($get_status_especial == 1) {
        $especial = array("data" => '<i class="fas fa-exclamation-triangle"></i>', "class" => array("status_especial", "text-center", "cursor-pointer", "text-danger"));
      }


      // Observaciones | Notas internas
      if ($this->cobranza_observaciones($fw['servicio_facturado'], 'W') != null) {
        $observaciones = array("data" => 'Obs', "class" => array(($get_status_especial == 1) ? "status-red" : "status-yellow", "status_obs_w", "text-center", "cursor-pointer"));
      } else {
        $observaciones = array("data" => 'Obs', "class" => array("text-center", "status_obs_w", "cursor-pointer"));
      }

      // Factura enviada
      if ($this->cobranza_factura_enviada($fw['servicio_facturado'], 'W') != 0) {
        $factura_enviada = array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => array("text-center"));
      } else {
        $factura_enviada = array("data" => "", "class" => []);
      }

      // Factura pagada
      if ($this->cobranza_factura_pagada($fw['servicio_facturado'], 'W') == 1) {
        $factura_pagada = array("data" => 'PayPal', "class" => array("text-center"));
      } else if ($this->cobranza_factura_pagada($fw['servicio_facturado'], 'W') == 2) {
        $factura_pagada = array("data" => 'PayU', "class" => array("text-center"));
      } else {
        $factura_pagada = array("data" => '0', "class" => array("text-center"));
      }

      $enviar_factura = array("data" => '<i class="fa fa-paper-plane" aria-hidden="true"></i>', "class" => array("text-center", "enviar_factura", "cursor-pointer"));


      $facturas_reporte_comercial[$rfc]["facturas"][] = array(
        "tipo_factura" => array("data" => 1, "class" => []), # 1 = Factura Web
        "folio" => array(
          "data" => $fw['servicio_facturado'],
          "class" => array("ver_factura", "cursor-pointer", "text-right", "status-blue")
        ),
        "status_pagar" => array(
          "data" => "No",
          "class" => array("status_pagado", "status-red", "text-center", "cursor-pointer")
        ),
        "fecha" => array("data" => date('d/m/y', $fw['factura_w_fecha']), "class" => []),
        "vencimiento" => array("data" => date('d/m/y', $fw['factura_w_fecha']), "class" => []),
        "total" => array(
          "data" => number_format($fw['factura_w_total'], 2, '.', ''),
          "class" => array("text-right")
        ),
        "saldo" => array(
          "data" => number_format($fw['factura_w_total'], 2, '.', ''),
          "class" => array("text-right")
        ),
        "notas" => array(
          "data" => (($fw['credito'] == 1) ? 'A' : 'B') . '-' . $fw['id_servicio'],
          "class" => array("text-center", "cursor-pointer", "vista_servicios_relacionados")
        ),
        "apoyo" => $apoyo,
        "observaciones" => $observaciones,
        "servidor" => array("data" => 1, "class" => []),
        "enviada" => $factura_enviada,
        "pagada" => $factura_pagada,
        "enviar" => $enviar_factura,
        "especial" => $especial,
        "data_folio" => $fw['servicio_facturado'],
        "data_nombre_cliente" => $fw['factura_w_nombre_facturacion'],
        "data_factura" => $fw['factura_w_servicio'],
        "data_exists_factura" => 1,
        "data_codigo_cliente" => 1,
        "data_apoyo" => $this->cobranza_apoyo($fw['servicio_facturado'], 'W'),
        "data_emails" => $fw['factura_w_correos_enviados'],
        "data_serie" => 'W',
        "data_diff" => 0,
        "data_id_servicio" => $fw['id_servicio'],
        "data_folio_servicio" => (($fw['credito'] == 1) ? 'A' : 'B') . '-' . $fw['id_servicio'],
        "data_total_servicio" => $fw['factura_w_total'],
        "data_rfc" => $rfc,
        "data_especial" => $get_status_especial
      );


      // Generar un ID unico para controlar el collapse
      $facturas_reporte_comercial[$rfc]['unique_id'] = REQUEST_TIME + rand(0, 10000);
    }

    $access_credentials = db_select('partners_sql_connections', 'psc')
      ->fields('psc')
      ->execute()->fetchAssoc();
    $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
    $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
    $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
    $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);

    $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);

    $query = "
                SELECT a.CRAZONSOCIAL AS 'CLIENTE',
                    a.CSERIEDOCUMENTO AS 'SERIE',
                    a.CFOLIO AS 'FOLIO',
                    a.CFECHA AS 'FECHA',
                    a.CFECHAVENCIMIENTO AS 'VENCIMIENTO',
                    a.CTOTAL AS 'TOTAL',
                    a.CPENDIENTE AS 'SALDO',
                    a.CNUMEROGUIA AS 'NOTAS',
                    c.CCODIGOCLIENTE,
                    c.CRFC,
                    c.CEMAIL1,
                    c.CEMAIL2,
                    c.CEMAIL3
                FROM admDocumentos a
                LEFT OUTER JOIN admDomicilios b
                ON a.CIDCLIENTEPROVEEDOR = b.CIDCATALOGO
                LEFT JOIN admClientes c
                ON c.CIDCLIENTEPROVEEDOR = a.CIDCLIENTEPROVEEDOR
                WHERE (a.CIDDOCUMENTODE=4)
                    AND (a.CSERIEDOCUMENTO='E')
                    AND (a.CCANCELADO=0)
                    AND (a.CPENDIENTE>0)
                    AND (b.CTIPOCATALOGO=1)
                ORDER BY a.CFOLIO DESC
                ";


    if ($objConnect) {
      $facturas_reporte_comercial = [];
      $result = sqlsrv_prepare($objConnect, $query);
      // $result = sqlsrv_query($objConnect, $query);
      sqlsrv_execute($result);
      while ($obj = sqlsrv_fetch_object($result)) {
        // while ($obj = sqlsrv_fetch_object($result)) {
        $rfc = $obj->CRFC;
        $current_t = &$facturas_reporte_comercial[$rfc]['total_total'];
        $current_s = &$facturas_reporte_comercial[$rfc]['total_saldo'];
        $facturas_reporte_comercial[$rfc]['total_total'] = $current_t + $obj->TOTAL;
        $facturas_reporte_comercial[$rfc]['total_saldo'] = $current_s + $obj->SALDO;
        $total_general_final += $obj->TOTAL;
        $saldo_general_final += $obj->SALDO;
        $facturas_reporte_comercial[$rfc]['nombre_cliente'] = utf8_encode($obj->CLIENTE);
        $facturas_reporte_comercial[$rfc]['clasificacion'] = $this->get_clasificacion_cliente_by_rfc($rfc)[0];
        $facturas_reporte_comercial[$rfc]['rfc'] = $rfc;
        # Generar un ID unico para controlar el collapse
        $facturas_reporte_comercial[$rfc]['unique_id'] = REQUEST_TIME + rand(0, 10000);


        $x = gettype($obj->FECHA) == "string" ? new DateTime($obj->FECHA) : $obj->FECHA;
        $f = $x->getTimestamp();


        $date1 = gettype($obj->VENCIMIENTO) == "string" ? new DateTime($obj->VENCIMIENTO) : $obj->VENCIMIENTO;
        $date2 = new DateTime(date("Y-m-d"));

        $diff = $date1->diff($date2)->format("%r%a");
        $ve = gettype($obj->VENCIMIENTO) == "string" ? new DateTime($obj->VENCIMIENTO) : $obj->VENCIMIENTO;
        $v = $ve->getTimestamp();

        if ($diff < 15) {
          $vencimiento_ = array("data" => date('d/m/y', $v), "class" => []);
          $data_diff = 0;
        } else if ($diff >= 15 && $diff < 40) {
          $vencimiento_ = array("data" => date('d/m/y', $v), "class" => array("status-yellow", "text-center"));
          $data_diff = 15;
        } else if ($diff >= 40) {
          $data_diff = 40;
          $vencimiento_ = array("data" => date('d/m/y', $v), "class" => array("status-red", "text-center"));
        }

        // Especial
        $get_status_especial = $this->cobranza_especial($obj->FOLIO, 'E');
        if ($get_status_especial == 0) {
          $especial_ = array("data" => '', "class" => array("status_especial", "text-center", "cursor-pointer"));
        } else if ($get_status_especial == 1) {
          $especial_ = array("data" => '<i class="fas fa-exclamation-triangle"></i>', "class" => array("status_especial", "text-center", "cursor-pointer", "text-danger"));
        }

        // Observaciones | Notas internas
        if ($this->cobranza_observaciones($obj->FOLIO, 'E') != null) {
          $observaciones_ = array("data" => 'Obs', "class" => array(($get_status_especial == 1) ? "status-red" : "status-yellow", "status_obs", "text-center", "cursor-pointer"));
        } else {
          $observaciones_ = array("data" => 'Obs', "class" => array("text-center", "status_obs", "cursor-pointer"));
        }

        // Apoyo
        if ($this->cobranza_apoyo($obj->FOLIO, 'E') == 0) {
          $apoyo_ = array("data" => '', "class" => array("status_apoyo", "text-center", "cursor-pointer"));
        } else if ($this->cobranza_apoyo($obj->FOLIO, 'E') == 1) {
          $apoyo_ = array("data" => '<i class="fa fa-phone" aria-hidden="true"></i>', "class" => array("status_apoyo", "text-center", "cursor-pointer", "text-danger"));
        } else if ($this->cobranza_apoyo($obj->FOLIO, 'E') == 2) {
          $apoyo_ = array("data" => '<i class="fa fa-phone" aria-hidden="true"></i>', "class" => array("text-center", "text-success"));
        }

        // Factura existente en servidor
        $exists_on_server_ = ($this->check_zip_exists($obj->CRFC, $obj->FOLIO, $obj->CCODIGOCLIENTE)) ? 1 : 0;


        // Factura enviada
        if ($this->cobranza_factura_enviada($obj->FOLIO, 'E') != 0) {
          $factura_enviada_ = array("data" => '<i class="fa fa-envelope" aria-hidden="true"></i>', "class" => array("text-center"));
        } else {
          $factura_enviada_ = array("data" => "", "class" => []);
        }

        // Factura pagada
        if ($this->cobranza_factura_pagada($obj->FOLIO, 'E') == 1) {
          $factura_pagada_ = array("data" => 'PayPal', "class" => array("text-center"));
        } else {
          $factura_pagada_ = array("data" => '0', "class" => array("text-center"));
        }

        $correos = '';

        if (trim($obj->CEMAIL1) != '') {
          $correos .= $obj->CEMAIL1;
        }
        if (trim($obj->CEMAIL2) != '') {
          $correos .= ',' . $obj->CEMAIL2;
        }

        if (trim($obj->CEMAIL3) != '') {
          $correos .= ',' . $obj->CEMAIL3;
        }

        // Notas
        if ($this->cobranza_notas($obj->FOLIO) == NULL) {
          $notas_ = array("data" => $obj->NOTAS, "class" => array("text-center"));
        } else {
          $notas_ = array("data" => $this->cobranza_notas($obj->FOLIO), "class" => array("text-center", "vista_servicios_relacionados", "cursor-pointer"));
        }


        $enviar_factura_ = array("data" => '<i class="fa fa-paper-plane" aria-hidden="true"></i>', "class" => array("text-center", "enviar_factura", "cursor-pointer"));

        $facturas_reporte_comercial[$rfc]["facturas"][] = array(
          "tipo_factura" => array("data" => 2, "class" => []),
          "folio" => array("data" => $obj->FOLIO, "class" => array("ver_factura", "cursor-pointer", "text-right")),
          "status_pagar" => array("data" => "", "class" => []),
          "fecha" => array("data" => date('d/m/y', $f), "class" => ["text-center"]),
          "vencimiento" => $vencimiento_,
          "total" => array("data" => number_format($obj->TOTAL, 2, '.', ','), "class" => array("text-right")),
          "saldo" => array("data" => number_format($obj->SALDO, 2, '.', ','), "class" => array("text-right")),
          "notas" => $notas_,
          "apoyo" => $apoyo_,
          "especial" => $especial_,
          "observaciones" => $observaciones_,
          "servidor" => array("data" => $exists_on_server_, "class" => []),
          "enviada" => $factura_enviada_,
          "pagada" => $factura_pagada_,
          "enviar" => $enviar_factura_,
          "data_folio" => $obj->FOLIO,
          "data_nombre_cliente" => $obj->CLIENTE,
          "data_id_cliente" => $this->get_clasificacion_cliente_by_rfc($rfc)[1],
          "data_factura" => $obj->CRFC . 'FE00000' . $obj->FOLIO,
          "data_exists_factura" => $exists_on_server_,
          "data_codigo_cliente" => $obj->CCODIGOCLIENTE,
          "data_diff" => $data_diff,
          "data_apoyo" => $this->cobranza_apoyo($obj->FOLIO, 'E'),
          "data_emails" => $correos,
          "data_serie" => 'E',
          "data_rfc" => $obj->CRFC,
          "data_especial" => $get_status_especial
        );
      }
    } else {
      echo "No se puede conectar a la base de datos del comercial.";
    }

    if (isset($datos->filter->orderBySaldo)) {
      usort($facturas_reporte_comercial, function ($a, $b) {
        return $a['total_saldo'] < $b['total_saldo'];
      });
    }

    $data['total_general_final'] = $total_general_final;
    $data['saldo_general_final'] = $saldo_general_final;
    $data['datos'] = $facturas_reporte_comercial;
    $tpl = render_template('php', 'cobranza.reporte_base_2', $data);
    echo $tpl;
  }

  private function status_especial($datos)
  {
    $existing_folio = db_select('partners_cobranza', 'pc')
      ->fields('pc', array('folio'))
      ->condition('folio', $datos->folio)
      ->condition('serie', $datos->serie)
      ->execute()->fetchField();


    if ($existing_folio) {
      db_update('partners_cobranza')
        ->fields(array(
          'especial' => $datos->especial,
          'observaciones' => $this->serialize_obs($datos->motivo, 2, 'partners_cobranza', 'folio', $existing_folio)
        ))
        ->condition('folio', $datos->folio)
        ->execute();
    } else {
      db_insert('partners_cobranza')
        ->fields(array(
          'folio' => $datos->folio,
          'especial' => $datos->especial,
          'serie' => $datos->serie,
          'observaciones' => $this->serialize_obs($datos->motivo, 1)
        ))
        ->execute();
    }

    $this->throw_message('success', 'Estatus actualizado');
    $this->register_log_actions('partners_cobranza', 'update', 'Se marcó como especial en el folio: ' . $datos->folio);
  }

  private function status_apoyo($datos)
  {
    if ($datos->apoyo == 0) {
      $existing_folio = db_select('partners_cobranza', 'pc')
        ->fields('pc', array('folio'))
        ->condition('folio', $datos->folio)
        ->condition('serie', $datos->serie)
        ->execute()->fetchField();

      if ($existing_folio) {
        db_update('partners_cobranza')
          ->fields(array(
            'apoyo' => 1
          ))
          ->condition('folio', $datos->folio)
          ->execute();
      } else {
        db_insert('partners_cobranza')
          ->fields(array(
            'folio' => $datos->folio,
            'apoyo' => 1,
            'serie' => $datos->serie
          ))
          ->execute();
      }

      $this->throw_message('success', 'Apoyo solicitado.');
      $this->register_log_actions('partners_cobranza', 'update', 'Se solicitó apoyo en el folio: ' . $datos->folio);
    } else {
      db_update('partners_cobranza')
        ->fields(array(
          'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_cobranza', 'folio', $datos->folio),
          'apoyo' => 2
        ))
        ->condition('folio', $datos->folio)
        ->condition('serie', $datos->serie)
        ->execute();

      $this->register_log_actions('partners_cobranza', 'update', 'Se marcó como realizado el apoyo en el folio: ' . $datos->folio);
      $this->throw_message('success', 'Registro actualizado.');
    }
  }

  /**
   * Solo recibe los datos del la factura/cliente para que sean enviados mediante $this->enviar_correos_factura()
   * @param $datos
   */
  private function enviar_solo_factura($datos)
  {
    $data['emails'] = $datos->emails;
    $data['id_cliente'] = $datos->id_cliente;
    $data['ruta'] = HOME_SERVER . 'facturas/' . $datos->factura . '.zip';
    $data['num_factura'] = substr($datos->factura, -5);
    $data['factura_name'] = $datos->factura;
    $data['deleted_files'] = $datos->deleted_files;
    $data['conTarjeta'] = $datos->conTarjeta;
    self::enviar_correos_factura($data);
  }

  /**
   * Envia los correos con el archivo de factura adjunto.
   * @param $datos
   * @throws Exception
   */
  public static function enviar_correos_factura($datos)
  {
    try {
      global $user, $base_root;
      // Si hay archivos a eliminar, eliminarlos mediante su index.
      if (count($datos['deleted_files']) > 0) {
        $zip = new ZipArchive;
        if ($zip->open($datos['ruta']) === TRUE) {
          for ($i = 0; $i < count($datos['deleted_files']); $i++) {
            $zip->deleteIndex($datos['deleted_files'][$i]);
          }
        }
        $zip->close();
      }


      $to = explode(",", $datos['emails']);
      $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];
      $transport = new Swift_SendmailTransport();
      $mailer = new Swift_Mailer($transport);

      // Traer los datos de la factura
      $zip = new ZipArchive;
      if ($zip->open($datos['ruta']) === TRUE) {
        $file = $zip->getFromName($datos['factura_name'] . '.xml');
      }
      $zip->close();

      $query = db_select("partners_clientes", "pc");
      $query->fields("pc", array("nombre_cliente", "email"));
      $query->condition("id_cliente", $datos['id_cliente']);
      $query = $query->execute();
      $cliente = $query->fetchAssoc();

      // Si pudo encontrar el xml para sacar los datos, entonces proceder y enviar los correos con los datos extraidos del xml, sino, tirar error de que
      // no pudo encontrar el xml.
      if ($file) {
        $datos_template = [];
        $factura = new SimpleXMLElement($file);
        $cfdiXml = new SimpleXMLElement($file, 0, false, 'cfdi', true);
        $datos_template['Serie'] = $factura[0]['Serie'];
        $datos_template['Folio'] = $factura[0]['Folio'];
        $datos_template['Total'] = (float)$factura[0]['Total'];
        $datos_template['Moneda'] = $factura[0]['Moneda'];

        $datos_template['send_paypal'] = encrypt_decrypt('encrypt', $factura[0]['Serie'] . '~' . $factura[0]['Folio'] . '~' . $factura[0]['Total']);

        // Generar URL de Conekta
        $precioConekta = (int)($datos_template['Total'] * 100);
        foreach ($to as $address => $name) {
          if (is_int($address)) {
            $clienteEmail = $name;
          } else {
            $clienteEmail = $address;
          }
          break;
        }
        $validCheckout = [
          'name' => "Pago de factura",
          'type' => "PaymentLink",
          'recurrent' => false,
          'expired_at' => strtotime("now+30day"),
          'allowed_payment_methods' => ["card"],
          'needs_shipping_contact' => false,
          'monthly_installments_enabled' => false,
          'monthly_installments_options' => [],
          'order_template' => [
            'line_items' => [[
              'name' => "Factura {$datos_template['Serie']}-{$datos_template['Folio']}",
              'unit_price' => $precioConekta,
              'quantity' => 1
            ]],
            'metadata' => [
              'tipo' => "factura",
              'folio' => (int)$datos_template['Folio']
            ],
            'currency' => "MXN",
            'customer_info' => [
              'name' => (string)$cfdiXml->Receptor->attributes('', TRUE)->Nombre,
              'email' => $clienteEmail,
              'phone' => "0000000000"
            ]
          ]
        ];
        $ch = curl_init('https://api.conekta.io/checkouts');
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt(
          $ch,
          CURLOPT_HTTPHEADER,
          array(
            "accept: application/vnd.conekta-v2.0.0+json",
            "content-type: application/json"
          )
        );
        curl_setopt($ch, CURLOPT_USERNAME, "key_pbwBpwHxGfHNArWoxp8Dsw"); //Pruebas
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($validCheckout));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        if ($response === false) {
          echo json_encode(array(
            "status" => "error",
            "message" => curl_error($ch)
          ));
          return;
        }
        $response = json_decode($response);
        curl_close($ch);
        //.
        $datos_template['conekta_url'] = $response->url;
        $datos_template['conTarjeta'] = $datos['conTarjeta'];
        $body = render_template('php', 'cobranza.mail_enviar_factura', $datos_template);
        $message = (new Swift_Message())
          ->setSubject('Factura ' . $datos_template['Serie'] . $datos_template['Folio'])
          ->setFrom($from)
          ->setBody($body, 'text/html');
        $failedRecipients = [];
        $numSent = 0;
        $attachment = Swift_Attachment::fromPath($datos['ruta'], 'application/zip');
        $message->attach($attachment);

        foreach ($to as $address => $name) {
          if (is_int($address)) {
            $message->setTo($name);
          } else {
            $message->setTo([$address => $name]);
          }
          db_insert('partners_log_actions')
            ->fields(array(
              'timestamp' => REQUEST_TIME,
              'uid' => $user->uid,
              'hostname' => ip_address(),
              'location' => $base_root . request_uri(),
              'table_at' => 'partners_cobranza',
              'type' => 'mail',
              'message' => 'Se envió la factura ' . $datos_template['Serie'] . $datos_template['Folio'] . ' a: ' . $name
            ))
            ->execute();
          $numSent += $mailer->send($message, $failedRecipients);
        }

        $check_exists = db_select('partners_cobranza', 'pc')
          ->fields('pc', array('folio'))
          ->condition('folio', $datos['num_factura'])
          ->execute()->fetchField();

        if ($check_exists > 0) {
          db_update('partners_cobranza')
            ->fields(array(
              'factura_enviada' => 1
            ))
            ->condition('folio', $datos['num_factura'])
            ->execute();
        } else {
          db_insert('partners_cobranza')
            ->fields(array(
              'folio' => $datos['num_factura'],
              'apoyo' => 0,
              'factura_enviada' => 1
            ))
            ->execute();
        }

        echo json_encode(array(
          "status" => "success",
          "message" => "Factura enviada correctamente a todos los correos."
        ));
      } else {
        echo json_encode(array(
          "status" => "error",
          "message" => "No se pudieron obtener los datos del xml de la factura."
        ));
      }
    } catch (Exception $e) {
      echo json_encode(array(
        "status" => "error",
        "message" => $e->getMessage()
      ));
    }
  }

  /**
   * Renderiza la vista de los archivos que hay dentro del pdf, para cuando se envie solo la factura sin adjuntar nada.
   * @param $datos
   */
  private function vista_content_zip($datos)
  {
    global $user;
    $zip = new ZipArchive();
    $data['datos'] = [];
    if ($zip->open(HOME_SERVER . 'facturas/' . $datos->factura . '.zip') === TRUE) {
      for ($i = 0; $i < $zip->numFiles; $i++) {
        $stat = $zip->statIndex($i);
        if ($datos->serie == 'E') {
          if (strpos($stat['name'], "FE000") === false) {
            $is_factura = true;
          } else {
            $is_factura = false;
          }
          $data['datos'][] = array("name" => $stat['name'], "delete" => $is_factura);
        } else {
          if (strpos($stat['name'], "FW000") === false) {
            $is_factura = true;
          } else {
            $is_factura = false;
          }
          $data['datos'][] = array("name" => $stat['name'], "delete" => $is_factura);
        }
      }
    }


    # Sacar emails de los contactos del cliente
    # deberá buscarlos primero en el sistema, si encuentra algún cliente con el rfc, entonces
    # después buscar sus contactos marcados con facturación, si no tiene contactos o no encuentra el
    # cliente, entonces agarrar el correo pero del comercial (que ya los traigo en $datos->emails)
    $rfc = $datos->rfc;

    // Simplemente no hacer nada en caso de que el RFC sea el de público en general, porque va a haber
    // varias facturas con ese rfc.
    if ($rfc == 'XAXX010101000') {
      $emails = '';
      $type_used_emails = 'rfc_publico';
      $id_cliente = 0;
    } else {
      $get_id_cliente = db_select('partners_clientes_datos_facturacion', 'pcdf');
      $get_id_cliente->fields('pcdf', array('id_cliente'));
      $get_id_cliente->condition('rfc', $rfc);
      $id_cliente = $get_id_cliente->execute()->fetchField();


      // No encontró el cliente en el sistema, entonces simplemente agarrar los correos del comercial
      if (!$id_cliente) {
        $emails = $datos->emails;
        $type_used_emails = 'comercial';
      } else {
        // Si encontró el cliente, entonces ahora buscar los contactos para facturación de ese cliente
        $get_contactos = db_select('partners_clientes', 'pc');
        $get_contactos->condition('id_padre', $id_cliente);
        $get_contactos->innerJoin('partners_clientes_datos', 'pcd', 'pc.id_cliente = pcd.id_cliente AND pcd.tipo_dato = 3');
        $get_contactos->addField('pcd', 'dato_valor', 'email');
        $get_contactos->condition('contacto_facturacion', 1);
        $contactos = $get_contactos->execute()->fetchAll(PDO::FETCH_ASSOC);

        if (!$contactos) {
          // No hay contactos, entonces buscar los correos del cliente en el comercial
          $em = $this->get_emails_cliente_comercial($rfc);
          if (empty($em)) {
            $emails = '';
          } else {
            $emails = $em;
          }
          $type_used_emails = 'comercial';
        } else {
          // Si hay almenos un contacto, sacar lista de correos entonces.
          $emls = [];
          foreach ($contactos as $contacto) {
            $emls[] = $contacto['email'];
          }
          $emails = implode(',', $emls);
          $type_used_emails = 'sistema';
        }
      }
    }


    $data['emails'] = $emails;
    $data['type_used_emails'] = $type_used_emails;
    $data['nombre_cliente'] = $datos->nombre_cliente;
    $data['folio_factura'] = $datos->folio_factura;
    $data['factura'] = $datos->factura;
    $data['cod_cliente'] = $datos->cod_cliente;
    $data['user_email'] = $user->mail;
    $data['id_cliente'] = $id_cliente;
    $tmpl = render_template('php', 'cobranza.vista_contenido_factura', $data);
    $this->throw_message('success', $tmpl);
  }

  /**
   * Renderiza la vista de los archivos que hay dentro del pdf, para cuando se adjunte un archivo  a la factura.
   * @param $datos
   */
  private function vista_content_zip_adjuntar($datos)
  {
    global $user;
    $zip = new ZipArchive();
    $data['datos'] = [];
    if ($zip->open(HOME_SERVER . 'facturas/' . $datos->factura . '.zip') === TRUE) {
      for ($i = 0; $i < $zip->numFiles; $i++) {
        $stat = $zip->statIndex($i);

        if ($datos->serie == 'E') {
          if (strpos($stat['name'], "FE000") === false) {
            $is_factura = true;
          } else {
            $is_factura = false;
          }
          $data['datos'][] = array("name" => $stat['name'], "delete" => $is_factura);
        } else {
          if (strpos($stat['name'], "FW000") === false) {
            $is_factura = true;
          } else {
            $is_factura = false;
          }
          $data['datos'][] = array("name" => $stat['name'], "delete" => $is_factura);
        }
      }
    }

    # Sacar emails de los contactos del cliente
    # deberá buscarlos primero en el sistema, si encuentra algún cliente con el rfc, entonces
    # después buscar sus contactos marcados con facturación, si no tiene contactos o no encuentra el
    # cliente, entonces agarrar el correo pero del comercial (que ya los traigo en $datos->emails)
    $rfc = $datos->rfc;

    // Simplemente no hacer nada en caso de que el RFC sea el de público en general, porque va a haber
    // varias facturas con ese rfc.
    if ($rfc == 'XAXX010101000') {
      $emails = '';
      $type_used_emails = 'rfc_publico';
      $id_cliente = "0";
    } else {
      $get_id_cliente = db_select('partners_clientes_datos_facturacion', 'pcdf');
      $get_id_cliente->fields('pcdf', array('id_cliente'));
      $get_id_cliente->condition('rfc', $rfc);
      $id_cliente = $get_id_cliente->execute()->fetchField();


      // No encontró el cliente en el sistema, entonces simplemente agarrar los correos del comercial
      if (!$id_cliente) {
        $emails = $datos->emails;
        $type_used_emails = 'comercial';
      } else {
        // Si encontró el cliente, entonces ahora buscar los contactos para facturación de ese cliente
        $get_contactos = db_select('partners_clientes', 'pc');
        $get_contactos->condition('id_padre', $id_cliente);
        $get_contactos->innerJoin('partners_clientes_datos', 'pcd', 'pc.id_cliente = pcd.id_cliente AND pcd.tipo_dato = 3');
        $get_contactos->addField('pcd', 'dato_valor', 'email');
        $get_contactos->condition('contacto_facturacion', 1);
        $contactos = $get_contactos->execute()->fetchAll(PDO::FETCH_ASSOC);

        if (!$contactos) {
          // No hay contactos, entonces buscar los correos del cliente en el comercial
          $em = $this->get_emails_cliente_comercial($rfc);
          if (empty($em)) {
            $emails = '';
          } else {
            $emails = $em;
          }
          $type_used_emails = 'comercial';
        } else {
          // Si hay almenos un contacto, sacar lista de correos entonces.
          $emls = [];
          foreach ($contactos as $contacto) {
            $emls[] = $contacto['email'];
          }
          $emails = implode(',', $emls);
          $type_used_emails = 'sistema';
        }
      }
    }


    $data['emails'] = $emails;
    $data['type_used_emails'] = $type_used_emails;
    $data['nombre_cliente'] = $datos->nombre_cliente;
    $data['folio_factura'] = $datos->folio_factura;
    $data['factura'] = $datos->factura;
    $data['cod_cliente'] = $datos->cod_cliente;
    $data['user_email'] = $user->mail;
    $data['id_cliente'] = $id_cliente;
    $tmpl = render_template('php', 'cobranza.vista_contenido_factura_adjuntar', $data);
    $this->throw_message('success', $tmpl);
  }


  /**
   * Marca el servicio como pagado otro y guarda cual fue ese otro metodo de pago.
   * Con lo cual automaticamente se actualiza el registro en cobranza para que desaparezca del panel de cobranza.
   * @param $datos
   */
  private function status_pagado_otro($datos)
  {
    /**
     * Pagado Cobranza:
     * 1) Pagada en efectivo
     * 2) Pagada por otro motivo
     */
    global $user;
    db_update('partners_servicios')
      ->fields(array(
        'pagado_cobranza' => 2,
        'pagado_cobranza_otro' => $datos->otro
      ))
      ->condition('id_servicio', $datos->id_servicio)
      ->execute();


    // Se actualiza el registro de cobranza, para guardar la bitácora
    $date = new DateTime();
    $date = $date->format("d/m/y H:i:s");

    $query = db_select('partners_cobranza', 'pc');
    $query->fields('pc', array('observaciones'))
      ->condition('pc.folio', $datos->folio)
      ->condition('pc.serie', 'W');
    $result = $query->execute();
    $record = $result->fetchAssoc();

    $anterior = unserialize($record['observaciones']);
    $dato = array(
      "fecha" => $date,
      "usuario" => $user->name,
      "texto" => "Se marcó como pagado otro con el motivo: " . $datos->otro,
    );
    $anterior[] = $dato;
    $data = $anterior;
    $obs = serialize($data);
    db_update('partners_cobranza')
      ->fields(array(
        'observaciones' => $obs
      ))
      ->condition('folio', $datos->folio)
      ->condition('serie', 'W')
      ->execute();

    $this->throw_message('success', 'Status modificado correctamente.');
  }


  private function update_status($datos)
  {
    global $user;

    db_update('partners_servicios')
      ->fields(array(
        $datos->col => $datos->new_val,
        $datos->col_fecha => strtotime($datos->val_fecha),
        'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_servicios', 'id_servicio', $datos->id_servicio)
      ))
      ->condition('id_servicio', $datos->id_servicio)
      ->execute();

    // Se actualiza el registro de cobranza, para guardar la bitácora
    $date = new DateTime();
    $date = $date->format("d/m/y H:i:s");

    $query = db_select('partners_cobranza', 'pc');
    $query->fields('pc', array('observaciones'))
      ->condition('pc.folio', $datos->folio)
      ->condition('pc.serie', 'W');

    $result = $query->execute();
    $record = $result->fetchAssoc();
    $anterior = unserialize($record['observaciones']);
    $dato = array(
      "fecha" => $date,
      "usuario" => $user->name,
      "texto" => $datos->obs,
    );
    $anterior[] = $dato;
    $data = $anterior;
    $obs = serialize($data);
    db_update('partners_cobranza')
      ->fields(array(
        'observaciones' => $obs
      ))
      ->condition('folio', $datos->folio)
      ->condition('serie', 'W')
      ->execute();


    if (isset($datos->capturar_caja) && $datos->capturar_caja == 1) {
      $this->capturar_entrada_caja($datos->concepto_capturar_caja, $datos->cantidad_capturar_caja);
    }

    if (isset($datos->facturado) && $datos->facturado != '') {
      $this->track_down_facturado($datos->numero_factura, $datos->id_servicio, "Administrador de Reportes de Servicios", "partners_servicios");
    }

    $this->register_log_actions('partners_servicios', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
    $this->throw_message('success', "Cambios Guardados");
  }


  /**
   * Recibe el RFC del cliente al cual se le mandará una URL con su estado de cuenta.
   * Recibe una lista de Correos para enviar el estado de cuenta.
   * @param $datos
   * @throws \Defuse\Crypto\Exception\BadFormatException
   * @throws \Defuse\Crypto\Exception\EnvironmentIsBrokenException
   */
  private function generar_estado_cuenta($datos)
  {
    global $user;
    /**
     * Versión más nueva, recibe solamente el RFC y lo encripta en un token, se envía por correo, y se procesará el estado
     * de cuenta de una manera dinamica.
     */
    setlocale(LC_TIME, "es_MX");
    $key = $this->loadEncryptionKeyFromConfig();
    $ciphertext = Crypto::encrypt($datos->rfc, $key);

    $data['url'] = "https://" . $_SERVER['HTTP_HOST'] . '/facturacion/estado_cuenta?token=' . $ciphertext;
    $data['nombre_empresa'] = $datos->nombre_empresa;
    $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];
    $to = $datos->emails;
    array_push($to, $user->mail);
    $subject = 'Estado de Cuenta.';
    $this->send_mail('cobranza.mail_estado_cuenta', $data, $subject, $from, $to);
    $this->throw_message('success', 'bien');
  }


  /**
   * Genera el estado de cuenta del cliente en base al RFC que se pasa en el token.
   * @param $datos
   * @throws \Defuse\Crypto\Exception\BadFormatException
   * @throws \Defuse\Crypto\Exception\EnvironmentIsBrokenException
   */
  private function cobranza_process_estado_cuenta($datos)
  {

    $key = $this->loadEncryptionKeyFromConfig();
    $ciphertext = $datos['token'];
    try {
      $secret_data = Crypto::decrypt($ciphertext, $key);


      $saldoT = 0;
      $totalT = 0;

      $access_credentials = db_select('partners_sql_connections', 'psc')
        ->fields('psc')
        ->execute()->fetchAssoc();
      $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
      $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
      $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
      $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);

      //$objConnect = mssql_connect($server_access, $user_access, $pass_access);
      //mssql_select_db($server_db_access);
      $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);


      if ($objConnect) {

        $query = "
                      SELECT a.CRAZONSOCIAL AS 'CLIENTE',
                        a.CSERIEDOCUMENTO AS 'SERIE',
                        a.CFOLIO AS 'FOLIO',
                        a.CFECHA AS 'FECHA',
                        a.CFECHAVENCIMIENTO AS 'VENCIMIENTO',
                        a.CTOTAL AS 'TOTAL',
                        a.CPENDIENTE AS 'SALDO',
                        a.CNUMEROGUIA AS 'NOTAS',
                         c.CCODIGOCLIENTE,
                         c.CRFC,
                         c.CEMAIL1,
                         c.CEMAIL2,
                         c.CEMAIL3
                      FROM admDocumentos a
                      LEFT OUTER JOIN admDomicilios b
                      ON a.CIDCLIENTEPROVEEDOR = b.CIDCATALOGO
                      LEFT JOIN admClientes c
                      ON c.CIDCLIENTEPROVEEDOR = a.CIDCLIENTEPROVEEDOR
                      WHERE (a.CIDDOCUMENTODE=4)
                        AND (a.CSERIEDOCUMENTO='E')
                        AND (a.CCANCELADO=0)
                        AND (a.CPENDIENTE>0)
                        AND (b.CTIPOCATALOGO=1)
                        AND (c.CRFC = '" . $secret_data . "')
                      ORDER BY a.CFOLIO DESC
                    ";

        //$result = mssql_query($query);
        $result = sqlsrv_query($objConnect, $query);


        // Primeramente, agregar las facturas con serie W hasta la parte de arriba del reporte
        $get_facturas_w = db_select('partners_servicios', 'ps');
        $get_facturas_w->fields('ps', array('factura_w_nombre_facturacion', 'servicio_facturado', 'factura_w_fecha', 'factura_w_total', 'id_servicio', 'factura_w_servicio', 'factura_w_correos_enviados'));
        $get_facturas_w->leftJoin('partners_clientes', 'pc', 'pc.id_cliente = ps.id_cliente');
        $get_facturas_w->fields('pc', array('credito'));
        $get_facturas_w->condition('pagado_cobranza', 0); // es diferente a la de pagado admon, esta es para controlar los pagos en cobranza
        $get_facturas_w->condition('servicio_facturado', 0, '!='); // La columna esta solo aplica para servicios con factura W
        $get_facturas_w->condition('factura_w_servicio', '%' . $secret_data . '%', 'LIKE'); // Filtrar los servicios por el RFC
        $get_facturas_w->orderBy('servicio_facturado', 'DESC');
        $facturas_w = $get_facturas_w->execute();
        $name = false;

        while ($row = $facturas_w->fetchAssoc()) {

          $tkf = encrypt_decrypt('encrypt', 1 . '~' . $row['factura_w_servicio']);
          $tkx = encrypt_decrypt('encrypt', 2 . '~' . $row['factura_w_servicio']);
          $tks = encrypt_decrypt('encrypt', 3 . '~' . $row['id_servicio'] . '~' . 1);
          $servicio = ($row['credito'] == 1) ? 'A' : 'B';
          $servicio .= '-' . $row['id_servicio'];
          $name = $row['factura_w_nombre_facturacion'];

          $descargar_pdf = array("data" => "<a href='#' class='ver_pdf_factura' data-token='" . $tkf . "'>PDF</a>", "class" => array("text-center"));
          $descargar_xml = array("data" => "<a href='#' class='descargar_xml_factura' data-token='$tkx'>XML</a>", "class" => array("text-center"));
          $descargar_serv = array("data" => "<a href='#' class='ver_servicio float-left' data-servicio='" . $row['id_servicio'] . "' data-token='$tks'>Servicio $servicio </a>", "class" => array("text-center"));

          $cobranza[] = array(
            "data" => array(
              date('d/m/y', $row['factura_w_fecha']),
              array("data" => "Factura", "class" => array("text-center")),
              array("data" => "W", "class" => array("text-center")),
              array("data" => $row['servicio_facturado'], "class" => array("text-right")),
              array("data" => number_format($row['factura_w_total'], 2, '.', ''), "class" => "text-right"),
              array("data" => number_format($row['factura_w_total'], 2, '.', ''), "class" => "text-right"),
              array("data" => date('d/m/y', $row['factura_w_fecha']), "class" => array("text-center")),
              $descargar_pdf,
              $descargar_serv,
              $descargar_xml
            ),
            "data-folio" => $row['servicio_facturado'],
            "data-factura" => $row['factura_w_servicio'],
            "data-serie" => 'W',
            "data-id-servicio" => $row['id_servicio'],
            "data-folio-servicio" => (($row['credito'] == 1) ? 'A' : 'B') . '-' . $row['id_servicio'],
            "data-nombre-cliente" => $row['factura_w_nombre_facturacion'],
            "data-total-servicio" => $row['factura_w_total'],
            "data-rfc" => substr($row['factura_w_servicio'], 0, -12),
          );
        }

        while ($obj = sqlsrv_fetch_object($result)) {
          //while ($obj = mssql_fetch_object($result)) {
          if ($name == false) {
            $name = utf8_encode($obj->CLIENTE);
          }
          $x = gettype($obj->FECHA) == "string" ? new DateTime($obj->FECHA) : $obj->FECHA;
          $f = $x->getTimestamp();

          $ve = gettype($obj->VENCIMIENTO) == "string" ? new DateTime($obj->VENCIMIENTO) : $obj->VENCIMIENTO;
          $v = $ve->getTimestamp();

          $tkf = encrypt_decrypt('encrypt', 1 . '~' . $obj->CRFC . 'FE00000' . $obj->FOLIO);
          $tkx = encrypt_decrypt('encrypt', 2 . '~' . $obj->CRFC . 'FE00000' . $obj->FOLIO);


          $vencimiento = array("data" => date('d/m/y', $v), "class" => array("text-center"));
          // Contar el total de facturas que hay
          if ($this->cobranza_notas($obj->FOLIO) == NULL) {
            $tpl_serv = "";
          } else {
            $facts = explode(',', $this->cobranza_notas($obj->FOLIO));
            $cant = count($facts);
            if ($cant > 1) {
              // Varios servicios, mandar a la página para descargar todos los servicios
              $out = [];
              foreach ($facts as $fact) {
                $out[] = substr($fact, 2);
              }

              if ($facts[0][0] == "F") {
                // Servicio Centro de Servicio
                $tks = encrypt_decrypt('encrypt', 4 . '~' . implode(',', $out) . '~' . $cant);
              } else {
                // Servicio Soporte
                $tks = encrypt_decrypt('encrypt', 3 . '~' . implode(',', $out) . '~' . $cant);
              }
              $tpl_serv = "<div class='row no-gutters'><div class='col-12'><a href='/facturacion/solicitud_archivos?token=$tks' target='_blank' class='float-left'>Servicios <i class='fas fa-external-link-alt'></i></a></div></div>";
            } else {
              // Solo una factura
              if ($facts[0][0] == "F") {
                // Servicio Centro de Servicio
                $tks = encrypt_decrypt('encrypt', 4 . '~' . substr($facts[0], 2));
              } else {
                // Servicio Soporte
                $tks = encrypt_decrypt('encrypt', 3 . '~' . substr($facts[0], 2));
              }
              $tpl_serv = "<a href='#' class='ver_servicio float-left' data-servicio='" . $facts[0] . "' data-token='$tks'>Servicio $facts[0]</a>";
            }
          }
          $descargar_pdf = array("data" => "<a href='#' class='ver_pdf_factura' data-token='" . $tkf . "'>PDF</a>", "class" => array("text-center"));
          $descargar_xml = array("data" => "<a href='#' class='descargar_xml_factura' data-token='$tkx'>XML</a>", "class" => array("text-center"));
          $descargar_serv = array("data" => $tpl_serv, "class" => array("text-center"));


          $totalT += $obj->TOTAL;
          $saldoT += $obj->SALDO;
          $cobranza[] = array(
            "data" => array(
              date('d/m/y', $f),
              array("data" => "Factura", "class" => array("text-center")),
              array("data" => "E", "class" => array("text-center")),
              array("data" => $obj->FOLIO, "class" => array("text-right")),
              array("data" => number_format($obj->TOTAL, 2, '.', ','), "class" => "text-right"),
              array("data" => number_format($obj->SALDO, 2, '.', ','), "class" => "text-right"),
              $vencimiento,
              $descargar_pdf,
              $descargar_serv,
              $descargar_xml
            ),
            "data-folio" => $obj->FOLIO,
            "data-nombre-cliente" => $obj->CLIENTE,
            "data-factura" => $obj->CRFC . 'FE00000' . $obj->FOLIO,
            "data-serie" => 'E',
            "data-rfc" => $obj->CRFC
          );
        }


        $header_cols = array(
          array("name" => array("data" => "Fecha", "class" => "dont-filter"), "sortable" => 0),
          array("name" => array("data" => "Concepto", "class" => "dont-filter text-center"), "sortable" => 0),
          array("name" => array("data" => "Serie", "class" => "dont-filter text-center"), "sortable" => 0),
          array("name" => array("data" => "Folio", "class" => "dont-filter text-right"), "sortable" => 0),
          array("name" => array("data" => "Total", "class" => "dont-filter text-right total-col"), "sortable" => 0),
          array("name" => array("data" => "Saldo", "class" => "dont-filter text-right saldo-col"), "sortable" => 0),
          array("name" => array("data" => "Vencimiento", "class" => "dont-filter text-center"), "sortable" => 0),
          array("name" => array("data" => "Ver", "class" => "dont-filter text-center"), "sortable" => 0),
          array("name" => array("data" => "Ver Servicio", "class" => "dont-filter"), "sortable" => 0),
          array("name" => array("data" => "Descargar", "class" => "dont-filter text-center"), "sortable" => 0),
        );


        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);

        $table = array(
          "header" => $header,
          "rows" => $cobranza,
          "sticky" => false,
          "attributes" => array("id" => "table_estado_cuenta", "class" => array("table-sm"))
        );
      }

      $result = theme('table', $table);

      $ret = array("table" => $result, "nombre_cliente" => $name, "fecha_corte" => date('d/m/Y', REQUEST_TIME), "rfc_cliente" => $secret_data);


      $this->throw_message('success', json_encode($ret));
    } catch (\Defuse\Crypto\Exception\WrongKeyOrModifiedCiphertextException $ex) {
      $this->throw_message('error', 'Ocurrió un error al procesar tus datos, asegurate que la URL sea correcta.');
    }
  }


  /**
   * Recibe un token, y después de procesarlo regresará  la url del archivo a descargar, que estará temporalmente en facturas_tmp
   * @param $data
   */
  private function proccess_solicitud_archivo($data)
  {

    setlocale(LC_TIME, "es_MX");

    $token = encrypt_decrypt('decrypt', $data['token']);
    $datos = explode('~', $token);

    # tipo_archivo:
    #   1) PDF de Factura
    #   1) XML de Factura
    #   3) PDF de Servicio a Domicilio
    #   4) PDF de Centro de Servicio

    # folio : El folio con el que dicho archivo se buscará

    # cantidad: El total de archivos (se da el caso de que existan varios servicios, en ese caso, deberá encriptar todos los folios)

    $type = $datos[0];
    $folio = $datos[1];
    $cantidad = (isset($datos[2])) ? $datos[2] : 1;


    if ($type == 1) {
      // Tipo 1 es el PDF de la factura, entonces, deberá de buscar el .zip en facturas, abrirlo, y crear una copia del PDF
      // en facturas_tmp para después pasar ese archivo temporal y forzar la descarga.
      $t = encrypt_decrypt('encrypt', 1 . '~' . $folio);
      $d = array("file" => array('/facturacion/download_file?token=' . $t), "cantidad" => $cantidad);
      $this->throw_message('success', json_encode($d));
    } else if ($type == 2) {
      // Tipo 2, regresar el XML de la factura con el mismo procedimiento del PDF siendo la extensión la única diferencia.
      $zip = new ZipArchive;
      $res = $zip->open(HOME_SERVER . 'facturas/' . "$folio.zip");
      $url = HOME_SERVER . 'facturas_tmp/';
      if ($res === TRUE) {
        $zip->extractTo($url, array("$folio.xml"));
        $zip->close();
        $t = encrypt_decrypt('encrypt', 2 . '~' . $folio);
        $d = array("file" => array('/facturacion/download_file?token=' . $t), "cantidad" => $cantidad, "type" => 2);
        $this->throw_message('success', json_encode($d));
      } else {
        $this->throw_message('error', 'Ocurrió un error al procesar su archivo, asegurate que la URL sea correcta.');
      }
    } else if ($type == 3) {
      // Tipo 3, genera el PDF del servicio
      if ($cantidad > 1) {
        $f = explode(",", $folio);
        $urls = [];
        $folios = [];

        for ($i = 0; $i < $cantidad; $i++) {
          // Una vez con el archivo temporal generado, agregarlo al array de urls
          $t = encrypt_decrypt('encrypt', 3 . '~' . $f[$i]);
          $folios[] = $f[$i];
          $urls[] = '/facturacion/download_file?token=' . $t;
        }
        $d = array("file" => $urls, "cantidad" => $cantidad, "folios" => $folios);
        $this->throw_message('success', json_encode($d));
      } else {
        $t = encrypt_decrypt('encrypt', 3 . '~' . $folio);
        $d = array("file" => array('/facturacion/download_file?token=' . $t), "cantidad" => $cantidad);
        $this->throw_message('success', json_encode($d));
      }
    } else if ($type == 4) {
      // Generar el PDF del reporte de trabajo de Centro de Servicio


      if ($cantidad > 1) {
        $f = explode(",", $folio);
        $urls = [];
        $folios = [];
        for ($i = 0; $i < $cantidad; $i++) {
          // Una vez con el archivo temporal generado, agregarlo al array de urls
          $t = encrypt_decrypt('encrypt', 4 . '~' . $f[$i]);
          $urls[] = '/facturacion/download_file?token=' . $t;
          $folios[] = $f[$i];
        }
        $d = array("file" => $urls, "cantidad" => $cantidad, "folios" => $folios);
        $this->throw_message('success', json_encode($d));
      } else {
        $t = encrypt_decrypt('encrypt', 4 . '~' . $folio);
        $d = array("file" => array('/facturacion/download_file?token=' . $t), "cantidad" => $cantidad);
        $this->throw_message('success', json_encode($d));
      }
    } else {
      $this->throw_message('error', 'Ocurrió un error al procesar su archivo, asegurate que la URL sea correcta.');
    }
  }


  /**
   * Una vez se haya procesado el archivo y lo haya puesto en facturas_tmp, deberá descargar el archivo y posteriormente borrar el archivo temporal
   * @param $data
   * @throws MpdfException
   */
  private function download_cobranza_file($data)
  {
    setlocale(LC_TIME, "es_MX");

    $token = encrypt_decrypt('decrypt', $data['token']);
    $datos = explode('~', $token);

    # tipo_archivo:
    #   1) PDF de Factura
    #   1) XML de Factura
    #   3) PDF de Servicio a Domicilio
    #   4) PDF de Centro de Servicio

    # folio : El folio con el que dicho archivo se buscará

    # cantidad: El total de archivos (se da el caso de que existan varios servicios, en ese caso, deberá encriptar todos los folios)

    $type = $datos[0];
    $folio = $datos[1];


    if ($type == 1) {
      // Tipo 1 es el PDF de la factura, entonces, deberá de buscar el .zip en facturas, abrirlo, y crear una copia del PDF
      // en facturas_tmp para después pasar ese archivo temporal y forzar la descarga.

      // El header se coloca en el partners.cobtanza.inc
      $pdf = file_get_contents('zip://' . HOME_SERVER . 'facturas/' . $folio . '.zip#' . $folio . '.pdf');
      echo $pdf;
    } else if ($type == 2) {
      $filepath = HOME_SERVER . 'facturas_tmp/' . $folio . '.xml';

      // Process download
      if (file_exists($filepath)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filepath));
        flush(); // Flush system output buffer
        readfile($filepath);

        // Una vez que fuerza la descarga, eliminar el archivo temporal.
        unlink($filepath);
      }
    } else if ($type == 3) {

      $servicio = $this->datos_servicio($folio);
      $html = render_template('php', 'servicios.reporte_servicio', $servicio);
      $this->generate_pdf($html, $servicio['folio'], 'Hoja de Servicio ' . $servicio['folio'], 1);
    } else if ($type == 4) {
      // Generar el PDF del reporte de trabajo de Centro de Servicio


      $registro = $this->datos_registro($folio, 2);
      $footer = render_template('php', 'system.footer_reporte');
      $html = render_template('php', 'taller.render_reporte', $registro);
      $this->generate_pdf($html, 'Reporte de Servicio ' . $registro['registro']['id_registro'], 'reporte_' . $registro['registro']['id_registro'], 1, $footer);
    } else {
      $this->throw_message('error', 'Ocurrió un error al procesar su archivo, asegurate que la URL sea correcta.');
    }
  }

  /**
   * Encripta el RFC,  y regresa una url al estado de cuenta del cliente en base a ese RFC.
   * @param $datos
   * @throws \Defuse\Crypto\Exception\BadFormatException
   * @throws \Defuse\Crypto\Exception\EnvironmentIsBrokenException
   */
  private function get_token_rfc_url($datos)
  {
    $key = $this->loadEncryptionKeyFromConfig();
    $ciphertext = Crypto::encrypt($datos, $key);

    $url = "https://" . $_SERVER['HTTP_HOST'] . '/facturacion/estado_cuenta?token=' . $ciphertext;
    $this->throw_message('success', $url);
  }

  /**
   * En base al RFC, busca a ver si existe un cliente en nuestra base de datos, en caso de encontrarlo,
   * regresar una lista de todos sus contactos, si no existe el cliente o contactos, regresar un aviso y
   * que puedan agregarlos.
   * @param $rfc
   */
  private function get_contactos_cliente_by_rfc($rfc)
  {
    // Buscar el RFC en la tabla de datos facturación.
    $get_id_cliente = db_select('partners_clientes_datos_facturacion', 'pcdf');
    $get_id_cliente->fields('pcdf', array('id_cliente'));
    $get_id_cliente->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pcdf.id_cliente');
    $get_id_cliente->fields('pc', array('nombre_cliente'));
    $get_id_cliente->condition('rfc', trim($rfc));
    $cliente = $get_id_cliente->execute()->fetchAssoc();

    if ($cliente == false) {
      $out = array(
        "id_cliente" => 0,
        "contactos" => array()
      );
    } else {
      // Si existe el cliente, buscar sus contactos.
      $get_contactos = db_select('partners_clientes', 'pc');
      $get_contactos->condition('id_padre', $cliente['id_cliente']);
      $get_contactos->innerJoin('partners_clientes_datos', 'pcd', 'pc.id_cliente = pcd.id_cliente AND pcd.tipo_dato = 3');
      $get_contactos->addField('pcd', 'dato_valor', 'email');
      $get_contactos->addField('pc', 'nombre_cliente');
      $get_contactos->condition('contacto_facturacion', 1);
      $contactos = $get_contactos->execute()->fetchAll(PDO::FETCH_ASSOC);

      if (empty($contactos)) {
        $out = array(
          "id_cliente" => $cliente['id_cliente'],
          "nombre_cliente" => $cliente['nombre_cliente'],
          "contactos" => 0
        );
      } else {
        $out = array(
          "id_cliente" => $cliente['id_cliente'],
          "nombre_cliente" => $cliente['nombre_cliente'],
          "contactos" => $contactos
        );
      }
    }
    $this->throw_message('success', json_encode($out));
  }


  /**
   * Regresa la clasificación del cliente en caso de encontrarla, se busca en base al RFC.
   * Regresa el id_cliente del cliente en caso de encontrarlo.
   * @param $rfc
   * @return array
   */
  private function get_clasificacion_cliente_by_rfc($rfc)
  {
    // Buscar el RFC en la tabla de datos facturación.
    $get_id_cliente = db_select('partners_clientes_datos_facturacion', 'pcdf');
    $get_id_cliente->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pcdf.id_cliente AND pc.cancelado != 1');
    $get_id_cliente->fields('pc', array('tipo_clasificacion', 'id_cliente'));
    $get_id_cliente->condition('rfc', trim($rfc));
    $data = $get_id_cliente->execute()->fetchAssoc();

    if (!$data) {
      $clasificacion = '';
      $id_cliente = '';
    } else {
      $clasificacion = $data['tipo_clasificacion'];
      $id_cliente = $data['id_cliente'];
    }
    return array(strtoupper($clasificacion), $id_cliente);
  }


  /**
   * Recibe las rows y los datos necesarios para generar un pdf, regresa la url en donde está el archivo.
   * @param $datos
   * @throws MpdfException
   */
  private function descargar_estado_cuenta($datos)
  {
    $rows = json_decode(json_encode($datos->rows), true);
    $data['rows'] = $rows;
    $data['nombre_cliente'] = $datos->nombre_cliente;
    $data['saldo'] = $datos->saldo;
    $footer = render_template('php', 'system.footer_reporte');
    $tmp = render_template('php', 'cobranza.estado_cuenta', $data);
    $file = 'estado_cuenta_' . REQUEST_TIME;
    $this->generate_pdf($tmp, 'Estado de Cuenta', $file, 3, $footer);
    $this->throw_message('success', $file);
  }


  /**
   * Se pasa solo el nombre, y con eso se busca en facturas_tmp y lo regresa y posteriormente lo borra ya que solo es temporal.
   * @param $file_name
   */
  private function get_file_estado_cuenta($file_name)
  {

    $filepath = HOME_SERVER . 'facturas_tmp/' . $file_name['file'] . '.pdf';

    // Process download
    if (file_exists($filepath)) {
      header('Content-Description: File Transfer');
      header('Content-Type: application/octet-stream');
      header('Content-Disposition: attachment; filename="' . basename($filepath) . '"');
      header('Expires: 0');
      header('Cache-Control: must-revalidate');
      header('Pragma: public');
      header('Content-Length: ' . filesize($filepath));
      flush(); // Flush system output buffer
      readfile($filepath);

      // Una vez que fuerza la descarga, eliminar el archivo temporal.
      unlink($filepath);
    }
  }


  /**
   * Genera los datos necesarios para poder generar después el PDF del servicio
   * @param $id_servicio
   * @return array
   */
  private function datos_servicio($id_servicio)
  {
    $query = db_select('partners_servicios', 'ps');
    $query->fields('ps');
    $query->addExpression("CASE ps.tipo_servicio WHEN 1 THEN 'Remoto' WHEN 2 THEN 'Interno' WHEN 3 THEN 'Actividad' WHEN 4 THEN 'Domicilio' END ", 'nombre_tipo_servicio');
    $query->leftJoin('field_data_field_nombre_completo', 'f', 'f . entity_id = ps . created_by');
    $query->addField('f', 'field_nombre_completo_value', 'nombre_tecnico');
    $query->leftJoin('partners_clientes', 'pc', 'pc . id_cliente = ps . id_cliente');
    $query->fields('pc', array('nombre_cliente', 'credito', 'email', 'nombre_facturacion', 'tipo_clasificacion'));
    $query->leftJoin('field_data_field_nombre_completo', 'ff', 'ff . entity_id = ps . id_usuario_interno');
    $query->addField('ff', 'field_nombre_completo_value', 'nombre_usuario_solicita');
    $query->condition('ps . id_servicio', $id_servicio);
    $servicio = $query->execute()->fetchAssoc();


    $query_p = db_select('partners_servicios_datos', 'psd')
      ->fields('psd', array('pieza_nombre', 'pieza_precio'))
      ->condition('id_servicio', $id_servicio);
    $piezas = $query_p->execute()->fetchAll(PDO::FETCH_ASSOC);
    $data = [];

    $servicio_total = 0;
    $piezas_precio = 0;
    $piezas_costo = 0;

    // Tipo Remomto
    // - Solamente se puede o por precio fijo o por calculo de horas, y ambos van a caer en la misma columna
    //   de servicio_total, no tiene para piezas.
    if ($servicio['tipo_servicio'] == 1) {
      $servicio_total = db_select('partners_servicios', 'ps')
        ->fields('ps', array('servicio_total'))
        ->condition('id_servicio', $id_servicio)
        ->execute()->fetchField();
    } else if ($servicio['tipo_servicio'] == 2) {
      // Tipo Interno
      // - tiene para precio fijo y solo piezas, por lo tanto o puede tener solamente el precio fijo de
      // la columna servicio_total o puede tener el precio total de la suma de todas las piezas.


      // Cuando es de precio fijo
      if ($servicio['tipo_precio'] == 2) {
        $servicio_total = db_select('partners_servicios', 'ps')
          ->fields('ps', array('servicio_total'))
          ->condition('id_servicio', $id_servicio)
          ->execute()->fetchField();
      } else {
        // Cuando es de solo piezas, se consulta la suma de todas las piezas.
        $piezas_p = db_select('partners_servicios_datos', 'psd');
        $piezas_p->addExpression('SUM(pieza_precio)', 'total_piezas_precio');
        $piezas_p->condition('id_servicio', $id_servicio);
        $piezas_precio = $piezas_p->execute()->fetchField();

        $piezas_c = db_select('partners_servicios_datos', 'psd');
        $piezas_c->addExpression('SUM(pieza_costo)', 'total_piezas_costo');
        $piezas_c->condition('id_servicio', $id_servicio);
        $piezas_costo = $piezas_c->execute()->fetchField();

        // solamente es de puras piezas entonces no hay que sumar con otro mas
        $servicio_total = $piezas_precio;
      }
    } else if ($servicio['tipo_servicio'] == 3) {
      // Tipo Actividad
      // - Los de actividad no se cobran
      $servicio_total = 0;
    } else if ($servicio['tipo_servicio'] == 4) {
      // Tipo Domicilio
      // -Tiene para precio fijo, calculo de horas, solo piezas, y aparte piezas. es el que tiene todos los
      // tipos de precio. Entonces puede ser solamente fijo o calulo y que solo tenga valor en servicio_total
      // o puede ser que sea que tenga fijo o calculo pero tambien piezas, o puede ser que tenga solo piezas

      $piezas_p = db_select('partners_servicios_datos', 'psd');
      $piezas_p->addExpression('SUM(pieza_precio)', 'total_piezas_precio');
      $piezas_p->condition('id_servicio', $id_servicio);
      $piezas_precio = $piezas_p->execute()->fetchField();

      // Cuando tiene piezas
      if ($servicio['piezas_domicilio'] == 1) {

        // Cuando tiene por calculo de tiempo
        if ($servicio['tipo_precio'] == 1) {
          $servicio_total = $piezas_precio + $servicio['servicio_total'];
        } else if ($servicio['tipo_precio'] == 2) {
          // Cuando es precio fijo
          $servicio_total = $piezas_precio + $servicio['servicio_total'];
        } else if ($servicio['tipo_precio'] == 3) {
          //Cuando es solo piezas
          $servicio_total = $piezas_precio;
        }
      } else {
        if ($servicio['tipo_precio'] == 1) {
          $servicio_total = $piezas_precio + $servicio['servicio_total'];
        } else if ($servicio['tipo_precio'] == 2) {
          // Cuando es precio fijo
          $servicio_total = $piezas_precio + $servicio['servicio_total'];
        } else if ($servicio['tipo_precio'] == 3) {
          //Cuando es solo piezas
          $servicio_total = $piezas_precio;
        }
      }
    }

    $data['servicio_total'] = $servicio_total;
    $data['precio_piezas'] = $piezas_precio;
    $data['costo_piezas'] = $piezas_costo;
    $data['servicio'] = $servicio;
    $data['piezas'] = $piezas;
    # No encontré otra forma para hacerlo que no sea hardcoded
    # 14/08/2018 folio 6399
    if ($servicio['id_servicio'] > 6399) {
      $folio = strtoupper($servicio['tipo_clasificacion']) . '-' . $servicio['id_servicio'];
    } else {
      # Conservar los folios anteriores con la misma serie.
      $folio = (($servicio['credito'] == 1) ? 'A' : 'B') . '-' . $servicio['id_servicio'];
    }
    $data['folio'] = $folio;
    return $data;
  }

  /**
   * Regresa los datos necesarios para generar el reporte de trabajo de centro de servicio
   * @param $id_registro
   * @param $tipo
   * @return mixed
   */
  private function datos_registro($id_registro, $tipo)
  {
    $query_registro = db_select('partners_taller', 'pt');
    $query_registro->innerJoin('partners_taller_equipos', 'pte', 'pte . id_registro_taller = pt . id_registro');
    $query_registro->fields('pte');
    $query_registro->addExpression("CASE pte.tipo_equipo WHEN 1 THEN 'CPU' WHEN 2 THEN 'Todo en uno' WHEN 3 THEN 'Laptop' WHEN 4 THEN 'Servidor' WHEN 5 THEN 'Impresora' WHEN 6 THEN 'Monitor' WHEN 7 THEN 'Tablet' WHEN 8 THEN 'Celular' WHEN 9 THEN 'Otro' END", 'nombre_tipo_equipo');
    $query_registro->fields('pt');
    $query_registro->innerJoin('partners_clientes', 'pc', 'pc . id_cliente = pt . id_cliente');
    $query_registro->fields('pc', array('nombre_cliente', 'tipo_clasificacion'));
    $query_registro->leftJoin('partners_clientes', 'pcc', 'pcc . id_cliente = pt . id_contacto');
    $query_registro->addField('pcc', 'nombre_cliente', 'nombre_contacto');
    $query_registro->condition('pt . id_registro', $id_registro);
    $registro = $query_registro->execute()->fetchAssoc();
    $data['registro'] = $registro;

    if ($tipo == 1) {
      $data['tipo_reporte'] = $tipo;
    } else if ($tipo == 2) {
      $id_presupuesto = db_select('partners_taller', 'pt')
        ->fields('pt', array('id_presupuesto'))
        ->condition('id_registro', $id_registro)
        ->execute()->fetchField();
      $presupuesto_datos = db_select('partners_taller_presupuesto_datos', 'ptpd');
      $presupuesto_datos->addExpression('SUM(ptpd . precio * ptpd . cantidad)', 'subtotal');
      $presupuesto_datos->fields('ptpd');
      $presupuesto_datos->condition('id_presupuesto', $id_presupuesto);
      $presupuesto_datos->condition('autorizacion', 1);
      $presupuesto_datos->groupBy('id_dato');
      $presupuesto = $presupuesto_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

      $presupuesto_total = db_select('partners_taller_presupuesto_datos', 'ptpd');
      $presupuesto_total->addExpression('SUM(precio * cantidad)', 'total');
      $presupuesto_total->condition('id_presupuesto', $id_presupuesto);
      $presupuesto_total->condition('autorizacion', 1);
      $total = $presupuesto_total->execute()->fetchField();
      $data['presupuesto_total'] = $total;
      $data['presupuesto'] = $presupuesto;
      $data['tipo_reporte'] = $tipo;
    } else if ($tipo == 3) {
      $id_presupuesto = db_select('partners_taller', 'pt')
        ->fields('pt', array('id_presupuesto'))
        ->condition('id_registro', $id_registro)
        ->execute()->fetchField();
      $presupuesto_datos = db_select('partners_taller_presupuesto_datos', 'ptpd');
      $presupuesto_datos->addExpression('SUM(ptpd . precio * ptpd . cantidad)', 'subtotal');
      $presupuesto_datos->fields('ptpd');
      $presupuesto_datos->condition('id_presupuesto', $id_presupuesto);
      $presupuesto_datos->condition('autorizacion', 0);
      $presupuesto_datos->groupBy('id_dato');
      $presupuesto = $presupuesto_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

      $presupuesto_total = db_select('partners_taller_presupuesto_datos', 'ptpd');
      $presupuesto_total->addExpression('SUM(precio * cantidad)', 'total');
      $presupuesto_total->condition('id_presupuesto', $id_presupuesto);
      $presupuesto_total->condition('autorizacion', 0);
      $total = $presupuesto_total->execute()->fetchField();

      $data['presupuesto_total'] = $total;
      $data['presupuesto'] = $presupuesto;
      $data['tipo_reporte'] = $tipo;
    } else if ($tipo == 4) {
      // Es lo mismo que el presupuesto inicial, solamente que ahora se necesitan traer las piezas
      // autorizadas
      $id_presupuesto = db_select('partners_taller', 'pt')
        ->fields('pt', array('id_presupuesto'))
        ->condition('id_registro', $id_registro)
        ->execute()->fetchField();
      $presupuesto_datos = db_select('partners_taller_presupuesto_datos', 'ptpd');
      $presupuesto_datos->addExpression('SUM(ptpd . precio * ptpd . cantidad)', 'subtotal');
      $presupuesto_datos->fields('ptpd');
      $presupuesto_datos->condition('id_presupuesto', $id_presupuesto);
      $presupuesto_datos->condition('autorizacion', 1);
      $presupuesto_datos->groupBy('id_dato');
      $presupuesto = $presupuesto_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

      $presupuesto_total = db_select('partners_taller_presupuesto_datos', 'ptpd');
      $presupuesto_total->addExpression('SUM(precio * cantidad)', 'total');
      $presupuesto_total->condition('id_presupuesto', $id_presupuesto);
      $presupuesto_total->condition('autorizacion', 1);
      $total = $presupuesto_total->execute()->fetchField();

      $data['presupuesto_total'] = $total;
      $data['presupuesto'] = $presupuesto;
      $data['tipo_reporte'] = 3;
    } else if ($tipo == 5) {
      $id_presupuesto = db_select('partners_taller', 'pt')
        ->fields('pt', array('id_presupuesto'))
        ->condition('id_registro', $id_registro)
        ->execute()->fetchField();
      $presupuesto_datos = db_select('partners_taller_presupuesto_datos', 'ptpd');
      $presupuesto_datos->addExpression('SUM(ptpd . precio * ptpd . cantidad)', 'subtotal');
      $presupuesto_datos->fields('ptpd');
      $presupuesto_datos->condition('id_presupuesto', $id_presupuesto);
      $presupuesto_datos->condition('autorizacion', 0);
      $presupuesto_datos->groupBy('id_dato');
      $presupuesto = $presupuesto_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

      $data['presupuesto'] = $presupuesto;
      $data['tipo_reporte'] = 5;
    }
    return $data;
  }


  /**
   * En base al RFC, busca en el comercial los correos del cliente.
   * @param $rfc
   * @return array|bool
   */
  private function get_emails_cliente_comercial($rfc)
  {
    $access_credentials = db_select('partners_sql_connections', 'psc')
      ->fields('psc')
      ->execute()->fetchAssoc();
    $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
    $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
    $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
    $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);
    // $objConnect = mssql_connect($server_access, $user_access, $pass_access);
    // mssql_select_db($server_db_access);
    $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);
    if ($objConnect) {
      $query = "
                SELECT
                a.CEMAIL1,
                a.CEMAIL2,
                a.CEMAIL3
                FROM admClientes a
                WHERE a.CRFC = '$rfc'";
      //$result = mssql_query($query);
      $result = sqlsrv_query($objConnect, $query);
      $cliente = [];
      //while ($obj = mssql_fetch_object($result)) {
      while ($obj = sqlsrv_fetch_object($result)) {
        $cliente = array(
          $obj->CEMAIL1,
          $obj->CEMAIL2,
          $obj->CEMAIL3,
        );
      }
      return implode(',', $cliente);
    } else {
      return false;
    }
  }


  private function vista_pagar_servicio_w($datos)
  {
    $this->throw_message('success', render_template('php', 'cobranza.pagar_servicio_w', (array)$datos));
  }

  /**
   * Reporteador de los recibos electrónicos de pago (REP)
   * @param $datos
   * @throws Exception
   */
  private function reporte_base_rep($datos)
  {
    $dir = HOME_SERVER . 'facturas/REP';

    $files = array_diff(scandir($dir), array('..', '.'));
    $fn = function ($file) {
      $tmp = explode('-', $file);
      $x = substr($tmp[1], 4, 9);
      $file_name = substr($file, 0, strlen($file) - 4);
      return array($tmp[0], (int)$x, $file_name);
    };


    # return false;
    # Este array tiene todos los REP que estan en el servidor, será usado
    # para comparar contra lo que se tiene en la base de datos, si hay alguno
    # que no este en la base de datos, hay que capturarlo.
    $rep_servidor = array_map($fn, $files);

    #var_dump($rep_servidor);
    # return false;

    $get_rep = db_select('partners_rep', 'pr');
    $get_rep->fields('pr', array('folio'));
    $rep_list = $get_rep->execute()->fetchAll(PDO::FETCH_ASSOC);
    $r_list = [];
    foreach ($rep_list as $item) {
      $r_list[] = (int)$item['folio'];
    }

    # Por cada archivo que este en el servidor, verificar que ya exista en la base de datos,
    # de lo contrario, capturarlo a la base de datos.
    #var_dump($rep_servidor);

    foreach ($rep_servidor as $item) {
      # No existe, entonces capturarlo.
      #echo $item[1] . PHP_EOL;
      // Se soluciona de cierta manera comparando enteros con enteros.
      if (!in_array($item[1], $r_list)) {

        // Traer los datos de la factura
        $zip = new ZipArchive;
        $file = false;
        if ($zip->open($dir . '/' . $item[2] . '.zip') === TRUE) {
          $file = $zip->getFromName($item[2] . '.xml');
        }
        $zip->close();

        if ($file) {
          $factura = new SimpleXMLElement($file);
          $folio_rep = (int)$factura->xpath('//cfdi:Comprobante')[0]['Folio'];
          $nombre_cliente = (string)$factura->xpath('//cfdi:Comprobante//cfdi:Receptor')[0]['Nombre'];
          $rfc_cliente = (string)$factura->xpath('//cfdi:Comprobante//cfdi:Receptor')[0]['Rfc'];
          $fecha_pago = (string)$factura->xpath('//cfdi:Comprobante//cfdi:Complemento//pago10:Pagos//pago10:Pago')[0]['FechaPago'];
          $fecha_emision = (string)$factura->xpath('//cfdi:Comprobante')[0]['Fecha'];
          $total = (float)$factura->xpath('//cfdi:Comprobante//cfdi:Complemento//pago10:Pagos//pago10:Pago')[0]['Monto'];

          $fp = new DateTime($fecha_pago);
          $fe = new DateTime($fecha_emision);

          if (!in_array($folio_rep, $r_list)) {
            // Si efectivamente no esta, entonces ahora si
            // capturarlo.
            db_insert('partners_rep')
              ->fields(array(
                'folio' => $folio_rep,
                'rfc' => $rfc_cliente,
                'nombre_cliente' => $nombre_cliente,
                'fecha_pago' => $fp->getTimestamp(),
                'fecha_emision' => $fe->getTimestamp(),
                'filename' => $item[2],
                'total' => $total
              ))
              ->execute();
          }
        }
      }
    }


    # Despues, en este punto, ya deberian de estar actualizados todos los datos.
    $fi = str_replace('/', '-', trim($datos->filter->start_date));
    $ff = str_replace('/', '-', trim($datos->filter->end_date));
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;
    $query = db_select('partners_rep', 'pr');
    $query->fields('pr');

    // Filtros
    if ($f_inicio == $f_final) {
      $f_final_same_day = $f_inicio + 86040;
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_emision', array($f_inicio, $f_final_same_day), 'BETWEEN');
      }
    } else {
      if ($datos->filter->start_date) {
        $query->condition('pr.fecha_emision', array($f_inicio, $f_final), 'BETWEEN');
      }
    }

    // Filtro - Search Bar
    if ($datos->filter->search_bar != null) {
      $rep_busqueda_or = db_or()
        ->condition('pr.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pr.folio', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pr.rfc', '%' . $datos->filter->search_bar . '%', 'LIKE');
      $query->condition($rep_busqueda_or);
    }

    $query->orderBy($datos->sort->sort_by, $datos->sort->order);
    $query_datos = $query->execute();
    $cobranza_rep = [];
    while ($row = $query_datos->fetchAssoc()) {
      $fecha_pago = date('d/m/y H:i:s', $row['fecha_pago']);
      $fecha_emision = date('d/m/y H:i:s', $row['fecha_emision']);

      // Observaciones | Notas internas
      if ($row['observaciones'] != NULL) {
        $observaciones = array("data" => 'Obs', "class" => array("status-yellow", "status_obs", "text-center", "cursor-pointer"));
      } else {
        $observaciones = array("data" => 'Obs', "class" => array("text-center", "status_obs", "cursor-pointer"));
      }


      // Factura enviada
      if ($row['rep_enviado'] == 0) {
        $rep_enviado = array("data" => '<i class="fa fa-paper-plane" aria-hidden="true"></i>', "class" => array("text-center", "cursor-pointer", "enviar_rep"));
      } else {
        $rep_enviado = array("data" => '<i class="fa fa-paper-plane" aria-hidden="true"></i>', "class" => array("text-center", "status-green", "cursor-pointer", "enviar_rep"));
      }

      $cobranza_rep[] = array(
        "data" => array(
          $row['folio'],
          $row['rfc'],
          $row['nombre_cliente'],
          array("data" => number_format($row['total'], 2, '.', ','), "class" => array("text-right")),
          $fecha_pago,
          $fecha_emision,
          $observaciones,
          $rep_enviado
        ),
        "data-folio" => $row['folio'],
        "data-rfc" => $row['rfc'],
        "data-filename" => $row['filename'],
        "data-nombre-cliente" => $row['nombre_cliente']
      );
    }

    $header_cols = array(
      array("name" => array("data" => "Folio", "class" => "filter-number"), "sortable" => 0),
      array("name" => array("data" => "RFC", "class" => "filter-date"), "sortable" => 0),
      array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Monto", "class" => "filter-text text-right"), "sortable" => 0),
      array("name" => array("data" => "Fecha Pago", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Fecha Emisión", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Obs", "class" => "filter-text text-center"), "sortable" => 0),
      array("name" => array("data" => '<i class="fa fa-paper-plane" aria-hidden="true"></i>', "class" => "filter-text text-center"), "sortable" => 0),
    );
    $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);
    $table = array(
      "header" => $header,
      "rows" => $cobranza_rep,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_cobranza_rep", "class" => array("table-sm"))
    );
    $result = theme('table', $table);
    echo $result;
  }

  /**
   * Genera la vista usada para enviar por correo el recibo electronico de pago.
   * @param $datos
   */
  private function vista_enviar_rep($datos)
  {
    global $user;

    # Sacar emails de los contactos del cliente
    # deberá buscarlos primero en el sistema, si encuentra algún cliente con el rfc, entonces
    # después buscar sus contactos marcados con facturación, si no tiene contactos o no encuentra el
    # cliente, entonces agarrar el correo pero del comercial (que ya los traigo en $datos->emails)
    $rfc = $datos->rfc;
    // Simplemente no hacer nada en caso de que el RFC sea el de público en general, porque va a haber
    // varias facturas con ese rfc.
    if ($rfc == 'XAXX010101000') {
      $emails = '';
      $type_used_emails = 'rfc_publico';
    } else {
      $get_id_cliente = db_select('partners_clientes_datos_facturacion', 'pcdf');
      $get_id_cliente->fields('pcdf', array('id_cliente'));
      $get_id_cliente->condition('rfc', $rfc);
      $id_cliente = $get_id_cliente->execute()->fetchField();


      // No encontró el cliente en el sistema, entonces simplemente agarrar los correos del comercial
      if (!$id_cliente) {
        $em = $this->get_emails_cliente_comercial($rfc);
        if (empty($em)) {
          $emails = '';
        } else {
          $emails = $em;
        }
        $type_used_emails = 'comercial';
      } else {
        // Si encontró el cliente, entonces ahora buscar los contactos para facturación de ese cliente
        $get_contactos = db_select('partners_clientes', 'pc');
        $get_contactos->condition('id_padre', $id_cliente);
        $get_contactos->innerJoin('partners_clientes_datos', 'pcd', 'pc.id_cliente = pcd.id_cliente AND pcd.tipo_dato = 3');
        $get_contactos->addField('pcd', 'dato_valor', 'email');
        $get_contactos->condition('contacto_facturacion', 1);
        $contactos = $get_contactos->execute()->fetchAll(PDO::FETCH_ASSOC);

        if (!$contactos) {
          // No hay contactos, entonces buscar los correos del cliente en el comercial
          $em = $this->get_emails_cliente_comercial($rfc);
          if (empty($em)) {
            $emails = '';
          } else {
            $emails = $em;
          }
          $type_used_emails = 'comercial';
        } else {
          // Si hay almenos un contacto, sacar lista de correos entonces.
          $emls = [];
          foreach ($contactos as $contacto) {
            $emls[] = $contacto['email'];
          }
          $emails = implode(',', $emls);
          $type_used_emails = 'sistema';
        }
      }
    }

    $data['emails'] = $emails;
    $data['type_used_emails'] = $type_used_emails;
    $data['nombre_cliente'] = $datos->nombre_cliente;
    $data['folio_rep'] = $datos->rep;
    $data['user_email'] = $user->mail;
    $data['filename'] = $datos->filename;
    $tmpl = render_template('php', 'cobranza.vista_enviar_rep', $data);
    $this->throw_message('success', $tmpl);
  }

  /**
   * Envia por correo el .zip de un recibo electrónico a los correos indicados.
   * @param $datos
   * @throws Exception
   */
  private function enviar_correo_rep($datos)
  {
    $ruta_base = HOME_SERVER . 'facturas/REP/';

    $to = explode(",", $datos->emails);
    $from = ['facturacion@pcpartners.com.mx' => 'Pc Partners - Facturación'];
    $transport = new Swift_SendmailTransport();
    $mailer = new Swift_Mailer($transport);

    // Traer los datos de la factura
    $file = false;
    $zip = new ZipArchive;
    if ($zip->open($ruta_base . $datos->filename . '.zip') === TRUE) {
      $file = $zip->getFromName($datos->filename . '.xml');
    }
    $zip->close();

    if ($file) {
      $factura = new SimpleXMLElement($file);
      $datos_template['folio_rep'] = (int)$factura->xpath('//cfdi:Comprobante')[0]['Folio'];
      $datos_template['nombre_cliente'] = (string)$factura->xpath('//cfdi:Comprobante//cfdi:Receptor')[0]['Nombre'];
      $datos_template['rfc_cliente'] = (string)$factura->xpath('//cfdi:Comprobante//cfdi:Receptor')[0]['Rfc'];
      $datos_template['fecha_pago'] = (string)$factura->xpath('//cfdi:Comprobante//cfdi:Complemento//pago10:Pagos//pago10:Pago')[0]['FechaPago'];
      $datos_template['fecha_emision'] = (string)$factura->xpath('//cfdi:Comprobante')[0]['Fecha'];
      $datos_template['total'] = (float)$factura->xpath('//cfdi:Comprobante//cfdi:Complemento//pago10:Pagos//pago10:Pago')[0]['Monto'];

      $facturas_pagadas = [];
      foreach ($factura->xpath('//cfdi:Comprobante//cfdi:Complemento//pago10:Pagos//pago10:Pago//pago10:DoctoRelacionado') as $factura) {
        $facturas_pagadas[] = array(
          "folio" => (int)$factura['Folio'],
          "serie" => (string)$factura['Serie'],
          "pagado" => (float)$factura['ImpPagado'],
          "saldo_insoluto" => (float)$factura['ImpSaldoInsoluto']
        );
      }

      $datos_template['facturas'] = $facturas_pagadas;
      $body = render_template('php', 'cobranza.mail_enviar_rep', $datos_template);
      $message = (new Swift_Message())
        ->setSubject('Recibo de Pago Electrónico ' . $datos_template['folio_rep'])
        ->setFrom($from)
        ->setBody($body, 'text/html');
      $failedRecipients = [];
      $numSent = 0;
      $attachment = Swift_Attachment::fromPath($ruta_base . $datos->filename . '.zip', 'application/zip');
      $message->attach($attachment);

      foreach ($to as $address => $name) {
        if (is_int($address)) {
          $message->setTo($name);
        } else {
          $message->setTo([$address => $name]);
        }
        $this->register_log_actions('partners_rep', 'mail', 'Se envió el REP ' . $datos_template['folio_rep'] . 'a: ' . $name);
        $numSent += $mailer->send($message, $failedRecipients);
      }


      // Actualizar el registro REP en la tabla de partners_rep para indicar que ya se envió
      // y aparte guardar en observaciones a que correos se envió.
      db_update('partners_rep')
        ->fields(array(
          'rep_enviado' => 1,
          'observaciones' => $this->serialize_obs('El REP se envió a los siguientes correos: ' . $datos->emails, 2, 'partners_rep', 'folio', $datos_template['folio_rep'])
        ))
        ->condition('folio', $datos_template['folio_rep'])
        ->execute();

      $this->throw_message('success', 'Correos enviados correctamente');
    } else {
      $this->throw_message('error', 'No se pudieron obtener los datos del xml del recibo electrónico de pago.');
    }
  }

  /**
   * Metodo para Regresar el Metodo de Pago de una factura
   * @param $factura
   * @return array
   */
  private function getFacturaMetodoPago($factura)
  {
    $metodoPago = '';
    $formaPago = '';
    $zip = new ZipArchive;
    $file = false;
    if ($zip->open(HOME_SERVER . 'facturas/' . $factura . '.zip') === TRUE) {
      $file = $zip->getFromName($factura . '.xml');
    }
    $zip->close();

    if ($file) {
      $factura = new SimpleXMLElement($file);
      $metodoPago = (string)$factura->xpath('//cfdi:Comprobante')[0]['MetodoPago'];
      $formaPago = (string)$factura->xpath('//cfdi:Comprobante')[0]['FormaPago'];
    }
    return [$metodoPago, $formaPago];
  }


  private function cobranza_observaciones($folio, $serie)
  {
    $obs = db_select('partners_cobranza', 'pc')
      ->fields('pc', array('observaciones'))
      ->condition('folio', $folio)
      ->condition('serie', $serie)
      ->execute()->fetchField();

    return ($obs) ? $obs : null;
  }

  private function cobranza_especial($folio, $serie)
  {
    $apoyo = db_select('partners_cobranza', 'pc')
      ->fields('pc', array('especial'))
      ->condition('folio', $folio)
      ->condition('serie', $serie)
      ->execute()->fetchField();

    return $apoyo;
  }

  /**
   * Validar si la factura ya ha sido enviada
   * @param $folio
   * @param $serie
   * @return mixed
   */
  private function cobranza_factura_enviada($folio, $serie)
  {
    $q = db_select('partners_cobranza', 'pc')
      ->condition('pc.folio', $folio, '=')
      ->condition('pc.serie', $serie, '=')
      ->fields('pc', array('factura_enviada'))
      ->execute()->fetchField();
    if (empty($q)) {
      return 0;
    } else {
      return 1;
    }
  }

  private function cobranza_apoyo($folio, $serie)
  {
    $q = db_select('partners_cobranza', 'pc')
      ->condition('pc.folio', $folio, '=')
      ->condition('pc.serie', $serie, '=')
      ->fields('pc', array('apoyo'))
      ->execute()->fetchField();
    if (empty($q)) {
      return 0;
    } else {
      return $q;
    }
  }

  /**
   * Valida si la factura ya ha sido pagada
   * @param $folio
   * @param $serie
   * @return mixed
   */
  private function cobranza_factura_pagada($folio, $serie)
  {
    $q = db_select('partners_cobranza', 'pc')
      ->condition('pc.folio', $folio, '=')
      ->condition('pc.serie', $serie, '=')
      ->fields('pc', array('factura_pagada'))
      ->execute()->fetchField();
    if (empty($q)) {
      return 0;
    } else {
      return 1;
    }
  }


  /**
   * Validar si existe el zip de la factura
   * @param string $rfc
   * @param string $folio
   * @param string $serie  acepta E por el momento
   * @return bool
   */
  private function check_zip_exists($rfc, $folio, $serie)
  {
    $zip = new ZipArchive();
    if ($serie != 'W') {
      if ($zip->open(HOME_SERVER . 'facturas/' . $rfc .  'FE00000' . $folio . '.zip') === TRUE) {
        for ($i = 0; $i < $zip->numFiles; $i++) {
          $stat = $zip->statIndex($i);
          if (strpos($stat['name'], "FE000") != false) {
            $is_factura = true;
          } else {
            $is_factura = false;
          }
          return $is_factura;
        }
      }
    }
    return false;
  }


  public static function vista_cliente($codigo)
  {

    $access_credentials = db_select('partners_sql_connections', 'psc')
      ->fields('psc')
      ->execute()->fetchAssoc();
    $user_access = self::encrypt_decrypt('decrypt', $access_credentials['user']);
    $pass_access = self::encrypt_decrypt('decrypt', $access_credentials['pass']);
    $server_access = self::encrypt_decrypt('decrypt', $access_credentials['server_ip']);
    $server_db_access = self::encrypt_decrypt('decrypt', $access_credentials['server_db']);

    //$objConnect = mssql_connect($server_access, $user_access, $pass_access);
    //mssql_select_db($server_db_access);

    $objConnect = sqlsrv_connect($server_access, ["Database" => $server_db_access, "UID" => $user_access, "PWD" => $pass_access]);




    if ($objConnect) {
      //$row = mssql_query($objConnect, "SELECT * FROM admClientes where CCODIGOCLIENTE = (?)", [$codigo]);
      //$row = mssql_fetch_object($row);
      $row = sqlsrv_query($objConnect, "SELECT * FROM admClientes WHERE CCODIGOCLIENTE = (?)", [$codigo]);
      $row = sqlsrv_fetch_object($row);
      $get_id_cliente = db_select('partners_clientes_datos_facturacion', 'pcdf');
      $get_id_cliente->fields('pcdf', array('id_cliente'));
      $get_id_cliente->condition('rfc', $row->CRFC);
      $id_cliente = $get_id_cliente->execute()->fetchField();
      if ($id_cliente) {
        $get_telefonos = db_select('partners_clientes', 'pc');
        $get_telefonos->condition('id_padre', $id_cliente);
        $get_telefonos->innerJoin('partners_clientes_datos', 'pcd', 'pc.id_cliente = pcd.id_cliente AND pcd.tipo_dato = 1');
        $get_telefonos->addField('pcd', 'dato_valor', 'telefono');
        $tels = $get_telefonos->execute()->fetchAll(PDO::FETCH_ASSOC);
      }
      //return print_r($row);
      $dd = '';
      foreach ($tels as $t) {
        $dd .=  ($t['telefono'] != '' ? $t['telefono'] . '<br>' : '');
      }
      $dato = ($row != '' ? '
        <style>
              table tr th:nth-child(11){
                  width: 10px;
                }
              .colu{
                  text-align: center;
                  font-weight: bold;

              }
              .colum{
                  text-align: center;
              }

              </style>
              <table class="table table-sm table-striped table-bordered table-condensed table-hover">

              <thead>
                  <tr>
                      <th class="colu">ID</th>
                      <th class="colu">Cliente</th>
                      <th class="colu"">RFC</th>
                      <th class="colu">EMAIL 1</th>
                      <th class="colu">EMAIL 2</th>
                      <th class="colu">EMAIL 3</th>
                      <th class="colu">TELEFONO(s)</th>


                  </tr>
              </thead>
              <tbody>
                  <tr data-codigo-cliente="' . $row->CCODIGOCLIENTE . '">
                      <td class="colum">' . $row->CCODIGOCLIENTE . '</td>
                      <td class="">' . $row->CRAZONSOCIAL  . '</td>
                      <td class="colum">' . $row->CRFC . '</td>
                      <td class="colum">' . $row->CEMAIL1 . '</td>
                      <td class="colum">' . $row->CEMAIL2  . '</td>
                      <td class="colum">' . $row->CEMAIL3 . '</td>
                      <td class="colum">' . $dd . '</td>
                    </tr>
              </tbody>' : print_r(sqlsrv_errors(), true)); //mssql_get_last_message(), true)); //


      return $dato;
    } else {
      return 'Error';
    }
  }
  private function cobranza_notas($folio)
  {
    $notas = db_select('partners_cobranza', 'pc')
      ->fields('pc', array('notas'))
      ->condition('folio', $folio)
      ->execute()->fetchField();

    if (empty($notas)) {
      return 0;
    } else {
      return $notas;
    }
    return ($notas) ? $notas : null;
  }
}
