<?php

class clientes_reporte
{
  public function __construct($data)
  {

    $this->reporte_base($data);
  }

  private function reporte_base($datos)
  {
    $query = db_select('partners_clientes', 'pc')->fields('pc')->condition('cancelado', 0);
    $query->innerJoin('partners_clientes_datos', 'pcd' ,'pc.id_cliente = pcd.id_cliente and tipo_dato = 3');
    $query->addField('pcd', 'dato_valor', 'correo');
    $filter = array();

    // Filtros

    //Search Bar
    if ($datos->filter->search_bar != null) {
      $cliente_or = db_or()
        ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pcd.dato_valor', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pc.nombre_facturacion', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pc.pagina_web', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pc.alias', '%' . $datos->filter->search_bar . '%', 'LIKE');
      $query->condition($cliente_or);
      array_push($filter, array(
        'type' => 'condition_group',
        'condition' => $cliente_or,
      ));
    }

    //Clasificación
    if ($datos->filter->clasificacion != 0) {
      $query->condition('pc.tipo_cliente', $datos->filter->clasificacion, '=');
      array_push($filter, array(
        'type' => 'condition',
        'condition' => 'pc.tipo_cliente',
        'value' => $datos->filter->clasificacion,
        'operator' => '='
      ));
    }


    // Tiene Licencias
    if ($datos->filter->has_licencia != 0) {
      $val = 0;
      if ($datos->filter->has_licencia == 1) {
        $val = 1;
      }
      $query->condition('pc.has_licencia', $val, '=');
      array_push($filter, array(
        'type' => 'condition',
        'condition' => 'pc.has_licencia',
        'value' => $val,
        'operator' => '='
      ));
    }

    //Tipo Empresa
    if ($datos->filter->tipo_empresa != null) {
      $d = explode(',', $datos->filter->tipo_empresa);
      $query->condition('pc.tipo_negocio', $d, 'IN');
      array_push($filter, array(
        'type' => 'condition',
        'condition' => 'pc.tipo_negocio',
        'value' => $d,
        'operator' => 'IN'
      ));
    }

    //Encuesta
    if ($datos->filter->encuesta != null) {
      if ($datos->filter->encuesta == 2) {
        $query->condition('pc.encuesta', 0, '=');
        array_push($filter, array(
          'type' => 'condition',
          'condition' => 'pc.encuesta',
          'value' => 0,
          'operator' => '='
        ));
      } else if ($datos->filter->encuesta == 1) {
        $query->condition('pc.encuesta', 0, '!=');
        array_push($filter, array(
          'type' => 'condition',
          'condition' => 'pc.encuesta',
          'value' => 0,
          'operator' => '!='
        ));
      }
    }

    //Clasificación Interna
    if ($datos->filter->clasificacion_interna != null) {
      $query->condition('pc.tipo_clasificacion', $datos->filter->clasificacion_interna, '=');
      array_push($filter, array(
        'type' => 'condition',
        'condition' => 'pc.tipo_clasificacion',
        'value' => $datos->filter->clasificacion_interna,
        'operator' => '='
      ));
    }

    $query->addExpression("CASE pc.tipo_cliente WHEN 1 THEN 'Cliente' WHEN 2 THEN 'Contacto' WHEN 3 THEN 'Proveedor' END ", 'tipo_cliente');
    $query->addExpression("CASE pc.tipo_negocio WHEN 1 THEN 'Negocio' WHEN 2 THEN 'Particular' WHEN 3 THEN 'Distribuidor' WHEN 4 THEN 'Prospecto' WHEN 5 THEN 'Proveedor' END ", 'negocio');
    $query->orderBy($datos->sort->sort_by, $datos->sort->order);

    // Pagination
    $options = array(
      'table' => 'partners_clientes',
      'alias' => 'pc',
      'index' => 'id_cliente',
      'range' => 6,
      'filter' => $filter,
      'limit' => 30,
      'current_page' => $datos->pagination->page,
      'deleted_rows' => 'cancelado'
    );
    $pagination = sys_tools::pagination($options, $query->execute());
    $offset = $pagination[0];

    $limit = $pagination[1];
    $rendered_pagination = $pagination[2];

    $query->range($offset, $limit);
    $query_datos = $query->execute();

    // Inicializar afuera en caso de que ningún row sea devuelto por el query.
    // https://github.com/ErickGomez98/Interno_dev/issues/107
    $clientes = [];

    while ($row = $query_datos->fetchAssoc()) {
      if ($row['tipo_cliente'] == 'Cliente' || $row['tipo_cliente'] == 'Proveedor') {
        $tipo_cliente_class = 'vista_cliente';
        $ventas = array("data" => "Ventas", "data-id-cliente" => $row['id_cliente'], "data-from-reporteador" => true, "data-nombre-cliente" => $row['nombre_cliente'], "class" => array("cursor-pointer", "area_ventas_cliente"));
      } else {
        $ventas = "";
        $tipo_cliente_class = 'vista_contacto';
      }
      $phone = db_select('partners_clientes_datos', 'pcd')
        ->fields('pcd', array('dato_valor'))
        ->condition('id_cliente', $row['id_cliente'])
        ->condition('pcd.tipo_dato', 1)
        ->execute()->fetchField();
      $cel = db_select('partners_clientes_datos', 'pcd')
        ->fields('pcd', array('dato_valor'))
        ->condition('id_cliente', $row['id_cliente'])
        ->condition('pcd.tipo_dato', 2)
        ->execute()->fetchField();

      $encuesta = array("data" => ($row['encuesta'] != 0) ? 'Si' : 'No', "data-encuesta" => ($row['encuesta'] != 0), "class" => array("cursor-pointer", "text-center", "cambiar_status_encuesta", ($row['encuesta'] != 0) ? 'status-green' : 'status-red'));


      $clientes[] = array(
        "data" => array(
          array("data" => $row['tipo_cliente'], "data-id" => $row['id_cliente'], "class" => array("cursor-pointer", $tipo_cliente_class)),
          array("data" => $row['id_cliente'], "data-id" => $row['id_cliente'], "class" => array("cursor-pointer", $tipo_cliente_class)),
          array("data" => $row['negocio'], "data-id" => $row['id_cliente'], "class" => array("cursor-pointer", $tipo_cliente_class)),
          array("data" => $row['nombre_cliente'], "data-id" => $row['id_cliente'], "class" => array("cursor-pointer", $tipo_cliente_class)),
          array("data" => $row['correo'], "data-id" => $row['id_cliente'], "class" => array("cursor-pointer", $tipo_cliente_class)),
          array("data" => $phone, "data-id" => $row['id_cliente'], "class" => array("cursor-pointer", $tipo_cliente_class)),
          array("data" => $cel, "data-id" => $row['id_cliente'], "class" => array("cursor-pointer", $tipo_cliente_class)),
          $encuesta,
          $ventas
        ),
        "data-id" => $row['id_cliente'],
        "class" => $row['solicitar_cancelacion'] == 1 ? "line-through-text" : ""
      );
    }


    // Header -- Sort
    $header_cols = array(
      array("name" => "Tipo Cliente", "table_field" => "tipo_cliente", "sortable" => 1),
      array("name" => "ID", "table_field" => "tipo_cliente", "sortable" => 1),
      array("name" => "Tipo Empresa", "table_field" => "tipo_negocio", "sortable" => 1),
      array("name" => "Nombre", "table_field" => "nombre_cliente", "sortable" => 1),
      array("name" => "Correo", "table_field" => "email", "sortable" => 1),
      array("name" => "Teléfono", "sortable" => 0),
      array("name" => "Celular", "sortable" => 0),
      array("name" => "Encuesta", "sortable" => 0),
      array("name" => "Ventas", "sortable" => 0),
    );
    $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


    $table = array(
      "header" => $header,
      "rows" => $clientes,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_clientes", "class" => array("table-sm"))
    );


    $result = theme('table', $table);

    echo $result;
    echo $rendered_pagination;
  }

}