<?php


class clientes_sys extends sys_tools
{
  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'new_client':
          try {
            $this->new_client($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_nuevo_cliente');
          }
          break;
        case 'new_contact':
          try {
            $this->new_contact($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_nuevo_contacto');
          }
          break;
        case 'cancel_client':
          try {
            $this->cancel_client($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'cancelar_cliente');
          }
          break;
        case 'reactivate_client':
          try {
            $this->reactivate_client($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reactivar_cliente');
          }
          break;
        case 'clientes_encuesta':
          try {
            $this->clientes_encuesta($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'clientes_encuesta');
          }
          break;
        case 'clientes_vista_encuesta':
          try {
            $this->clientes_vista_encuesta($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'clientes_vista_encuesta');
          }
          break;
        case 'modificar_correo_edicion':
          try {
            $this->modificar_correo_edicion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'modificar_correo_edicion');
          }
          break;
        case 'datos_extras_clientes':
          try {
            $this->datos_extras_clientes($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'datos_extras_clientes');
          }
          break;
        case 'capturar_datos_facturacion':
          try {
            $this->capturar_datos_facturacion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_datos_facturacion');
          }
          break;
        case 'mover_clasificacion_cliente':
          try {
            $this->mover_clasificacion_cliente($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'mover_clasificacion_cliente');
          }
          break;
        case 'sugerir_clasificacion_cliente':
          try {
            $this->sugerir_clasificacion_cliente($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'sugerir_clasificacion_cliente');
          }
          break;
        case 'vista_panel_ventas':
          try {
            $this->vista_panel_ventas($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'vista_panel_ventas');
          }
          break;
        case 'agregar_nueva_licencia':
          try {
            $this->agregar_nueva_licencia($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'agregar_nueva_licencia');
          }
          break;
        case 'eliminar_licencia':
          try {
            $this->eliminar_licencia($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'eliminar_licencia');
          }
          break;
        case 'update_status_facturacion_contacto':
          try {
            $this->update_status_facturacion_contacto($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'update_status_facturacion_contacto');
          }
          break;
        case 'update_status_encuesta':
          try {
            $this->update_status_encuesta($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'update_status_encuesta');
          }
          break;
        case 'solicitar_cancel_client':
          try {
            $this->solicitar_cancel_client($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'solicitar_cancel_client');
          }
          break;
        case 'cancelar_solicitud_cancel_client':
          try {
            $this->cancelar_solicitud_cancel_client($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'cancelar_solicitud_cancel_client');
          }
          break;
        case 'get_contactos_cliente_by_id':
          try {
            $this->get_contactos_cliente_by_id($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'get_contactos_cliente_by_id');
          }
          break;
      }
    }
  }

  private function new_client($datos)
  {
    global $user;
    $t_c = 1;
    if ($datos->tipo_cliente == 5) {
      $t_c = 3;
    }
    $capturar_cliente = db_insert('partners_clientes')
      ->fields(array(
        'created_by' => $user->uid,
        'created_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'areas_cliente' => $datos->areas,
        'tipo_cliente' => $t_c,
        'email' => $datos->cliente_correo,
        'tipo_negocio' => $datos->tipo_cliente,
        'relacionado' => $datos->cliente_relacionado,
        'nombre_cliente' => $datos->cliente_nombre,
        'nombre_facturacion' => $datos->cliente_facturacion,
        'alias' => $datos->cliente_alias,
        'giro_empresa' => $datos->cliente_giro,
        'como_se_entero' => (isset($datos->radio_como_se_entero) && $datos->radio_como_se_entero != '') ? $datos->radio_como_se_entero : null,
        'descripcion_otro' => (isset($datos->se_entero_otro) && $datos->se_entero_otro != '') ? $datos->se_entero_otro : null,
        'compra_servicio' => $datos->cliente_compro,
        'tipo_clasificacion' => 'c', // Todos los nuevos entran con C, y aparte se sugiere clasificación
        'credito' => 2, // Para que todos los usuarios nuevos entren con crédito = anticipado
        'pagina_web' => $datos->cliente_pagina,
      ))
      ->execute();

    $datos_c = $datos->datos;
    foreach ($datos_c as $dato_c) {
      $capturar_dc = db_insert('partners_clientes_datos')
        ->fields(array(
          'id_cliente' => $capturar_cliente,
          'tipo_dato' => $dato_c->tipo,
          'dato_valor' => $dato_c->valor
        ))
        ->execute();
    }


    // Sugerir clasificación
    $data = [];
    $data['id_cliente'] = $capturar_cliente;
    $data['current_clasificacion'] = 'c';
    if ($datos->cliente_nuevo == 2) {
      # Si es cliente no nuevo, entonces si sugerir clasificación
      $data['new_clasificacion'] = $datos->sugerir_clasificacion_cliente;
      $data['motivo_clasificacion'] = $datos->motivo_sugerir_clasificacion;
      $data['dont_throw_message'] = true;
      $a = (object)$data;
      $this->sugerir_clasificacion_cliente($a);
    }


    // Dar de alta el correo en MailRelay
    if (($datos->tipo_cliente == 2 || $datos->tipo_cliente == 4) && isset($datos->cliente_correo)) {

      $hostname = 'https://pcpartners.ip-zone.com/ccm/admin/api/version/2/&type=json';
      $apiKey = 'McKtJV4SQsyRGB2wDgKS2nvNyJHXEBDReOAnk451';
      $curl = curl_init($hostname);

      $postData = array(
        'function' => 'addSubscriber',
        'apiKey' => $apiKey,
        'email' => $datos->cliente_correo,
        'groups' => [4] // Grupo Boletin
      );

      curl_setopt($curl, CURLOPT_POST, true);
      curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($postData));
      curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

      $json = curl_exec($curl);
      $result = json_decode($json);

      if ($result->status != 0) {
        $this->register_log_actions('partners_clientes', 'insert', 'Se dió de alta el email: ' . $datos->cliente_correo . ' en Mailrelay porque se capturó un contacto.');
      }
    }


    $this->register_log_actions('partners_clientes', 'insert', 'Cliente ' . $datos->cliente_nombre . '(' . $capturar_cliente . ')' . ' creado');
    $this->throw_message('success', 'Cliente <b>' . $datos->cliente_nombre . '</b> creado, <a href="#" class="vista_cliente" data-id="' . $capturar_cliente . '">Ver:</a>');

  }

  /**
   * Sugiere que se modifique la clasificación de un Cliente, pidiendo a cual clasificación se desea mover y por que
   * motivo. Deja el comentario en la bitácora interna del cliente, y aparte envia un correo.
   * @param $datos
   * @throws Exception
   */
  private function sugerir_clasificacion_cliente($datos)
  {
    global $user;

    $text_bitacora = $user->name . ' sugiere que se cambie la clasificación de este cliente de: ' . strtoupper($datos->current_clasificacion) . ' a: ' . strtoupper($datos->new_clasificacion) . ' por el motivo: ' . $datos->motivo_clasificacion;
    db_update('partners_clientes')
      ->fields(array(
        'observaciones_internas' => $this->serialize_obs($text_bitacora, 2, 'partners_clientes', 'id_cliente', $datos->id_cliente, NULL, 'observaciones_internas')
      ))
      ->condition('id_cliente', $datos->id_cliente)
      ->execute();


    # Capturar la sugerencia
    db_insert('partners_clientes_sugerencias_reclasificacion')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'id_cliente' => $datos->id_cliente,
        'clasificacion_from' => strtoupper($datos->current_clasificacion),
        'clasificacion_to' => strtoupper($datos->new_clasificacion),
        'motivo_sugerencia' => $datos->motivo_clasificacion
      ))
      ->execute();

    $this->register_log_actions('partners_clientes_sugerencias_reclasificacion', 'insert', 'Se capturó una solicitud de reclasificacion: ' . $text_bitacora);

    $get_n_cliente = db_select('partners_clientes', 'pc');
    $get_n_cliente->fields('pc', array('nombre_cliente'));
    $get_n_cliente->condition('id_cliente', $datos->id_cliente);
    $nombre_cliente = $get_n_cliente->execute()->fetchField();

    $from = [$user->mail => 'Pc Partners - Solicitud de Re-Clasificación'];
    $to = ['roberto@pcpartners.com.mx', 'administracion@pcpartners.com.mx'];
    $subject = 'Solicitud de Reclasificación';
    $data['nombre_cliente'] = $nombre_cliente;
    $data['id_cliente'] = $datos->id_cliente;
    $data['texto_bitacora'] = $text_bitacora;
    // Enviar correos
    $this->send_mail('clientes.mail_solicitud_reclasificacion', $data, $subject, $from, $to);

    if (!isset($datos->dont_throw_message)) {
      $this->throw_message('success', 'Solicitud de reclasificación enviada correctamente.');
    }
  }

  private function new_contact($datos)
  {
    global $user;
    $tipo_clasificacion = db_select('partners_clientes', 'pc')
      ->fields('pc', array('tipo_clasificacion'))
      ->condition('id_cliente', $datos->id_padre)
      ->execute()->fetchField();
    $capturar_contacto = db_insert('partners_clientes')
      ->fields(array(
        'created_by' => $user->uid,
        'created_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'tipo_cliente' => 2,
        'id_padre' => $datos->id_padre,
        'notas_contacto' => $datos->contacto_notas,
        'puesto_contacto' => $datos->contacto_puesto,
        'email' => $datos->cliente_correo,
        'nombre_cliente' => $datos->contacto_nombre,
        'tipo_clasificacion' => $tipo_clasificacion,
        'promociones' => $datos->radio_contacto_promociones,
        'particular_sucursal' => $datos->radio_tipo_contacto
      ))
      ->execute();

    $datos_c = $datos->datos;
    foreach ($datos_c as $dato_c) {
      $capturar_dc = db_insert('partners_clientes_datos')
        ->fields(array(
          'id_cliente' => $capturar_contacto,
          'tipo_dato' => $dato_c->tipo,
          'dato_valor' => $dato_c->valor
        ))
        ->execute();
    }


    // Dar de alta el correo en MailRelay
    $hostname = 'https://pcpartners.ip-zone.com/ccm/admin/api/version/2/&type=json';
    $apiKey = 'McKtJV4SQsyRGB2wDgKS2nvNyJHXEBDReOAnk451';
    $curl = curl_init($hostname);

    $postData = array(
      'function' => 'addSubscriber',
      'apiKey' => $apiKey,
      'email' => $datos->cliente_correo,
      'groups' => [4] // Grupo Boletin
    );

    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

    $json = curl_exec($curl);
    $result = json_decode($json);

    if ($result->status != 0) {
      $this->register_log_actions('partners_clientes', 'insert', 'Se dió de alta el email: ' . $datos->cliente_correo . ' en Mailrelay porque se capturó un contacto.');
    }

    $this->register_log_actions('partners_clientes', 'insert', 'Contacto ' . $datos->contacto_nombre . '(' . $capturar_contacto . ')' . ' creado');
    $this->throw_message('success', 'Contacto <b>' . $datos->contacto_nombre . '</b> creado, <a href="#" class="vista_contacto" data-id="' . $capturar_contacto . '">Ver:</a>');
  }

  private function cancel_client($id_cliente)
  {
    global $user;
    $cancel = db_update('partners_clientes')
      ->fields(array(
        'cancelado' => 1,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid
      ))
      ->condition('id_cliente', $id_cliente)
      ->execute();


    $this->register_log_actions('partners_clientes', 'update', 'Se canceló el cliente ' . $id_cliente);
    $this->throw_message('success', 'Good');

  }

  private function reactivate_client($id_cliente)
  {
    $cancel = db_update('partners_clientes')
      ->fields(array(
        'cancelado' => 0
      ))
      ->condition('id_cliente', $id_cliente)
      ->execute();


    $this->register_log_actions('partners_clientes', 'update', 'Se reactivó el cliente ' . $id_cliente);
    $this->throw_message('success', 'Good');
  }

  /**
   * @param $datos ->type 1:Vista, 2:Capturar
   */
  private function clientes_encuesta($datos)
  {
    global $user;
    if ($datos->type == 1) {
      $nombre_cliente = db_select('partners_clientes', 'pc')
        ->fields('pc', array('nombre_cliente'))
        ->condition('id_cliente', $datos->id_cliente)
        ->execute()->fetchField();
      $data['id_cliente'] = $datos->id_cliente;
      $data['nombre_cliente'] = $nombre_cliente;
      $template = render_template('php', 'clientes.capturar_encuesta', $data);
      $this->throw_message('success', $template);
    } else if ($datos->type == 2) {
      $encuesta = db_insert('partners_clientes_encuestas')
        ->fields(array(
          'created_at' => REQUEST_TIME,
          'created_by' => $user->uid,
          'id_cliente' => $datos->id_cliente,
          'empleados' => $datos->numero_empleados,
          'computadoras' => $datos->numero_computadoras,
          'proveedor_tecnico' => $datos->radio_proveedor_tecnico,
          'detalle_proveedor_tecnico' => $datos->detalle_proveedor_tecnico,
          'sucursales' => $datos->radio_sucursales,
          'detalle_sucursales' => $datos->detalle_sucursales,
          'detalle_impresoras' => $datos->detalle_impresoras,
          'servidor' => $datos->radio_servidor,
          'detalle_servidor' => $datos->detalle_servidor,
          'conmutador' => $datos->radio_conmutador,
          'detalle_conmutador' => $datos->detalle_conmutador,
          'punto_venta' => $datos->radio_punto_venta,
          'detalle_punto_venta' => $datos->detalle_punto_venta,
          'checador' => $datos->radio_checador,
          'detalle_checador' => $datos->detalle_checador,
          'camaras' => $datos->radio_camaras,
          'detalle_camaras' => $datos->detalle_camaras,
          'pagina_web' => $datos->radio_pagina_web,
          'detalle_pagina_web' => $datos->detalle_pagina_web,
          'correos' => $datos->radio_correos,
          'detalle_correos' => $datos->detalle_correos,
          'detalle_factura_electronica' => $datos->detalle_factura_electronica,
          'detalle_contabilidad' => $datos->detalle_contabilidad,
          'antivirus' => $datos->radio_antivirus,
          'detalle_antivirus' => $datos->detalle_antivirus,
          'respaldos' => $datos->radio_respaldos,
          'detalle_respaldos' => $datos->detalle_respaldos,
          'mantenimientos' => $datos->radio_mantenimientos,
          'detalle_mantenimientos' => $datos->detalle_mantenimientos,
          'areas_interes' => $datos->areas,
          'detalle_interes' => $datos->detalle_interes
        ))
        ->execute();

      db_update('partners_clientes')
        ->fields(array(
          'encuesta' => $encuesta
        ))
        ->condition('id_cliente', $datos->id_cliente)
        ->execute();
      $this->register_log_actions('partners_clientes_encuestas', 'insert', 'Se capturó la encuesta al cliente: ' . $datos->id_cliente);
      $this->throw_message('success', 'Encuesta creada correctamente.');
    }

  }

  private function clientes_vista_encuesta($datos)
  {
    $query_encuesta = db_select('partners_clientes_encuestas', 'pce');
    $query_encuesta->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pce.id_cliente');
    $query_encuesta->fields('pce');
    $query_encuesta->fields('pc', array('nombre_cliente'));
    $query_encuesta->condition('pce.id_encuesta', $datos->id_encuesta);
    $encuesta = $query_encuesta->execute()->fetchAssoc();

    /**
     * Areas de Cliente
     */
    $areas = db_select('partners_areas', 'pa')
      ->fields('pa')
      ->execute()->fetchAll(PDO::FETCH_ASSOC);
    $a = array();
    foreach ($areas as $area) {
      if (strpos($encuesta['areas_interes'], $area['id_area']) !== false) {
        array_push($a, array(
          'id_area' => $area['id_area'],
          'found' => 1,
          'area' => $area['area']
        ));
      } else {
        array_push($a, array(
          'id_area' => $area['id_area'],
          'found' => 0,
          'area' => $area['area']
        ));
      }
    }
    $data['encuesta'] = $encuesta;
    $data['areas'] = $a;
    $data['created_by'] = user_load($encuesta['created_by'])->name;
    $template = render_template('php', 'clientes.vista_encuesta', $data);
    $this->throw_message('success', $template);
  }

  /**
   * @param $datos ,
   * Función utilizada para modificar el correo del cliente en la tabla de partners_clientes al momento de editar
   */
  private function modificar_correo_edicion($datos)
  {
    $id_cliente = db_select('partners_clientes_datos', 'pcd')
      ->fields('pcd', array('id_cliente'))
      ->condition('id_dato', $datos->edit_id)
      ->execute()->fetchField();
    db_update('partners_clientes')
      ->fields(array(
        'email' => $datos->new_val
      ))
      ->condition('id_cliente', $id_cliente)
      ->execute();
    $this->throw_message('success', '');
  }

  /**
   * @param $datos ->type 1:Capturar, 2:Eliminar
   * @throws Exception
   */
  private function datos_extras_clientes($datos)
  {
    if ($datos->type == 1) {
      db_insert('partners_clientes_datos')
        ->fields(array(
          'id_cliente' => $datos->id_cliente,
          'tipo_dato' => $datos->tipo_dato,
          'dato_valor' => $datos->new_val
        ))
        ->execute();
      $this->throw_message('success', 'Dato extra agregado.');
    } else {
      db_delete('partners_clientes_datos')
        ->condition('id_dato', $datos->id_dato)
        ->execute();
      $this->throw_message('success', 'Dato extra eliminado.');
    }
    $this->register_log_actions('partners_clientes_datos', 'update', 'Se modificaros los datos extras del id_cliente: ' . $datos->id_cliente);
  }

  /**
   * Captura por grupos de rfc y nombre de facturación.
   * @param $datos
   */
  private function capturar_datos_facturacion($datos)
  {
    if ($datos->nuevos_datos) {
      foreach ($datos->nuevos_datos as $dato) {
        if ($dato->dato_nuevo == true) {
          db_insert('partners_clientes_datos_facturacion')
            ->fields(array(
              'id_cliente' => $datos->id_cliente,
              'nombre_facturacion' => $dato->nombre_facturacion,
              'rfc' => $dato->rfc
            ))
            ->execute();
        } else {
          db_update('partners_clientes_datos_facturacion')
            ->fields(array(
              'nombre_facturacion' => $dato->nombre_facturacion,
              'rfc' => $dato->rfc
            ))
            ->condition('id_dato', $dato->id_dato)
            ->execute();
        }
      }
    }

    if ($datos->deleted_datos) {
      foreach ($datos->deleted_datos as $dato) {
        db_delete('partners_clientes_datos_facturacion')
          ->condition('id_dato', $dato)
          ->execute();
      }
    }
    $this->throw_message('success', 'Datos de facturación guardados.');
  }

  /**
   * Recibe un objeto con los datos sobre la modificación, después de realizar la modificación, deberá guardar registro
   * en la bitácora de clasificación
   * @param $datos
   */
  private function mover_clasificacion_cliente($datos)
  {
    global $user;

    $text_bitacora = 'Cambió de la clasificación ' . strtoupper($datos->current_clasificacion) . ' a ' . strtoupper($datos->new_clasificacion) . ' por el motivo: ' . $datos->motivo_clasificacion;
    $new_credito = '';
    if ($datos->new_clasificacion == 'a') {
      $new_credito = 1;
    } else if ($datos->new_clasificacion == 'b') {
      $new_credito = 0;
    } else if ($datos->new_clasificacion == 'c' || $datos->new_clasificacion == 'd' || $datos->new_clasificacion == 'e') {
      $new_credito = 2;
    }

    db_update('partners_clientes')
      ->fields(array(
        'updated_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'tipo_clasificacion' => $datos->new_clasificacion,
        'credito' => $new_credito,
        'observaciones_internas' => $this->serialize_obs($text_bitacora, 2, 'partners_clientes', 'id_cliente', $datos->id_cliente, NULL, 'observaciones_internas')
      ))
      ->condition('id_cliente', $datos->id_cliente)
      ->execute();

    $this->throw_message('success', 'Clasificación actualizada correctamente.');
  }

  private function vista_panel_ventas($id_cliente)
  {
    // Generar Tabla cotizaciones
    $get_cot = db_select('partners_cotizaciones', 'pc');
    $get_cot->fields('pc', array('id_cotizacion', 'created_at', 'created_by'), 'cotizacion_compartida');
    $get_cot->leftJoin('partners_cotizaciones_datos', 'pcd', 'pcd.id_cotizacion = pc.id_cotizacion');
    $get_cot->addExpression('SUM(pcd.cantidad * pcd.precio)', 'subtotal');
    $get_cot->addExpression("GROUP_CONCAT(pcd.descripcion SEPARATOR '|')", 'desc_cotizacion');
    $get_cot->condition('pc.cotizacion_eliminada', 1, '!=');
    $get_cot->condition('pc.id_cliente', $id_cliente);
    $get_cot->orderBy('id_cotizacion', 'DESC');
    $get_cot->groupBy('pc.id_cotizacion');

    $cotizaciones = [];
    $query_datos = $get_cot->execute();
    while ($row = $query_datos->fetchAssoc()) {
      $folio = array("data" => $row['id_cotizacion'], "class" => array("cursor-pointer", "vista_cotizacion_panel_ventas"));
      $fecha = array("data" => date('d/m/y', $row['created_at']), "class" => array("cursor-pointer", "vista_cotizacion_panel_ventas"));
      $usuario = array("data" => user_load($row['created_by'])->name, "class" => array("cursor-pointer", "vista_cotizacion_panel_ventas"));
      $desc = array("data" => mb_substr($row['desc_cotizacion'], 0, 50, "utf-8"), "class" => array("cursor-pointer", "vista_cotizacion_panel_ventas"));
      $precio = array("data" => number_format($row['subtotal'], 2, '.', ','), "class" => array("cursor-pointer", "vista_cotizacion_panel_ventas", "text-right"));
      $cotizaciones[] = array(
        "data" => array(
          $folio,
          $fecha,
          $usuario,
          $desc,
          $precio
        ),
        "data-id-cotizacion" => $row['id_cotizacion']
      );
    }


    // Header -- Sort
    $header_cols = array(
      array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
      array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Total", "class" => "filter-number"), "sortable" => 0),
    );

    $header = sys_tools::sort_table('id_cotizacion', 'DESC', $header_cols);

    $table = array(
      "header" => $header,
      "rows" => $cotizaciones,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_cotizaciones", "class" => array("table-sm"))
    );


    $table_cotizaciones = theme('table', $table);

    // Generar Tabla de Renovaciones
    $query = db_select('partners_renovaciones', 'pr');
    $query->innerJoin('taxonomy_term_data', 'pt', 'pt.tid = pr.id_tipo');
    $query->fields('pr');
    $query->addField('pt', 'name', 'nombre_tipo_renovacion');
    $query->condition('pr.renovacion_eliminada', '1', '!=');
    $query->condition('pr.fecha_renovacion', array(strtotime('first day of january this year'), (strtotime('last day of december this year') + 86340)), 'BETWEEN');
    $query->condition('pr.id_cliente', $id_cliente);
    $query->condition('pr.id_tipo', [135, 136], 'IN'); // Solo los dos que pertenecen a ventas
    $query->orderBy('fecha_renovacion', 'DESC');
    $query->condition('pr.renovacion_eliminada', '1', '!=');

    $query_datos_r = $query->execute();

    $renovaciones = [];
    while ($row = $query_datos_r->fetchAssoc()) {
      $fecha_r = date('d/m/y', $row['fecha_renovacion']);
      $tipo_renovacion = $row['nombre_tipo_renovacion'];
      $producto = $row['producto_servicio'];
      $precio = array("data" => number_format($row['precio'], 2, '.', ','), "class" => array("text-right"));

      $renovaciones[] = array(
        "data" => array(
          $fecha_r,
          $tipo_renovacion,
          $producto,
          $precio
        ),
        "data-id-renovacion" => $row['id_renovacion']
      );

    }

    $header_renovaciones_cols = array(
      array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
      array("name" => array("data" => "Tipo", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Producto", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Precio", "class" => "filter-number text-right"), "sortable" => 0)
    );

    $header_renovaciones = sys_tools::sort_table('fecha_renovacion', 'ASC', $header_renovaciones_cols);
    $table_renovaciones = array(
      "header" => $header_renovaciones,
      "rows" => $renovaciones,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_renovaciones", "class" => array("table-sm"))
    );
    $result_renovaciones = theme('table', $table_renovaciones);


    // Generar Tabla Licencias
    $get_lic = db_select('partners_clientes_licencias', 'pclt');
    $get_lic->fields('pclt');
    $get_lic->condition('id_cliente', $id_cliente);
    $get_lic->orderBy('id_licencia', 'DESC');
    $query_lic = $get_lic->execute();

    $licencias = [];
    while ($row = $query_lic->fetchAssoc()) {
      $fecha_l = date('d/m/y', $row['fecha_compra_licencia']);
      $licencia = $row['producto'];
      $serie_licencia = $row['serie_licencia'];
      $eliminar = array("data" => '<i class="fas fa-trash"></i>', "class" => array("text-center", "eliminar_licencia", "text-danger", "cursor-pointer"));
      $obs = array("data" => "Obs", "class" => array("observaciones_licencia", ($row['observaciones']) ? "status-yellow" : "", "cursor-pointer", "text-center"));
      $licencias[] = array(
        "data" => array(
          $fecha_l,
          $licencia,
          $serie_licencia,
          $obs,
          $eliminar
        ),
        "data-id-licencia" => $row['id_licencia'],
        "data-id-cliente" => $row['id_cliente']
      );
    }
    $header_lic_cols = array(
      array("name" => array("data" => "Fecha Compra", "class" => "filter-date"), "sortable" => 0),
      array("name" => array("data" => "Producto", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Serie", "class" => "filter-text"), "sortable" => 0),
      array("name" => array("data" => "Obs", "class" => "filter-text text-center"), "sortable" => 0),
      array("name" => array("data" => '<i class="fas fa-trash"></i>', "class" => "filter-text text-center"), "sortable" => 0),
    );

    $header_lic = sys_tools::sort_table('id_licencia', 'DESC', $header_lic_cols);
    $table_lic = array(
      "header" => $header_lic,
      "rows" => $licencias,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_licencias", "class" => array("table-sm"))
    );
    $result_lic = theme('table', $table_lic);


    // Datos de Cliente
    $query_c = db_select('partners_clientes', 'pc');
    $query_c->fields('pc');
    $query_c->addExpression("CASE pc.tipo_cliente WHEN 1 THEN 'Cliente' WHEN 2 THEN 'Contacto' WHEN 3 THEN 'Proveedor' END ", 'tipo_cliente');
    $query_c->addExpression("CASE pc.tipo_negocio WHEN 1 THEN 'Negocio' WHEN 2 THEN 'Particular' WHEN 3 THEN 'Distribuidor' WHEN 4 THEN 'Prospecto' WHEN 5 THEN 'Proveedor' END ", 'negocio');
    $query_c->condition('id_cliente', $id_cliente);
    $cliente = $query_c->execute()->fetchAssoc();

    $query_d = db_select('partners_clientes_datos', 'pcd');
    $query_d->fields('pcd');
    $query_d->condition('id_cliente', $id_cliente);
    $query_d->orderBy('FIELD(pcd.tipo_dato,1,11,2,12,3,13,5,6,7,8,9,10)');
    $cliente_datos = $query_d->execute()->fetchAll(PDO::FETCH_ASSOC);

    $query_datos_facturacion = db_select('partners_clientes_datos_facturacion', 'pcdf');
    $query_datos_facturacion->fields('pcdf');
    $query_datos_facturacion->condition('id_cliente', $id_cliente);
    $datos_facturacion = $query_datos_facturacion->execute()->fetchAll(PDO::FETCH_ASSOC);

    // Data Template
    $data['id_cliente'] = $id_cliente;
    $data['table_cotizaciones'] = (empty($cotizaciones)) ? '<p class="lead text-danger">El Cliente no cuenta con ninguna cotización.</p>' : $table_cotizaciones;
    $data['table_renovaciones'] = (empty($renovaciones)) ? '<p class="lead text-danger">El Cliente no cuenta con ninguna renovación en este año.</p>' : $result_renovaciones;
    $data['table_licencias'] = (empty($licencias)) ? '<p class="lead text-danger">El Cliente no cuenta con ninguna licencia.</p>' : $result_lic;
    $data['cliente'] = $cliente;
    $data['cliente_datos'] = $cliente_datos;
    $data['cliente_facturacion'] = $datos_facturacion;

    $tpl = render_template('php', 'clientes.vista_panel_ventas', $data);
    $this->throw_message('success', $tpl);
  }

  /**
   * Agrega una nueva licencia relacionada con el cliente, aparecerá en el panel de Ventas del Cliente
   * @param $datos
   * @throws Exception
   */
  private function agregar_nueva_licencia($datos)
  {
    global $user;

    $bitacora = null;
    if (trim($datos->observaciones_licencia) != '') {
      $bitacora = $this->serialize_obs($datos->observaciones_licencia, 1);
    }
    $id_licencia = db_insert('partners_clientes_licencias')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'id_cliente' => $datos->id_cliente,
        'fecha_compra_licencia' => strtotime($datos->fecha_compra),
        'producto' => $datos->producto,
        'serie_licencia' => $datos->serie_licencia,
        'observaciones' => $bitacora
      ))
      ->execute();

    // Actualizar la tabla de clientes con has_licencia = 1, este campo será utilizado después
    // debido a un filtrado, y se hace de esta manera para hacer la consulta de clientes más eficiente y no tener que
    // hacer una consulta en cada cliente para ir a verificar a la otra tabla de licencias a ver si tiene alguna licencia.
    // De esta manera ya no se tendrá que hacer una consulta extra por cada cliente, porque lo estaría guardando en la tabla de clientes
    // y no en otra tabla diferente.
    db_update('partners_clientes')
      ->fields(array(
        'has_licencia' => 1
      ))
      ->condition('id_cliente', $datos->id_cliente)
      ->execute();

    $this->register_log_actions('partners_clientes_licencias', 'insert', "Se capturó una nueva licencia ($id_licencia) al cliente: $datos->id_cliente ");
    $this->throw_message('success', "Bien, Licencia agregada correctamente.");
  }

  /**
   * Elimina una licencia de un Cliente.
   * @param $datos
   * @throws Exception
   */
  private function eliminar_licencia($datos)
  {
    db_delete('partners_clientes_licencias')
      ->condition('id_licencia', $datos->id_licencia)
      ->execute();

    // Deberá de verificar si aún existen licencias con este cliente, en caso de que si existan licencias todavía
    // no pasa nada, pero si ya no existen licencias, deberá de actualizar la tabla de clientes con has_licecia = 0
    $get = db_select('partners_clientes_licencias', 'pc');
    $get->fields('pc', array('id_licencia'));
    $get->condition('id_cliente', $datos->id_cliente);
    $validate = $get->execute()->rowCount();

    if ($validate == 0) {
      db_update('partners_clientes')
        ->fields(array(
          'has_licencia' => 0
        ))
        ->condition('id_cliente', $datos->id_cliente)
        ->execute();
    }

    $this->register_log_actions('partners_clientes_licencias', 'delete', "Se eliminó una licencia ($datos->id_licencia) del cliente: $datos->id_cliente ");
    $this->throw_message('success', "Bien, Licencia eliminada correctamente.");
  }

  /**
   * Marca a desmarca un contacto como contacto de facturación
   * @param $datos
   */
  private function update_status_facturacion_contacto($datos)
  {
    db_update('partners_clientes')
      ->fields(array(
        'contacto_facturacion' => $datos->statusFacturacion
      ))
      ->condition('id_cliente', $datos->idContacto)
      ->execute();
    $this->throw_message('success', 'Estatus cambiado correctamente.');
  }

  /**
   * Método para cambiar el estatus de la encuesta
   * @param $datos
   */
  private function update_status_encuesta($datos)
  {
    db_update('partners_clientes')
      ->fields(array(
        'encuesta' => $datos->newVal
      ))
      ->condition('id_cliente', $datos->idCliente)
      ->execute();
    $this->throw_message('success', 'Estatus cambiado correctamente.');
  }

  /**
   * Método para solicitar que se cancele un cliente, lo deja marcado para que sea eliminado después por un administrador.
   * @param $idCliente
   * @throws Exception
   */
  private function solicitar_cancel_client($idCliente)
  {
    global $user;
    db_update('partners_clientes')
      ->fields(array(
        'solicitar_cancelacion' => 1,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid
      ))
      ->condition('id_cliente', $idCliente)
      ->execute();


    $this->register_log_actions('partners_clientes', 'update', 'Se solicitó la cancelación del cliente ' . $idCliente);
    $this->throw_message('success', 'Se ha solicitado la eliminación del cliente.');
  }

  /**
   * @param $idCliente
   * @throws Exception
   */
  private function cancelar_solicitud_cancel_client($idCliente)
  {
    global $user;
    db_update('partners_clientes')
      ->fields(array(
        'solicitar_cancelacion' => 0,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid
      ))
      ->condition('id_cliente', $idCliente)
      ->execute();


    $this->register_log_actions('partners_clientes', 'update', 'Se ha cancelado la solicitud para eliminar el cliente: ' . $idCliente);
    $this->throw_message('success', 'Se ha cancelado la solicitud para eliminar el cliente.');
  }





  /**
   * @param int $id_cliente id a buscar información
   * @return mixed array de datos del cliente listos para renderizar
   * @notes se hace public static para poder regresar info y poder renderizarla despues,
   * las demas que son updates o inserts si van private
   */
  public static function vista_cliente($id_cliente)
  {
    $query_c = db_select('partners_clientes', 'pc');
    $query_c->fields('pc');
    $query_c->addExpression("CASE pc.tipo_cliente WHEN 1 THEN 'Cliente' WHEN 2 THEN 'Contacto' WHEN 3 THEN 'Proveedor' END ", 'tipo_cliente');
    $query_c->addExpression("CASE pc.tipo_negocio WHEN 1 THEN 'Negocio' WHEN 2 THEN 'Particular' WHEN 3 THEN 'Distribuidor' WHEN 4 THEN 'Prospecto' WHEN 5 THEN 'Proveedor' END ", 'negocio');
    $query_c->condition('id_cliente', $id_cliente);
    $cliente = $query_c->execute()->fetchAssoc();


    /**
     * Created / Updated
     */
    $user_create = db_select('users', 'u')
      ->fields('u', array('name'))
      ->condition('uid', $cliente['created_by'])
      ->execute()->fetchField();

    $user_updated = db_select('users', 'u')
      ->fields('u', array('name'))
      ->condition('uid', $cliente['updated_by'])
      ->execute()->fetchField();

    if ($cliente['cancelado'] != 1) {
      //Si aun no se ha editado, ni mostrar el de ultima vez editado por...
      if ($cliente['created_at'] == $cliente['updated_at']) {
        $created_updated = 'Creado por <b>' . $user_create . '</b> el ' . date('d-m-Y', $cliente['created_at']) . ' a las ' . date('H:i', $cliente['created_at']);
      } else {
        $created_updated = 'Creado por <b>' . $user_create . '</b> el ' . date('d-m-Y', $cliente['created_at']) . ' a las ' . date('H:i', $cliente['created_at']) . ' | Modificado última vez por <b>' . $user_updated . '</b> el ' . date('d-m-Y', $cliente['updated_at']) . ' a las ' . date('H:i', $cliente['updated_at']);
      }
    } else {
      $created_updated = 'Creado por <b>' . $user_create . '</b> el ' . date('d-m-Y', $cliente['created_at']) . ' a las ' . date('H:i', $cliente['created_at']) . ' | Cancelado por <b>' . $user_updated . '</b> el ' . date('d-m-Y', $cliente['updated_at']) . ' a las ' . date('H:i', $cliente['updated_at']);
    }

    $query_d = db_select('partners_clientes_datos', 'pcd');
    $query_d->fields('pcd');
    $query_d->condition('id_cliente', $id_cliente);
    $query_d->orderBy('FIELD(pcd.tipo_dato,1,11,2,12,3,13,5,6,7,8,9,10)');
    $cliente_datos = $query_d->execute()->fetchAll(PDO::FETCH_ASSOC);

    $query_datos_facturacion = db_select('partners_clientes_datos_facturacion', 'pcdf');
    $query_datos_facturacion->fields('pcdf');
    $query_datos_facturacion->condition('id_cliente', $id_cliente);
    $datos_facturacion = $query_datos_facturacion->execute()->fetchAll(PDO::FETCH_ASSOC);

    /**
     * Contactos
     */
    $contactos = db_select('partners_clientes', 'pc')
      ->fields('pc', array('id_cliente', 'nombre_cliente', 'id_padre', 'puesto_contacto', 'contacto_facturacion'))
      ->condition('id_padre', $id_cliente)
      ->condition('cancelado', 1, '!=')
      ->execute()->fetchAll(PDO::FETCH_ASSOC);


    /**
     * Areas de Cliente
     */
    $areas = db_select('partners_areas', 'pa')
      ->fields('pa')
      ->execute()->fetchAll(PDO::FETCH_ASSOC);
    $a = array();
    $found = array();
    $found_text = array();
    foreach ($areas as $area) {
      if (strpos($cliente['areas_cliente'], $area['id_area']) !== false) {
        array_push($a, array(
          'id_area' => $area['id_area'],
          'found' => 1,
          'area' => $area['area']
        ));
        array_push($found, $area['id_area']);
        array_push($found_text, $area['area']);
      } else {
        array_push($a, array(
          'id_area' => $area['id_area'],
          'found' => 0,
          'area' => $area['area']
        ));
      }
    }

    // User allowed
    $data['user_allowed'] = 0;
    if (user_access('clientes_administrador')) {
      $data['user_allowed'] = 1;
    }


    /**
     * Valores crédito
     */

    $credito = "";
    if ($cliente['credito'] == 0) {
      $credito = "Contado";
    } elseif ($cliente['credito'] == 1) {
      $credito = "Crédito";
    } elseif ($cliente['credito'] == 2) {
      $credito = "Anticipado";
    }
    /**
     * Return data
     */
    $data['cliente'] = $cliente;
    $data['contactos'] = $contactos;
    $data['datos'] = $cliente_datos;
    $data['datos_facturacion'] = $datos_facturacion;
    $data['tipo'] = $cliente['tipo_negocio'];
    $data['created_updated'] = $created_updated;
    $data['areas'] = $a;
    $data['found_areas'] = implode(',', $found);
    $data['found_areas_text'] = implode(',', $found_text);
    $data['credito'] = $credito;
    return $data;

  }


  ///////////////////////////////////////////




  public static function vista_contacto($id_contacto)
  {
    $query_c = db_select('partners_clientes', 'pc');
    $query_c->fields('pc');
    $query_c->condition('id_cliente', $id_contacto);
    $contacto = $query_c->execute()->fetchAssoc();

    $cliente_padre = db_select('partners_clientes', 'pc')
      ->fields('pc', array('nombre_cliente', 'id_cliente'))
      ->condition('id_cliente', $contacto['id_padre'])
      ->execute()->fetchAssoc();

    /**
     * Created / Updated
     */
    $user_create = db_select('users', 'u')
      ->fields('u', array('name'))
      ->condition('uid', $contacto['created_by'])
      ->execute()->fetchField();

    $user_updated = db_select('users', 'u')
      ->fields('u', array('name'))
      ->condition('uid', $contacto['updated_by'])
      ->execute()->fetchField();

    if ($contacto['cancelado'] != 1) {
      //Si aun no se ha editado, ni mostrar el de ultima vez editado por...
      if ($contacto['created_at'] == $contacto['updated_at']) {
        $created_updated = 'Creado por <b>' . $user_create . '</b> el ' . date('d-m-Y', $contacto['created_at']) . ' a las ' . date('H:i', $contacto['created_at']);
      } else {
        $created_updated = 'Creado por <b>' . $user_create . '</b> el ' . date('d-m-Y', $contacto['created_at']) . ' a las ' . date('H:i', $contacto['created_at']) . ' | Modificado última vez por <b>' . $user_updated . '</b> el ' . date('d-m-Y', $contacto['updated_at']) . ' a las ' . date('H:i', $contacto['updated_at']);
      }
    } else {
      $created_updated = 'Creado por <b>' . $user_create . '</b> el ' . date('d-m-Y', $contacto['created_at']) . ' a las ' . date('H:i', $contacto['created_at']) . ' | Cancelado por <b>' . $user_updated . '</b> el ' . date('d-m-Y', $contacto['updated_at']) . ' a las ' . date('H:i', $contacto['updated_at']);
    }

    $query_d = db_select('partners_clientes_datos', 'pcd');
    $query_d->fields('pcd');
    $query_d->condition('id_cliente', $id_contacto);
    $query_d->orderBy('FIELD(pcd.tipo_dato,1,11,2,12,3,13,5,6,7,8,9,10)');
    $contacto_datos = $query_d->execute()->fetchAll(PDO::FETCH_ASSOC);


    /**
     * Return data
     */
    $data['contacto'] = $contacto;
    $data['cliente_padre'] = $cliente_padre;
    $data['datos'] = $contacto_datos;
    $data['created_updated'] = $created_updated;
    // User allowed
    $data['user_allowed'] = false;
    if (user_access('clientes_administrador')) {
      $data['user_allowed'] = true;
    }
    return $data;

  }

  /**
   * Conseguir contactos de un cliente
   *
   * @param stdClass $data
   */
  public function get_contactos_cliente_by_id($data)
  {
    try {
      $idCliente = $data->idCliente;
      if (!((int)$idCliente > 0)) {
        //Respuesta vacía
        $out = array(
          "idCliente" => 0,
          "contactos" => array()
        );
        //.
      } else {
        //Conseguir nombre del cliente
        $query = db_select('partners_clientes', 'pc');
        $query->fields('pc', array('nombre_cliente', 'email'));
        $query->condition('id_cliente', $idCliente);
        $query = $query->execute();
        $row = $query->fetchAssoc();
        $nombreCliente = $row['nombre_cliente'];
        $emailCliente = $row['email'];
        //.
        //Conseguir los contactos
        $getContactos = db_select('partners_clientes', 'pc');
        $getContactos->condition('id_padre', $idCliente);
        $getContactos->innerJoin('partners_clientes_datos', 'pcd', 'pc.id_cliente = pcd.id_cliente AND pcd.tipo_dato = 3');
        $getContactos->addField('pcd', 'dato_valor', 'email');
        $getContactos->addField('pc', 'nombre_cliente', 'nombreContacto');
        if (isset($data->condition->name)) {
          $getContactos->condition($data->condition->name, (string)$data->condition->value);
        }
        $contactos = array();
        if ($emailCliente != null && trim($emailCliente) != "") {
          $contactos[] = array(
            'nombreContacto' => $nombreCliente,
            'email' => $emailCliente,
          );
        }
        $contactos = array_merge($contactos, $getContactos->execute()->fetchAll(PDO::FETCH_ASSOC));
        //.
        //Preparar respuesta
        if (empty($contactos)) {
          $out = array(
            "idCliente" => $idCliente,
            "nombreCliente" => $nombreCliente,
            "contactos" => $contactos
          );
        } else {
          $out = array(
            "idCliente" => $idCliente,
            "nombreCliente" => $nombreCliente,
            "contactos" => $contactos
          );
        }
        //.
      }
      $this->throw_message('success', json_encode($out));
    } catch (Exception $e) {
      $this->throw_message('error', json_encode($e->getMessage()));
    }
  }
}
