<?php

class cctv_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'reporte_base':
                    try {
                        $this->reporte_base($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reporte_base');
                    }
                    break;
                case 'update_status':
                    try {
                        $this->update_status($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'update_status');
                    }
                    break;
                case 'eliminar_proyecto':
                    try {
                        $this->eliminar_proyecto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'eliminar_proyecto');
                    }
                    break;
                case 'reactivate_proyecto':
                    try {
                        $this->reactivate_proyecto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'reactivate_proyecto');
                    }
                    break;
                case 'vista_proyecto':
                    try {
                        $this->vista_proyecto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'vista_proyecto');
                    }
                    break;
                case 'modificacion_costos':
                    try {
                        $this->modificacion_costos($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'modificacion_costos');
                    }
                    break;
                case 'editar_proyecto':
                    try {
                        $this->editar_proyecto($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'editar_proyecto');
                    }
                    break;
                case 'render_proyecto_impreso':
                    try {
                        $this->render_proyecto_impreso($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'render_proyecto_impreso');
                    }
                    break;
                case 'crear_google_sheet':
                    try {
                        $this->crear_google_sheet($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'crear_google_sheet');
                    }
                    break;
                case 'sincronizar_google_sheet':
                    try {
                        $this->sincronizar_google_sheet($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'sincronizar_google_sheet');
                    }
                    break;
                case 'salida_merc_form':
                    try {
                        $this->salida_merc_form($data);
                    } catch(Exception $e) {
                        $this->throw_fatal_error($e, 'salida_merc_form');
                    }
                    break;
                case 'addMerc':
                    try {
                        $this->addMerc($data);
                    } catch(Exception $e) {
                        $this->throw_fatal_error($e, 'addMerc');
                    }
                    break;
                case 'deleteMerc':
                    try {
                        $this->deleteMerc($data);
                    } catch(Exception $e) {
                        $this->throw_fatal_error($e, 'deleteMerc');
                    }
                    break;
                 case 'marcar_finalizado':
                    try {
                        $this->marcar_finalizado($data);
                    } catch(Exception $e) {
                        $this->throw_fatal_error($e, 'marcar_finalizado');
                    }
                    break;
                 case 'nuevo_form':
                    try {
                        $this->nuevo_form($data);
                    } catch(Exception $e) {
                        $this->throw_fatal_error($e, 'nuevo_form');
                    }
                    break;
                case 'nuevo_proyecto':
                    try {
                        $this->nuevo_proyecto($data);
                    } catch(Exception $e) {
                        $this->throw_fatal_error($e, 'nuevo_proyecto');
                    }
                    break;
            }
        }
    }

    private function reporte_base($datos)
    {
        $fi = str_replace('/', '-', trim($datos->filter->start_date));
        $ff = str_replace('/', '-', trim($datos->filter->end_date));
        $f_inicio = strtotime($fi);
        $f_final = strtotime($ff) + 86040;

        $query = db_select('partners_cctv', 'pcctv');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pcctv.id_cliente');
        $query->fields('pcctv');
        $query->fields('pc', array('nombre_cliente'));
        $query->condition('pcctv.proyecto_eliminado', '1', '!=');

        // Filtros
        if ($f_inicio == $f_final) {
            $f_final_same_day = $f_inicio + 86040;
            if ($datos->filter->start_date) {
                $query->condition('pcctv.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
            }
        } else {
            if ($datos->filter->start_date) {
                $query->condition('pcctv.created_at', array($f_inicio, $f_final), 'BETWEEN');
            }
        }


        // Filtro - Search Bar
        if ($datos->filter->search_bar != null) {
            $on_products = db_select('partners_cctv_datos', 'pcd')
                ->fields('pcd', array('id_proyecto'))
                ->where('pcctv.id_proyecto = pcd.id_proyecto')
                ->condition('pcd.descripcion', '%' . $datos->filter->search_bar . '%', 'LIKE');

            $cctv_or = db_or()
                ->condition('pc.nombre_cliente', '%' . $datos->filter->search_bar . '%', 'LIKE')
                ->condition('pcctv.id_proyecto', $on_products, 'IN');
            $query->condition($cctv_or);
        }


        $query->orderBy($datos->sort->sort_by, $datos->sort->order);

        $query_datos = $query->execute();

        $cctv = [];
        while ($row = $query_datos->fetchAssoc()) {
            $folio = array("data" => $row['id_proyecto'], "class" => array("cursor-pointer", "vista_proyecto"));
            $fecha = array("data" => date('d/m/y', $row['created_at']), "class" => array("cursor-pointer", "vista_proyecto"));
            $usuario = array("data" => user_load($row['created_by'])->name, "class" => array("cursor-pointer", "vista_proyecto"));
            $cliente = array("data" => mb_substr($row['nombre_cliente'], 0, 20, "utf-8"), "class" => array("cursor-pointer", "vista_proyecto"));
            $descripcion = array("data" => mb_substr($this->get_description($row['id_proyecto']), 0, 60, "utf-8"), "class" => array("cursor-pointer", "vista_proyecto"));
            $precio = array("data" => number_format($this->calcular_precio_total($row['id_proyecto'], 1), 2, '.', ','), "class" => array("cursor-pointer", "vista_proyecto", "text-right"));
            $costo = array("data" => number_format($this->calcular_precio_total($row['id_proyecto'], 2), 2, '.', ','), "class" => array("text-right"));

            $utilidad = array("data" => number_format($this->calcular_precio_total($row['id_proyecto'], 1) - $this->calcular_precio_total($row['id_proyecto'], 2), 2, '.', ','), "class" => array("text-right"));
            // Observaciones | Notas internas
            if ($row['observaciones'] != null) {
                $observaciones = array("data" => 'Obs', "class" => array("status-yellow", "status_obs", "text-center", "cursor-pointer"));
            } else {
                $observaciones = array("data" => 'Obs', "class" => array("text-center", "status_obs", "cursor-pointer"));
            }

            // Pagado
            if ($row['pagado'] == 0) {
                $pagado = array("data" => "No", "class" => array((user_access("cctv_administrador") && $row['finalizado'] == 0) ? "status_facturado cursor-pointer" : "", "status-red", "text-center"));
            } else if ($row['pagado'] == 1) {
                $pagado = array("data" => "Pagado", "class" => array((user_access("cctv_administrador") && $row['finalizado'] == 0)? "status_facturado cursor-pointer" : "", "status-green", "text-center"));
            } else if ($row['pagado'] == 2) {
                $pagado = array("data" => "Factura", "class" => array((user_access("cctv_administrador") && $row['finalizado'] == 0)? "status_facturado cursor-pointer" : "", "status-green", "text-center"));
            }

            // Instalado
            $instalado = array("data" => ($row['instalado'] == 1 ? 'Si' : 'No'), "class" => array(($row['instalado'] == 1 ? 'status-green' : 'status-red'), (($row['finalizado'] == 0)?"status_instalado cursor-pointer":""), "text-center"));


            // Borrar
            $borrar = array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => array( (($row['finalizado'] == 0)?"eliminar_proyecto cursor-pointer":""), "text-center"));


            //  $numero_factura = array("data" => $this->get_numero_factura('partners_cctv', $row['id_proyecto']), "class" => array(($this->get_numero_factura('partners_cctv', $row['id_proyecto'])) ? "text-right cursor-pointer ver_factura" : ""));
            if ($this->get_numero_factura('partners_cctv', $row['id_proyecto'])) {
                if ($this->validate_factura_pagada($this->get_numero_factura('partners_cctv', $row['id_proyecto'])) == 0) {
                    $numero_factura = array("data" => $this->get_numero_factura('partners_cctv', $row['id_proyecto']), "class" => array("text-right cursor-pointer ver_factura status-green"));
                } else {
                    $numero_factura = array("data" => $this->get_numero_factura('partners_cctv', $row['id_proyecto']), "class" => array("text-right cursor-pointer ver_factura status-red"));
                }
            } else {
                $numero_factura = "";
            }

            // Excel Relacionado
            if ($row['google_sheet'] != null) {
                // Si ya está pagado el proyecto, significa que ya esta cerrado, por lo tanto ya no sincroziar el proyecto
                if ($row['pagado'] != 0) {
                    $google_sheet = array("data" => '<a href="' . $row['google_sheet'] . '" target="_blank>"><i class="fas fa-external-link-alt text-white"></i></a>', "class" => array("status-green", "text-center", "cursor-pointer"));
                } else { // Si aun no está pagado, sincronizar el proyecto en la hoja de calculo de google
                    $google_sheet = array("data" => '<i class="fas fa-external-link-alt text-white"></i>', "class" => array("status-green", "text-center", "cursor-pointer", "sincronizar_google_sheet"));
                }
            } else {
                $google_sheet = array("data" => '<i class="far fa-file-excel"></i>', "class" => array("text-center", "status_crear_sheet", "cursor-pointer"));
            }

            $mercancia = '<button class="btn btn-sm w-100 btn-success add-merch" style="padding: 0.1rem .5rem;"><i class="fas fa-box"></i></button>';

            if($row['finalizado']) {
                $finalizado = array("data" => '<i class="fas fa-check-circle fa-2x"></i>', "class" => "text-center text-success");
            } else {
                $finalizado = array("data" => '<i class="fas fa-circle fa-2x"></i>', "class" => "text-center text-danger");
            }

            if(user_has_role(user_role_load_by_name('Supervisor')->rid)){
                if($row['finalizado']) {
                    $finalizado = array("data" => '<i class="fas fa-check-circle fa-2x"></i>', "class" => "text-center text-success finalizado-btn cursor-pointer finalizado-status", "status" => "1");
                } else {
                    $finalizado = array("data" => '<i class="fas fa-circle fa-2x"></i>', "class" => "text-center text-danger finalizado-btn cursor-pointer finalizado-status", "status" => "0");
                }
            }

            if (user_access("cctv_administrador")) {
                if(user_has_role(user_role_load_by_name('Auxiliar')->rid)){
                    $cctv[] = array(
                        "data" => array(
                            $folio,
                            $fecha,
                            $usuario,
                            $cliente,
                            $descripcion,
                            $precio,
                            $costo,
                            $mercancia,
                            $instalado,
                            $pagado,
                            $numero_factura,
                            $observaciones,
                            $finalizado,
                            $google_sheet
                        ),
                        "data-id-proyecto" => $row['id_proyecto'],
                        "data-instalado" => $row['instalado'],
                        "data-sheet-id" => $row['google_sheet']
                    );
                } else {
                    $cctv[] = array(
                        "data" => array(
                            $folio,
                            $fecha,
                            $usuario,
                            $cliente,
                            $descripcion,
                            $precio,
                            $costo,
                            $utilidad,
                            $mercancia,
                            $instalado,
                            $pagado,
                            $numero_factura,
                            $observaciones,
                            $finalizado,
                            $google_sheet,
                            $borrar
                        ),
                        "data-id-proyecto" => $row['id_proyecto'],
                        "data-instalado" => $row['instalado'],
                        "data-sheet-id" => $row['google_sheet']
                    );
                }
            } else {
                $cctv[] = array(
                    "data" => array(
                        $folio,
                        $fecha,
                        $usuario,
                        $cliente,
                        $descripcion,
                        $precio,
                        $costo,
                        $utilidad,
                        $mercancia,
                        $instalado,
                        $pagado,
                        $numero_factura,
                        $observaciones,
                        $finalizado,
                        $google_sheet
                    ),
                    "data-id-proyecto" => $row['id_proyecto'],
                    "data-instalado" => $row['instalado'],
                    "data-sheet-id" => $row['google_sheet']
                );
            }
        }

        $finalizadoHeader = array("name" => array("data" => '<i class="fas fa-check-circle fa-2x"></i>', "class" => "dont-filter text-center"), "sortable" => 0);

        if (user_access("cctv_administrador")) {
            if(user_has_role(user_role_load_by_name('Auxiliar')->rid)){
                $header_cols = array(
                    array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
                    array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Total", "class" => "filter-number col-total"), "sortable" => 0),
                    array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
                    array("name" => array("data" => '<i class="fas fa-box"></i>', "class" => "filter-text", "style"=>"width: 50px"), "sortable" => 0),
                    array("name" => array("data" => "Instalado Cliente", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Facturado", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "N. Fact", "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
                    $finalizadoHeader,
                    array("name" => array("data" => '<i class="far fa-file-excel"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
                );
            } else {
                $header_cols = array(
                    array("name" => array("data" => "Folio", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
                    array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Total", "class" => "filter-number col-total"), "sortable" => 0),
                    array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
                    array("name" => array("data" => "Utilidad", "class" => "filter-number col-utilidad"), "sortable" => 0),
                    array("name" => array("data" => '<i class="fas fa-box"></i>', "class" => "filter-text", "style"=>"width: 50px"), "sortable" => 0),
                    array("name" => array("data" => "Instalado Cliente", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "Facturado", "class" => "filter-text"), "sortable" => 0),
                    array("name" => array("data" => "N. Fact", "class" => "dont-filter"), "sortable" => 0),
                    array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
                    $finalizadoHeader,
                    array("name" => array("data" => '<i class="far fa-file-excel"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
                    array("name" => array("data" => '<i class="fa fa-trash" aria-hidden="true"></i>', "class" => "dont-filter"), "sortable" => 0)
                );
            }
        } else {
            $header_cols = array(
                array(
                  "name" => array("data" => "Folio", "class" => "filter-text"),
                  "sortable" => 0
                ),
                array("name" => array("data" => "Fecha", "class" => "filter-date"), "sortable" => 0),
                array("name" => array("data" => "Usuario", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Cliente", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Descripción", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Total", "class" => "filter-number col-total"), "sortable" => 0),
                array("name" => array("data" => "Costo", "class" => "filter-number col-costo"), "sortable" => 0),
                array("name" => array("data" => "Utilidad", "class" => "filter-number col-utilidad"), "sortable" => 0),
                array("name" => array("data" => '<i class="fas fa-box"></i>', "class" => "filter-text", "style"=>"width: 50px"), "sortable" => 0),
                array("name" => array("data" => "Instalado Cliente", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "Facturado", "class" => "filter-text"), "sortable" => 0),
                array("name" => array("data" => "N. Fact", "class" => "dont-filter"), "sortable" => 0),
                array("name" => array("data" => "Obs", "class" => "dont-filter"), "sortable" => 0),
                $finalizadoHeader,
                array("name" => array("data" => '<i class="far fa-file-excel"></i>', "class" => "dont-filter text-center"), "sortable" => 0),
            );
        }

        $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


        $table = array(
            "header" => $header,
            "rows" => $cctv,
            "sticky" => false,
            "attributes" => array("id" => "table_reporteador_cctv", "class" => array("table-sm"))
        );


        $result = theme('table', $table);

        echo $result;
    }

    private function get_description($id_proyecto)
    {
        $descripcion = db_select('partners_cctv_datos', 'pcd');
        $descripcion->addExpression("GROUP_CONCAT(descripcion SEPARATOR ' | ')", 'descripcion');
        $descripcion->condition('id_proyecto', $id_proyecto);
        $desc = $descripcion->execute()->fetchField();

        return $desc;
    }

    /**
     * @param $id_proyecto
     * @param $tipo 1: piezas_precio, 2: piezas_costo
     * @return int
     */
    private function calcular_precio_total($id_proyecto, $tipo)
    {
        if ($tipo == 1) {
            $get_precio = db_select('partners_cctv_datos', 'pcd');
            $get_precio->addExpression('SUM(precio * cantidad)', 'total_piezas_precio');
            $get_precio->condition('pcd.id_proyecto', $id_proyecto);
            $precio = $get_precio->execute()->fetchField();
            return $precio;
        } else if ($tipo == 2) {
            $id_cotizacion = db_select('partners_cctv', 'pcctv')
                ->fields('pcctv', array('id_cotizacion'))
                ->condition('id_proyecto', $id_proyecto)
                ->execute()->fetchField();

            $id_mercancia = db_select('partners_mercancia', 'pm')
                ->fields('pm', array('id_salida'))
                ->condition('vinculacion_cotizacion', $id_cotizacion)
                ->condition('salida_eliminada', '0')
                ->execute()->fetchField();

            //Si no hay, buscar vinculación por proyecto
            if(!$id_mercancia) {
                $id_mercancia = db_select('partners_mercancia', 'pm')
                    ->fields('pm', array('id_salida'))
                    ->condition('vinculacion_proyecto', $id_proyecto)
                    ->condition('salida_eliminada', '0')
                    ->execute()->fetchField();
            }

            $q_costo = db_select('partners_mercancia_productos');
            $q_costo->addExpression('SUM(costo)', 'total_costo');
            $q_costo->condition('id_salida', $id_mercancia);
            $costo = $q_costo->execute()->fetchField();
            return $costo;
        }

    }

    private function update_status($datos)
    {
        global $user;
        if (isset($datos->obs)) {
            db_update('partners_cctv')
                ->fields(array(
                    $datos->col => $datos->new_val,
                    'observaciones' => $this->serialize_obs($datos->obs, 2, 'partners_cctv', 'id_proyecto', $datos->id_proyecto)
                ))
                ->condition('id_proyecto', $datos->id_proyecto)
                ->execute();
        } else {
            db_update('partners_cctv')
                ->fields(array(
                    $datos->col => $datos->new_val,
                ))
                ->condition('id_proyecto', $datos->id_proyecto)
                ->execute();
        }

        if (isset($datos->facturado)) {
            $this->track_down_facturado($datos->numero_factura, $datos->id_proyecto, "Proyectos CCTV", "partners_cctv", $datos->numero_factura);
        }

        $this->register_log_actions('partners_cctv', 'update', 'Se actualizó el status ' . $datos->col . ' con el valor ' . $datos->new_val . ' por el usuario ' . $user->name);
        $this->throw_message('success', "Cambios Guardados");
    }

    private function eliminar_proyecto($datos)
    {
        db_update('partners_cctv')
            ->fields(array(
                'proyecto_eliminado' => 1
            ))
            ->condition('id_proyecto', $datos)
            ->execute();
        $this->throw_message('success', 'Eliminado correctamente.');
        $this->register_log_actions('partners_cctv', 'delete', 'Se eliminó el proyecto CCTV: ' . $datos);
    }

    private function reactivate_proyecto($datos)
    {
        db_update('partners_cctv')
            ->fields(array(
                'proyecto_eliminado' => 0
            ))
            ->condition('id_proyecto', $datos)
            ->execute();
        $this->throw_message('success', 'Reactivado correctamente.');
        $this->register_log_actions('partners_cctv', 'update', 'Se reactivó el proyecto CCTV: ' . $datos);
    }

    private function vista_proyecto($id_proyecto)
    {
        $query = db_select('partners_cctv', 'pcctv');
        $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pcctv.id_cliente');
        $query->fields('pcctv');
        $query->fields('pc', array('nombre_cliente', 'tipo_cliente', 'credito', 'tipo_clasificacion'));
        $query->leftJoin('partners_clientes', 'pcc', 'pcc.id_cliente = pcctv.id_contacto');
        $query->addField('pcc', 'nombre_cliente', 'nombre_contacto');
        $query->addField('pcc', 'tipo_cliente', 'tipo_contacto');
        $query->condition('pcctv.id_proyecto', $id_proyecto);
        $datos = $query->execute()->fetchAssoc();

        $q_datos = db_select('partners_cctv_datos', 'pcd');
        $q_datos->fields('pcd');
        $q_datos->addExpression('SUM(cantidad * precio)', 'subtotal');
        $q_datos->condition('id_proyecto', $id_proyecto);
        $q_datos->groupBy('id_dato');
        $datos_proyecto = $q_datos->execute()->fetchAll(PDO::FETCH_ASSOC);


        $id_cotizacion = db_select('partners_cctv', 'pcctv')
            ->fields('pcctv', array('id_cotizacion'))
            ->condition('id_proyecto', $id_proyecto)
            ->execute()->fetchField();

        $id_mercancia = db_select('partners_mercancia', 'pm')
            ->fields('pm', array('id_salida'))
            ->condition('vinculacion_cotizacion', $id_cotizacion)
            ->condition('salida_eliminada', '0')
            ->execute()->fetchField();

        //Si no hay, buscar vinculación por proyecto
        if(!$id_mercancia) {
            $id_mercancia = db_select('partners_mercancia', 'pm')
                ->fields('pm', array('id_salida'))
                ->condition('vinculacion_proyecto', $id_proyecto)
                ->condition('salida_eliminada', '0')
                ->execute()->fetchField();
        }

        $q_mercancia = db_select('partners_mercancia_productos', 'pmp')
            ->fields('pmp')
            ->condition('id_salida', $id_mercancia)
            ->condition('cctv_extra', '0');
        $mercancia = $q_mercancia->execute()->fetchAll(PDO::FETCH_ASSOC);

        $q_mercanciae = db_select('partners_mercancia_productos', 'pmp')
            ->fields('pmp')
            ->condition('id_salida', $id_mercancia)
            ->condition('cctv_extra', '1');
        $mercanciae = $q_mercanciae->execute()->fetchAll(PDO::FETCH_ASSOC);

        $total = db_select('partners_cctv_datos', 'pcd');
        $total->addExpression('SUM(cantidad * precio)', 'total');
        $total->condition('id_proyecto', $id_proyecto);
        $t = $total->execute()->fetchField();

        $t_mercancia = db_select('partners_mercancia_productos', 'pmp');
        $t_mercancia->addExpression('SUM(costo)', 'total');
        $t_mercancia->condition('id_salida', $id_mercancia);
        $total_mercancia = $t_mercancia->execute()->fetchField();

        $data['proyecto'] = $datos;
        $data['total'] = $t;
        $data['total_mercancia'] = $total_mercancia;
        $data['datos'] = $datos_proyecto;
        $data['mercancia'] = $mercancia;
        $data['mercanciae'] = $mercanciae;
        $template = render_template('php', 'cctv.vista_proyecto', $data);

        $this->throw_message('success', $template);
    }

    /**
     * @param $datos ->type 1: render_vista ,2 : capturar
     */
    private function modificacion_costos($datos)
    {
        if ($datos->type == 1) {
            $get_piezas = db_select('partners_cctv_datos', 'pcd')
                ->fields('pcd')
                ->condition('pcd.tipo', 1)
                ->condition('pcd.id_proyecto', $datos->id_proyecto);
            $piezas = $get_piezas->execute()->fetchAll(PDO::FETCH_ASSOC);
            $data = [];
            $data['id_proyecto'] = $datos->id_proyecto;
            $data['piezas'] = $piezas;
            $render_tpl = render_template('php', 'cctv.vista_modificacion_piezas', $data);

            $this->throw_message('success', $render_tpl);
        } else if ($datos->type == 2) {
            if ($datos->datos) {
                foreach ($datos->datos as $pieza) {
                    db_update('partners_cctv_datos')
                        ->fields(array(
                            'costo' => strtr($pieza->new_costo, array(',' => ''))
                        ))
                        ->condition('id_dato', $pieza->id_pieza)
                        ->execute();
                }
                $this->throw_message('success', 'Piezas modificadas correctamente');
            }
        }
    }

    /**
     * Capturar la edición del proyecto de CCTV.
     * @param $datos
     */
    private function editar_proyecto($datos)
    {
        foreach ($datos->datos as $dato) {
            db_insert('partners_cctv_datos')
                ->fields(array(
                    'id_proyecto' => $datos->id_proyecto,
                    'descripcion' => $dato->descripcion,
                    'precio' => $dato->precio,
                    'cantidad' => $dato->cantidad,
                    'costo' => 0,
                    'tipo' => $dato->tipo
                ))
                ->execute();
        }

        foreach ($datos->eliminados as $eliminado) {
            db_delete('partners_cctv_datos')
                ->condition('id_dato', $eliminado)
                ->condition('id_proyecto', $datos->id_proyecto)
                ->execute();
        }

        $this->throw_message('success', 'Proyecto editado correctamente.');
    }


    /**
     * Imprime el detalle del proyecto CCTV
     * @param $datos
     * @throws MpdfException
     */
    private function render_proyecto_impreso($datos)
    {
        setlocale(LC_TIME, "es_MX");
        $id_proyecto = $datos['id_proyecto'];


        $q_datos = db_select('partners_cctv_datos', 'pcd');
        $q_datos->fields('pcd');
        $q_datos->addExpression('SUM(cantidad * precio)', 'subtotal');
        $q_datos->condition('id_proyecto', $id_proyecto);
        $q_datos->groupBy('id_dato');
        $datos_proyecto = $q_datos->execute()->fetchAll(PDO::FETCH_ASSOC);


        $total = db_select('partners_cctv_datos', 'pcd');
        $total->addExpression('SUM(cantidad * precio)', 'total');
        $total->condition('id_proyecto', $id_proyecto);
        $t = $total->execute()->fetchField();


        $data['datos'] = $datos_proyecto;
        $data['subtotal'] = $t;
        $data['iva'] = $t * 0.16;
        $data['total'] = $t * 1.16;
        $html = render_template('php', 'cctv.render_proyecto', $data);
        $footer = render_template('php', 'system.footer_reporte');
        $this->generate_pdf($html, 'Proyecto ' . $id_proyecto, 'proyecto_' . $id_proyecto, 1, $footer, null);
    }

    /**
     * Método para crear una hoja de cálculo en Google Sheets
     * @param $id_proyecto
     */
    private function crear_google_sheet($id_proyecto)
    {
        // Credenciales
        $gs_clid = '564404237953-cc9260rhg2nlp20u6ra6i19359nbi5sn.apps.googleusercontent.com'; // API Client ID
        $gs_clis = 'KHML_fu2AU8sqov_m9Kgb2RE'; // API Client Secret
        $gs_rtok = '1/BNGwlbsn9J-LIGK0SPOTcXPuU9cq0S6s5EI41C9MovU'; // OAuth Refresh Token

        // Cuenta en donde se crean las hojas:
        # Correo: partnerssistema@gmail.com
        # Pass: Pulso4745

        // Traer el OAuth token para realizar la transacción
        $auth_url = 'https://www.googleapis.com/oauth2/v4/token?client_id='
            . $gs_clid . '&client_secret=' . $gs_clis . '&refresh_token=' . $gs_rtok . '&grant_type=refresh_token';

        $ch_auth_token = curl_init();
        curl_setopt($ch_auth_token, CURLOPT_URL, $auth_url);
        curl_setopt($ch_auth_token, CURLOPT_POST, 1);
        curl_setopt($ch_auth_token, CURLOPT_HTTPHEADER, ['Content-type: application/x-www-form-urlencoded', 'Content-Length: 0']);
        curl_setopt($ch_auth_token, CURLOPT_RETURNTRANSFER, true);

        $server_auth_output = curl_exec($ch_auth_token);

        if (curl_errno($ch_auth_token)) {
            # Hay un error con el curl
            $this->throw_message('error', curl_error($ch_auth_token));
        } else {
            // HTTP status code of the request
            $resultStatus = curl_getinfo($ch_auth_token, CURLINFO_HTTP_CODE);
            if ($resultStatus == 200) {

                // Si fue success, ahora como ya tenemos el token, toca crear la hoja.
                $spreadsheet_title = 'Proyecto CCTV ' . $id_proyecto;

                $gs_body = array(
                    "properties" => array(
                        "title" => $spreadsheet_title,
                        "locale" => "es_MX"
                    )
                );

                $post_data_string = json_encode($gs_body);
                $sheets_url = 'https://sheets.googleapis.com/v4/spreadsheets/';

                $ch_create_sheet = curl_init();
                curl_setopt($ch_create_sheet, CURLOPT_URL, $sheets_url);
                curl_setopt($ch_create_sheet, CURLOPT_POST, 1);
                curl_setopt($ch_create_sheet, CURLOPT_POSTFIELDS, $post_data_string);
                curl_setopt($ch_create_sheet, CURLOPT_HTTPHEADER,
                    [
                        'Content-type: application/json',
                        'Authorization: OAuth ' . json_decode($server_auth_output)->access_token,
                        'Content-Length: ' . strlen($post_data_string)]
                );
                curl_setopt($ch_create_sheet, CURLOPT_RETURNTRANSFER, true);

                $server_create_sheet_output = curl_exec($ch_create_sheet);

                if (curl_errno($ch_create_sheet)) {
                    $this->throw_message('error', curl_error($ch_create_sheet));
                } else {
                    // check the HTTP status code of the request
                    $resultStatus_ = curl_getinfo($ch_auth_token, CURLINFO_HTTP_CODE);
                    if ($resultStatus_ == 200) {
                        // Una vez con la hoja creada, hay que asignarle permisos a cada email
                        $emails = ["lesliev.partners@gmail.com", "roberto.partners@gmail.com", "partnerscctv@gmail.com", "rocio.partners@gmail.com"];
                        $success_permissions = 0;
                        foreach ($emails as $email) {
                            // Si las envio asi sin esperar, regresa error 500 por alguna razón que no se porque.
                            // Entonces tuve que forzar un "timeout" para que se envie cada solicitud con retraso.
                            // Esto basicamente porque la API no permite enviar varios correos a la vez y pues
                            // esta era una forma de solucionarlo.
                            sleep(1);
                            $gs_body_permissions = array(
                                "role" => "writer",
                                "type" => "user",
                                "emailAddress" => $email);

                            $post_data_string_permissions = json_encode($gs_body_permissions);

                            $permissions_url = 'https://www.googleapis.com/drive/v3/files/'
                                . json_decode($server_create_sheet_output)->spreadsheetId
                                . '/permissions?sendNotificationEmail=false';

                            $ch_set_permissions = curl_init();
                            curl_setopt($ch_set_permissions, CURLOPT_URL, $permissions_url);
                            curl_setopt($ch_set_permissions, CURLOPT_POST, 1);
                            curl_setopt($ch_set_permissions, CURLOPT_POSTFIELDS, $post_data_string_permissions);
                            curl_setopt($ch_set_permissions, CURLOPT_HTTPHEADER,
                                [
                                    'Content-type: application/json',
                                    'Authorization: OAuth ' . json_decode($server_auth_output)->access_token,
                                    'Content-Length: ' . strlen($post_data_string_permissions)]
                            );
                            curl_setopt($ch_set_permissions, CURLOPT_RETURNTRANSFER, true);

                            curl_exec($ch_set_permissions);
                            if (curl_errno($ch_set_permissions)) {
                                $this->throw_message('error', curl_error($ch_set_permissions));
                            } else {
                                //HTTP status code of the request
                                $resultStatus__ = curl_getinfo($ch_set_permissions, CURLINFO_HTTP_CODE);
                                if ($resultStatus__ == 200) {
                                    $success_permissions++;

                                } else {
                                    $this->throw_message('error', $resultStatus__);
                                }
                            }

                            curl_close($ch_set_permissions);
                        }

                        // Despues, validar que el total de solicitudes correctas sea igual al de los emails
                        // y en caso de que si sean las mismas, significa que se asignaron bien los permisos.

                        if ($success_permissions == count($emails)) {
                            // Se le agregaron correctamente los permisos, actualizar el proyecto con su
                            // url.
                            db_update('partners_cctv')
                                ->fields(array(
                                    'google_sheet' => json_decode($server_create_sheet_output)->spreadsheetUrl
                                ))
                                ->condition('id_proyecto', $id_proyecto)
                                ->execute();


                            // Ahora solo falta generar el JSON para meter la info del proyecto a la hoja de calculo.

                            $query = db_select('partners_cctv', 'pcctv');
                            $query->innerJoin('partners_clientes', 'pc', 'pc.id_cliente = pcctv.id_cliente');
                            $query->fields('pcctv');
                            $query->fields('pc', array('nombre_cliente'));
                            $query->condition('pcctv.id_proyecto', $id_proyecto);
                            $datosProyecto = $query->execute()->fetchAssoc();

                            $q_datos = db_select('partners_cctv_datos', 'pcd');
                            $q_datos->fields('pcd');
                            $q_datos->addExpression('SUM(cantidad * precio)', 'subtotal');
                            $q_datos->condition('id_proyecto', $id_proyecto);
                            $q_datos->groupBy('id_dato');
                            $datos_proyecto = $q_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

                            $id_cotizacion = db_select('partners_cctv', 'pcctv')
                                ->fields('pcctv', array('id_cotizacion'))
                                ->condition('id_proyecto', $id_proyecto)
                                ->execute()->fetchField();

                            $id_mercancia = db_select('partners_mercancia', 'pm')
                                ->fields('pm', array('id_salida'))
                                ->condition('vinculacion_cotizacion', $id_cotizacion)
                                ->execute()->fetchField();
                            $q_mercancia = db_select('partners_mercancia_productos', 'pmp')
                                ->fields('pmp')
                                ->condition('id_salida', $id_mercancia);
                            $mercancia = $q_mercancia->execute()->fetchAll(PDO::FETCH_ASSOC);

                            $sheetData = array(
                                "range" => "'Hoja 1'!A1:Z1000",
                                "majorDimension" => "ROWS",
                                "values" => array(
                                    # Cada array, es un row en el sheet, y cada elemento del array, es una columna.
                                    array(
                                        "Proyecto " . $id_proyecto
                                    ),
                                    array(
                                        "Cliente:",
                                        $datosProyecto['nombre_cliente']
                                    ),
                                    array(
                                        "Fecha Creación",
                                        date('d/m/Y h:i', $datosProyecto['created_at'])
                                    ),
                                    array(),
                                    array(
                                        "VENTA"
                                    ),
                                    array(
                                        "Tipo",
                                        "Cantidad",
                                        "Descripción",
                                        "Precio Unitario",
                                        "Subtotal"
                                    )
                                )
                            );

                            $total_datos_proyecto = 0;
                            foreach ($datos_proyecto as $item) {
                                $sheetData['values'][] = array(
                                    $item['tipo'] == 1 ? "Pieza" : "Servicio",
                                    (float)$item['cantidad'],
                                    $item['descripcion'],
                                    (float)$item['precio'],
                                    (float)$item['precio'] * $item['cantidad'],
                                );
                                $total_datos_proyecto += (float)$item['precio'] * $item['cantidad'];
                            }

                            # Al final despues de haber agregado todos los productos, agregar el total.
                            $sheetData['values'][] = array(
                                "",
                                "",
                                "",
                                "",
                                (float)$total_datos_proyecto,
                            );


                            # Ahora capturar datos de mercancia.
                            $sheetData_ = array(
                                "range" => "'Hoja 1'!G5",
                                "majorDimension" => "ROWS",
                                "values" => array(
                                    array(
                                        "SALIDAS",
                                        "",
                                        "",
                                        "",
                                        "",
                                        "OTROS",
                                    ),
                                    array(
                                        "UPC",
                                        "Producto",
                                        "Serie",
                                        "Costo",
                                        "",
                                        "Proveedor",
                                        "Factura",
                                        "Gasto",
                                        "Fecha",
                                        "Cantidad",
                                        "Comentarios",
                                    )
                                )
                            );

                            $total_datos_salida = 0;
                            foreach ($mercancia as $item) {
                                $sheetData_['values'][] = array(
                                    $item['upc_producto'],
                                    $item['nombre_producto'],
                                    $item['serie_producto'],
                                    (float)$item['costo'],
                                );
                                $total_datos_salida += (float)$item['costo'];
                            }

                            # Al final despues de haber agregado todos los productos, agregar el total.
                            $sheetData_['values'][] = array(
                                "",
                                "",
                                "",
                                (float)$total_datos_salida,
                            );

                            # Enviar la primera parte.
                            $gs_body_write = json_encode($sheetData);

                            $sheets_write_url = 'https://sheets.googleapis.com/v4/spreadsheets/'
                                . json_decode($server_create_sheet_output)->spreadsheetId .
                                "/values/'Hoja%201'!A1%3AZ1000?valueInputOption=RAW";

                            $ch_write_sheet = curl_init();
                            curl_setopt($ch_write_sheet, CURLOPT_URL, $sheets_write_url);
                            curl_setopt($ch_write_sheet, CURLOPT_CUSTOMREQUEST, 'PUT');
                            curl_setopt($ch_write_sheet, CURLOPT_POSTFIELDS, $gs_body_write);
                            curl_setopt($ch_write_sheet, CURLOPT_HTTPHEADER,
                                [
                                    'Content-type: application/json',
                                    'Authorization: OAuth ' . json_decode($server_auth_output)->access_token,
                                    'Content-Length: ' . strlen($gs_body_write)]
                            );
                            curl_setopt($ch_write_sheet, CURLOPT_RETURNTRANSFER, true);

                            curl_exec($ch_write_sheet);

                            if (curl_errno($ch_write_sheet)) {
                                $this->throw_message('error', curl_error($ch_write_sheet));
                            } else {
                                // check the HTTP status code of the request
                                $resultStatus_write = curl_getinfo($ch_write_sheet, CURLINFO_HTTP_CODE);
                                if ($resultStatus_write == 200) {

                                    # Una vez capturado los datos del proyecto, ahora capturar los datos de la
                                    # salida de mercancia y regresar la url.
                                    $gs_body_write_ = json_encode($sheetData_);

                                    $sheets_write_url_ = 'https://sheets.googleapis.com/v4/spreadsheets/'
                                        . json_decode($server_create_sheet_output)->spreadsheetId .
                                        "/values/'Hoja%201'!G5?valueInputOption=RAW";

                                    $ch_write_sheet_ = curl_init();
                                    curl_setopt($ch_write_sheet_, CURLOPT_URL, $sheets_write_url_);
                                    curl_setopt($ch_write_sheet_, CURLOPT_CUSTOMREQUEST, 'PUT');
                                    curl_setopt($ch_write_sheet_, CURLOPT_POSTFIELDS, $gs_body_write_);
                                    curl_setopt($ch_write_sheet_, CURLOPT_HTTPHEADER,
                                        [
                                            'Content-type: application/json',
                                            'Authorization: OAuth ' . json_decode($server_auth_output)->access_token,
                                            'Content-Length: ' . strlen($gs_body_write_)]
                                    );
                                    curl_setopt($ch_write_sheet_, CURLOPT_RETURNTRANSFER, true);

                                    curl_exec($ch_write_sheet_);

                                    if (curl_errno($ch_write_sheet_)) {
                                        $this->throw_message('error', curl_error($ch_write_sheet_));
                                    } else {
                                        // check the HTTP status code of the request
                                        $resultStatus_write_ = curl_getinfo($ch_write_sheet_, CURLINFO_HTTP_CODE);
                                        if ($resultStatus_write_ == 200) {
                                            # Si toda la captura salió correcta, ahora si regresar la url de la hoja
                                            # al usuario.
                                            $this->throw_message('success', json_decode($server_create_sheet_output)->spreadsheetUrl);
                                            $this->register_log_actions('partners_cctv',
                                                'sheet', 'Se creó una hoja de cálculo relacioanda con el proyecto cctv: ' . $id_proyecto);
                                        } else {
                                            $this->throw_message('error', $resultStatus_write_);
                                        }
                                    }
                                } else {
                                    $this->throw_message('error', $resultStatus_write);
                                }
                            }


                        } else {
                            $this->throw_message('error', 'Se creó la hoja de cálculo, pero no se ha podido compartir.');
                        }

                    } else {
                        $this->throw_message('error', $resultStatus_);
                    }
                }

            } else {
                $this->throw_message('error', $resultStatus);
            }
        }
    }

    /**
     * Sincroniza una hoja de calculo de google relacionada a un proyecto CCTV, agregandole a la hoja de calculo otra
     * vez todos los datos del proyecto de CCTV.
     * @param $datos
     */
    private function sincronizar_google_sheet($datos)
    {
        $sheet_id = str_replace('https://docs.google.com/spreadsheets/d/', '', $datos->sheetId);
        $sheet_id = str_replace('/edit', '', $sheet_id);

        // Credenciales
        $gs_clid = '564404237953-cc9260rhg2nlp20u6ra6i19359nbi5sn.apps.googleusercontent.com'; // API Client ID
        $gs_clis = 'KHML_fu2AU8sqov_m9Kgb2RE'; // API Client Secret
        $gs_rtok = '1/BNGwlbsn9J-LIGK0SPOTcXPuU9cq0S6s5EI41C9MovU'; // OAuth Refresh Token

        // Cuenta en donde se crean las hojas:
        # Correo: partnerssistema@gmail.com
        # Pass: Pulso4745

        // Traer el OAuth token para realizar la transacción
        $auth_url = 'https://www.googleapis.com/oauth2/v4/token?client_id='
            . $gs_clid . '&client_secret=' . $gs_clis . '&refresh_token=' . $gs_rtok . '&grant_type=refresh_token';

        $ch_auth_token = curl_init();
        curl_setopt($ch_auth_token, CURLOPT_URL, $auth_url);
        curl_setopt($ch_auth_token, CURLOPT_POST, 1);
        curl_setopt($ch_auth_token, CURLOPT_HTTPHEADER, ['Content-type: application/x-www-form-urlencoded', 'Content-Length: 0']);
        curl_setopt($ch_auth_token, CURLOPT_RETURNTRANSFER, true);

        $server_auth_output = curl_exec($ch_auth_token);

        if (curl_errno($ch_auth_token)) {
            # Hay un error con el curl
            $this->throw_message('error', curl_error($ch_auth_token));
        } else {
            // HTTP status code of the request
            $resultStatus = curl_getinfo($ch_auth_token, CURLINFO_HTTP_CODE);
            if ($resultStatus == 200) {
                // Ahora solo falta generar el JSON para meter la info del proyecto a la hoja de calculo.

                $q_datos = db_select('partners_cctv_datos', 'pcd');
                $q_datos->fields('pcd');
                $q_datos->addExpression('SUM(cantidad * precio)', 'subtotal');
                $q_datos->condition('id_proyecto', $datos->idProyecto);
                $q_datos->groupBy('id_dato');
                $datos_proyecto = $q_datos->execute()->fetchAll(PDO::FETCH_ASSOC);

                $id_cotizacion = db_select('partners_cctv', 'pcctv')
                    ->fields('pcctv', array('id_cotizacion'))
                    ->condition('id_proyecto', $datos->idProyecto)
                    ->execute()->fetchField();

                $id_mercancia = db_select('partners_mercancia', 'pm')
                    ->fields('pm', array('id_salida'))
                    ->condition('vinculacion_cotizacion', $id_cotizacion)
                    ->execute()->fetchField();
                $q_mercancia = db_select('partners_mercancia_productos', 'pmp')
                    ->fields('pmp')
                    ->condition('id_salida', $id_mercancia);
                $mercancia = $q_mercancia->execute()->fetchAll(PDO::FETCH_ASSOC);

                $sheetData = array(
                    "range" => "'Hoja 1'!A7",
                    "majorDimension" => "ROWS",
                    "values" => array()
                );

                $total_datos_proyecto = 0;
                foreach ($datos_proyecto as $item) {
                    $sheetData['values'][] = array(
                        $item['tipo'] == 1 ? "Pieza" : "Servicio",
                        (float)$item['cantidad'],
                        $item['descripcion'],
                        (float)$item['precio'],
                        (float)$item['precio'] * $item['cantidad'],
                    );
                    $total_datos_proyecto += (float)$item['precio'] * $item['cantidad'];
                }

                # Al final despues de haber agregado todos los productos, agregar el total.
                $sheetData['values'][] = array(
                    "",
                    "",
                    "",
                    "",
                    (float)$total_datos_proyecto,
                );


                # Agregar rows extras vacias porque puede ser que se llegue a eliminar registros, y si no
                # agrego rows vacías no hay forma de eliminarlas y se quedarían hay registros que no deben de estar,
                # porque basicamente como serian menos registros, nunca los sobreescribiria.
                for ($i = 0; $i < 10; $i++) {
                    $sheetData['values'][] = array("", "", "", "", "");
                }

                # Ahora capturar datos de mercancia.
                $sheetData_ = array(
                    "range" => "'Hoja 1'!G7",
                    "majorDimension" => "ROWS",
                    "values" => array()
                );

                $total_datos_salida = 0;
                foreach ($mercancia as $item) {
                    $sheetData_['values'][] = array(
                        $item['upc_producto'],
                        $item['nombre_producto'],
                        $item['serie_producto'],
                        (float)$item['costo'],
                    );
                    $total_datos_salida += (float)$item['costo'];
                }

                # Al final despues de haber agregado todos los productos, agregar el total.
                $sheetData_['values'][] = array(
                    "",
                    "",
                    "",
                    (float)$total_datos_salida,
                );

                # Agregar rows extras vacias porque puede ser que se llegue a eliminar registros, y si no
                # agrego rows vacías no hay forma de eliminarlas y se quedarían hay registros que no deben de estar,
                # porque basicamente como serian menos registros, nunca los sobreescribiria.
                for ($i = 0; $i < 10; $i++) {
                    $sheetData_['values'][] = array("", "", "", "");
                }

                # Enviar la primera parte.
                $gs_body_write = json_encode($sheetData);

                $sheets_write_url = 'https://sheets.googleapis.com/v4/spreadsheets/'
                    . $sheet_id .
                    "/values/'Hoja%201'!A7?valueInputOption=RAW";

                $ch_write_sheet = curl_init();
                curl_setopt($ch_write_sheet, CURLOPT_URL, $sheets_write_url);
                curl_setopt($ch_write_sheet, CURLOPT_CUSTOMREQUEST, 'PUT');
                curl_setopt($ch_write_sheet, CURLOPT_POSTFIELDS, $gs_body_write);
                curl_setopt($ch_write_sheet, CURLOPT_HTTPHEADER,
                    [
                        'Content-type: application/json',
                        'Authorization: OAuth ' . json_decode($server_auth_output)->access_token,
                        'Content-Length: ' . strlen($gs_body_write)]
                );
                curl_setopt($ch_write_sheet, CURLOPT_RETURNTRANSFER, true);

                curl_exec($ch_write_sheet);

                if (curl_errno($ch_write_sheet)) {
                    $this->throw_message('error', curl_error($ch_write_sheet));
                } else {
                    // check the HTTP status code of the request
                    $resultStatus_write = curl_getinfo($ch_write_sheet, CURLINFO_HTTP_CODE);
                    if ($resultStatus_write == 200) {

                        # Una vez capturado los datos del proyecto, ahora capturar los datos de la
                        # salida de mercancia y regresar la url.
                        $gs_body_write_ = json_encode($sheetData_);

                        $sheets_write_url_ = 'https://sheets.googleapis.com/v4/spreadsheets/'
                            . $sheet_id .
                            "/values/'Hoja%201'!G7?valueInputOption=RAW";

                        $ch_write_sheet_ = curl_init();
                        curl_setopt($ch_write_sheet_, CURLOPT_URL, $sheets_write_url_);
                        curl_setopt($ch_write_sheet_, CURLOPT_CUSTOMREQUEST, 'PUT');
                        curl_setopt($ch_write_sheet_, CURLOPT_POSTFIELDS, $gs_body_write_);
                        curl_setopt($ch_write_sheet_, CURLOPT_HTTPHEADER,
                            [
                                'Content-type: application/json',
                                'Authorization: OAuth ' . json_decode($server_auth_output)->access_token,
                                'Content-Length: ' . strlen($gs_body_write_)]
                        );
                        curl_setopt($ch_write_sheet_, CURLOPT_RETURNTRANSFER, true);

                        curl_exec($ch_write_sheet_);

                        if (curl_errno($ch_write_sheet_)) {
                            $this->throw_message('error', curl_error($ch_write_sheet_));
                        } else {
                            // check the HTTP status code of the request
                            $resultStatus_write_ = curl_getinfo($ch_write_sheet_, CURLINFO_HTTP_CODE);
                            if ($resultStatus_write_ == 200) {
                                # Si toda la captura salió correcta, ahora si regresar success con el url a la hoja.
                                $this->throw_message('success', $datos->sheetId);
                            } else {
                                $this->throw_message('error', $resultStatus_write_);
                            }
                        }
                    } else {
                        $this->throw_message('error', $resultStatus_write);
                    }
                }

            } else {
                $this->throw_message('error', $resultStatus);
            }
        }
    }

    private function salida_merc_form($datos)
    {
        global $user;
        $proyecto = db_select('partners_cctv', 'pcctv')
                ->fields('pcctv', array('id_cotizacion', 'created_by', 'id_cliente', 'finalizado'))
                ->condition('id_proyecto', $datos->id)
                ->execute()->fetchAssoc();
        $idCotizacion = $proyecto['id_cotizacion'];
        $solicita = $proyecto['created_by'];
        $idCliente = $proyecto['id_cliente'];
        $finalizado = $proyecto['finalizado'];
        //Buscar vinculación por cotización
        $id_mercancia = db_select('partners_mercancia', 'pm')
                ->fields('pm', array('id_salida'))
                ->condition('vinculacion_cotizacion', $idCotizacion)
                ->condition('salida_eliminada', '0')
                ->execute()->fetchField();
        //Si no hay, buscar vinculación por proyecto
        if(!$id_mercancia) {
            $id_mercancia = db_select('partners_mercancia', 'pm')
                ->fields('pm', array('id_salida'))
                ->condition('vinculacion_proyecto', $datos->id)
                ->condition('salida_eliminada', '0')
                ->execute()->fetchField();
        }
        //Si no hay, crear vinculación por proyecto
        if(!$id_mercancia) {
            $id_mercancia = db_insert('partners_mercancia')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => $user->uid,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid,
                'id_usuario_solicito' => $solicita,
                'id_cliente' => $idCliente,
                'detalle_salida' => '',
                'vinculacion_cotizacion' => null,
                'vinculacion_proyecto' => $datos->id,
                'tipo_salida' => 6
            ))
            ->execute();
        }

        $mercs = db_select('partners_mercancia_productos', 'pmp')
            ->fields('pmp')
            ->condition('id_salida', $id_mercancia)
            ->condition('cctv_extra', 0)
            ->execute()
            ->fetchAll();

        $mercse = db_select('partners_mercancia_productos', 'pmp')
            ->fields('pmp')
            ->condition('id_salida', $id_mercancia)
            ->condition('cctv_extra', 1)
            ->execute()
            ->fetchAll();

            $total = db_select('partners_mercancia_productos', 'pmp');
            $total->addExpression('SUM(costo)', 'total');
            $total->condition('id_salida', $id_mercancia);
            $t = $total->execute()->fetchField();

            $template = '';

            if(!$finalizado) {
                $template = '
        <button class="btn btn-sm btn-merc m-1 collapsed" type="button" data-toggle="collapse" data-target=".add-merc-or-extra" aria-expanded="false" aria-controls="add-merc-form add-extra-form">Extra</button>
        <div id="add-merc-form" class="add-merc-or-extra collapse show">
            <h5 class="text-center">Salida de mercancia para proyecto '. $datos->id .'</h5>
            <div class="d-flex justify-content-around">
                <div class="form-group w-100 m-1">
                    <label><b>UPC</b></label>
                    <input type="text" id="UPCInput" class="form-control">
                </div>
                <div class="form-group w-100 m-1">
                    <label><b>PRODUCTO</b></label>
                    <input type="text" id="ProductoInput" class="form-control">
                </div>
                <div class="form-group w-100 m-1">
                    <label><b>SERIE</b></label>
                    <input type="text" id="SerieInput" class="form-control">
                </div>
                <div class="form-group w-100 m-1">
                    <label><b>COSTO</b></label>
                    <input type="text" id="CostoInput" class="form-control">
                </div>
                <div class="form-group w-100 m-1">
                    <label><b>VENTA</b></label>
                    <input type="text" id="VentaInput" class="form-control">
                </div>
                <button class="btn btn-success mb-1 add-cost" cost-type="1" project-id="'. $datos->id .'"  style="height: max-content;margin-top: auto;">Agregar</button>
            </div>
        </div>
        <div id="add-extra-form" class="add-merc-or-extra collapse">
            <h5 class="text-center">Costo extra para proyecto '. $datos->id .'</h5>
            <div class="form-group d-flex justify-content-around">
                <div class="form-group w-100 m-1">
                    <label><b>CONCEPTO</b></label>
                    <input type="text" id="ConceptoInput" class="form-control">
                </div>
                <div class="form-group w-100 m-1">
                    <label><b>COSTO</b></label>
                    <input type="text" id="ExtraCostoInput" class="form-control">
                </div>
                <button class="btn btn-success mb-1 add-cost" cost-type="2" project-id="'. $datos->id .'" style="height: max-content;margin-top: auto;">Agregar</button>
            </div>
        </div>
        ';
        }
        //Tabla productos
        if($mercs) {
            $template .= '
            <h5>Piezas</h5>
            <div class="w-100">
                <table class="table table-sm table-striped table-mobile">
                    <thead>
                        <tr>
                            <th>UPC</th>
                            <th>Producto</th>
                            <th>Serie</th>
                            <th class="text-right">Venta</th>
                            <th class="text-right">Costo</th>'
                            . ((user_access("mercancia_administrador") && !$finalizado)?'<th class="text-center" style="width: 50px;"><i class="fas fa-trash-alt"></i></th>':'') .
                        '</tr>
                    </thead>
                    <tbody>';

                    foreach($mercs as $merc) {
                        $costo = number_format($merc->costo, 2);
                        $venta = number_format($merc->venta, 2);
                        $template .= "
                        <tr field-id=\"{$merc->id_producto}\" id-proyecto=\"{$datos->id}\">
                            <td class=\"align-middle\">{$merc->upc_producto}</td>
                            <td class=\"align-middle\">{$merc->nombre_producto}</td>
                            <td class=\"align-middle\">{$merc->serie_producto}</td>
                            <td class=\"align-middle text-right\">{$venta}</td>
                            <td class=\"align-middle text-right\">{$costo}</td>"
                            . ((user_access("mercancia_administrador") && !$finalizado)?'<td class="text-right"><button class="btn btn-sm btn-outline-danger border-0 w-100 delete-merc-field"><i class="fas fa-trash-alt"></i></button></td>':'') .
                        "</tr>
                        ";
                    }

        $template .= '</tbody>
                </table>
            </div>
        ';
        }
        //tabla extras
        if($mercse) {
            $template .= '
            <h5>Costos extra</h5>
            <div class="w-100 mt-2">
                <table class="table table-sm table-striped table-mobile">
                    <thead>
                        <tr>
                            <th>Concepto</th>
                            <th class="text-right">Costo</th>'
                            . ((user_access("mercancia_administrador") && !$finalizado)?'<th class="text-center" style="width: 50px;"><i class="fas fa-trash-alt"></i></th>':'') .
                        '</tr>
                    </thead>
                    <tbody>';

                    foreach($mercse as $merc) {
                        $costo = number_format($merc->costo, 2);
                        $template .= "
                        <tr field-id=\"{$merc->id_producto}\" id-proyecto=\"{$datos->id}\">
                            <td class=\"align-middle\">{$merc->nombre_producto}</td>
                            <td class=\"align-middle text-right\">{$costo}</td>"
                            . ((user_access("mercancia_administrador") && !$finalizado)?'<td class="text-right"><button class="btn btn-sm btn-outline-danger border-0 w-100 delete-merc-field"><i class="fas fa-trash-alt"></i></button></td>':'') .
                        "</tr>
                        ";
                    }

        $template .= '</tbody>
                </table>
            </div>
        ';
        }
        $total = number_format($t, 2);
        $template .= "
            <div class=\"w-100 mt-2\">
                <table class=\"table table-sm\">
                    <tbody>
                        <tr>
                            <th class=\"text-right\">TOTAL</th>
                            <th class=\"text-right\" style=\"width: 200px;\">{$total}</th>"
                            . ((user_access("mercancia_administrador") && !$finalizado)?'<td style="width: 50px;">&nbsp;</td>':'') .
                        "</tr>
                    </tbody>
                </table>
            </div>
        ";
        $this->throw_message('success', $template);
    }

    public function addMerc($datos)
    {
        $idCotizacion = db_select('partners_cctv', 'pcctv')
            ->fields('pcctv', array('id_cotizacion'))
            ->condition('id_proyecto', $datos->id)
            ->execute()->fetchField();
        $id_mercancia = db_select('partners_mercancia', 'pm')
                ->fields('pm', array('id_salida'))
                ->condition('vinculacion_cotizacion', $idCotizacion)
                ->condition('salida_eliminada', '0')
                ->execute()->fetchField();
        //Si no hay, buscar vinculación por proyecto
        if(!$id_mercancia) {
            $id_mercancia = db_select('partners_mercancia', 'pm')
                ->fields('pm', array('id_salida'))
                ->condition('vinculacion_proyecto', $datos->id)
                ->condition('salida_eliminada', '0')
                ->execute()->fetchField();
        }

        if($datos->type == 1) {
            db_insert('partners_mercancia_productos')
            ->fields(array(
                "id_salida" => (int)$id_mercancia,
                "nombre_producto" => $datos->producto,
                "upc_producto" => $datos->upc,
                "serie_producto" => $datos->serie,
                "costo" => (float)$datos->costo,
                "venta" => (float)$datos->venta,
                "cctv_extra" => 0
            ))->execute();
        } else {
            db_insert('partners_mercancia_productos')
            ->fields(array(
                "id_salida" => (int)$id_mercancia,
                "nombre_producto" => $datos->concepto,
                "upc_producto" => 'extra',
                "serie_producto" => 'extra',
                "costo" => (float)$datos->costo,
                "venta" => 0,
                "cctv_extra" => 1
            ))->execute();
        }
        $this->throw_message('success', "ok");
    }

    public function deleteMerc($datos)
    {
        $get_pieza = db_select('partners_mercancia_productos', 'pmp');
        $get_pieza->fields('pmp');
        $get_pieza->condition('id_producto', $datos->idProducto);
        $pieza = $get_pieza->execute()->fetchAssoc();
        $obs_txt = 'Se eliminó la pieza: ' . $pieza['upc_producto'] . ' | ' . $pieza['nombre_producto'] . ' | '
        . $pieza['serie_producto'] . ' | costo: ' . number_format($pieza['costo'], 2, '.', ',')
        . ' | venta: ' . number_format($pieza['venta'], 2, '.', ',')
        . ' | por el motivo: ' . $datos->motivo;
        $obs = $this->serialize_obs($obs_txt, 2, 'partners_mercancia', 'id_salida', $pieza['id_salida']);
         # Caputrar la nueva observacion
         db_update('partners_mercancia')
            ->fields(array(
                'observaciones' => $obs
            ))
            ->condition('id_salida', $pieza['id_salida'])
            ->execute();

        # Después de haber guardado en bitacora, ahora si eliminar la pieza.
        db_delete('partners_mercancia_productos')
            ->condition('id_producto', $datos->idProducto)
            ->execute();

        $this->register_log_actions('partners_mercancia', 'update', 'Se editó la salida de mercancia: ' . $pieza['id_salida']);
        $this->throw_message('success', 'Mercancia editada correctamente');
    }

    public function marcar_finalizado($datos)
    {
        db_update('partners_cctv')
            ->fields(array(
                "finalizado" => (int)!$datos->status
            ))
            ->condition("id_proyecto", $datos->id)
            ->execute();
        $this->throw_message('success', (int)!$datos->status);
    }

    public function nuevo_form()
    {
        $template = render_template('php', 'cctv.nuevo_proyecto');

        $this->throw_message('success', $template);
    }

    public function nuevo_proyecto($datos)
    {
        global $user;
        $id_proyecto = db_insert('partners_cctv')
            ->fields(array(
                'created_at' => REQUEST_TIME,
                'created_by' => $user->uid,
                'updated_at' => REQUEST_TIME,
                'updated_by' => $user->uid,
                'id_cotizacion' => 999999999,
                'id_cliente' => $datos->idCliente,
                'id_contacto' => ($datos->idContacto) ? $datos->idContacto : null,
                'notas_proyecto' => "",
            ))
            ->execute();

        foreach ($datos->products as $dato) {
            db_insert('partners_cctv_datos')
                ->fields(array(
                'id_proyecto' => $id_proyecto,
                'descripcion' => $dato->descripcion,
                'precio' => $dato->precio,
                'cantidad' => $dato->cantidad,
                'tipo' => $dato->tipo
                ))
                ->execute();
        }
        // var_dump($datos);
        $this->register_log_actions('partners_cctv', 'insert', 'Se capturó un nuevo proyecto CCTV: ' . $id_proyecto);
        $this->throw_message('success', "Se ha creado un nuevo pryecto cctv");
    }

}
