<?php

class capacitacion_sys extends sys_tools
{

  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'reporte_base':
          try {
            $this->reporte_base($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reporte_base');
          }
          break;
        case 'nueva_cotizacion':
          try {
            $this->nueva_cotizacion($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'nueva_cotizacion');
          }
          break;
      }
    }
  }

  private function reporte_base($datos)
  {
    echo "reporte";

  }

  private function nueva_cotizacion()
  {
    global $user;
    $role = user_role_load_by_name('Todos');
    $query = 'SELECT ur.uid
        FROM {users_roles} AS ur
        WHERE ur.rid = :rid';
    $result = db_query($query, array(':rid' => $role->rid));
    $uids = $result->fetchCol();

    $usuarios = db_select('users', 'u')
      ->fields('u', array('uid', 'name'))
      ->condition('status', 1)
      ->condition('uid', $uids, 'IN')
      ->condition('uid', 26, '!=')
      ->orderBy('name', 'ASC')
      ->execute()->fetchAll(PDO::FETCH_ASSOC);
    $datos['usuarios'] = $usuarios;
    $datos['email_user'] = $user->mail; # Traer email del usuario logueado
    $template = render_template('php', 'capacitacion.nueva_cotizacion', $datos);
    $this->throw_message('success', $template);
  }
}