<?php

class caja_grande_sys extends sys_tools
{
  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'reporte_base';
          try {
            $this->reporte_base($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'cargar_reporte_base');
          }
          break;
        case 'nueva_entrada';
          try {
            $this->nueva_entrada($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'nueva_entrada');
          }
          break;
        case 'nueva_salida';
          try {
            $this->nueva_salida($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'nueva_salida');
          }
          break;
        case 'capturar_salida_caja';
          try {
            $this->capturar_salida_caja($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_salida_caja');
          }
          break;
        case 'capturar_entrada_caja';
          try {
            $this->capturar_entrada_caja_($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_entrada_caja');
          }
          break;
      }
    }
  }

  /**
   * Reporte Base de la Caja Grande
   * @param $datos
   * @throws Exception
   */
  private function reporte_base($datos)
  {
    $fi = str_replace('/', '-', trim($datos->filter->start_date));
    $ff = str_replace('/', '-', trim($datos->filter->end_date));
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;

    $query = db_select('partners_caja_grande', 'jcc');
    $query->fields('jcc');
    $query->condition('jcc.movimiento_eliminado', '1', '!=');
    $query->addExpression(" if(cantidad >= 0, cantidad, '----')", 'entrada');
    $query->addExpression(" if(cantidad < 0, ABS(cantidad), '----')", 'salida');

    // Filtros
    if ($f_inicio == $f_final) {
      $f_final_same_day = $f_inicio + 86040;
      if ($datos->filter->start_date) {
        $query->condition('jcc.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
      }
    } else {
      if ($datos->filter->start_date) {
        $query->condition('jcc.created_at', array($f_inicio, $f_final), 'BETWEEN');
      }
    }

    // Filtro - Search Bar
    if ($datos->filter->search_bar != null) {
      $caja_or = db_or()
        ->condition('jcc.concepto', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('jcc.cantidad', '%' . $datos->filter->search_bar . '%', 'LIKE');
      $query->condition($caja_or);
    }


    $query->orderBy('id_movimiento', 'ASC');

    $query_datos = $query->execute();

    if (!$query_datos->rowCount()) {
      $query = db_select('partners_caja_grande', 'jcc');
      $query->fields('jcc');
      $query->condition('jcc.movimiento_eliminado', '1', '!=');
      $query->addExpression(" if(cantidad >= 0, cantidad, '----')", 'entrada');
      $query->addExpression(" if(cantidad < 0, ABS(cantidad), '----')", 'salida');
      $query->condition('jcc.created_at', $f_inicio, '<');
      $query->orderBy('id_movimiento', 'DESC');
      $query->range(0, 1);
      $query_datos = $query->execute();
    }

    $caja = [];
    while ($row = $query_datos->fetchAssoc()) {
      $last_row = db_select('partners_caja_grande', 'jcc');
      $last_row->addExpression('SUM(cantidad)', 'last_saldo');
      $last_row->condition('movimiento_eliminado', 1, '!=');
      $last_row->condition('id_movimiento', $row['id_movimiento'], '<');
      $last_saldo = $last_row->execute()->fetchField();
      if ($row['entrada'] != '----') {
        $new_saldo = $last_saldo + $row['entrada'];
      } else {
        $new_saldo = $last_saldo - $row['salida'];
      }

      $fecha = date('d/m/y', $row['created_at']);
      $entrada = array("data" => ($row['entrada'] != 0) ? number_format($row['entrada'], 2, '.', ',') : '-----', "class" => "text-right");
      $salida = array("data" => ($row['salida'] != 0) ? number_format($row['salida'], 2, '.', ',') : '-----', "class" => "text-right");
      $saldo = array("data" => number_format($new_saldo, 2, '.', ','), "class" => "text-right");
      $caja[] = array(
        "data" => array(
          $fecha,
          $row['concepto'],
          $entrada,
          $salida,
          $saldo,
        ),
        "data-id" => $row['id_movimiento'],
        "data-desc-mov" => $row['concepto']
      );
    }
    $header_cols = array(
      array("name" => "Fecha", "sortable" => 0),
      array("name" => "Concepto", "sortable" => 0),
      array("name" => "Entrada", "sortable" => 0),
      array("name" => "Salida", "sortable" => 0),
      array("name" => "Saldo", "sortable" => 0),
    );


    $header = sys_tools::sort_table('id_movimiento', 'ASC', $header_cols);


    $table = array(
      "header" => $header,
      "rows" => $caja,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_caja", "class" => array("table-sm"))
    );


    $result = theme('table', $table);

    $this->throw_message('success', $result);
  }

  /**
   * Genera la vista para capturar una nueva entrada a la caja
   */
  private function nueva_entrada()
  {
    $tpl = render_template('php', 'caja_grande.entrada');
    $this->throw_message('success', $tpl);
  }

  /**
   * Genera la vista para capturar una nueva salida de dinero a la caja
   */
  private function nueva_salida()
  {
    $tpl = render_template('php', 'caja_grande.salida');
    $this->throw_message('success', $tpl);
  }

  /**
   * Captura en caja un movimiento de salida de dinero.
   * @param $datos
   * @throws Exception
   */
  private function capturar_salida_caja($datos)
  {
    global $user;
    db_insert('partners_caja_grande')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'tipo_movimiento' => 2, # Salida de Dinero
        'concepto' => $datos->concepto_salida,
        'cantidad' => $datos->cantidad_salida
      ))
      ->execute();
    $this->register_log_actions('partners_caja_grande', 'insert', 'Nueva salida a la caja :' . $datos->concepto_salida);
    $this->throw_message('success', 'Salida de dinero en caja correctamente');

  }

  /**
   * Captura en caja un movimiento de entrada de dinero.
   * @param $datos
   * @throws Exception
   */
  private function capturar_entrada_caja_($datos)
  {
    global $user;
    db_insert('partners_caja_grande')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'tipo_movimiento' => 1, # Entrada de Dinero
        'concepto' => $datos->concepto_entrada,
        'cantidad' => $datos->cantidad_entrada
      ))
      ->execute();
    $this->register_log_actions('partners_caja_grande', 'insert', 'Nueva entrada a la caja :' . $datos->concepto_entrada);
    $this->throw_message('success', 'Entrada de dinero en caja correctamente');

  }
}
