<?php

class caja_sys extends sys_tools
{
  public function __construct($tipo, $data)
  {
    if (!$data) {
      $this->throw_message('error', 'No data');
    } else {
      switch ($tipo) {
        case 'reporte_base';
          try {
            $this->reporte_base($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'cargar_reporte_base');
          }
          break;
        case 'new_reigstro';
          try {
            $this->new_reigstro($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'capturar_new_reigstro');
          }
          break;
        case 'autorizar_salida';
          try {
            $this->autorizar_salida($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'autorizar_salida_caja');
          }
          break;
        case 'editar_movimiento';
          try {
            $this->editar_movimiento($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'editar_movimiento_caja');
          }
          break;
        case 'eliminar_movimiento';
          try {
            $this->eliminar_movimiento($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'eliminar_movimiento');
          }
          break;
        case 'reactivate_movimiento';
          try {
            $this->reactivate_movimiento($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'reactivate_movimiento');
          }
          break;
        case 'retiro_caja_grande';
          try {
            $this->retiro_caja_grande($data);
          } catch (Exception $e) {
            $this->throw_fatal_error($e, 'retiro_caja_grande');
          }
          break;
      }
    }
  }

  private function reporte_base($datos)
  {
    $fi = str_replace('/', '-', trim($datos->filter->start_date));
    $ff = str_replace('/', '-', trim($datos->filter->end_date));
    $f_inicio = strtotime($fi);
    $f_final = strtotime($ff) + 86040;

    $query = db_select('partners_caja', 'pc');
    $query->fields('pc');
    $query->condition('pc.movimiento_eliminado', '1', '!=');
    $query->addExpression(" if(cantidad >= 0, cantidad, '----')", 'entrada');
    $query->addExpression(" if(cantidad < 0, ABS(cantidad), '----')", 'salida');

    // Filtros
    if ($f_inicio == $f_final) {
      $f_final_same_day = $f_inicio + 86040;
      if ($datos->filter->start_date) {
        $query->condition('pc.created_at', array($f_inicio, $f_final_same_day), 'BETWEEN');
      }
    } else {
      if ($datos->filter->start_date) {
        $query->condition('pc.created_at', array($f_inicio, $f_final), 'BETWEEN');
      }
    }

    // Filtro - Search Bar
    if ($datos->filter->search_bar != null) {
      $caja_or = db_or()
        ->condition('pc.concepto', '%' . $datos->filter->search_bar . '%', 'LIKE')
        ->condition('pc.cantidad', '%' . $datos->filter->search_bar . '%', 'LIKE');
      $query->condition($caja_or);
    }


    $query->orderBy($datos->sort->sort_by, $datos->sort->order);

    $query_datos = $query->execute();

    if (!$query_datos->rowCount()) {
      $query = db_select('partners_caja', 'pc');
      $query->fields('pc');
      $query->condition('pc.movimiento_eliminado', '1', '!=');
      $query->addExpression(" if(cantidad >= 0, cantidad, '----')", 'entrada');
      $query->addExpression(" if(cantidad < 0, ABS(cantidad), '----')", 'salida');
      $query->condition('pc.created_at', $f_inicio, '<');
      $query->orderBy('id_movimiento', 'DESC');
      $query->range(0, 1);
      $query_datos = $query->execute();
    }

    while ($row = $query_datos->fetchAssoc()) {
      $last_row = db_select('partners_caja', 'pc');
      $last_row->addExpression('SUM(cantidad)', 'last_saldo');
      $last_row->condition('movimiento_eliminado', 1, '!=');
      $last_row->condition('id_movimiento', $row['id_movimiento'], '<');
      $last_saldo = $last_row->execute()->fetchField();
      if ($row['entrada'] != '----') {
        $new_saldo = $last_saldo + $row['entrada'];
      } else {
        $new_saldo = $last_saldo - $row['salida'];
      }

      $fecha = date('d/m/y', $row['created_at']);
      $entrada = array("data" => ($row['entrada'] != 0) ? number_format($row['entrada'], 2, '.', ',') : '-----', "class" => "text-right");
      $salida = array("data" => ($row['salida'] != 0) ? number_format($row['salida'], 2, '.', ',') : '-----', "class" => "text-right");
      $saldo = array("data" => number_format($new_saldo, 2, '.', ','), "class" => "text-right");

      if ($row['cantidad'] < 0) {
        if ($row['autorizado'] != 0) {
          if (user_access('caja_administrador')) {
            $autorizado = array("data" => "Si", "data-autorizado-por" => user_load($row['autorizado'])->name, "class" => array("text-center status-green vista_user_autorizado"));
          } else {
            $autorizado = array("data" => "Si", "class" => array("text-center status-green"));
          }
        } else {
          if (user_access('caja_administrador')) {
            $autorizado = array("data" => "No", "class" => array("text-center status-red cursor-pointer autorizar_salida_caja"));
          } else {
            $autorizado = array("data" => "No", "class" => array("text-center status-red"));
          }
        }
      } else {
        $autorizado = array("data" => "N/A", "class" => array("text-center"));
      }

      $borrar = array("data" => 'Eliminar', "class" => array("cursor-pointer", "text-center", "eliminar_movimiento"));
      $editar = array("data" => 'Editar', "class" => array("cursor-pointer", "text-center", "editar_movimiento"));

      if (user_access('caja_administrador')) {
        $caja[] = array(
          "data" => array(
            $fecha,
            $row['concepto'],
            $entrada,
            $salida,
            $saldo,
            $autorizado,
            $editar,
            $borrar,
          ),
          "data-id" => $row['id_movimiento'],
          "data-desc-mov" => $row['concepto']
        );

      } else {
        $caja[] = array(
          "data" => array(
            $fecha,
            $row['concepto'],
            $entrada,
            $salida,
            $saldo,
            $autorizado
          ),
          "data-id" => $row['id_movimiento']
        );
      }


    }


    if (user_access('caja_administrador')) {
      // Header -- Sort
      $header_cols = array(
        array("name" => "Fecha", "sortable" => 0),
        array("name" => "Concepto", "sortable" => 0),
        array("name" => "Entrada", "sortable" => 0),
        array("name" => "Salida", "sortable" => 0),
        array("name" => "Saldo", "sortable" => 0),
        array("name" => "Autorizado", "sortable" => 0),
        array("name" => 'Editar', "sortable" => 0),
        array("name" => 'Eliminar', "sortable" => 0)
      );
    } else {
      $header_cols = array(
        array("name" => "Fecha", "sortable" => 0),
        array("name" => "Concepto", "sortable" => 0),
        array("name" => "Entrada", "sortable" => 0),
        array("name" => "Salida", "sortable" => 0),
        array("name" => "Saldo", "sortable" => 0),
        array("name" => "Autorizado", "sortable" => 0)
      );

    }


    $header = sys_tools::sort_table($datos->sort->sort_by, $datos->sort->order, $header_cols);


    $table = array(
      "header" => $header,
      "rows" => $caja,
      "sticky" => false,
      "attributes" => array("id" => "table_reporteador_caja", "class" => array("table-sm"))
    );


    $result = theme('table', $table);

    echo $result;

  }

  /**
   * @param $datos ->type 1: Entrada, 2:Salida, 3:Corte
   */
  private function new_reigstro($datos)
  {
    global $user;
    if ($datos->type == 1) {
      db_insert('partners_caja')
        ->fields(array(
          'created_at' => REQUEST_TIME,
          'created_by' => $user->uid,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid,
          'concepto' => $datos->concepto_entrada,
          'cantidad' => strtr($datos->cantidad_entrada, array(',' => ''))
        ))
        ->execute();
      $this->register_log_actions('partners_caja', 'insert', 'Nueva entrada a la caja :' . $datos->concepto_entrada . ' | ' . $datos->cantidad_entrada);
      $this->throw_message('success', 'Entrada de dinero en caja correctamente');
    } else if ($datos->type == 2) {
      db_insert('partners_caja')
        ->fields(array(
          'created_at' => REQUEST_TIME,
          'created_by' => $user->uid,
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid,
          'concepto' => $datos->concepto_entrada,
          'cantidad' => (strtr($datos->cantidad_salida, array(',' => '')) * -1)
        ))
        ->execute();
      $this->register_log_actions('partners_caja', 'insert', 'Nueva salida de la caja :' . $datos->concepto_entrada . ' | ' . $datos->cantidad_salida);
      $this->throw_message('success', "Salida de dinero de caja realizada correctamente");
    } else if ($datos->type == 3) {
      $total_cant = db_select('partners_caja', 'pc');
      $total_cant->addExpression("SUM(cantidad)");
      $total_cant->condition('pc.movimiento_eliminado', 1, '!=');
      $cant = $total_cant->execute()->fetchField();
      $corte = -(($cant) - $datos->cantidad_corte_caja);

      $check_corte = db_select('partners_caja', 'pc')
        ->fields('pc', array('cantidad'))
        ->condition('pc.cantidad', 0, '<')
        ->condition('pc.autorizado', 0)
        ->condition('pc.movimiento_eliminado', 1, '!=')
        ->execute()->fetchField();
      if ($check_corte) {
        $this->throw_message('error', "Deben de autorizar todas las salidas de la caja para poder realizar el corte de caja. Pídele a un supervisor que revise las salidas de la caja.");
      } else {
        db_insert('partners_caja')
          ->fields(array(
            'created_by' => $user->uid,
            'created_at' => REQUEST_TIME,
            'updated_by' => $user->uid,
            'updated_at' => REQUEST_TIME,
            'concepto' => 'Corte por diferencia',
            'cantidad' => $corte,
            'corte' => 1
          ))
          ->execute();
        $this->register_log_actions('partners_caja', 'insert', 'Nueva corte de caja : Corte por diferencia  | ' . $corte);
        $this->throw_message('success', "Corte de caja realizado correctamente");
      }


    }


  }

  /**
   * @param $datos object de datos a utilizar: id_movimiento,user_nip. Se usa una función del system para autorizar al
   *   usuario mediante su NIP.
   */
  private function autorizar_salida($datos)
  {
    $d = $this->auth_user_nip($datos->user_nip);
    if ($d) {
      db_update('partners_caja')
        ->fields(array(
          'autorizado' => $d[0]
        ))
        ->condition('id_movimiento', $datos->id_movimiento)
        ->execute();
      $this->throw_message('success', 'Movimiento Autorizado por: ' . $d[1]);
      $this->register_log_actions('partners_caja', 'update', 'Movimiento ' . $datos->id_movimiento . ' Autorizado por ' . $d[1]);
    } else {
      $this->throw_message('error', 'NIP Incorrecto.');
    }
  }


  /**
   * @param $datos ->type 1: Vista, 2: Update
   * @param $datos ->type_movimiento 1: Entrada, 2: Salida, 3: Corte
   */
  private function editar_movimiento($datos)
  {
    if ($datos->type == 1) {
      $get_movimiento = db_select('partners_caja', 'pc')
        ->fields('pc')
        ->condition('id_movimiento', $datos->id_movimiento);
      $movimiento = $get_movimiento->execute()->fetchAssoc();
      $data['movimiento'] = $movimiento;

      $template = render_template('php', 'caja.editar_movimiento', $data);

      $this->throw_message('success', $template);
    } else if ($datos->type == 2) {
      global $user;
      db_update('partners_caja')
        ->fields(array(
          'updated_at' => REQUEST_TIME,
          'updated_by' => $user->uid,
          'concepto' => $datos->concepto_movimiento,
          'cantidad' => ($datos->type_movimiento == 2) ? strtr(($datos->cantidad_movimiento * -1), array(',' => '')) : strtr($datos->cantidad_movimiento, array(',' => ''))
        ))
        ->condition('id_movimiento', $datos->id_movimiento)
        ->execute();
      $this->register_log_actions('partners_caja', 'update', 'Se actualizó el movimiento ' . $datos->id_movimiento . ':' . $datos->concepto_movimiento . ' | ' . $datos->cantidad_movimiento);
      $this->throw_message('success', 'Movimiento editado correctamente.');


    }

  }

  private function eliminar_movimiento($datos)
  {
    db_update('partners_caja')
      ->fields(array(
        'movimiento_eliminado' => 1
      ))
      ->condition('id_movimiento', $datos)
      ->execute();

    $get_mov = db_select('partners_caja', 'pc');
    $get_mov->addField('pc', 'id_movimiento_caja_grande');
    $get_mov->condition('id_movimiento', $datos);
    $mov = $get_mov->execute()->fetchField();

    if($mov){
      db_update('partners_caja_grande')
        ->fields(array(
          'movimiento_eliminado' => 1
        ))
        ->condition('id_movimiento', $mov)
        ->execute();
    }
    $this->throw_message('success', 'Eliminado correctamente.');
    $this->register_log_actions('partners_caja', 'delete', 'Se eliminó el movimiento de caja: ' . $datos);
  }

  private function reactivate_movimiento($datos)
  {
    db_update('partners_caja')
      ->fields(array(
        'movimiento_eliminado' => 0
      ))
      ->condition('id_movimiento', $datos)
      ->execute();

    $get_mov = db_select('partners_caja', 'pc');
    $get_mov->addField('pc', 'id_movimiento_caja_grande');
    $get_mov->condition('id_movimiento', $datos);
    $mov = $get_mov->execute()->fetchField();

    if($mov){
      db_update('partners_caja_grande')
        ->fields(array(
          'movimiento_eliminado' => 0
        ))
        ->condition('id_movimiento', $mov)
        ->execute();
    }

    $this->throw_message('success', 'Reactivado correctamente.');
    $this->register_log_actions('partners_caja', 'update', 'Se reactivó el movimiento de caja: ' . $datos);
  }

  /**
   * Método para mover una cantidad de dinero a la caja grande.
   * @param $datos
   */
  private function retiro_caja_grande($datos)
  {
    global $user;

    # Capturar una entrada en caja grande
    $id_caja_grande = db_insert('partners_caja_grande')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'tipo_movimiento' => 3, # 3 = Movimiento caja chica a caja grande
        'concepto' => 'Retiro de caja Chica',
        'cantidad' => $datos->cantidad_retiro_caja
      ))
      ->execute();


    # Capturar una salida en caja chica
    db_insert('partners_caja')
      ->fields(array(
        'created_at' => REQUEST_TIME,
        'created_by' => $user->uid,
        'updated_at' => REQUEST_TIME,
        'updated_by' => $user->uid,
        'concepto' => 'Retiro de dinero',
        'cantidad' => ($datos->cantidad_retiro_caja * -1),
        'id_movimiento_caja_grande' => $id_caja_grande
      ))
      ->execute();
    $this->register_log_actions('partners_caja', 'insert', 'Nueva retiro a caja grande :' . $datos->cantidad_retiro_caja);
    $this->throw_message('success', 'Retiro realizado correctamente!');
  }
}