<?php

class boletin_sys extends sys_tools
{

    public function __construct($tipo, $data)
    {
        if (!$data) {
            $this->throw_message('error', 'No data');
        } else {
            switch ($tipo) {
                case 'boletin_preview':
                    try {
                        $this->boletin_preview($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'boletin_preview');
                    }
                    break;
                case 'boletin_init_data':
                    try {
                        $this->boletin_init_data($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'boletin_init_data');
                    }
                    break;
                case 'get_productos_data':
                    try {
                        $this->get_productos_data($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'get_productos_data');
                    }
                    break;
                case 'get_main_product_info':
                    try {
                        $this->get_main_product_info($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'get_main_product_info');
                    }
                    break;
                case 'upload_boletin_imagen':
                    try {
                        $this->upload_boletin_imagen($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'upload_boletin_imagen');
                    }
                    break;
                case 'boletin_get_grupos_mailrelay':
                    try {
                        $this->boletin_get_grupos_mailrelay($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'boletin_get_grupos_mailrelay');
                    }
                    break;
                case 'enviar_boletin':
                    try {
                        $this->enviar_boletin($data);
                    } catch (Exception $e) {
                        $this->throw_fatal_error($e, 'enviar_boletin');
                    }
                    break;
            }
        }
    }


    /**
     * Regresa un array de todas las categorias de la tienda.
     * @param int $vid
     * @return array
     */
    private function _taxonomy_get_real_tree($vid = 4)
    {
        $result_tree = array();
        $terms = array();
        foreach (taxonomy_get_tree($vid) as $term) {
            if (isset($terms[$term->tid])) {
                $term->children = $terms[$term->tid]->children;
                $terms[$term->tid] = $term;
            } else {
                $terms[$term->tid] = $term;
            }

            if ($term->depth === 0) {
                $result_tree[$term->tid] = &$terms[$term->tid];
                continue;
            }

            foreach ($term->parents as $tid) {
                if ($tid) {
                    if (!isset($terms[$tid])) {
                        $terms[$tid] = new stdClass();
                    }
                    $terms[$tid]->children[$term->tid] = &$terms[$term->tid];
                }
            }
        }

        $taxonomy_tree = [];
        foreach ($result_tree as $item) {
            $a = array(
                "tid" => $item->tid,
                "name" => $item->name
            );

            if ($item->children) {
                $b = [];
                foreach ($item->children as $child) {
                    $b[] = array(
                        "tid" => $child->tid,
                        "name" => $child->name
                    );
                }

                $a['children'] = $b;

            }
            $taxonomy_tree[] = $a;
        }

        return $taxonomy_tree;
    }

    /**
     * Carga una imagen al servidor para ser utilizada de una manera temporal para generar la preview del boletin.
     * @param $datos
     */
    private function upload_boletin_imagen($datos)
    {

        $path = HOME_SERVER . '/public_html/intranet/sites/default/files/boletin_tmp/';
        $img = $datos['img'];
        $tmp = $datos['tmp'];
        $final_image = (rand(1000, 1000000) + REQUEST_TIME) . $img;

        $path = $path . strtolower($final_image);

        if (move_uploaded_file($tmp, $path)) {
            $this->throw_message('success', 'sites/default/files/boletin_tmp/' . $final_image);
        } else {
            $this->throw_message('error', 'Ocurrio un error al subir la imagen al servidor.');
        }
    }

    /**
     * Imprime una vista Previa de como va quedando el boletín con cierta información
     * @param $datos
     */
    private function boletin_preview($datos)
    {
        $data = [];

        // Generar un placeholder en caso de que no se tenga seleccioando nada.
        $placeholder = array(
            "name" => "Producto Principal",
            "img" => file_create_url('sites/default/files/140x140_placeholder.png'),
            "sku" => 'XXX',
            "stock" => 1,
            "price" => number_format(0, 2)
        );

        if (!empty($datos->products)) {
            // Convertir a array's para pasarlo al render
            $productos = [];
            foreach ($datos->products as $producto) {
                $productos[] = (array)$producto;
            }
            $pieces = array_chunk($productos, ceil(count($productos) / 2));
            $data['productos_first_row'] = $pieces[0];
            $data['productos_second_row'] = $pieces[1];
        } else {
            // Enviar info de relleno si esta vacio los productos.
            for ($i = 0; $i < 4; $i++) {
                $data['productos_first_row'][] = $placeholder;
                $data['productos_second_row'][] = $placeholder;
            }
        }

        if (!empty($datos->mainProduct) || $datos->mainProduct != null) {
            $data['main_product'] = (array)$datos->mainProduct;

        } else {
            // Enviar info de relleneo si esta vacio el main Product
            $data['main_product'] = $placeholder;
        }


        if (!empty($datos->mainBannerImg) || $datos->mainBannerImg != null) {
            $data['main_banner_img'] = file_create_url($datos->mainBannerImg);
        } else {
            $data['main_banner_img'] = file_create_url('sites/default/files/600x480_placeholder.png');
        }

        if (!empty($datos->mainBannerUrl) || $datos->mainBannerUrl != null) {
            $data['main_banner_url'] = $datos->mainBannerUrl;
        } else {
            $data['main_banner_url'] = '#';
        }


        if (!empty($datos->secondaryBannerImg) || $datos->secondaryBannerImg != null) {
            $data['secondary_banner_img'] = file_create_url($datos->secondaryBannerImg);
        } else {
            $data['secondary_banner_img'] = file_create_url('sites/default/files/600x80_placeholder.png');
        }

        if (!empty($datos->secondaryBannerUrl) || $datos->secondaryBannerUrl != null) {
            $data['secondary_banner_url'] = $datos->secondaryBannerUrl;
        } else {
            $data['secondary_banner_url'] = '#';
        }

        if (!empty($datos->customContactBannerImg) || $datos->customContactBannerImg != null) {
            $data['custom_contact_banner_img'] = file_create_url($datos->customContactBannerImg);
        } else {
            $data['custom_contact_banner_img'] = file_create_url('sites/default/files/600x300_placeholder.png');
        }


        if (!empty($datos->leyendaBoletin) || $datos->leyendaBoletin != null) {
            $data['leyenda_boletin'] = $datos->leyendaBoletin;
        } else {
            $data['leyenda_boletin'] = '';
        }


        $tpl = render_template('php', 'boletin.boletin_preview', $data);
        $this->throw_message('success', json_encode($tpl));
    }


    /**
     * Metodo para trucar una string y ponerle al final 3 puntos...
     * @param $text
     * @param $length
     * @return null|string|string[]
     */
    private function truncate($text, $length)
    {
        $length = abs((int)$length);
        if (strlen($text) > $length) {
            $text = preg_replace("/^(.{1,$length})(\s.*|$)/s", '\\1...', $text);
        }
        return ($text);
    }


    /**
     * Regresa un JSON con todas las categorias de la tienda disponibles para crear la UI.
     */
    private function boletin_init_data()
    {
        $taxonomy_tree = $this->_taxonomy_get_real_tree();
        $data['tree'] = $taxonomy_tree;

        // Pa traer todos los productos
        $query = new EntityFieldQuery;

        $query = $query->entityCondition('entity_type', 'commerce_product')->execute();

        $lista_productos = [];
        foreach ($query['commerce_product'] as $key => $entity) {
            $product_id = $entity->product_id;
            $product_wrapper = entity_metadata_wrapper('commerce_product', commerce_product_load($product_id));

            // Me debe de omitir todos aquellos productos que no cuenten con stock y los que esten desactivados.
            $product_stock = $product_wrapper->commerce_stock->value();
            $product_status = $product_wrapper->status->value();
            if ($product_stock > 0 && $product_status == 1) {
                $lista_productos[] = array(
                    "product_id" => $product_id,
                    # "name" => $product_wrapper->title->value(),
                    "name" => $product_wrapper->field_product_boletin_titulo->value(),
                    "price" => number_format(($product_wrapper->commerce_price->amount->value() / 100), 2)
                );
            }
        }

        $data['list_products'] = $lista_productos;

        $this->throw_message('success', json_encode($data));
    }


    /**
     * Busca los grupos que existen en mailrelay, para que despues seleccionen a cual grupo desean enviar el boletin.
     */
    private function boletin_get_grupos_mailrelay()
    {
        $hostname = 'https://pcpartners.ip-zone.com/ccm/admin/api/version/2/&type=json';
        $apiKey = 'McKtJV4SQsyRGB2wDgKS2nvNyJHXEBDReOAnk451';
        $curl = curl_init($hostname);
        $postData = array(
            'function' => 'getGroups',
            'apiKey' => $apiKey
        );


        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($postData));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        $json = curl_exec($curl);
        $result = json_decode($json);

        if ($result->status == 0) {
            $this->throw_message('error', 'No se pudieron cargar los grupos de Mailrelay.');
        } else {
            $this->throw_message('success', $result->data);
        }
    }


    /**
     * Enviar el boletín mediante la API de mailrelay.
     * @param $datos {asuntoBoletin, grupoIDMailrelay, htmlIframe}
     */
    private function enviar_boletin($datos)
    {
        $hostname = 'https://pcpartners.ip-zone.com/ccm/admin/api/version/2/&type=json';
        $apiKey = 'McKtJV4SQsyRGB2wDgKS2nvNyJHXEBDReOAnk451';
        $curlCampaign = curl_init($hostname);


        // Primero hay que dar de alta la campaña
        $postDataCampaign = array(
            'function' => 'addCampaign',
            'apiKey' => $apiKey,
            'subject' => $datos->asuntoBoletin,
            'mailboxFromId' => 1,
            'mailboxReplyId' => 1,
            'mailboxReportId' => 1,
            'emailReport' => true,
            'groups' => [(int)$datos->grupoIDMailrelay],
            'html' => html_entity_decode($datos->htmlIframe),
            'urlToken' => false,
            'packageId' => 6 // El paquete que se usa para enviar emails, en este caso es el free con los 75k de correos al mes
        );


        curl_setopt($curlCampaign, CURLOPT_POST, true);
        curl_setopt($curlCampaign, CURLOPT_POSTFIELDS, http_build_query($postDataCampaign));
        curl_setopt($curlCampaign, CURLOPT_RETURNTRANSFER, 1);

        $jsonCampaign = curl_exec($curlCampaign);
        $resultCampaign = json_decode($jsonCampaign);

        if ($resultCampaign->status == 0) {
            $this->throw_message('error', 'Ocurrió un error al crear la campaña en Mailrelay.');
        } else {

            $campaignId = $resultCampaign->data;

            $curlSendCampaign = curl_init($hostname);
            $postData = array(
                'function' => 'sendCampaign',
                'apiKey' => $apiKey,
                'id' => $campaignId,
            );

            curl_setopt($curlSendCampaign, CURLOPT_POST, true);
            curl_setopt($curlSendCampaign, CURLOPT_POSTFIELDS, http_build_query($postData));
            curl_setopt($curlSendCampaign, CURLOPT_RETURNTRANSFER, 1);

            $json = curl_exec($curlSendCampaign);
            $result = json_decode($json);

            if ($result->status == 0) {
                $this->throw_message('error', 'Ocurrió un error al enviar la campaña en Mailrelay.');
            } else {
                $this->throw_message('success', 'Boletín Enviado correctamente!');
            }

        }
    }


    /**
     * En base a un ID del producto, trae toda la información de dicho producto.
     * @param $id_product
     */
    private function get_main_product_info($id_product)
    {

        // Para traer la vista de producto
        $query = new EntityFieldQuery();
        $result = $query->entityCondition('entity_type', 'node')
            ->entityCondition('bundle', 'vista_producto')
            ->execute();
        $vistas_producto = node_load_multiple(array_keys($result['node']));

        $url_producto = [];
        foreach ($vistas_producto as $vista_producto) {
            if ($vista_producto->field_product['und'][0]['product_id'] == $id_product) {
                $url_producto[$vista_producto->field_product['und'][0]['product_id']] =
                    file_create_url(drupal_get_path_alias("node/" . $vista_producto->nid));
                break;
            }
        }


        // Pa traer todos los productos y despues buscar uno solo en especifico
        $query = new EntityFieldQuery;

        $query = $query->entityCondition('entity_type', 'commerce_product')->execute();

        $main_producto = [];
        foreach ($query['commerce_product'] as $key => $entity) {
            $product_id = $entity->product_id;
            $product_wrapper = entity_metadata_wrapper('commerce_product', commerce_product_load($product_id));

            if ($id_product == $product_id) {
                // Cree un estilo de imagen en drupal para que el main product me las regrese mas grande.
                $image = image_style_url('300x300_boletin', $product_wrapper->field_product_image->value()[0]['uri']);

                // Aplicar un truncate al nombre para que todas ocupen el mismo tamaño
                #$name = $this->truncate($product_wrapper->title->value(), 30);
                $name = $product_wrapper->field_product_boletin_titulo->value();
                $main_producto = array(
                    "name" => $name,
                    "desc" => $this->truncate(strip_tags($product_wrapper->field_body->value->value()), 130),
                    "url" => $url_producto[$product_id],
                    "img" => $image,
                    "sku" => $product_wrapper->sku->value(),
                    "stock" => $product_wrapper->commerce_stock->value(),
                    "price" => number_format(($product_wrapper->commerce_price->amount->value() / 100), 2)
                );
                break;
            }
        }


        $this->throw_message('success', $main_producto);


    }

    /**
     * Busca los productos en base a las categorias y regresa un array de productos aleatorios.
     * @param $categorias
     */
    private function get_productos_data($categorias)
    {
        // Array con la posible lista de productos que iran en el boletin
        $posible_lista_productos = [];
        if (is_array($categorias)) {

            // Para traer la vista de producto
            $query = new EntityFieldQuery();
            $result = $query->entityCondition('entity_type', 'node')
                ->entityCondition('bundle', 'vista_producto')
                ->execute();
            $vistas_producto = node_load_multiple(array_keys($result['node']));


            $productos_from_categoria = [];
            $urls_productos = [];
            foreach ($vistas_producto as $vista_producto) {
                $found = false;
                foreach ($vista_producto->field_category as $key => $categoria_vista_producto) {
                    foreach ($categoria_vista_producto as $value) {
                        if (in_array($value['tid'], $categorias)) $found = true;
                    }
                }
                if ($found) {
                    $productos_from_categoria[] = $vista_producto->field_product['und'][0]['product_id'];
                    $urls_productos[$vista_producto->field_product['und'][0]['product_id']] =
                        file_create_url(drupal_get_path_alias("node/" . $vista_producto->nid));
                }
            }

            // Este arreglo tiene todos los ID de producto que pertenecen a la categoria de $tid_propuesto.
            // Con este arreglo, ahora simplemente es sacar toda la información que se necesita de cada producto,
            // con su respectivas validaciones/restricciones.
            #var_dump($productos_from_categoria);
            $productos_restantes_por_comparar = $productos_from_categoria;


            // Pa traer todos los productos
            $query = new EntityFieldQuery;

            $query = $query->entityCondition('entity_type', 'commerce_product')->execute();

            foreach ($query['commerce_product'] as $key => $entity) {
                $product_id = $entity->product_id;
                $product_wrapper = entity_metadata_wrapper('commerce_product', commerce_product_load($product_id));

                if (count($productos_restantes_por_comparar)) {
                    if (in_array($product_id, $productos_restantes_por_comparar)) {
                        // Si lo encontro, entonces este producto debe de ir en el array final de los productos
                        // que iran en el boletin.

                        // Me debe de omitir todos aquellos productos que no cuenten con stock y los que estén desactivados.
                        $product_stock = $product_wrapper->commerce_stock->value();
                        $product_status = $product_wrapper->status->value();
                        if ($product_stock > 0 && $product_status == 1) {
                            // Cree un estilo de imagen en drupal para que todas me las regrese del mismo tamaño.
                            $image = image_style_url('140x140_boletin', $product_wrapper->field_product_image->value()[0]['uri']);

                            // Aplicar un truncate al nombre para que todas ocupen el mismo tamaño
                            #$name = $this->truncate($product_wrapper->title->value(), 30);
                            $name = $product_wrapper->field_product_boletin_titulo->value();
                            $posible_lista_productos[] = array(
                                "name" => $name,
                                "desc" => $this->truncate(strip_tags($product_wrapper->field_body->value->value()), 130),
                                "url" => $urls_productos[$product_id],
                                "img" => $image,
                                "sku" => $product_wrapper->sku->value(),
                                "stock" => $product_stock,
                                "price" => number_format(($product_wrapper->commerce_price->amount->value() / 100), 2)
                            );
                        }


                        // Eliminar este product_id del array de los productos de una categoria para que ya no lo vuelva
                        // a tomar en cuenta.
                        if (($key = array_search($product_id, $productos_restantes_por_comparar)) !== false) {
                            unset($productos_restantes_por_comparar[$key]);
                        }
                    }
                } else {
                    // Cuando ya haya encontrado todos los productos, romper el ciclo porque ya no tiene caso de que
                    // de vueltas de mas.
                    break;
                }
            }

        }

        shuffle($posible_lista_productos);

        // Si hay mas de 8 productos, entonces sacar aleatoriamente un maximo de 8 productos,
        // Si hay 8 productos o menos, basicamente pasar la posible lista de productos completa.
        if (count($posible_lista_productos) <= 8) {
            // Pasar todos
            $product_list = $posible_lista_productos;

        } else {
            // Solamente seleccionar 8 aleatoriamente
            $rand_keys = array_rand($posible_lista_productos, 8);
            $product_list = [];
            for ($i = 0; $i < 8; $i++) {
                $product_list[] = $posible_lista_productos[$rand_keys[$i]];
            }
        }


        $this->throw_message('success', json_encode($product_list));
    }

}