<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 09/02/2019
 * Time: 12:50 PM
 */

namespace Partners\Vehiculo;


use Exception;
use Partners\Utils\JsonMessageHelper;
use Partners\Utils\PartnersLogger;
use Partners\Utils\PartnersRouter;

/**
 * Class VehiculoRouter
 * @package Partners\Vehiculo
 */
class VehiculoRouter extends PartnersRouter
{

  protected function routes()
  {
    $VehiculoController = new VehiculoController();
    try {
      switch ($this->path) {
        case 'reporte_base':
          $VehiculoController->reporteBase($this->data);
          break;
        case 'nuevo_vehiculo':
          $VehiculoController->vistaNuevoVehiculo();
          break;
        case 'capturar_vehiculo':
          $VehiculoController->capturarVehiculo($this->data);
          break;
        case 'nuevo_gasto':
          $VehiculoController->vistaNuevoGasto();
          break;
        case 'lista_vehiculos':
          $VehiculoController->listaVehiculos();
          break;
        case 'capturar_gasto':
          $VehiculoController->capturarGasto($this->data);
          break;
        case 'nuevo_seguro':
          $VehiculoController->vistaNuevoSeguro();
          break;
        case 'capturar_seguro':
          $VehiculoController->capturarSeguro($this->data);
          break;
        case 'nuevo_km':
          $VehiculoController->vistaNuevoKm();
          break;
        case 'capturar_km':
          $VehiculoController->capturarKm($this->data);
          break;
        case 'nueva_afinacion':
          $VehiculoController->vistaNuevaAfinacion();
          break;
        case 'capturar_afinacion':
          $VehiculoController->capturarAfinacion($this->data);
          break;
        case 'nuevo_refrendo':
          $VehiculoController->vistaNuevoRefrendo();
          break;
        case 'capturar_refrendo':
          $VehiculoController->capturarRefrendo($this->data);
          break;
        case 'vista_vehiculo':
          $VehiculoController->vistaVehiculo($this->data);
          break;
        case 'vista_kilometraje':
          $VehiculoController->vistaKilometraje();
          break;
        case 'reporte_kilometraje':
          $VehiculoController->reporteKilometraje($this->data);
          break;
        case 'vista_gasto_anual':
          $VehiculoController->vistaGastoAnual();
          break;
        case 'reporte_gasto_anual':
          $VehiculoController->reporteGastoAnual($this->data);
          break;
        case 'load_obs':
          $VehiculoController->loadObs($this->data);
          break;
        case 'vista_entrada_vales':
          $VehiculoController->vistaNuevaEntradaVales();
          break;
        case 'capturar_entrada_vales':
          $VehiculoController->capturarEntradaVales($this->data);
          break;
        case 'vista_nuevo_vale':
          $VehiculoController->vistaNuevoVale();
          break;
        case 'capturar_vale':
          $VehiculoController->capturarVale($this->data);
          break;
        case 'vista_vales':
          $VehiculoController->vistaVales();
          break;
        case 'reporte_vales':
          $VehiculoController->reporteVales($this->data);
          break;
        case 'lista_vales_vehiculo':
          $VehiculoController->listValesVehiculo($this->data);
          break;
        case 'mostrar_archivo':
          $VehiculoController->showPdfFile($this->data);
          break;
        case 'vista_reporte_vales':
          $VehiculoController->vistaReporteVales();
          break;
        default:
          JsonMessageHelper::Error("No se encontró la ruta que buscabas");
      }
    } catch (Exception $e) {
      PartnersLogger::Error($e, $this->path);
    }
  }


}