<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 09/02/2019
 * Time: 12:50 PM
 */

namespace Partners\Vehiculo;


use Partners\Utils\BaseEntityInterface;

/**
 * Class Vehiculo
 * @package Partners\Vehiculo
 */
class Vehiculo implements BaseEntityInterface
{
  /**
   * @var int
   */
  private $idVehiculo = 0;

  /**
   * @var int
   */
  private $createdAt = 0;
  /**
   * @var int
   */
  private $createdBy = 0;
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;

  /**
   * @var string
   */
  private $nombreVehiculo = "";
  /**
   * @var int
   */
  private $anoVehiculo = 0;
  /**
   * @var string
   */
  private $placaVehiculo = "";
  /**
   * @var string
   */
  private $serieVehiculo = "";

  /**
   * @var int
   */
  private $gastoAnual = 0;

  /**
   * @var Seguro
   */
  private $Seguro;

  /**
   * @var Refrendo
   */
  private $Refrendo;

  /**
   * @var Kilometraje
   */
  private $Kilometraje;

  /**
   * @var int
   */
  private $ultimoKmAfinacion = 0;

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Vehiculo.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * Vehiculo constructor.
   * @param $datosVehiculo
   */
  public function __construct($datosVehiculo)
  {
    if (isset($datosVehiculo['id_vehiculo'])) {
      $this->idVehiculo = (int)$datosVehiculo['id_vehiculo'];
    }
    if (isset($datosVehiculo['created_at'])) {
      $this->createdAt = (int)$datosVehiculo['created_at'];
    }
    if (isset($datosVehiculo['created_by'])) {
      $this->createdBy = (int)$datosVehiculo['created_by'];
    }
    if (isset($datosVehiculo['updated_at'])) {
      $this->updatedAt = (int)$datosVehiculo['updated_at'];
    }
    if (isset($datosVehiculo['updated_by'])) {
      $this->updatedBy = (int)$datosVehiculo['updated_by'];
    }
    if (isset($datosVehiculo['nombre_vehiculo'])) {
      $this->nombreVehiculo = (string)$datosVehiculo['nombre_vehiculo'];
    }
    if (isset($datosVehiculo['ano_vehiculo'])) {
      $this->anoVehiculo = (int)$datosVehiculo['ano_vehiculo'];
    }
    if (isset($datosVehiculo['placa_vehiculo'])) {
      $this->placaVehiculo = (string)$datosVehiculo['placa_vehiculo'];
    }
    if (isset($datosVehiculo['serie_vehiculo'])) {
      $this->serieVehiculo = (string)$datosVehiculo['serie_vehiculo'];
    }
    if (isset($datosVehiculo['ultimo_km_afinacion'])) {
      $this->ultimoKmAfinacion = (int)$datosVehiculo['ultimo_km_afinacion'];
    }

    foreach ($datosVehiculo as $key => $val) {
      switch ($key) {
        case 'id_vehiculo':
        case 'created_at':
        case 'created_by':
        case 'updated_at':
        case 'updated_by':
        case 'nombre_vehiculo':
        case 'ano_vehiculo':
        case 'placa_vehiculo':
        case 'serie_vehiculo':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdVehiculo()
  {
    return $this->idVehiculo;
  }

  /**
   * @param int $idVehiculo
   */
  public function setIdVehiculo($idVehiculo)
  {
    $this->idVehiculo = $idVehiculo;
  }

  /**
   * @return string
   */
  public function getNombreVehiculo()
  {
    return $this->nombreVehiculo;
  }

  /**
   * @param string $nombreVehiculo
   */
  public function setNombreVehiculo($nombreVehiculo)
  {
    $this->nombreVehiculo = $nombreVehiculo;
  }

  /**
   * @return int
   */
  public function getAnoVehiculo()
  {
    return $this->anoVehiculo;
  }

  /**
   * @param int $anoVehiculo
   */
  public function setAnoVehiculo($anoVehiculo)
  {
    $this->anoVehiculo = $anoVehiculo;
  }

  /**
   * @return string
   */
  public function getPlacaVehiculo()
  {
    return $this->placaVehiculo;
  }

  /**
   * @param string $placaVehiculo
   */
  public function setPlacaVehiculo($placaVehiculo)
  {
    $this->placaVehiculo = $placaVehiculo;
  }

  /**
   * @return string
   */
  public function getSerieVehiculo()
  {
    return $this->serieVehiculo;
  }

  /**
   * @param string $serieVehiculo
   */
  public function setSerieVehiculo($serieVehiculo)
  {
    $this->serieVehiculo = $serieVehiculo;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getGastoAnual()
  {
    return $this->gastoAnual;
  }

  /**
   * @param int $gastoAnual
   */
  public function setGastoAnual($gastoAnual)
  {
    $this->gastoAnual = $gastoAnual;
  }

  /**
   * @return Seguro
   */
  public function getSeguro()
  {
    return $this->Seguro;
  }

  /**
   * @param Seguro $Seguro
   */
  public function setSeguro(Seguro $Seguro)
  {
    $this->Seguro = $Seguro;
  }

  /**
   * @return Refrendo
   */
  public function getRefrendo()
  {
    return $this->Refrendo;
  }

  /**
   * @param Refrendo $Refrendo
   */
  public function setRefrendo(Refrendo $Refrendo)
  {
    $this->Refrendo = $Refrendo;
  }

  /**
   * @return Kilometraje
   */
  public function getKilometraje()
  {
    return $this->Kilometraje;
  }

  /**
   * @param Kilometraje $Kilometraje
   */
  public function setKilometraje(Kilometraje $Kilometraje)
  {
    $this->Kilometraje = $Kilometraje;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @return int
   */
  public function getUltimoKmAfinacion()
  {
    return $this->ultimoKmAfinacion;
  }

  /**
   * @param int $ultimoKmAfinacion
   */
  public function setUltimoKmAfinacion($ultimoKmAfinacion)
  {
    $this->ultimoKmAfinacion = $ultimoKmAfinacion;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }


}