<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 21/03/2019
 * Time: 03:47 PM
 */

namespace Partners\Vehiculo;


use Partners\Utils\BaseEntityInterface;

/**
 * Class Vale
 * @package Partners\Vehiculo
 */
class Vale implements BaseEntityInterface
{

  /**
   * @var int
   */
  private $idVale = 0;
  /**
   * @var int
   */
  private $idEntradaVales = 0;
  /**
   * @var string
   */
  private $folioVale = "";
  /**
   * @var float|int
   */
  private $montoVale = 0;
  /**
   * @var float|int
   */
  private $litros = 0;
  /**
   * @var int
   */
  private $valeUsado = 0;

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Vale.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * Vale constructor.
   * @param $datosVale
   */
  public function __construct($datosVale)
  {
    if (isset($datosVale['id_vale'])) {
      $this->idVale = (int)$datosVale['id_vale'];
    }
    if (isset($datosVale['id_entrada_vales'])) {
      $this->idEntradaVales = (int)$datosVale['id_entrada_vales'];
    }
    if (isset($datosVale['folio_vale'])) {
      $this->folioVale = (string)$datosVale['folio_vale'];
    }
    if (isset($datosVale['monto_vale'])) {
      $this->montoVale = (float)$datosVale['monto_vale'];
    }
    if (isset($datosVale['litros'])) {
      $this->litros = (float)$datosVale['litros'];
    }
    if (isset($datosVale['vale_usado'])) {
      $this->valeUsado = (int)$datosVale['vale_usado'];
    }

    foreach ($datosVale as $key => $val) {
      switch ($key) {
        case 'id_vale':
        case 'id_entrada_vales':
        case 'folio_vale':
        case 'monto_vale':
        case 'litros':
        case 'vale_usado':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdVale()
  {
    return $this->idVale;
  }

  /**
   * @param int $idVale
   */
  public function setIdVale($idVale)
  {
    $this->idVale = $idVale;
  }

  /**
   * @return int
   */
  public function getIdEntradaVales()
  {
    return $this->idEntradaVales;
  }

  /**
   * @param int $idEntradaVales
   */
  public function setIdEntradaVales($idEntradaVales)
  {
    $this->idEntradaVales = $idEntradaVales;
  }

  /**
   * @return string
   */
  public function getFolioVale()
  {
    return $this->folioVale;
  }

  /**
   * @param string $folioVale
   */
  public function setFolioVale($folioVale)
  {
    $this->folioVale = $folioVale;
  }

  /**
   * @return float|int
   */
  public function getMontoVale()
  {
    return $this->montoVale;
  }

  /**
   * @param float|int $montoVale
   */
  public function setMontoVale($montoVale)
  {
    $this->montoVale = $montoVale;
  }

  /**
   * @return float|int
   */
  public function getLitros()
  {
    return $this->litros;
  }

  /**
   * @param float|int $litros
   */
  public function setLitros($litros)
  {
    $this->litros = $litros;
  }

  /**
   * @return int
   */
  public function getValeUsado()
  {
    return $this->valeUsado;
  }

  /**
   * @param int $valeUsado
   */
  public function setValeUsado($valeUsado)
  {
    $this->valeUsado = $valeUsado;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}