<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 12/03/2019
 * Time: 06:15 PM
 */

namespace Partners\Vehiculo;


use Partners\Utils\BaseEntityInterface;

/**
 * Class Seguro
 * @package Partners\Vehiculo
 */
class Seguro implements BaseEntityInterface
{

  /**
   * @var int
   */
  private $idSeguro = 0;
  /**
   * @var int
   */
  private $createdAt = 0;
  /**
   * @var int
   */
  private $createdBy = 0;
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;
  /**
   * @var int
   */
  private $idVehiculo = 0;
  /**
   * @var int
   */
  private $fechaVencimiento = 0;
  /**
   * @var string
   */
  private $compania = "";
  /**
   * @var string
   */
  private $poliza = "";
  /**
   * @var float|int
   */
  private $precio = 0;
  /**
   * @var string
   */
  private $pdf = "";
  /**
   * @var string
   */
  private $formaPago = "";

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Seguro.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * Seguro constructor.
   * @param $datosSeguro
   */
  public function __construct($datosSeguro)
  {
    if (isset($datosSeguro['id_seguro'])) {
      $this->idSeguro = (int)$datosSeguro['id_seguro'];
    }
    if (isset($datosSeguro['created_at'])) {
      $this->createdAt = (int)$datosSeguro['created_at'];
    }
    if (isset($datosSeguro['created_by'])) {
      $this->createdBy = (int)$datosSeguro['created_by'];
    }
    if (isset($datosSeguro['updated_at'])) {
      $this->updatedAt = (int)$datosSeguro['updated_at'];
    }
    if (isset($datosSeguro['updated_by'])) {
      $this->updatedBy = (int)$datosSeguro['updated_by'];
    }
    if (isset($datosSeguro['id_vehiculo'])) {
      $this->idVehiculo = (int)$datosSeguro['id_vehiculo'];
    }
    if (isset($datosSeguro['fecha_vencimiento'])) {
      $this->fechaVencimiento = (int)$datosSeguro['fecha_vencimiento'];
    }
    if (isset($datosSeguro['compania'])) {
      $this->compania = (string)$datosSeguro['compania'];
    }
    if (isset($datosSeguro['poliza'])) {
      $this->poliza = (string)$datosSeguro['poliza'];
    }
    if (isset($datosSeguro['precio'])) {
      $this->precio = (float)$datosSeguro['precio'];
    }
    if (isset($datosSeguro['pdf'])) {
      $this->pdf = (string)$datosSeguro['pdf'];
    }
    if (isset($datosSeguro['forma_pago'])) {
      $this->formaPago = (string)$datosSeguro['forma_pago'];
    }

    if ($datosSeguro) {
      foreach ($datosSeguro as $key => $val) {
        switch ($key) {
          case 'id_seguro':
          case 'created_at':
          case 'created_by':
          case 'updated_at':
          case 'updated_by':
          case 'id_vehiculo':
          case 'fecha_vencimiento':
          case 'compania':
          case 'poliza':
          case 'precio':
          case 'pdf':
          case 'forma_pago':
            break;
          default:
            $this->__unkownProperties[$key] = $val;
        }
      }
    }
  }

  /**
   * @return int
   */
  public function getIdSeguro()
  {
    return $this->idSeguro;
  }

  /**
   * @param int $idSeguro
   */
  public function setIdSeguro($idSeguro)
  {
    $this->idSeguro = $idSeguro;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getIdVehiculo()
  {
    return $this->idVehiculo;
  }

  /**
   * @param int $idVehiculo
   */
  public function setIdVehiculo($idVehiculo)
  {
    $this->idVehiculo = $idVehiculo;
  }

  /**
   * @return int
   */
  public function getFechaVencimiento()
  {
    return $this->fechaVencimiento;
  }

  /**
   * @param int $fechaVencimiento
   */
  public function setFechaVencimiento($fechaVencimiento)
  {
    $this->fechaVencimiento = $fechaVencimiento;
  }

  /**
   * @return string
   */
  public function getCompania()
  {
    return $this->compania;
  }

  /**
   * @param string $compania
   */
  public function setCompania($compania)
  {
    $this->compania = $compania;
  }

  /**
   * @return float|string
   */
  public function getPoliza()
  {
    return $this->poliza;
  }

  /**
   * @param float|string $poliza
   */
  public function setPoliza($poliza)
  {
    $this->poliza = $poliza;
  }

  /**
   * @return float|int
   */
  public function getPrecio()
  {
    return $this->precio;
  }

  /**
   * @param float|int $precio
   */
  public function setPrecio($precio)
  {
    $this->precio = $precio;
  }

  /**
   * @return string
   */
  public function getPdf()
  {
    return $this->pdf;
  }

  /**
   * @param string $pdf
   */
  public function setPdf($pdf)
  {
    $this->pdf = $pdf;
  }

  /**
   * @return string
   */
  public function getFormaPago()
  {
    return $this->formaPago;
  }

  /**
   * @param string $formaPago
   */
  public function setFormaPago($formaPago)
  {
    $this->formaPago = $formaPago;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}