<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 14/03/2019
 * Time: 06:33 PM
 */

namespace Partners\Vehiculo;


use Partners\Utils\BaseEntityInterface;

class Refrendo implements BaseEntityInterface
{
  /**
   * @var int
   */
  private $idRefrendo = 0;
  /**
   * @var int
   */
  private $createdAt = 0;
  /**
   * @var int
   */
  private $createdBy = 0;
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;
  /**
   * @var int
   */
  private $idVehiculo = 0;
  /**
   * @var int
   */
  private $fechaRefrendo = 0;


  /**
   * @var string
   */
  private $pdf = "";
  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Refrendo.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * Refrendo constructor.
   * @param $datosRefrendo
   */
  public function __construct($datosRefrendo)
  {
    if (isset($datosRefrendo['id_refrendo'])) {
      $this->idRefrendo = (int)$datosRefrendo['id_refrendo'];
    }
    if (isset($datosRefrendo['created_at'])) {
      $this->createdAt = (int)$datosRefrendo['created_at'];
    }
    if (isset($datosRefrendo['created_by'])) {
      $this->createdBy = (int)$datosRefrendo['created_by'];
    }
    if (isset($datosRefrendo['updated_at'])) {
      $this->updatedAt = (int)$datosRefrendo['updated_at'];
    }
    if (isset($datosRefrendo['updated_by'])) {
      $this->updatedBy = (int)$datosRefrendo['updated_by'];
    }
    if (isset($datosRefrendo['id_vehiculo'])) {
      $this->idVehiculo = (int)$datosRefrendo['id_vehiculo'];
    }
    if (isset($datosRefrendo['pdf'])) {
      $this->pdf = (string)$datosRefrendo['pdf'];
    }
    if (isset($datosRefrendo['fecha_refrendo'])) {
      $this->fechaRefrendo = (int)$datosRefrendo['fecha_refrendo'];
    }

    foreach ($datosRefrendo as $key => $val) {
      switch ($key) {
        case 'id_refrendo':
        case 'created_at':
        case 'created_by':
        case 'updated_at':
        case 'updated_by':
        case 'id_vehiculo':
        case 'fecha_refrendo':
        case 'pdf':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdRefrendo()
  {
    return $this->idRefrendo;
  }

  /**
   * @param int $idRefrendo
   */
  public function setIdRefrendo($idRefrendo)
  {
    $this->idRefrendo = $idRefrendo;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getIdVehiculo()
  {
    return $this->idVehiculo;
  }

  /**
   * @param int $idVehiculo
   */
  public function setIdVehiculo($idVehiculo)
  {
    $this->idVehiculo = $idVehiculo;
  }

  /**
   * @return string
   */
  public function getPdf()
  {
    return $this->pdf;
  }

  /**
   * @param string $pdf
   */
  public function setPdf($pdf)
  {
    $this->pdf = $pdf;
  }

  /**
   * @return int
   */
  public function getFechaRefrendo()
  {
    return $this->fechaRefrendo;
  }

  /**
   * @param int $fechaRefrendo
   */
  public function setFechaRefrendo($fechaRefrendo)
  {
    $this->fechaRefrendo = $fechaRefrendo;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}