<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 14/03/2019
 * Time: 03:21 PM
 */

namespace Partners\Vehiculo;


use Partners\Utils\BaseEntityInterface;

/**
 * Class Kilometraje
 * @package Partners\Vehiculo
 */
class Kilometraje implements BaseEntityInterface
{

  /**
   * @var int
   */
  private $idKilometraje = 0;
  /**
   * @var int
   */
  private $createdAt = 0;
  /**
   * @var int
   */
  private $createdBy = 0;
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;
  /**
   * @var int
   */
  private $idVehiculo = 0;
  /**
   * @var int
   */
  private $kilometros = 0;

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Gasto.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * Gasto constructor.
   * @param $datosKilometraje
   */
  public function __construct($datosKilometraje)
  {
    if (isset($datosKilometraje['id_kilometraje'])) {
      $this->idKilometraje = (int)$datosKilometraje['id_kilometraje'];
    }
    if (isset($datosKilometraje['created_at'])) {
      $this->createdAt = (int)$datosKilometraje['created_at'];
    }
    if (isset($datosKilometraje['created_by'])) {
      $this->createdBy = (int)$datosKilometraje['created_by'];
    }
    if (isset($datosKilometraje['updated_at'])) {
      $this->updatedAt = (int)$datosKilometraje['updated_at'];
    }
    if (isset($datosKilometraje['updated_by'])) {
      $this->updatedBy = (int)$datosKilometraje['updated_by'];
    }
    if (isset($datosKilometraje['id_vehiculo'])) {
      $this->idVehiculo = (int)$datosKilometraje['id_vehiculo'];
    }
    if (isset($datosKilometraje['kilometros'])) {
      $this->kilometros = (int)$datosKilometraje['kilometros'];
    }

    foreach ($datosKilometraje as $key => $val) {
      switch ($key) {
        case 'id_kilometraje':
        case 'created_at':
        case 'created_by':
        case 'updated_at':
        case 'updated_by':
        case 'id_vehiculo':
        case 'kilometros':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdKilometraje()
  {
    return $this->idKilometraje;
  }

  /**
   * @param int $idKilometraje
   */
  public function setIdKilometraje($idKilometraje)
  {
    $this->idKilometraje = $idKilometraje;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getIdVehiculo()
  {
    return $this->idVehiculo;
  }

  /**
   * @param int $idVehiculo
   */
  public function setIdVehiculo($idVehiculo)
  {
    $this->idVehiculo = $idVehiculo;
  }

  /**
   * @return int
   */
  public function getKilometros()
  {
    return $this->kilometros;
  }

  /**
   * @param int $kilometros
   */
  public function setKilometros($kilometros)
  {
    $this->kilometros = $kilometros;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  public function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  public function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}