<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 12/03/2019
 * Time: 02:25 PM
 */

namespace Partners\Vehiculo;


use Partners\Utils\BaseEntityInterface;

/**
 * Class Gasto
 * @package Partners\Vehiculo
 */
class Gasto implements BaseEntityInterface
{

  /**
   * @var int
   */
  private $idGasto = 0;
  /**
   * @var int
   */
  private $createdAt = 0;
  /**
   * @var int
   */
  private $createdBy = 0;
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;
  /**
   * @var int
   */
  private $idVehiculo = 0;
  /**
   * @var int
   */
  private $fechaGasto = 0;
  /**
   * @var string
   */
  private $concepto = "";
  /**
   * @var float
   */
  private $cantidad = 0;
  /**
   * @var string
   */
  private $taller = "";
  /**
   * @var int
   */
  private $km = 0;
  /**
   * @var string
   */
  private $observaciones = "";

  /**
   * 1: Gasto
   * 2: Afinación
   * @var int
   */
  private $tipoGasto = 1;

  /**
   * 0: Afinación Normal
   * 1: Solo Aceite
   * @var int
   */
  private $soloAceite = 0;

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Gasto.
   * @var array
   */
  private $__unkownProperties = [];


  /**
   * Gasto constructor.
   * @param $datosGasto
   */
  public function __construct($datosGasto)
  {
    if (isset($datosGasto['id_gasto'])) {
      $this->idGasto = (int)$datosGasto['id_gasto'];
    }
    if (isset($datosGasto['created_at'])) {
      $this->createdAt = (int)$datosGasto['created_at'];
    }
    if (isset($datosGasto['created_by'])) {
      $this->createdBy = (int)$datosGasto['created_by'];
    }
    if (isset($datosGasto['updated_at'])) {
      $this->updatedAt = (int)$datosGasto['updated_at'];
    }
    if (isset($datosGasto['updated_by'])) {
      $this->updatedBy = (int)$datosGasto['updated_by'];
    }
    if (isset($datosGasto['id_vehiculo'])) {
      $this->idVehiculo = (int)$datosGasto['id_vehiculo'];
    }
    if (isset($datosGasto['fecha_gasto'])) {
      $this->fechaGasto = (int)$datosGasto['fecha_gasto'];
    }
    if (isset($datosGasto['concepto'])) {
      $this->concepto = (string)$datosGasto['concepto'];
    }
    if (isset($datosGasto['cantidad'])) {
      $this->cantidad = (float)$datosGasto['cantidad'];
    }
    if (isset($datosGasto['taller'])) {
      $this->taller = (string)$datosGasto['taller'];
    }
    if (isset($datosGasto['km'])) {
      $this->km = (int)$datosGasto['km'];
    }
    if (isset($datosGasto['observaciones'])) {
      $this->observaciones = (string)$datosGasto['observaciones'];
    }
    if (isset($datosGasto['solo_aceite'])) {
      $this->soloAceite = (int)$datosGasto['solo_aceite'];
    }

    foreach ($datosGasto as $key => $val) {
      switch ($key) {
        case 'id_gasto':
        case 'created_at':
        case 'created_by':
        case 'updated_at':
        case 'updated_by':
        case 'id_vehiculo':
        case 'fecha_gasto':
        case 'concepto':
        case 'cantidad':
        case 'taller':
        case 'km':
        case 'observaciones':
        case 'tipo_gasto':
        case 'solo_aceite':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdGasto()
  {
    return $this->idGasto;
  }

  /**
   * @param int $idGasto
   */
  public function setIdGasto($idGasto)
  {
    $this->idGasto = $idGasto;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getIdVehiculo()
  {
    return $this->idVehiculo;
  }

  /**
   * @param int $idVehiculo
   */
  public function setIdVehiculo($idVehiculo)
  {
    $this->idVehiculo = $idVehiculo;
  }

  /**
   * @return int
   */
  public function getFechaGasto()
  {
    return $this->fechaGasto;
  }

  /**
   * @param int $fechaGasto
   */
  public function setFechaGasto($fechaGasto)
  {
    $this->fechaGasto = $fechaGasto;
  }

  /**
   * @return string
   */
  public function getConcepto()
  {
    return $this->concepto;
  }

  /**
   * @param string $concepto
   */
  public function setConcepto($concepto)
  {
    $this->concepto = $concepto;
  }

  /**
   * @return int
   */
  public function getCantidad()
  {
    return $this->cantidad;
  }

  /**
   * @param int $cantidad
   */
  public function setCantidad($cantidad)
  {
    $this->cantidad = $cantidad;
  }

  /**
   * @return string
   */
  public function getTaller()
  {
    return $this->taller;
  }

  /**
   * @param string $taller
   */
  public function setTaller($taller)
  {
    $this->taller = $taller;
  }

  /**
   * @return int
   */
  public function getKm()
  {
    return $this->km;
  }

  /**
   * @param int $km
   */
  public function setKm($km)
  {
    $this->km = $km;
  }

  /**
   * @return string
   */
  public function getObservaciones()
  {
    return $this->observaciones;
  }

  /**
   * @param string $observaciones
   */
  public function setObservaciones($observaciones)
  {
    $this->observaciones = $observaciones;
  }

  /**
   * @return int
   */
  public function getTipoGasto()
  {
    return $this->tipoGasto;
  }

  /**
   * @param int $tipoGasto
   */
  public function setTipoGasto($tipoGasto)
  {
    $this->tipoGasto = $tipoGasto;
  }

  /**
   * @return int
   */
  public function getSoloAceite()
  {
    return $this->soloAceite;
  }

  /**
   * @param int $soloAceite
   */
  public function setSoloAceite($soloAceite)
  {
    $this->soloAceite = $soloAceite;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}