<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 19/03/2019
 * Time: 03:44 PM
 */

namespace Partners\Vehiculo;


use Partners\Utils\BaseEntityInterface;

/**
 * Class EntradaVales
 * @package Partners\Vehiculo
 */
class EntradaVales implements BaseEntityInterface
{
  /**
   * @var int
   */
  private $idEntradaVales = 0;
  /**
   * @var int
   */
  private $createdAt = 0;
  /**
   * @var int
   */
  private $createdBy = 0;
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;
  /**
   * @var int
   */
  private $precioGasolina = 0;

  /**
   * @var array
   */
  private $listVales = [];
  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase EntradaVales.
   * @var array
   */
  private $__unkownProperties = [];


  /**
   * EntradaVales constructor.
   * @param $datosEntradaVales
   */
  public function __construct($datosEntradaVales)
  {
    if (isset($datosEntradaVales['id_entrada_vales'])) {
      $this->idEntradaVales = (int)$datosEntradaVales['id_entrada_vales'];
    }
    if (isset($datosEntradaVales['created_at'])) {
      $this->createdAt = (int)$datosEntradaVales['created_at'];
    }
    if (isset($datosEntradaVales['created_by'])) {
      $this->createdBy = (int)$datosEntradaVales['created_by'];
    }
    if (isset($datosEntradaVales['updated_at'])) {
      $this->updatedAt = (int)$datosEntradaVales['updated_at'];
    }
    if (isset($datosEntradaVales['updated_by'])) {
      $this->updatedBy = (int)$datosEntradaVales['updated_by'];
    }
    if (isset($datosEntradaVales['precio_gasolina'])) {
      $this->precioGasolina = (float)$datosEntradaVales['precio_gasolina'];
    }

    foreach ($datosEntradaVales as $key => $val) {
      switch ($key) {
        case 'id_entrada_vales':
        case 'created_at':
        case 'created_by':
        case 'updated_at':
        case 'updated_by':
        case 'precio_gasolina':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdEntradaVales()
  {
    return $this->idEntradaVales;
  }

  /**
   * @param int $idEntradaVales
   */
  public function setIdEntradaVales($idEntradaVales)
  {
    $this->idEntradaVales = $idEntradaVales;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getPrecioGasolina()
  {
    return $this->precioGasolina;
  }

  /**
   * @param int $precioGasolina
   */
  public function setPrecioGasolina($precioGasolina)
  {
    $this->precioGasolina = $precioGasolina;
  }

  /**
   * @return array
   */
  public function getListVales()
  {
    return $this->listVales;
  }

  /**
   * @param array $listVales
   */
  public function setListVales($listVales)
  {
    $this->listVales = $listVales;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}