<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 07/06/2019
 * Time: 02:10 PM
 */

namespace Partners\Utils;


class PartnersTelegramBot
{
  private $apiEndpoint = 'https://api.telegram.org/bot689905640:AAEOS35vFV4OA2ZDf_Ha9pGGZ8a2emhVVsY/';
  private $chatId = '';
  private $message = '';

  public function __construct($message, $chatId)
  {
    $this->message = $message;
    $this->chatId = $chatId;
  }

  /**
   * Método para enviar una petición a la API de telegram para enviar un mensaje.
   */
  public function sendMessage(){
    $queryArray = [
      'chat_id' => $this->chatId,
      'text' => $this->message,
      'parse_mode' => 'HTML',
    ];
    $url = $this->apiEndpoint . 'sendMessage?' . http_build_query($queryArray);
    return file_get_contents($url);
  }

  /**
   * Método que busca el chatId asociado a un usuario.
   * @param $uid
   * @return int
   */
  public static function getChatId($uid){
    $query = db_select('partners_telegram', 'pt');
    $query->addField('pt', 'chat_id');
    $query->condition('uid', $uid);
    $chatId = $query->execute()->fetchField();
    return $chatId ? $chatId : -1;
  }
}