<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 05/02/2019
 * Time: 05:58 PM
 */

namespace Partners\Utils;


/**
 * Class PartnersRouter
 * @package Partners\Utils
 */
abstract class PartnersRouter
{
  /**
   * @var null
   */
  protected $data = null;
  /**
   * @var string
   */
  protected $path = "";

  /**
   * PartnersRouter constructor.
   * @param $path
   */
  public function __construct($path)
  {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      if (!empty($_FILES)) {
        // Cuando se envian archivos, normalmente se quiere enviar otra
        // información, por ello en JS se crea un FormData y ahí en ese objeto
        // se pasa la información necesaria, entonces aquí se modifica la forma
        // enla que se recibe la información.
        $this->data['data'] = $_POST;
        $this->data['files'] = $_FILES;
      }
      else {
        $this->data = json_decode(file_get_contents('php://input'), 0);
      }
    } else if ($_SERVER['REQUEST_METHOD'] === 'GET') {
      $this->data = $_GET;
    }

    $this->path = $path;

    $this->routes();
  }

  abstract protected function routes();
}