<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 29/03/2019
 * Time: 06:29 PM
 */

namespace Partners\Utils;


/**
 * Class PartnersPdf
 *
 * @package Partners\Utils
 */
class PartnersPdf {

  /**
   * @var
   */
  public $mPdf;

  /**
   * @var string
   */
  private $fileOutName;

  /**
   * @var string
   */
  private $writeToDiskPath;

  /**
   * PartnersPdf constructor.
   *
   * @param string $title Titulo que llevará el PDF
   * @param string $html Contenido que llevará el PDF
   * @param string $footer Contenido que se incluirá en el footer del PDF
   * @param string $watermark Marca de agua que llevará el PDF
   * @param string $fileOutName Nombre bajo el cual se generará el PDF
   * @param string $writeToDiskPath Ubicación en disco en donde se generará el
   *   PDF
   *
   * @throws \MpdfException
   */
  public function __construct($title = "", $html = "", $fileOutName = "file.pdf", $footer = NULL, $watermark = NULL, $writeToDiskPath = NULL) {
    $this->fileOutName = $fileOutName;
    $this->writeToDiskPath = $writeToDiskPath;

    try {
      $this->mPdf = new \mPDF();
      $this->mPdf->SetTitle($title);
      $this->mPdf->WriteHtml($html);

      if ($watermark !== NULL) {
        $this->mPdf->SetWatermarkImage($watermark);
        $this->mPdf->showWatermarkImage = TRUE;
      }
      if ($footer !== NULL) {
        $this->mPdf->SetHTMLFooter($footer);
      }
    } catch (\MpdfException $e) {
      throw new \MpdfException($e);
    }
  }

  /**
   * Método para generar un PDF en el navegador
   *
   * @return string
   * @throws \MpdfException
   */
  public function renderPdf() {
    return $this->mPdf->Output($this->fileOutName . '.pdf', 'I');
  }

  /**
   * Método para generar un PDF como string, usado para enviar PDF por los
   * correos.
   *
   * @return string
   * @throws \MpdfException
   */
  public function renderPdfAsString() {
    return $this->mPdf->Output('', 'S');
  }

  /**
   * Método para generar un PDF en disco en una ruta en especifico.
   *
   * @return string
   * @throws \MpdfException
   */
  public function writePdfToDisk() {
    return $this->mPdf->Output($this->writeToDiskPath . $this->fileOutName . '.pdf', 'F');
  }

  /**
   * @return \mPDF
   */
  public function getMPdf() {
    return $this->mPdf;
  }

  /**
   * @param mixed $mPdf
   */
  public function setMPdf($mPdf) {
    $this->mPdf = $mPdf;
  }

  /**
   * @return string
   */
  public function getFileOutName() {
    return $this->fileOutName;
  }

  /**
   * @param string $fileOutName
   */
  public function setFileOutName($fileOutName) {
    $this->fileOutName = $fileOutName;
  }
}