<?php

/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 02/02/2019
 * Time: 01:01 PM
 */

namespace Partners\Utils;


use Swift_Mailer;
use Swift_Message;
use Swift_SendmailTransport;

/**
 * Class PartnersLogger
 * @package Partners\Utils
 */
class PartnersLogger
{
  /**
   * @param $table
   * @param $type
   * @param $message
   */
  public static function Info($table, $type, $message)
  {
    global $user, $base_root;
    try {
      db_insert('partners_log_actions')
        ->fields(array(
          'timestamp' => REQUEST_TIME,
          'uid' => $user->uid,
          'hostname' => ip_address(),
          'location' => $base_root . request_uri(),
          'table_at' => $table,
          'type' => $type,
          'message' => $message
        ))
        ->execute();
    } catch (\Exception $e) {
    }
  }

  /**
   * @param \Exception $e
   * @param $location
   */
  public static function Error(\Exception $e, $location)
  {
    global $user;
    try {
      $trace = (strlen($e->getTraceAsString()) > 500)
        ? substr($e->getTraceAsString(), 0, 500)
        : $e->getTraceAsString();
      $id_report = db_insert('partners_error_reports')
        ->fields(array(
          'user_report' => $user->uid,
          'report_date' => REQUEST_TIME,
          'report_location' => $location,
          'report_msg' => $e->getMessage(),
          'detailed_description' => $trace
        ))
        ->execute();
    } catch (\Exception $e) {
    }

    $transport = new Swift_SendmailTransport();
    $mailer = new Swift_Mailer($transport);
    $from = ['errores@pcpartners.com.mx' => 'Pc Partners - Error Reports'];
    $to = ['omar@pcpartners.com.mx' => 'Pc Partners - Error', 'roberto@pcpartners.com.mx' => 'Pc Partners - Roberto'];
    if (!empty($id_report)) {
      $data['id_report'] = $id_report;
    }
    $data['message'] = $e->getMessage();
    $data['trace'] = $e->getTrace();
    $body = render_template('php', 'system.mail_send_report', $data);
    if (!empty($id_report)) {
      $message = (new Swift_Message())
        ->setSubject('Reporte de error fatal en PcPartners: ' . $id_report)
        ->setFrom($from)
        ->setBody($body, 'text/html');
    }
    $failedRecipients = [];
    $numSent = 0;

    foreach ($to as $address => $name) {
      if (is_int($address)) {
        if (!empty($message)) {
          $message->setTo($name);
        }
      } else {
        if (!empty($message)) {
          $message->setTo([$address => $name]);
        }
      }
      self::Info('partners_error_reports', 'mail', 'Se envió automáticamente el reporte de un error fatal a Erick.');
      if (!empty($message)) {
        $numSent += $mailer->send($message, $failedRecipients);
      }
    }

    JsonMessageHelper::Error("Lamentamos lo sucedido, ya se ha enviado el reporte del error para que sea atendido lo más pronto posible!");
  }
}
