<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 12/03/2019
 * Time: 02:48 PM
 */

namespace Partners\Utils;


use DateTime;

/**
 * Class PartnersBitacora
 * @package Partners\Utils
 */
class PartnersBitacora
{
  /**
   * @var string
   */
  private $textoObservacion = "";
  /**
   * @var string|null
   */
  private $fechaObservacion = null;
  /**
   * @var null
   */
  private $userName = null;
  /**
   * @var null
   */
  private $tableName;
  /**
   * @var null
   */
  private $colName;
  /**
   * @var null
   */
  private $primaryKey;
  /**
   * @var null
   */
  private $id;

  /**
   * PartnersBitacora constructor.
   * @param string $textoObservacion Texto para insertar a la bitácora.
   * @param null $fechaObservacion Fecha y hora de la bitácora.
   * @param null $userName El nombre de usuario que generó la bitácora.
   * @param null $tableName El nombre de la tabla a la cual hay que consultar para trar bitácoras existentes.
   * @param null $colName El nombre de la columna de la tabla la cual almacena las observaciones.
   * @param null $primaryKeyCol El nombre de la columna de la llave primaria de la tabla en la cual se hará la
   * condición de la consulta.
   * @param null $id El id del registro el cual se está buscando su bitácora
   * @throws \Exception
   */
  public function __construct($textoObservacion = "", $fechaObservacion = null, $userName = null, $tableName = null,
                              $colName = null, $primaryKeyCol = null, $id = null)
  {
    $this->textoObservacion = $textoObservacion;

    if (!$fechaObservacion) {
      $d = new DateTime();
      $date = $d->format("d/m/y H:i:s");
      $this->fechaObservacion = $date;
    }

    if (!$userName) {
      global $user;
      $this->userName = $user->name;
    }else{
      $this->userName = $userName;
    }

    $this->tableName = $tableName;
    $this->colName = $colName;
    $this->primaryKey = $primaryKeyCol;
    $this->id = $id;
  }

  /**
   * Método el cual regresa una string que es usada para capturar directamente en la base de datos, la cual
   * contiene una bitácora nueva.
   * Cuando no existe ningún texto para capturar en la bitácora, regresa null
   * @return string | null
   */
  public function generarNuevaObservacion()
  {
    $dato = array(
      "fecha" => $this->fechaObservacion,
      "usuario" => $this->userName,
      "texto" => $this->textoObservacion,
    );
    $data[] = $dato;

    return ($this->textoObservacion == "") ? null : serialize($data);
  }

  /**
   * @return string
   */
  public function getTextoObservacion()
  {
    return $this->textoObservacion;
  }

  /**
   * @param string $textoObservacion
   */
  public function setTextoObservacion($textoObservacion)
  {
    $this->textoObservacion = $textoObservacion;
  }

  /**
   * @return string|null
   */
  public function getFechaObservacion()
  {
    return $this->fechaObservacion;
  }

  /**
   * @param string|null $fechaObservacion
   */
  public function setFechaObservacion($fechaObservacion)
  {
    $this->fechaObservacion = $fechaObservacion;
  }

  /**
   * @return null
   */
  public function getUserName()
  {
    return $this->userName;
  }

  /**
   * @param |null $userName
   */
  public function setUserName($userName)
  {
    $this->userName = $userName;
  }

  /**
   * @return null
   */
  public function getTableName()
  {
    return $this->tableName;
  }

  /**
   * @param null $tableName
   */
  public function setTableName($tableName)
  {
    $this->tableName = $tableName;
  }

  /**
   * @return null
   */
  public function getColName()
  {
    return $this->colName;
  }

  /**
   * @param null $colName
   */
  public function setColName($colName)
  {
    $this->colName = $colName;
  }

  /**
   * @return null
   */
  public function getPrimaryKey()
  {
    return $this->primaryKey;
  }

  /**
   * @param null $primaryKey
   */
  public function setPrimaryKey($primaryKey)
  {
    $this->primaryKey = $primaryKey;
  }

  /**
   * @return null
   */
  public function getId()
  {
    return $this->id;
  }

  /**
   * @param null $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }

  /**
   * Método el cual se encarga de generar la vista de las observaciones de cierto
   * registro.
   * @throws PartnersException
   * @return string
   */
  public function loadObs()
  {
    $getObs = db_select($this->tableName, 'custom_alias')
      ->fields('custom_alias', array($this->colName));
    $getObs->condition($this->primaryKey, $this->id);


    $observaciones = $getObs->execute()->fetchField();

    $obs['observaciones'] = unserialize($observaciones);
    $tpl = render_template('php', 'system.load_obs', $obs);
    GenerateTemplate::Generate('system.load_obs', $obs);
    return $tpl;
  }

  /**
   * Método para capturar una observación en determinado registro.
   * @return string
   */
  public function capturarObs()
  {
    $newObs = $this->mergeExistingObs();

    db_update($this->tableName)
      ->fields(array(
        $this->colName => $newObs
      ))
      ->condition($this->primaryKey, $this->id)
      ->execute();

    $newObsStr = "<tr>
        <td>$this->fechaObservacion</td>
        <td>$this->userName</td>
        <td>$this->textoObservacion</td>
    </tr>";

    return $newObsStr;
  }

  /**
   * Método el cual en base a un registro de observaciones ya existente,
   * le agrega una nueva observación.
   * Regresa el string ya serialized
   * @return string
   */
  public function mergeExistingObs()
  {
    $getObs = db_select($this->tableName, 'custom_alias')
      ->fields('custom_alias', array($this->colName));
    $getObs->condition($this->primaryKey, $this->id);

    $observaciones = $getObs->execute()->fetchField();

    $prevObs = unserialize($observaciones);

    $tempNewObs = array(
      "fecha" => $this->fechaObservacion,
      "usuario" => $this->userName,
      "texto" => $this->textoObservacion,
    );

    $prevObs[] = $tempNewObs;
    return serialize($prevObs);
  }
}