<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 02/02/2019
 * Time: 12:41 PM
 */

namespace Partners\Utils;


use Dwoo_Core;

class GenerateTemplate
{
  /**
   * @param $dir
   * @param null $data
   * @return string
   * @throws PartnersException
   */
  static function Generate($dir, $data = null)
  {
    $dwoo = new Dwoo_Core();
    $dir = str_replace('.', '/', $dir);
    $root_dir = drupal_get_path('module', 'partners') . '/lib/templates/';

    if ($data != null) {
      $data = array("datos" => $data);
      try {
        $dwooTpl = $dwoo->get($root_dir . $dir . '.tpl', $data);
      } catch (\Dwoo_Exception $e) {
        throw new PartnersException($e->getMessage());
      }
    } else {
      try {
        $dwooTpl = $dwoo->get($root_dir . $dir . '.tpl');
      } catch (\Dwoo_Exception $e) {
        throw new PartnersException($e->getMessage());
      }
    }
    return $dwooTpl;
  }
}