<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 05/02/2019
 * Time: 02:40 PM
 */

namespace Partners\Renovacion;


/**
 * Class RenovacionController
 * @package Partners\Renovacion
 */
class RenovacionController
{

  /**
   * @param $idRenovacion
   * @return Renovacion
   */
  public function findRenovacion($idRenovacion)
  {
    $query = db_select('partners_renovaciones', 'pr');
    $query->innerJoin('taxonomy_term_data', 'pt', 'pt.tid = pr.id_tipo');
    $query->fields('pr');
    $query->addField('pt', 'name', 'nombre_tipo_renovacion');
    $query->condition('pr.renovacion_eliminada', '1', '!=');
    $query->condition('pr.fecha_renovacion', array(strtotime('first day of january this year'), (strtotime('last day of december this year') + 86340)), 'BETWEEN');
    $query->condition('pr.id_renovacion', $idRenovacion);
    $query->condition('pr.renovacion_eliminada', '1', '!=');

    $Renovacion = new Renovacion($query->execute()->fetchAssoc());

    return $Renovacion;
  }
}