<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 05/02/2019
 * Time: 02:40 PM
 */

namespace Partners\Renovacion;


use Partners\Utils\BaseEntityInterface;

/**
 * Class Renovacion
 * @package Partners\Renovacion
 */
class Renovacion implements BaseEntityInterface
{
  /**
   * @var int
   */
  private $idRenovacion = 0;
  /**
   * @var int
   */
  private $createdAt = 0;
  /**
   * @var int
   */
  private $createdBy = 0;
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;
  /**
   * @var int
   */
  private $idCliente = 0;
  /**
   * @var int
   */
  private $idContacto = 0;
  /**
   * @var int
   */
  private $idTipo = 0;
  /**
   * @var int
   */
  private $idAreaRenovacion = 0;
  /**
   * @var string
   */
  private $productoServicio = "";
  /**
   * @var string
   */
  private $detalle = "";
  /**
   * @var int
   */
  private $fechaInicio = 0;
  /**
   * @var int
   */
  private $frecuenciaIntervalo = 0;
  /**
   * @var string
   */
  private $frecuenciaTipo = "";
  /**
   * @var int
   */
  private $precio = 0;
  /**
   * @var string
   */
  private $observaciones = "";
  /**
   * @var string
   */
  private $tokenRelacionRenovacion = "";
  /**
   * @var int
   */
  private $fechaRenovacion = 0;
  /**
   * @var int
   */
  private $recordatorio = 0;
  /**
   * @var int
   */
  private $autorizado = 0;
  /**
   * @var int
   */
  private $idRelacionCotizacion = 0;
  /**
   * @var int
   */
  private $renovacionEliminada = 0;

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Renovacion.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * Renovacion constructor.
   * @param $datosRenovacion
   */
  public function __construct($datosRenovacion)
  {
    if (isset($datosRenovacion['id_renovacion'])) {
      $this->idRenovacion = (int)$datosRenovacion['id_renovacion'];
    }
    if (isset($datosRenovacion['created_at'])) {
      $this->createdAt = (int)$datosRenovacion['created_at'];
    }
    if (isset($datosRenovacion['created_by'])) {
      $this->createdBy = (int)$datosRenovacion['created_by'];
    }
    if (isset($datosRenovacion['updated_at'])) {
      $this->updatedAt = (int)$datosRenovacion['updated_at'];
    }
    if (isset($datosRenovacion['updated_by'])) {
      $this->updatedBy = (int)$datosRenovacion['updated_by'];
    }
    if (isset($datosRenovacion['id_cliente'])) {
      $this->idCliente = (int)$datosRenovacion['id_cliente'];
    }
    if (isset($datosRenovacion['id_contacto'])) {
      $this->idContacto = (int)$datosRenovacion['id_contacto'];
    }
    if (isset($datosRenovacion['id_tipo'])) {
      $this->idTipo = (int)$datosRenovacion['id_tipo'];
    }
    if (isset($datosRenovacion['id_area_renovacion'])) {
      $this->idAreaRenovacion = (int)$datosRenovacion['id_area_renovacion'];
    }
    if (isset($datosRenovacion['producto_servicio'])) {
      $this->productoServicio = (string)$datosRenovacion['producto_servicio'];
    }
    if (isset($datosRenovacion['detalle'])) {
      $this->detalle = (string)$datosRenovacion['detalle'];
    }
    if (isset($datosRenovacion['fecha_inicio'])) {
      $this->fechaInicio = (int)$datosRenovacion['fecha_inicio'];
    }
    if (isset($datosRenovacion['frecuencia_intervalo'])) {
      $this->frecuenciaIntervalo = (int)$datosRenovacion['frecuencia_intervalo'];
    }
    if (isset($datosRenovacion['frecuencia_tipo'])) {
      $this->frecuenciaTipo = (string)$datosRenovacion['frecuencia_tipo'];
    }
    if (isset($datosRenovacion['precio'])) {
      $this->precio = (int)$datosRenovacion['precio'];
    }
    if (isset($datosRenovacion['observaciones'])) {
      $this->observaciones = (string)$datosRenovacion['observaciones'];
    }
    if (isset($datosRenovacion['token_relacion_renovacion'])) {
      $this->tokenRelacionRenovacion = (string)$datosRenovacion['token_relacion_renovacion'];
    }
    if (isset($datosRenovacion['fecha_renovacion'])) {
      $this->fechaRenovacion = (int)$datosRenovacion['fecha_renovacion'];
    }
    if (isset($datosRenovacion['recordatorio'])) {
      $this->recordatorio = (int)$datosRenovacion['recordatorio'];
    }
    if (isset($datosRenovacion['autorizado'])) {
      $this->autorizado = (int)$datosRenovacion['autorizado'];
    }
    if (isset($datosRenovacion['id_relacion_cotizacion'])) {
      $this->idRelacionCotizacion = (int)$datosRenovacion['id_relacion_cotizacion'];
    }
    if (isset($datosRenovacion['renovacion_eliminada'])) {
      $this->renovacionEliminada = (int)$datosRenovacion['renovacion_eliminada'];
    }

    foreach ($datosRenovacion as $key => $val) {
      switch ($key) {
        case 'id_renovacion':
        case 'created_at':
        case 'created_by':
        case 'updated_at':
        case 'updated_by':
        case 'id_cliente':
        case 'id_contacto':
        case 'id_tipo':
        case 'id_area_renovacion':
        case 'producto_servicio':
        case 'detalle':
        case 'fecha_inicio':
        case 'frecuencia_intervalo':
        case 'frecuencia_tipo':
        case 'precio':
        case 'observaciones':
        case 'token_relacion_renovacion':
        case 'fecha_renovacion':
        case 'recordatorio':
        case 'autorizado':
        case 'id_relacion_cotizacion':
        case 'renovacion_eliminada':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdRenovacion()
  {
    return $this->idRenovacion;
  }

  /**
   * @param int $idRenovacion
   */
  public function setIdRenovacion($idRenovacion)
  {
    $this->idRenovacion = $idRenovacion;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getIdCliente()
  {
    return $this->idCliente;
  }

  /**
   * @param int $idCliente
   */
  public function setIdCliente($idCliente)
  {
    $this->idCliente = $idCliente;
  }

  /**
   * @return int
   */
  public function getIdContacto()
  {
    return $this->idContacto;
  }

  /**
   * @param int $idContacto
   */
  public function setIdContacto($idContacto)
  {
    $this->idContacto = $idContacto;
  }

  /**
   * @return int
   */
  public function getIdTipo()
  {
    return $this->idTipo;
  }

  /**
   * @param int $idTipo
   */
  public function setIdTipo($idTipo)
  {
    $this->idTipo = $idTipo;
  }

  /**
   * @return int
   */
  public function getIdAreaRenovacion()
  {
    return $this->idAreaRenovacion;
  }

  /**
   * @param int $idAreaRenovacion
   */
  public function setIdAreaRenovacion($idAreaRenovacion)
  {
    $this->idAreaRenovacion = $idAreaRenovacion;
  }

  /**
   * @return string
   */
  public function getProductoServicio()
  {
    return $this->productoServicio;
  }

  /**
   * @param string $productoServicio
   */
  public function setProductoServicio($productoServicio)
  {
    $this->productoServicio = $productoServicio;
  }

  /**
   * @return string
   */
  public function getDetalle()
  {
    return $this->detalle;
  }

  /**
   * @param string $detalle
   */
  public function setDetalle($detalle)
  {
    $this->detalle = $detalle;
  }

  /**
   * @return int
   */
  public function getFechaInicio()
  {
    return $this->fechaInicio;
  }

  /**
   * @param int $fechaInicio
   */
  public function setFechaInicio($fechaInicio)
  {
    $this->fechaInicio = $fechaInicio;
  }

  /**
   * @return int
   */
  public function getFrecuenciaIntervalo()
  {
    return $this->frecuenciaIntervalo;
  }

  /**
   * @param int $frecuenciaIntervalo
   */
  public function setFrecuenciaIntervalo($frecuenciaIntervalo)
  {
    $this->frecuenciaIntervalo = $frecuenciaIntervalo;
  }

  /**
   * @return string
   */
  public function getFrecuenciaTipo()
  {
    return $this->frecuenciaTipo;
  }

  /**
   * @param string $frecuenciaTipo
   */
  public function setFrecuenciaTipo($frecuenciaTipo)
  {
    $this->frecuenciaTipo = $frecuenciaTipo;
  }

  /**
   * @return int
   */
  public function getPrecio()
  {
    return $this->precio;
  }

  /**
   * @param int $precio
   */
  public function setPrecio($precio)
  {
    $this->precio = $precio;
  }

  /**
   * @return string
   */
  public function getObservaciones()
  {
    return $this->observaciones;
  }

  /**
   * @param string $observaciones
   */
  public function setObservaciones($observaciones)
  {
    $this->observaciones = $observaciones;
  }

  /**
   * @return string
   */
  public function getTokenRelacionRenovacion()
  {
    return $this->tokenRelacionRenovacion;
  }

  /**
   * @param string $tokenRelacionRenovacion
   */
  public function setTokenRelacionRenovacion($tokenRelacionRenovacion)
  {
    $this->tokenRelacionRenovacion = $tokenRelacionRenovacion;
  }

  /**
   * @return int
   */
  public function getFechaRenovacion()
  {
    return $this->fechaRenovacion;
  }

  /**
   * @param int $fechaRenovacion
   */
  public function setFechaRenovacion($fechaRenovacion)
  {
    $this->fechaRenovacion = $fechaRenovacion;
  }

  /**
   * @return int
   */
  public function getRecordatorio()
  {
    return $this->recordatorio;
  }

  /**
   * @param int $recordatorio
   */
  public function setRecordatorio($recordatorio)
  {
    $this->recordatorio = $recordatorio;
  }

  /**
   * @return int
   */
  public function getAutorizado()
  {
    return $this->autorizado;
  }

  /**
   * @param int $autorizado
   */
  public function setAutorizado($autorizado)
  {
    $this->autorizado = $autorizado;
  }

  /**
   * @return int
   */
  public function getIdRelacionCotizacion()
  {
    return $this->idRelacionCotizacion;
  }

  /**
   * @param int $idRelacionCotizacion
   */
  public function setIdRelacionCotizacion($idRelacionCotizacion)
  {
    $this->idRelacionCotizacion = $idRelacionCotizacion;
  }

  /**
   * @return int
   */
  public function getRenovacionEliminada()
  {
    return $this->renovacionEliminada;
  }

  /**
   * @param int $renovacionEliminada
   */
  public function setRenovacionEliminada($renovacionEliminada)
  {
    $this->renovacionEliminada = $renovacionEliminada;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}