<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 02/02/2019
 * Time: 11:21 AM
 */

namespace Partners\Cotizacion;


use Partners\Cliente\Cliente;
use Partners\Utils\BaseEntityInterface;

/**
 * Class Cotizacion
 * @package Partners\Cotizacion
 */
class Cotizacion implements BaseEntityInterface
{
  /**
   * @var int
   */
  private $idCotizacion = 0;
  /**
   * @var int
   */
  private $createdAt = 0;
  /**
   * @var int
   */
  private $createdBy = 0;
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;
  /**
   * @var int
   */
  private $idCliente = 0;
  /**
   * @var int
   */
  private $idContacto = 0;
  /**
   * @var int
   */
  private $cotizacionCompartida = 0;
  /**
   * @var string
   */
  private $notas = "";
  /**
   * @var int
   */
  private $ivaIncluido = 0;
  /**
   * @var string
   */
  private $observaciones = "";
  /**
   * @var int
   */
  private $facturado = 0;
  /**
   * @var int
   */
  private $enviado = 0;
  /**
   * @var int
   */
  private $recibido = 0;
  /**
   * @var int
   */
  private $venta = 0;
  /**
   * @var int
   */
  private $compra = 0;
  /**
   * @var int
   */
  private $entregado = 0;
  /**
   * @var int
   */
  private $idArea = 0;
  /**
   * @var int
   */
  private $sinSumatoria = 0;
  /**
   * @var int
   */
  private $tipoCotizacion = 0;
  /**
   * @var int
   */
  private $idRelacionRenovacion = 0;
  /**
   * @var int
   */
  private $cotizacionCompartidaCon = 0;
  /**
   * @var int
   */
  private $cotizacionEliminada = 0;
  /**
   * @var int
   */
  private $cotizacionVinculada = 0;
  /**
   * @var string
   */
  private $textoCorreo = "";
  /**
   * @var null
   */
  private $datosCotizacion = [];

  /**
   * @var Cliente
   */
  private $Cliente = null;

  /**
   * @var Cliente
   */
  private $Contacto = null;

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Cotizacion.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * Cotizacion constructor.
   * @param array $cotizacion
   */
  public function __construct(array $cotizacion)
  {

    if (isset($cotizacion['id_cotizacion'])) {
      $this->idCotizacion = (int)$cotizacion['id_cotizacion'];
    }

    if (isset($cotizacion['created_at'])) {
      $this->createdAt = (int)$cotizacion['created_at'];
    }

    if (isset($cotizacion['created_by'])) {
      $this->createdBy = (int)$cotizacion['created_by'];
    }

    if (isset($cotizacion['updated_at'])) {
      $this->updatedAt = (int)$cotizacion['updated_at'];
    }

    if (isset($cotizacion['updated_by'])) {
      $this->updatedBy = (int)$cotizacion['updated_by'];
    }

    if (isset($cotizacion['id_cliente'])) {
      $this->idCliente = $cotizacion['id_cliente'];
    }

    if (isset($cotizacion['id_contacto'])) {
      $this->idContacto = $cotizacion['id_contacto'];
    }

    if (isset($cotizacion['cotizacion_compartida'])) {
      $this->cotizacionCompartida = (int)$cotizacion['cotizacion_compartida'];
    }

    if (isset($cotizacion['notas'])) {
      $this->notas = (string)$cotizacion['notas'];
    }

    if (isset($cotizacion['iva_incluido'])) {
      $this->ivaIncluido = (int)$cotizacion['iva_incluido'];
    }

    if (isset($cotizacion['observaciones'])) {
      $this->observaciones = (int)$cotizacion['observaciones'];
    }

    if (isset($cotizacion['facturado'])) {
      $this->facturado = (int)$cotizacion['facturado'];
    }

    if (isset($cotizacion['enviado'])) {
      $this->enviado = (int)$cotizacion['enviado'];
    }

    if (isset($cotizacion['recibido'])) {
      $this->recibido = (int)$cotizacion['recibido'];
    }

    if (isset($cotizacion['venta'])) {
      $this->venta = (int)$cotizacion['venta'];
    }

    if (isset($cotizacion['compra'])) {
      $this->compra = (int)$cotizacion['compra'];
    }

    if (isset($cotizacion['entregado'])) {
      $this->entregado = (int)$cotizacion['entregado'];
    }

    if (isset($cotizacion['id_area'])) {
      $this->idArea = (int)$cotizacion['id_area'];
    }

    if (isset($cotizacion['sin_sumatoria'])) {
      $this->sinSumatoria = (int)$cotizacion['sin_sumatoria'];
    }

    if (isset($cotizacion['tipo_cotizacion'])) {
      $this->tipoCotizacion = (int)$cotizacion['tipo_cotizacion'];
    }

    if (isset($cotizacion['id_relacion_renovacion'])) {
      $this->idRelacionRenovacion = (int)$cotizacion['id_relacion_renovacion'];
    }

    if (isset($cotizacion['cotizacion_compartida_con'])) {
      $this->cotizacionCompartidaCon = (int)$cotizacion['cotizacion_compartida_con'];
    }

    if (isset($cotizacion['cotizacion_eliminada'])) {
      $this->cotizacionEliminada = (int)$cotizacion['cotizacion_eliminada'];
    }

    if (isset($cotizacion['cotizacion_vinculada'])) {
      $this->cotizacionVinculada = (int)$cotizacion['cotizacion_vinculada'];
    }

    if (isset($cotizacion['texto_correo'])) {
      $this->textoCorreo = (string)$cotizacion['texto_correo'];
    }

    foreach ($cotizacion as $key => $val){
      switch ($key){
        case 'id_cotizacion':
        case 'created_at':
        case 'created_by':
        case 'updated_at':
        case 'updated_by':
        case 'id_cliente':
        case 'id_contacto':
        case 'cotizacion_compartida':
        case 'notas':
        case 'iva_incluido':
        case 'observaciones':
        case 'facturado':
        case 'enviado':
        case 'recibido':
        case 'venta':
        case 'compra':
        case 'entregado':
        case 'id_area':
        case 'sin_sumatoria':
        case 'tipo_cotizaciones':
        case 'id_relacion_renovacion':
        case 'cotizacion_compartida_con':
        case 'cotizacion_eliminada':
        case 'cotizacion_vinculada':
        case 'texto_correo':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }

  }


  /**
   * @return int
   */
  public function getIdCotizacion()
  {
    return $this->idCotizacion;
  }

  /**
   * @param int $idCotizacion
   */
  public function setIdCotizacion($idCotizacion)
  {
    $this->idCotizacion = $idCotizacion;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getIdCliente()
  {
    return $this->idCliente;
  }

  /**
   * @param int $idCliente
   */
  public function setIdCliente($idCliente)
  {
    $this->idCliente = $idCliente;
  }

  /**
   * @return int
   */
  public function getIdContacto()
  {
    return $this->idContacto;
  }

  /**
   * @param int $idContacto
   */
  public function setIdContacto($idContacto)
  {
    $this->idContacto = $idContacto;
  }

  /**
   * @return int
   */
  public function getCotizacionCompartida()
  {
    return $this->cotizacionCompartida;
  }

  /**
   * @param int $cotizacionCompartida
   */
  public function setCotizacionCompartida($cotizacionCompartida)
  {
    $this->cotizacionCompartida = $cotizacionCompartida;
  }

  /**
   * @return string
   */
  public function getNotas()
  {
    return $this->notas;
  }

  /**
   * @param string $notas
   */
  public function setNotas($notas)
  {
    $this->notas = $notas;
  }

  /**
   * @return int
   */
  public function getIvaIncluido()
  {
    return $this->ivaIncluido;
  }

  /**
   * @param int $ivaIncluido
   */
  public function setIvaIncluido($ivaIncluido)
  {
    $this->ivaIncluido = $ivaIncluido;
  }

  /**
   * @return string
   */
  public function getObservaciones()
  {
    return $this->observaciones;
  }

  /**
   * @param string $observaciones
   */
  public function setObservaciones($observaciones)
  {
    $this->observaciones = $observaciones;
  }

  /**
   * @return int
   */
  public function getFacturado()
  {
    return $this->facturado;
  }

  /**
   * @param int $facturado
   */
  public function setFacturado($facturado)
  {
    $this->facturado = $facturado;
  }

  /**
   * @return int
   */
  public function getEnviado()
  {
    return $this->enviado;
  }

  /**
   * @param int $enviado
   */
  public function setEnviado($enviado)
  {
    $this->enviado = $enviado;
  }

  /**
   * @return int
   */
  public function getRecibido()
  {
    return $this->recibido;
  }

  /**
   * @param int $recibido
   */
  public function setRecibido($recibido)
  {
    $this->recibido = $recibido;
  }

  /**
   * @return int
   */
  public function getVenta()
  {
    return $this->venta;
  }

  /**
   * @param int $venta
   */
  public function setVenta($venta)
  {
    $this->venta = $venta;
  }

  /**
   * @return int
   */
  public function getCompra()
  {
    return $this->compra;
  }

  /**
   * @param int $compra
   */
  public function setCompra($compra)
  {
    $this->compra = $compra;
  }

  /**
   * @return int
   */
  public function getEntregado()
  {
    return $this->entregado;
  }

  /**
   * @param int $entregado
   */
  public function setEntregado($entregado)
  {
    $this->entregado = $entregado;
  }

  /**
   * @return int
   */
  public function getIdArea()
  {
    return $this->idArea;
  }

  /**
   * @param int $idArea
   */
  public function setIdArea($idArea)
  {
    $this->idArea = $idArea;
  }

  /**
   * @return int
   */
  public function getSinSumatoria()
  {
    return $this->sinSumatoria;
  }

  /**
   * @param int $sinSumatoria
   */
  public function setSinSumatoria($sinSumatoria)
  {
    $this->sinSumatoria = $sinSumatoria;
  }

  /**
   * @return int
   */
  public function getTipoCotizacion()
  {
    return $this->tipoCotizacion;
  }

  /**
   * @param int $tipoCotizacion
   */
  public function setTipoCotizacion($tipoCotizacion)
  {
    $this->tipoCotizacion = $tipoCotizacion;
  }

  /**
   * @return int
   */
  public function getIdRelacionRenovacion()
  {
    return $this->idRelacionRenovacion;
  }

  /**
   * @param int $idRelacionRenovacion
   */
  public function setIdRelacionRenovacion($idRelacionRenovacion)
  {
    $this->idRelacionRenovacion = $idRelacionRenovacion;
  }

  /**
   * @return int
   */
  public function getCotizacionCompartidaCon()
  {
    return $this->cotizacionCompartidaCon;
  }

  /**
   * @param int $cotizacionCompartidaCon
   */
  public function setCotizacionCompartidaCon($cotizacionCompartidaCon)
  {
    $this->cotizacionCompartidaCon = $cotizacionCompartidaCon;
  }

  /**
   * @return int
   */
  public function getCotizacionEliminada()
  {
    return $this->cotizacionEliminada;
  }

  /**
   * @param int $cotizacionEliminada
   */
  public function setCotizacionEliminada($cotizacionEliminada)
  {
    $this->cotizacionEliminada = $cotizacionEliminada;
  }

  /**
   * @return int
   */
  public function getCotizacionVinculada()
  {
    return $this->cotizacionVinculada;
  }

  /**
   * @param int $cotizacionVinculada
   */
  public function setCotizacionVinculada($cotizacionVinculada)
  {
    $this->cotizacionVinculada = $cotizacionVinculada;
  }

  /**
   * @return string
   */
  public function getTextoCorreo()
  {
    return $this->textoCorreo;
  }

  /**
   * @param string $textoCorreo
   */
  public function setTextoCorreo($textoCorreo)
  {
    $this->textoCorreo = $textoCorreo;
  }

  /**
   * @return null
   */
  public function getDatosCotizacion()
  {
    return $this->datosCotizacion;
  }

  /**
   * @param null $datosCotizacion
   */
  public function setDatosCotizacion($datosCotizacion)
  {
    $this->datosCotizacion = $datosCotizacion;
  }

  /**
   * @return Cliente
   */
  public function getCliente()
  {
    return $this->Cliente;
  }

  /**
   * @param Cliente $Cliente
   */
  public function setCliente(Cliente $Cliente)
  {
    $this->Cliente = $Cliente;
  }

  /**
   * @return Cliente
   */
  public function getContacto()
  {
    return $this->Contacto;
  }

  /**
   * @param Cliente $Contacto
   */
  public function setContacto(Cliente $Contacto)
  {
    $this->Contacto = $Contacto;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }


}