<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 05/02/2019
 * Time: 02:07 PM
 */

namespace Partners\Cliente;


use Partners\Utils\BaseEntityInterface;

/**
 * Class DatosFacturacion
 * @package Partners\Cliente
 */
class DatosFacturacion implements BaseEntityInterface
{

  /**
   * @var int
   */
  private $idDato = 0;
  /**
   * @var int
   */
  private $idCliente = 0;
  /**
   * @var string
   */
  private $nombreFacturacion = "";
  /**
   * @var string
   */
  private $rfc = "";

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase DatosFacturacion.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * DatosFacturacion constructor.
   * @param $datosFacturacion
   */
  public function __construct($datosFacturacion)
  {
    if (isset($datosFacturacion['id_dato'])) {
      $this->idDato = (int)$datosFacturacion['id_dato'];
    }

    if (isset($datosFacturacion['id_cliente'])) {
      $this->idCliente = (int)$datosFacturacion['id_cliente'];
    }

    if (isset($datosFacturacion['nombre_facturacion'])) {
      $this->nombreFacturacion = (string)$datosFacturacion['nombre_facturacion'];
    }

    if (isset($datosFacturacion['rfc'])) {
      $this->rfc = (string)$datosFacturacion['rfc'];
    }

    foreach ($datosFacturacion as $key => $val) {
      switch ($key) {
        case 'id_dato':
        case 'id_cliente':
        case 'nombre_facturacion':
        case 'rfc':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }


  /**
   * @return int
   */
  public function getIdDato()
  {
    return $this->idDato;
  }

  /**
   * @param int $idDato
   */
  public function setIdDato($idDato)
  {
    $this->idDato = $idDato;
  }

  /**
   * @return int
   */
  public function getIdCliente()
  {
    return $this->idCliente;
  }

  /**
   * @param int $idCliente
   */
  public function setIdCliente($idCliente)
  {
    $this->idCliente = $idCliente;
  }

  /**
   * @return string
   */
  public function getNombreFacturacion()
  {
    return $this->nombreFacturacion;
  }

  /**
   * @param string $nombreFacturacion
   */
  public function setNombreFacturacion($nombreFacturacion)
  {
    $this->nombreFacturacion = $nombreFacturacion;
  }

  /**
   * @return string
   */
  public function getRfc()
  {
    return $this->rfc;
  }

  /**
   * @param string $rfc
   */
  public function setRfc($rfc)
  {
    $this->rfc = $rfc;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}