<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 05/02/2019
 * Time: 01:29 PM
 */

namespace Partners\Cliente;


use Partners\Utils\BaseEntityInterface;

/**
 * Class DatosCliente
 * @package Partners\Cliente
 */
class DatosCliente implements BaseEntityInterface
{
  /**
   * @var int
   */
  private $idDato = 0;
  /**
   * @var int
   */
  private $idCliente = 0;
  /**
   * @var int
   */
  private $tipoDato = 0;
  /**
   * @var string
   */
  private $datoValor = "";
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase DatosCliente.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * DatosCliente constructor.
   * @param $datosCliente
   */
  public function __construct($datosCliente)
  {
    if (isset($datosCliente['id_dato'])) {
      $this->idDato = (int)$datosCliente['id_dato'];
    }

    if (isset($datosCliente['id_cliente'])) {
      $this->idCliente = (int)$datosCliente['id_cliente'];
    }

    if (isset($datosCliente['tipo_dato'])) {
      $this->tipoDato = (int)$datosCliente['tipo_dato'];
    }

    if (isset($datosCliente['dato_valor'])) {
      $this->datoValor = (string)$datosCliente['dato_valor'];
    }

    if (isset($datosCliente['updated_at'])) {
      $this->updatedAt = (int)$datosCliente['updated_at'];
    }

    if (isset($datosCliente['updated_by'])) {
      $this->updatedBy = (int)$datosCliente['updated_by'];
    }

    foreach ($datosCliente as $key => $val) {
      switch ($key) {
        case 'id_dato':
        case 'id_cliente':
        case 'tipo_dato':
        case 'dato_valor':
        case 'updated_at':
        case 'updated_by':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdDato()
  {
    return $this->idDato;
  }

  /**
   * @param int $idDato
   */
  public function setIdDato($idDato)
  {
    $this->idDato = $idDato;
  }

  /**
   * @return int
   */
  public function getIdCliente()
  {
    return $this->idCliente;
  }

  /**
   * @param int $idCliente
   */
  public function setIdCliente($idCliente)
  {
    $this->idCliente = $idCliente;
  }

  /**
   * @return int
   */
  public function getTipoDato()
  {
    return $this->tipoDato;
  }

  /**
   * @param int $tipoDato
   */
  public function setTipoDato($tipoDato)
  {
    $this->tipoDato = $tipoDato;
  }

  /**
   * @return string
   */
  public function getDatoValor()
  {
    return $this->datoValor;
  }

  /**
   * @param string $datoValor
   */
  public function setDatoValor($datoValor)
  {
    $this->datoValor = $datoValor;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}