<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 05/02/2019
 * Time: 05:17 PM
 */

namespace Partners\Cliente;


use Partners\Utils\JsonMessageHelper;
use Partners\Utils\PartnersLogger;
use Partners\Utils\PartnersRouter;

/**
 * Class ClienteRouter
 * @package Partners\Cliente
 */
class ClienteRouter extends PartnersRouter
{
  /**
   * Método en el cual se describen todas las rutas necesarias para interacturar con los CLientes.
   */
  protected function routes()
  {
    $ClienteController = new ClienteController();
    try {
      switch ($this->path) {
        case 'cliente_vista_ventas':
          echo $ClienteController->generarVistaVentas($this->data);
          break;
        default:
          JsonMessageHelper::Error("No se encontró la ruta que buscabas");
      }
    } catch (\Exception $e) {
      PartnersLogger::Error($e, $this->path);
    }
  }
}