<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 05/02/2019
 * Time: 02:16 PM
 */

namespace Partners\Cliente;


use Partners\Utils\BaseEntityInterface;

class ClienteLicencia implements BaseEntityInterface
{

  private $idLicencia = 0;
  private $updatedAt = 0;
  private $updatedBy = 0;
  private $createdAt = 0;
  private $createdBy = 0;
  private $idCliente = 0;
  private $fechaCompraLicencia = 0;
  private $producto = "";
  private $serieLicencia = "";
  private $observaciones = "";

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase ClienteLicencia.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * ClienteLicencia constructor.
   * @param $clienteLicencias
   */
  public function __construct($clienteLicencias)
  {
    if (isset($clienteLicencias['id_licencia'])) {
      $this->idLicencia = (int)$clienteLicencias['id_licencia'];
    }

    if (isset($clienteLicencias['updated_at'])) {
      $this->updatedAt = (int)$clienteLicencias['updated_at'];
    }

    if (isset($clienteLicencias['updated_by'])) {
      $this->updatedBy = (int)$clienteLicencias['updated_by'];
    }

    if (isset($clienteLicencias['created_at'])) {
      $this->createdAt = (int)$clienteLicencias['created_at'];
    }

    if (isset($clienteLicencias['created_by'])) {
      $this->createdBy = (int)$clienteLicencias['created_by'];
    }

    if (isset($clienteLicencias['id_cliente'])) {
      $this->idCliente = (int)$clienteLicencias['id_cliente'];
    }

    if (isset($clienteLicencias['fecha_compra_licencia'])) {
      $this->fechaCompraLicencia = (int)$clienteLicencias['fecha_compra_licencia'];
    }

    if (isset($clienteLicencias['producto'])) {
      $this->producto = (string)$clienteLicencias['producto'];
    }

    if (isset($clienteLicencias['serie_licencia'])) {
      $this->serieLicencia = (string)$clienteLicencias['serie_licencia'];
    }

    if (isset($clienteLicencias['observaciones'])) {
      $this->observaciones = (string)$clienteLicencias['observaciones'];
    }

    foreach ($clienteLicencias as $key => $val) {
      switch ($key) {
        case 'id_licencia':
        case 'updated_at':
        case 'updated_by':
        case 'created_at':
        case 'created_by':
        case 'id_cliente':
        case 'fecha_compra_licencia':
        case 'producto':
        case 'serie_licencia':
        case 'observaciones':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdLicencia()
  {
    return $this->idLicencia;
  }

  /**
   * @param int $idLicencia
   */
  public function setIdLicencia($idLicencia)
  {
    $this->idLicencia = $idLicencia;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getIdCliente()
  {
    return $this->idCliente;
  }

  /**
   * @param int $idCliente
   */
  public function setIdCliente($idCliente)
  {
    $this->idCliente = $idCliente;
  }

  /**
   * @return int
   */
  public function getFechaCompraLicencia()
  {
    return $this->fechaCompraLicencia;
  }

  /**
   * @param int $fechaCompraLicencia
   */
  public function setFechaCompraLicencia($fechaCompraLicencia)
  {
    $this->fechaCompraLicencia = $fechaCompraLicencia;
  }

  /**
   * @return int|string
   */
  public function getProducto()
  {
    return $this->producto;
  }

  /**
   * @param int|string $producto
   */
  public function setProducto($producto)
  {
    $this->producto = $producto;
  }

  /**
   * @return int|string
   */
  public function getSerieLicencia()
  {
    return $this->serieLicencia;
  }

  /**
   * @param int|string $serieLicencia
   */
  public function setSerieLicencia($serieLicencia)
  {
    $this->serieLicencia = $serieLicencia;
  }

  /**
   * @return int|string
   */
  public function getObservaciones()
  {
    return $this->observaciones;
  }

  /**
   * @param int|string $observaciones
   */
  public function setObservaciones($observaciones)
  {
    $this->observaciones = $observaciones;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}