<?php
/**
 * Created by PhpStorm.
 * User: Erick
 * Date: 01/02/2019
 * Time: 05:54 PM
 */

namespace Partners\Cliente;


use Partners\Utils\BaseEntityInterface;

/**
 * Class Cliente
 * @package Partners\Cliente
 */
class Cliente implements BaseEntityInterface
{
  /**
   * @var int
   */
  private $idCliente = 0;
  /**
   * @var mixed|string
   */
  private $areasCliente = "";
  /**
   * @var int|mixed
   */
  private $tipoCliente = 0;
  /**
   * @var mixed|string
   */
  private $email = "";
  /**
   * @var int|mixed
   */
  private $tipoNegocio = 0;
  /**
   * @var mixed|string
   */
  private $relacionado = "";
  /**
   * @var mixed|string
   */
  private $nombreCliente = "";
  /**
   * @var mixed|string
   */
  private $nombreFacturacion = "";
  /**
   * @var mixed|string
   */
  private $alias = "";
  /**
   * @var int|mixed
   */
  private $idPadre = 0;
  /**
   * @var mixed|string
   */
  private $giroEmpresa = "";
  /**
   * @var mixed|string
   */
  private $notasContacto = "";
  /**
   * @var int|mixed
   */
  private $promociones = 0;
  /**
   * @var mixed|string
   */
  private $puestoContacto = "";
  /**
   * @var int|mixed
   */
  private $encuesta = 0;
  /**
   * @var mixed|string
   */
  private $comoSeEntero = "";
  /**
   * @var mixed|string
   */
  private $descripcionOtro = "";
  /**
   * @var mixed|string
   */
  private $compraServicio = "";
  /**
   * @var int
   */
  private $distribuidor = 0;
  /**
   * @var int
   */
  private $credito = 0;
  /**
   * @var mixed|string
   */
  private $tipoClasificacion = "";
  /**
   * @var mixed|string
   */
  private $clasificacionNotas = "";
  /**
   * @var int
   */
  private $particularSucursal = 0;
  /**
   * @var mixed|string
   */
  private $paginaWeb = "";
  /**
   * @var mixed|string
   */
  private $infoAdicional = "";
  /**
   * @var int|mixed
   */
  private $updatedBy = 0;
  /**
   * @var int|mixed
   */
  private $updatedAt = 0;
  /**
   * @var int|mixed
   */
  private $createdBy = 0;
  /**
   * @var int|mixed
   */
  private $createdAt = 0;
  /**
   * @var int|mixed
   */
  private $cancelado = 0;
  /**
   * @var int|mixed
   */
  private $isFromPrepago = 0;
  /**
   * @var mixed|string
   */
  private $observacionesInternas = "";
  /**
   * @var int|mixed
   */
  private $hasLicencia = 0;
  /**
   * @var int|mixed
   */
  private $contactoFacturacion = 0;
  /**
   * @var null
   */
  private $datosCliente = [];
  /**
   * @var null
   */
  private $contactosCliente = null;

  /**
   * @var array
   */
  private $datosFacturacion = [];

  private $clienteLicencias = [];

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Cliente.
   * @var array
   */
  private $__unkownProperties = [];


  /**
   * Cliente constructor.
   * @param array $cliente
   */
  public function __construct(array $cliente)
  {
    if (isset($cliente['id_cliente'])) {
      $this->idCliente = (int)$cliente['id_cliente'];
    }

    if (isset($cliente['areas_cliente'])) {
      $this->areasCliente = (string)$cliente['areas_cliente'];
    }

    if (isset($cliente['tipo_cliente'])) {
      $this->tipoCliente = (int)$cliente['tipo_cliente'];
    }

    if (isset($cliente['email'])) {
      $this->email = (string)$cliente['email'];
    }

    if (isset($cliente['tipo_negocio'])) {
      $this->tipoNegocio = (int)$cliente['tipo_negocio'];
    }

    if (isset($cliente['relacionado'])) {
      $this->relacionado = (string)$cliente['relacionado'];
    }

    if (isset($cliente['nombre_cliente'])) {
      $this->nombreCliente = (string)$cliente['nombre_cliente'];
    }

    if (isset($cliente['nombre_facturacion'])) {
      $this->nombreFacturacion = (string)$cliente['nombre_facturacion'];
    }

    if (isset($cliente['alias'])) {
      $this->alias = (string)$cliente['alias'];
    }

    if (isset($cliente['id_padre'])) {
      $this->idPadre = (int)$cliente['id_padre'];
    }

    if (isset($cliente['giro_empresa'])) {
      $this->giroEmpresa = (string)$cliente['giro_empresa'];
    }

    if (isset($cliente['notas_contacto'])) {
      $this->notasContacto = (string)$cliente['notas_contacto'];
    }

    if (isset($cliente['promociones'])) {
      $this->promociones = (int)$cliente['promociones'];
    }

    if (isset($cliente['puesto_contacto'])) {
      $this->puestoContacto = (string)$cliente['puesto_contacto'];
    }

    if (isset($cliente['encuesta'])) {
      $this->encuesta = (int)$cliente['encuesta'];
    }

    if (isset($cliente['como_se_entero'])) {
      $this->comoSeEntero = (string)$cliente['como_se_entero'];
    }

    if (isset($cliente['descripcion_otro'])) {
      $this->descripcionOtro = (string)$cliente['descripcion_otro'];
    }

    if (isset($cliente['compra_servicio'])) {
      $this->compraServicio = (string)$cliente['compra_servicio'];
    }

    if (isset($cliente['distribuidor'])) {
      $this->distribuidor = (int)$cliente['distribuidor'];
    }

    if (isset($cliente['credito'])) {
      $this->credito = (int)$cliente['credito'];
    }

    if (isset($cliente['tipo_clasificacion'])) {
      $this->tipoClasificacion = (string)$cliente['tipo_clasificacion'];
    }

    if (isset($cliente['clasificacion_notas'])) {
      $this->clasificacionNotas = (string)$cliente['clasificacion_notas'];
    }

    if (isset($cliente['particular_sucursal'])) {
      $this->particularSucursal = (int)$cliente['particular_sucursal'];
    }

    if (isset($cliente['pagina_web'])) {
      $this->paginaWeb = (string)$cliente['pagina_web'];
    }

    if (isset($cliente['info_adicional'])) {
      $this->infoAdicional = (string)$cliente['info_adicional'];
    }

    if (isset($cliente['updated_by'])) {
      $this->updatedBy = (int)$cliente['updated_by'];
    }

    if (isset($cliente['updated_at'])) {
      $this->updatedAt = (int)$cliente['updated_at'];
    }

    if (isset($cliente['created_by'])) {
      $this->createdBy = (int)$cliente['created_by'];
    }

    if (isset($cliente['created_at'])) {
      $this->createdAt = (int)$cliente['created_at'];
    }

    if (isset($cliente['cancelado'])) {
      $this->cancelado = (int)$cliente['cancelado'];
    }

    if (isset($cliente['is_from_prepago'])) {
      $this->isFromPrepago = (int)$cliente['is_from_prepago'];
    }

    if (isset($cliente['observaciones_internas'])) {
      $this->observacionesInternas = (string)$cliente['observaciones_internas'];
    }

    if (isset($cliente['has_licencia'])) {
      $this->hasLicencia = (int)$cliente['has_licencia'];
    }

    if (isset($cliente['contacto_facturacion'])) {
      $this->contactoFacturacion = (int)$cliente['contacto_facturacion'];
    }

    foreach ($cliente as $key => $val) {
      switch ($key) {
        case 'id_cliente':
        case 'areas_cliente':
        case 'tipo_cliente':
        case 'email':
        case 'tipo_negocio':
        case 'relacionado':
        case 'nombre_cliente':
        case 'nombre_facturacion':
        case 'alias':
        case 'id_padre':
        case 'giro_empresa':
        case 'notas_contacto':
        case 'promociones':
        case 'puesto_contacto':
        case 'encuesta':
        case 'como_se_entero':
        case 'descripcion_otro':
        case 'compra_servicio':
        case 'distribuidor':
        case 'credito':
        case 'tipo_clasificacion':
        case 'clasificacion_notas':
        case 'particular_sucursal':
        case 'pagina_web':
        case 'info_adicional':
        case 'updated_by':
        case 'updated_at':
        case 'created_by':
        case 'created_at':
        case 'cancelado':
        case 'is_from_prepago':
        case 'observaciones_internas':
        case 'has_licencia':
        case 'contacto_facturacion':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return array
   */
  public function getDatosCliente()
  {
    return $this->datosCliente;
  }

  /**
   * @param array $datosCliente
   */
  public function setDatosCliente(array $datosCliente)
  {
    $this->datosCliente = $datosCliente;
  }

  /**
   * @return mixed
   */
  public function getContactosCliente()
  {
    return $this->contactosCliente;
  }

  /**
   * @param mixed $contactosCliente
   */
  public function setContactosCliente($contactosCliente)
  {
    $this->contactosCliente = $contactosCliente;
  }

  /**
   * @return mixed
   */
  public function getIdCliente()
  {
    return $this->idCliente;
  }

  /**
   * @param mixed $idCliente
   */
  public function setIdCliente($idCliente)
  {
    $this->idCliente = $idCliente;
  }

  /**
   * @return mixed
   */
  public function getAreasCliente()
  {
    return $this->areasCliente;
  }

  /**
   * @param mixed $areasCliente
   */
  public function setAreasCliente($areasCliente)
  {
    $this->areasCliente = $areasCliente;
  }

  /**
   * @return mixed
   */
  public function getTipoCliente()
  {
    return $this->tipoCliente;
  }

  /**
   * @param mixed $tipoCliente
   */
  public function setTipoCliente($tipoCliente)
  {
    $this->tipoCliente = $tipoCliente;
  }

  /**
   * @return mixed
   */
  public function getEmail()
  {
    return $this->email;
  }

  /**
   * @param mixed $email
   */
  public function setEmail($email)
  {
    $this->email = $email;
  }

  /**
   * @return mixed
   */
  public function getTipoNegocio()
  {
    return $this->tipoNegocio;
  }

  /**
   * @param mixed $tipoNegocio
   */
  public function setTipoNegocio($tipoNegocio)
  {
    $this->tipoNegocio = $tipoNegocio;
  }

  /**
   * @return mixed
   */
  public function getRelacionado()
  {
    return $this->relacionado;
  }

  /**
   * @param mixed $relacionado
   */
  public function setRelacionado($relacionado)
  {
    $this->relacionado = $relacionado;
  }

  /**
   * @return mixed
   */
  public function getNombreCliente()
  {
    return $this->nombreCliente;
  }

  /**
   * @param mixed $nombreCliente
   */
  public function setNombreCliente($nombreCliente)
  {
    $this->nombreCliente = $nombreCliente;
  }

  /**
   * @return mixed
   */
  public function getNombreFacturacion()
  {
    return $this->nombreFacturacion;
  }

  /**
   * @param mixed $nombreFacturacion
   */
  public function setNombreFacturacion($nombreFacturacion)
  {
    $this->nombreFacturacion = $nombreFacturacion;
  }

  /**
   * @return mixed
   */
  public function getAlias()
  {
    return $this->alias;
  }

  /**
   * @param mixed $alias
   */
  public function setAlias($alias)
  {
    $this->alias = $alias;
  }

  /**
   * @return mixed
   */
  public function getIdPadre()
  {
    return $this->idPadre;
  }

  /**
   * @param mixed $idPadre
   */
  public function setIdPadre($idPadre)
  {
    $this->idPadre = $idPadre;
  }

  /**
   * @return mixed
   */
  public function getGiroEmpresa()
  {
    return $this->giroEmpresa;
  }

  /**
   * @param mixed $giroEmpresa
   */
  public function setGiroEmpresa($giroEmpresa)
  {
    $this->giroEmpresa = $giroEmpresa;
  }

  /**
   * @return mixed
   */
  public function getNotasContacto()
  {
    return $this->notasContacto;
  }

  /**
   * @param mixed $notasContacto
   */
  public function setNotasContacto($notasContacto)
  {
    $this->notasContacto = $notasContacto;
  }

  /**
   * @return mixed
   */
  public function getPromociones()
  {
    return $this->promociones;
  }

  /**
   * @param mixed $promociones
   */
  public function setPromociones($promociones)
  {
    $this->promociones = $promociones;
  }

  /**
   * @return mixed
   */
  public function getPuestoContacto()
  {
    return $this->puestoContacto;
  }

  /**
   * @param mixed $puestoContacto
   */
  public function setPuestoContacto($puestoContacto)
  {
    $this->puestoContacto = $puestoContacto;
  }

  /**
   * @return mixed
   */
  public function getEncuesta()
  {
    return $this->encuesta;
  }

  /**
   * @param mixed $encuesta
   */
  public function setEncuesta($encuesta)
  {
    $this->encuesta = $encuesta;
  }

  /**
   * @return mixed
   */
  public function getComoSeEntero()
  {
    return $this->comoSeEntero;
  }

  /**
   * @param mixed $comoSeEntero
   */
  public function setComoSeEntero($comoSeEntero)
  {
    $this->comoSeEntero = $comoSeEntero;
  }

  /**
   * @return mixed
   */
  public function getDescripcionOtro()
  {
    return $this->descripcionOtro;
  }

  /**
   * @param mixed $descripcionOtro
   */
  public function setDescripcionOtro($descripcionOtro)
  {
    $this->descripcionOtro = $descripcionOtro;
  }

  /**
   * @return mixed
   */
  public function getCompraServicio()
  {
    return $this->compraServicio;
  }

  /**
   * @param mixed $compraServicio
   */
  public function setCompraServicio($compraServicio)
  {
    $this->compraServicio = $compraServicio;
  }

  /**
   * @return mixed
   */
  public function getDistribuidor()
  {
    return $this->distribuidor;
  }

  /**
   * @param mixed $distribuidor
   */
  public function setDistribuidor($distribuidor)
  {
    $this->distribuidor = $distribuidor;
  }

  /**
   * @return mixed
   */
  public function getCredito()
  {
    return $this->credito;
  }

  /**
   * @param mixed $credito
   */
  public function setCredito($credito)
  {
    $this->credito = $credito;
  }

  /**
   * @return mixed
   */
  public function getTipoClasificacion()
  {
    return $this->tipoClasificacion;
  }

  /**
   * @param mixed $tipoClasificacion
   */
  public function setTipoClasificacion($tipoClasificacion)
  {
    $this->tipoClasificacion = $tipoClasificacion;
  }

  /**
   * @return mixed
   */
  public function getClasificacionNotas()
  {
    return $this->clasificacionNotas;
  }

  /**
   * @param mixed $clasificacionNotas
   */
  public function setClasificacionNotas($clasificacionNotas)
  {
    $this->clasificacionNotas = $clasificacionNotas;
  }

  /**
   * @return mixed
   */
  public function getParticularSucursal()
  {
    return $this->particularSucursal;
  }

  /**
   * @param mixed $particularSucursal
   */
  public function setParticularSucursal($particularSucursal)
  {
    $this->particularSucursal = $particularSucursal;
  }

  /**
   * @return mixed
   */
  public function getPaginaWeb()
  {
    return $this->paginaWeb;
  }

  /**
   * @param mixed $paginaWeb
   */
  public function setPaginaWeb($paginaWeb)
  {
    $this->paginaWeb = $paginaWeb;
  }

  /**
   * @return mixed
   */
  public function getInfoAdicional()
  {
    return $this->infoAdicional;
  }

  /**
   * @param mixed $infoAdicional
   */
  public function setInfoAdicional($infoAdicional)
  {
    $this->infoAdicional = $infoAdicional;
  }

  /**
   * @return mixed
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param mixed $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return mixed
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param mixed $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return mixed
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param mixed $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return mixed
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param mixed $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return mixed
   */
  public function getCancelado()
  {
    return $this->cancelado;
  }

  /**
   * @param mixed $cancelado
   */
  public function setCancelado($cancelado)
  {
    $this->cancelado = $cancelado;
  }

  /**
   * @return mixed
   */
  public function getisFromPrepago()
  {
    return $this->isFromPrepago;
  }

  /**
   * @param mixed $isFromPrepago
   */
  public function setIsFromPrepago($isFromPrepago)
  {
    $this->isFromPrepago = $isFromPrepago;
  }

  /**
   * @return mixed
   */
  public function getObservacionesInternas()
  {
    return $this->observacionesInternas;
  }

  /**
   * @param mixed $observacionesInternas
   */
  public function setObservacionesInternas($observacionesInternas)
  {
    $this->observacionesInternas = $observacionesInternas;
  }

  /**
   * @return mixed
   */
  public function getHasLicencia()
  {
    return $this->hasLicencia;
  }

  /**
   * @param mixed $hasLicencia
   */
  public function setHasLicencia($hasLicencia)
  {
    $this->hasLicencia = $hasLicencia;
  }

  /**
   * @return mixed
   */
  public function getContactoFacturacion()
  {
    return $this->contactoFacturacion;
  }

  /**
   * @param mixed $contactoFacturacion
   */
  public function setContactoFacturacion($contactoFacturacion)
  {
    $this->contactoFacturacion = $contactoFacturacion;
  }

  /**
   * @return array
   */
  public function getDatosFacturacion()
  {
    return $this->datosFacturacion;
  }

  /**
   * @param array $datosFacturacion
   */
  public function setDatosFacturacion($datosFacturacion)
  {
    $this->datosFacturacion = $datosFacturacion;
  }

  /**
   * @return array
   */
  public function getClienteLicencias()
  {
    return $this->clienteLicencias;
  }

  /**
   * @param array $clienteLicencias
   */
  public function setClienteLicencias($clienteLicencias)
  {
    $this->clienteLicencias = $clienteLicencias;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }

}