<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 17/05/2019
 * Time: 02:21 PM
 */

namespace Partners\Backups;


use Exception;
use Partners\Utils\JsonMessageHelper;
use Partners\Utils\PartnersLogger;
use Partners\Utils\PartnersRouter;

class BackupsRouter extends PartnersRouter
{
  protected function routes()
  {
    $backupsController = new BackupsController();
    try {
      switch ($this->path) {
        case 'reporte_base':
          $backupsController->reporteBase($this->data);
          break;
        case 'nuevo_backup':
          $backupsController->vistaNuevoBackup();
          break;
        case 'capturar_respaldo':
          $backupsController->capturarBackup($this->data);
          break;
        case 'vista_equipos':
          $backupsController->vistaEquipos($this->data);
          break;
        case 'consultar_espacio_equipo':
          $backupsController->consultarEspacioEquipo($this->data);
          break;
        case 'consultar_espacio_bucket':
          $backupsController->consultarEspacioBucket($this->data);
          break;
        case 'capturar_edicion_equipos':
          $backupsController->capturarEdicionEquipos($this->data);
          break;
        case 'capturar_edicion_paquete':
          $backupsController->capturarEdicionPaquete($this->data);
          break;
        case 'pre_eliminar_backup':
          $backupsController->preEliminarBackup($this->data);
          break;
        case 'eliminar_backup':
          $backupsController->eliminarBackup($this->data);
          break;
        case 'cambiar_status_access_key':
          $backupsController->cambiarStatusAccessKey($this->data);
          break;
        case 'load_obs':
          $backupsController->loadObs($this->data);
          break;
        case 'vista_ficha_backup':
          $backupsController->vistaFichaBackup($this->data);
          break;
        case 'lista_tecnicos':
          $backupsController->listaTecnicos();
          break;
        case 'send_token_secret_key':
          $backupsController->sendTokenSecretKey($this->data);
          break;
        case 'validar_codigo_ficha':
          $backupsController->validarCodigoFicha($this->data);
          break;
        default:
          JsonMessageHelper::Error("No se encontró la ruta que buscabas");
      }
    } catch (Exception $e) {
      PartnersLogger::Error($e, $this->path);
    }
  }
}