<?php
/**
 * Archivo del sistema interno de pcpartners.com.mx.
 * User: Erick
 * Date: 18/05/2019
 * Time: 12:45 PM
 */

namespace Partners\Backups;


use Partners\Utils\BaseEntityInterface;

/**
 * Class Backup
 * @package Partners\Backups
 */
class Backup implements BaseEntityInterface
{
  /**
   * @var int
   */
  private $idBackup = 0;
  /**
   * @var int
   */
  private $createdAt = 0;
  /**
   * @var int
   */
  private $createdBy = 0;
  /**
   * @var int
   */
  private $updatedAt = 0;
  /**
   * @var int
   */
  private $updatedBy = 0;
  /**
   * @var int
   */
  private $idCliente = 0;
  /**
   * @var int
   */
  private $idContacto = 0;
  /**
   * @var string
   */
  private $nombreBucket = '';
  /**
   * @var int
   */
  private $paqueteRespaldo = 0;
  /**
   * @var string
   */
  private $accessKeyAWS = "";
  /**
   * @var string
   */
  private $secretKeyAWS = "";
  /**
   * @var string
   */
  private $tokenRenovacion = "";
  /**
   * @var float
   */
  private $usoReal = 0;
  /**
   * @var int
   */
  private $ultimaFechaUsoReal = 0;
  /**
   * @var array
   */
  private $listEquipos = [];
  /**
   * @var string
   */
  private $observaciones = null;
  /**
   * @var int
   */
  private $eliminar = 0;
  /**
   * @var int
   */
  private $accessKeyStatus = 1;

  /**
   * Este atributo guarda todas las propiedades que no estan estandarizadas pero
   * que de alguna manera se necesitaron pasar al momento de instanciar un objeto de la
   * clase Backup.
   * @var array
   */
  private $__unkownProperties = [];

  /**
   * Backup constructor.
   * @param $datosBackup
   */
  public function __construct($datosBackup)
  {
    if (isset($datosBackup['id_backup'])) {
      $this->idBackup = (int)$datosBackup['id_backup'];
    }
    if (isset($datosBackup['created_at'])) {
      $this->createdAt = (int)$datosBackup['created_at'];
    }
    if (isset($datosBackup['created_by'])) {
      $this->createdBy = (int)$datosBackup['created_by'];
    }
    if (isset($datosBackup['updated_at'])) {
      $this->updatedAt = (int)$datosBackup['updated_at'];
    }
    if (isset($datosBackup['updated_by'])) {
      $this->updatedBy = (int)$datosBackup['updated_by'];
    }
    if (isset($datosBackup['id_cliente'])) {
      $this->idCliente = (int)$datosBackup['id_cliente'];
    }
    if (isset($datosBackup['id_contacto'])) {
      $this->idContacto = (int)$datosBackup['id_contacto'];
    }
    if (isset($datosBackup['nombre_bucket'])) {
      $this->nombreBucket = (string)$datosBackup['nombre_bucket'];
    }
    if (isset($datosBackup['paquete_respaldo'])) {
      $this->paqueteRespaldo = (int)$datosBackup['paquete_respaldo'];
    }
    if (isset($datosBackup['access_key_aws'])) {
      $this->accessKeyAWS = (string)$datosBackup['access_key_aws'];
    }
    if (isset($datosBackup['secret_key_aws'])) {
      $this->secretKeyAWS = (string)$datosBackup['secret_key_aws'];
    }
    if (isset($datosBackup['token_renovacion'])) {
      $this->tokenRenovacion = (string)$datosBackup['token_renovacion'];
    }
    if (isset($datosBackup['uso_real'])) {
      $this->usoReal = (float)$datosBackup['uso_real'];
    }
    if (isset($datosBackup['ultima_fecha_uso_real'])) {
      $this->ultimaFechaUsoReal = (integer)$datosBackup['ultima_fecha_uso_real'];
    }
    if (isset($datosBackup['observaciones'])) {
      $this->observaciones = (string)$datosBackup['observaciones'];
    }
    if (isset($datosBackup['eliminar'])) {
      $this->eliminar = (integer)$datosBackup['eliminar'];
    }
    if (isset($datosBackup['access_key_status'])) {
      $this->accessKeyStatus = (integer)$datosBackup['access_key_status'];
    }

    foreach ($datosBackup as $key => $val) {
      switch ($key) {
        case 'id_backup':
        case 'created_at':
        case 'created_by':
        case 'updated_at':
        case 'updated_by':
        case 'id_cliente':
        case 'id_contacto':
        case 'nombre_bucket':
        case 'paquete_respaldo':
        case 'id_renovacion':
        case 'access_key_aws':
        case 'secret_key_aws':
        case 'token_renovacion':
        case 'uso_real':
        case 'ultima_fecha_uso_real':
        case 'observaciones':
        case 'eliminar':
        case 'access_key_status':
          break;
        default:
          $this->__unkownProperties[$key] = $val;
      }
    }
  }

  /**
   * @return int
   */
  public function getIdBackup()
  {
    return $this->idBackup;
  }

  /**
   * @param int $idBackup
   */
  public function setIdBackup($idBackup)
  {
    $this->idBackup = $idBackup;
  }

  /**
   * @return int
   */
  public function getCreatedAt()
  {
    return $this->createdAt;
  }

  /**
   * @param int $createdAt
   */
  public function setCreatedAt($createdAt)
  {
    $this->createdAt = $createdAt;
  }

  /**
   * @return int
   */
  public function getCreatedBy()
  {
    return $this->createdBy;
  }

  /**
   * @param int $createdBy
   */
  public function setCreatedBy($createdBy)
  {
    $this->createdBy = $createdBy;
  }

  /**
   * @return int
   */
  public function getUpdatedAt()
  {
    return $this->updatedAt;
  }

  /**
   * @param int $updatedAt
   */
  public function setUpdatedAt($updatedAt)
  {
    $this->updatedAt = $updatedAt;
  }

  /**
   * @return int
   */
  public function getUpdatedBy()
  {
    return $this->updatedBy;
  }

  /**
   * @param int $updatedBy
   */
  public function setUpdatedBy($updatedBy)
  {
    $this->updatedBy = $updatedBy;
  }

  /**
   * @return int
   */
  public function getIdCliente()
  {
    return $this->idCliente;
  }

  /**
   * @param int $idCliente
   */
  public function setIdCliente($idCliente)
  {
    $this->idCliente = $idCliente;
  }

  /**
   * @return int
   */
  public function getIdContacto()
  {
    return $this->idContacto;
  }

  /**
   * @param int $idContacto
   */
  public function setIdContacto($idContacto)
  {
    $this->idContacto = $idContacto;
  }

  /**
   * @return string
   */
  public function getNombreBucket()
  {
    return $this->nombreBucket;
  }

  /**
   * @param string $nombreBucket
   */
  public function setNombreBucket($nombreBucket)
  {
    $this->nombreBucket = $nombreBucket;
  }

  /**
   * @return int
   */
  public function getPaqueteRespaldo()
  {
    return $this->paqueteRespaldo;
  }

  /**
   * @param int $paqueteRespaldo
   */
  public function setPaqueteRespaldo($paqueteRespaldo)
  {
    $this->paqueteRespaldo = $paqueteRespaldo;
  }

  /**
   * @return string
   */
  public function getAccessKeyAWS()
  {
    return $this->accessKeyAWS;
  }

  /**
   * @param string $accessKeyAWS
   */
  public function setAccessKeyAWS($accessKeyAWS)
  {
    $this->accessKeyAWS = $accessKeyAWS;
  }

  /**
   * @return string
   */
  public function getSecretKeyAWS()
  {
    return $this->secretKeyAWS;
  }

  /**
   * @param string $secretKeyAWS
   */
  public function setSecretKeyAWS($secretKeyAWS)
  {
    $this->secretKeyAWS = $secretKeyAWS;
  }

  /**
   * @return string
   */
  public function getTokenRenovacion()
  {
    return $this->tokenRenovacion;
  }

  /**
   * @param string $tokenRenovacion
   */
  public function setTokenRenovacion($tokenRenovacion)
  {
    $this->tokenRenovacion = $tokenRenovacion;
  }

  /**
   * @return array
   */
  public function getListEquipos()
  {
    return $this->listEquipos;
  }

  /**
   * @param array $listEquipos
   */
  public function setListEquipos($listEquipos)
  {
    $this->listEquipos = $listEquipos;
  }

  /**
   * @return float
   */
  public function getUsoReal()
  {
    return $this->usoReal;
  }

  /**
   * @param float $usoReal
   */
  public function setUsoReal($usoReal)
  {
    $this->usoReal = $usoReal;
  }

  /**
   * @return int
   */
  public function getUltimaFechaUsoReal()
  {
    return $this->ultimaFechaUsoReal;
  }

  /**
   * @return string
   */
  public function getObservaciones()
  {
    return $this->observaciones;
  }

  /**
   * @param string $observaciones
   */
  public function setObservaciones($observaciones)
  {
    $this->observaciones = $observaciones;
  }

  /**
   * @return int
   */
  public function getEliminar()
  {
    return $this->eliminar;
  }

  /**
   * @param int $eliminar
   */
  public function setEliminar($eliminar)
  {
    $this->eliminar = $eliminar;
  }

  /**
   * @param int $ultimaFechaUsoReal
   */
  public function setUltimaFechaUsoReal($ultimaFechaUsoReal)
  {
    $this->ultimaFechaUsoReal = $ultimaFechaUsoReal;
  }

  /**
   * @return int
   */
  public function getAccessKeyStatus()
  {
    return $this->accessKeyStatus;
  }

  /**
   * @param int $accessKeyStatus
   */
  public function setAccessKeyStatus($accessKeyStatus)
  {
    $this->accessKeyStatus = $accessKeyStatus;
  }

  /**
   * @return array
   */
  public function getUnkownProperties()
  {
    return $this->__unkownProperties;
  }

  /**
   * @param array $_unkownProperties
   */
  public function setUnkownProperties($_unkownProperties)
  {
    $this->__unkownProperties = $_unkownProperties;
  }

  /**
   * @return mixed
   */
  function __toJson()
  {
    return json_encode(get_object_vars($this));
  }

  /**
   * @return mixed
   */
  function __toArray()
  {
    return json_decode(json_encode(get_object_vars($this)), true);
  }
}