# Documentación completa orientada al desarrolador del sistema interno de [PcPartners](http://www.pcpartners.com.mx)

![Deploy to server](https://github.com/alejandro-antonio/partners/workflows/Deploy%20to%20server/badge.svg)

## Durante el transcurso del desarrollo del sistema, se han ido detectando fallas y posibles mejoras, las cuales deberán ser corregidas e implementadas conforme pasa el tiempo

### Fallas de la versión 1.0

1. Filtrado de los reporteadores ineficiente
2. Uso de `GET` en lugar de `POST` para capturar
3. Uso inapropiado de tablas para construir formularios
4. Estilos inconcistentes por todo el sistema
5. No permitia usar comillas o diagonales en captura de datos
6. Directorios del sistema poco organizados
7. Rutas URL inconcistentes
8. Necesita permisos del navegador para abrir ventanas emergentes
9. Librerias repetidas en diferentes directorios
10. Usaba alertas del navegador (pueden ser bloqueadas por el usuario)

### Posibles Mejoras a implementar en esta versión

1. Uso de Pre-Loader
2. Mejorar el control/seguimiento de las acciones de los usuarios
3. Mejorar Control de estatus con acciones directas a bases de datos
4. Separar correctamente la lógica de la vista
5. Uso de engine de templates
6. Usar un mismo sistema de notificaciones de acciones
7. Usar una misma libreria para remplazar las alertas del navegador
8. Implementar UNDO en acciones con bases de datos
9. Implementar un include de todas las librerias CSS/JS
10. Crear vistas principales por usarios
11. Usar el mismo formato en todos los correos electrónicos
12. Mejorar estatus básicos de dos acciones (ej. Si/No)
13. Cuando suceda un error, tener la posibilidad de informarlo al programador
14. Temporizadores en pendientes
15. Uso de Bootrstrap v4
16. Uso de bootstrap datepicker

* * *

### Documentación de módulos

* * *

* ### System

* **partners.system.inc**

Igual que todos los archivos `.inc` solamente funcionan para hacer uso de las clases.

* **class.sys_tools.inc**

Contiene las siguientes funciones que se necesitarán a lo largo de todo el sistema, manteniendo en mente la filosofia [DRY](https://en.wikipedia.org/wiki/Don%27t_repeat_yourself).
Dicha clase será extendida por todas las clases del sistema para poder hace uso de sus métodos.

* `system:throw_message:` Función utilizada para devolver los valores de cada función, como normalmente todas las funciones fueron solicitadas desde `ajax`,
necesito que me devuleva un json con información útil, en este caso, devuelve un success o error dependiendo del proceso de la función.

* `system:report_error:` Función utilizada para reportar un error fatal del sistema, son llamados errores fatales porque son errores que no fueron
ocasionados por algún uso incorrecto del usuario, sino porque son errores del sistema propio, por lo tanto, requieren atención inmediata, así que lo que
hace la función es avisar al programador mediante un panel, y aparte mediante un correo electrónico, en ambos casos enviando información
útil sobre el error. Cabe destacar que este proceso solamente se podrá realizar en dado caso de que el usuario lo reporte. Cuando se detecte un error fatal en el
sistema, se le avisará al usuario de inmediato, y se le pedirá de favor que envie el reporte de error con un simple click.

* `system:throw_fatal_error:` Función lanzada cuando entra el bloque de Except en el try-catch para avisar sobre un error fatal.

* `system:lista_clientes:` Función utilizada para devolver la lista de los clientes en la base de datos, como esta consulta es sumamente común, se decidió
colocarla como una herramienta del sistema para ser utilizada en todos lados.

* `system:pagination:` Función utilizada para generar una paginación en los reporteadores que lo necesiten.

* `system:sort_table` Función utilizada para ordenar datos de los reporteadores mediante sus columnas. Solamente se encarga de ordenar
el `thead` de las tablas, las consultas en si para ordenar los datos, son realizadas en cada reporteador.

* `system:send_mail` Función utilizada para enviar correos, se necesitan pasar todos los parametros para que se pueda enviar el
correo correctamente. Ahora el cuerpo de los correos se genera en templates. Los correos se envian ahora de manera individual de uno
por uno, y no de todos al mismo tiempo, ejemplo, si se deseaba enviar un correo a varias personas, se agregaba el destinatario
multiple y se enviaba un solo correo a varias personas, ahora cuando se requiere enviar a multiples destinatarios, envia los correos
de uno por uno para que no muestre en el destinatario que se ha enviado a varias personas.

* `system:encrypt_decrypt` Función utilizada para encriptar datos, normalmente para ser mandados por url, se utilizó por primera vez
para generar una especie de "token" el cual tenia encriptado un id, el cual con la misma función se puede desencriptar para saber
lo que contiene.

* `system:register_log_actions` Función utilizada para registrar todos los movimientos que se hacen en la base de datos. Guarda solamente
las queries que impliquen alguna modificación de información, y algunas otras acciones. Principalmente registra: (Update,Insert,Delete,Mail,Telegram) <los select de la base de datos
no los registra>

* `system:lista_clientes` Función utilizada para generar una lista de todos los clientes, es especificamente
para alimentar al buscador `typeahead`.

* `system:lista_contactos` Función utilizada para generar la lista de los contactos pertenecientes a
un cliente, trabaja en conjunto con el buscador de clientes `typeahead`

* `system:generate_pdf` Función utilizada para renderizar pdf en base a un template (.tpl). Ya sea
que lo genere en la pantalla, o lo prepare para ser enviado por email.

* `system:auth_user_nip` Función utilizada para autentificar a los usuarios mediante su NIP, regresa
el uid y name en un array en caso de que se haya encontrado una coincidencia con el NIP.

* `system:load_producto_info` Función utilizada para obtener los datos de los productos desde
la base local de los productos. Los datos están encriptados en una tabla de la base de datos para
mayor seguridad.

* `system:serialize_obs` Función utilizada para dar formato a las observaciones, solamente se pasarán parametros
y regresara el texto listo (serializado) para ser capturado en la base de datos.

* `system:load_obs` Función utilizada para capturar las observaciones, trabaja en conjunto con el
plugin de `partnersObs`.
* `system:capturar_entrada_caja` Función utilizada para capturar movimientos en la caja desde a fuera en otros modulos,
será utilizada para cuando se marquen estatus de los reporteadores en pagado y se tenga que capturar la cantidad en la caja.

* **partnersPlugin.js**

* `partnersObs(settings)`
Función utilizada para ver y capturar observaciones dentro de los reporteadores, solamente
bastará con que se pasen todos los parámetros necesarios, y el plugin se encargará
de mostrar y capturar las observaciones, para inicializarlo, se deberá llamar de la siguiente
manera:

```javascript
// Ejemplo:
$(this).partnersObs(
    {
        modalId: 'modal-id', // ID que se le dará al modal de observaciones.
        ajaxUrl: settings.module.ruta_sys_tools + 'load_obs', //La ruta será la misma
        index: 'id_salida', //El index principal de la tabla, utilizado para condicionar al momento de capturar
        id_index: 123, // El id del registro a modificar
        tabla: 'partners_mercancia', // La tabla a modificar
        col: 'observaciones', // El nombre de la columna de observaciones
        only_view: true, // Si se desea que las observaciones no se permita agregar, solo vista, poner este parametro verdadero
        auth_user: true, // Cuando se necesita que se autorice el usuario
        closeAfterSuccess: true, // Una vez se guarda la observación, se cerrará el modal
        ajaxSuccessCallback: function (callback_only_on_auth_user) { // Callback a ejecutar una vez se capturen las observaciones, si tiene auth_user = true, regresará los datos del usuario autorizado.
        autoUpdate.forceUpdate();
        }
    }
);
```

* `partnersEditableContent(ruta,callback)`

Esta función es utilizada para permitir que se edite el contenido en páginas,
se edite de forma directa, de uno por uno, se creo pensado principalmente en la edición de los pendientes, pero podrá
ser utlizada en donde se requiera, siempre y cuando se siga una misma sintaxis.

Para utilizarlo, basta con solamente llamarlo una vez al inicio del archivo en el que se desea editar el contenido, pasando
como parametro la ruta a la que se harán las capturas.

El plugin necesita de los siguientes parametros para poder funcionar correctamente, los cuales se deberán de incluir en las
etiquetas html metiante atributos, y además se puede pasar algún callback por la función
 en js, para que sea ejecutada una vez se realice la edición correcatamente.

Attribute | Descripción | Valores
--------- | ----------- | -------
partners_edit | Clase utilizada para inicializar en cada elemento el plugin | .partners_edit
data-edit-type | Tipo de edición del elemento | (text, date, select, radio)
data-edit-widget-type | Solamente funciona junto con el tipo de texto | input o textarea
data-edit-id | El id del registro a editar para condicionar en la consulta | unique_id
data-edit-column | La columna(campo) de la tabla a editar | column
data-edit-table | La tabla de la base de datos a editar | table
data-edit-table-key | La primary-key de la tabla para hacer la condicion | primary key

Los valores ya modificados y listos para editarse se generarán en el plugin, los datos anteriores
son todos los datos que se necesitan para inicializar un elemento editable.
Se pide la tabla y columna porque el plugin será solamente llamado una sola vez por módulo, y en la clase
de system en php se manejará todas las consultas necesarias, todo esto para no repetir esta función en
cada uno de los módulos.

Ejemplo de sintaxis:

```html
<div class="row margin-bot">
    <div class="col-md-3">
        Horario
    </div>
    <div class="col-md-8">
        <div class="editable-field col-md-10">Text</div>
    </div>
    <div class="col-md-1" style="overflow:hidden;">
        <i class="fa fa-pencil float-right partners-edit" data-edit-type="text" data-edit-widget-type="input" data-edit-id="14295" data-edit-column="horario_pendiente" data-edit-table="partners_pendientes" data-edit-table-key="id_pendiente" role="button" aria-hidden="true"></i>
    </div>
</div>



<div class="row margin-bot">
    <div class="col-md-3">
        Date
    </div>
    <div class="col-md-8">
        <div class="editable-field col-md-10">15/06/2017</div>
    </div>
    <div class="col-md-1" style="overflow:hidden;">
        <i class="fa fa-pencil float-right partners-edit" data-edit-type="date"  data-edit-id="14295" data-edit-column="fecha_pendiente" data-edit-table="partners_pendientes" data-edit-table-key="id_pendiente" role="button" aria-hidden="true"></i>
    </div>
</div>


<div class="row margin-bot">
    <div class="col-md-3">
        Radio
    </div>
    <div class="col-md-8">
        <div class="editable-field col-md-10">Urgente</div>
    </div>
    <div class="col-md-1" style="overflow:hidden;">
        <i class="fa fa-pencil float-right partners-edit" data-edit-type="radio" data-edit-radio-options='"Urgente" : 1,"Mismo Día" : 2, "Programar" : 3, "Cuando haya vuelta": 4' data-edit-id="14295" data-edit-column="prioridad_pendiente" data-edit-table="partners_pendientes" data-edit-table-key="id_pendiente" role="button" aria-hidden="true"></i>
    </div>
</div>

<div class="row margin-bot">
    <div class="col-md-3 font-weight-bold">
        Asignado a
    </div>
    <div class="col-md-8">
        <div class="editable-field col-md-10">{$datos.pendiente.asignado_para}</div>
    </div>
    <div class="col-md-1" style="overflow:hidden;">
        <i class="fa fa-pencil float-right partners-edit" data-edit-type="select"
           data-edit-extra-ruta="/pendientes/consultas/telegram "
           data-edit-select-options='{loop $datos.usuarios_area}"{$name}":"{$uid}",{/loop}'
           data-edit-id="{$datos.pendiente.id_pendiente}" data-edit-column="asignado_para"
           data-edit-table="partners_pendientes" data-edit-table-key="id_pendiente" role="button"
           aria-hidden="true"></i>
    </div>
</div>
```

* `auth_user(callback)`

Esta función es de suma importancia, ya se tenia implementada en la versión anterior, pero de una manera
no eficiente que se repetia en cada lugar que se necesitaba autenticar a cada usuario, dando como resultado
que el mismo código haya sido repetido más de 10 veces durante todo el sistema. Ahora con esta mejora, se logró
realizar la función para que funcione dentro del plugin de PartnersInterno y solamente se tenga que llamar
en los lugares en los que se necesite haciendo esto mucho más eficiente ya que solamente se tendrá el código 1
sola vez y ser utilizado un número indefinido de veces, siempre y cuando siguiendo una
sintaxis especifica:

Ejemplo:
Se tiene una funcion en un evento "submit" para guardar  un formulario, ya esta
todo listo para guardar y solamente se necesita autenticar el usuario mediante su NIP, etonces
se utiliza la función:

```javascript
auth_user(
    function(user_authenticated){
    callback
    }
);
```

La función recibe como parámetro una función con el callback a realizar una vez
se autentifique el usuario, un ejemplo común de como seria el uso de esta función
dentro de un evento "submit" seria la siguiente:

```javascript
$(document).on('submit','#form',function(){
//...

auth_user(function(user_authenticated){
    datosEnvio.uid = JSON.parse(user_authenticated)[0];
    var envio = JSON.stringify(datosEnvio);
    $.ajax({
        type: 'POST',
        //...
    });
});

});
```

Lo que sucede en la función de ``auth_user``, es que en el parámetro regresa un array
con los datos del usuario que se autentico correctamente, y dichos datos
son utilizados en este caso para ponerlos en ``datosEnvio.uid``. Solamente
se ejecutará el callback en caso de que se logré autentificar al usuario, de lo contrario
seguira pidiendo el NIP correcto.
Se necesita seguir la sintaxis anterior, en la que dentro del callback se
hace el uso correcto del array regresado por ``auth_user``.

* `delay(callback,ms)`

Función utilizada para retrasar cierta acción por un lapso de tiempo en espeficico. Se
utiliza normalmente por ejemplo en los buscadores, que despues de ciertos ms, se ejecute la
función de buscar y no en cada keyup:

```javascript
delay(function(){
    console.log("Esperé 500 ms para ejecutarme!");
},500);
```

* `autoUpdate()`

Función utilizada para controlar de una mejor manera la actualización de información
de los reporteadores, recibe como parametros un objeto con las siguientes opciones:

Parametro | Descripción | Tipo
--------- | ----------- | -------
toUpdate | Se pasa la función utilizada para actualizar el reporteador deseado | function(){};
interval | Cada cuantos segundos se actualizará automáticamente el reporteador | int
iddle_after | A partir de cuantos segundos se considera que el usuario esta en iddle para que deje de actualizarce automáticamente | int

La función también contiene el método `forceUpdate` que servirá para actualizar el reporteador
en el momento que se requiera sin tener que esperar a que se actualice automáticamente. Para
llamaralo basta con: `autoUpdate.forceUpdate()` y se actualizará en ese momento.

Está es la sintaxis a seguir:

```javascript
var autoUpdate = new AutoUpdate({
            toUpdate: function () {
                reporte_base();
            },
            interval: 1110,
            iddle_after: 120,
        });
```

``fixBootstrapModal y restoreBootstrapModal``
Funciones utilizadas para controlar un error con los modales de bootstrap, que
al momento de que se abre algun otro elemento por encima del modal (iziToast o swal) y este
contiene un input, no se podrá hacer focus en el input porque el modal de bootstrap contiene
un attr de tabindex, entonces está función (que trabajan en conjunto) se encarga de eliminar
ese atributo y después volverlo a colocar para que no interfiera. Para ejecutarlas solamente se
tienen que llamar en la parte del código que se desee solucionar el problema:

``fixBootstrapModal() y después llamar restoreBootstrapModal() para regresar el comportamiento del modal al
original``

* ``getUrlVars()`` Función utilizada para obtener los datos de una url.

```javascript
// Ej.
if(getUrlVars()["new_cliente"] == 1) console.log("Si existe el parametro en la url");
 ```

* ``generar_contactos(ruta,id_cliente)`` Función utilizada para generar la lista de
todos los contactos relacionados con cierto cliente, la función normalmente será utilizada
junto con el ``typeahead`` al momento de que se estén buscando clientes. Para ejecutarla, solamente
basta con llamar la función junto con sus dos parámetros.

* ``partnersfilter()`` Plugin utilizado para filtrar tablas por todas y cada una de las columnas
que se le especifique. Realiza las mismas acciones que un filtrado de excel. Para inicializarlo solamente
hace falta llamarlo en la tabla que se quiera filtrar. Si se necesitan sumatorias, se tendrá que
quitar la sumatoria que se hace con php y dejar que el plugin las haga, y se tendrían que pasar los
siguientes parámetros.

```javascript
$('#id-de-tabla').partnersfilter({
    sumatory: true,
    sumatory_cols: ["total-col", "saldo-col"]
});

// Siendo sumatory_cols las columnas de las cuales se requiere sumatoria
```

 En caso de que no se necesite sumatoria, solamente hay que llamar al plugin sin parámetros:

```javascript
    $('#id-de-tabla').partnersfilter();
```

Se necesita seguir una sintaxis especifica en la tabla para que el plugin pueda funcionar
correctamente, en este caso, solo basta con modificar la forma en la que se genera el thead
en php y ya será suficiente:

```php
    array("data" => "Cliente", "class" => "filter-text")
```

Existen 3 diferentes tipos de columnas para filtrar: por texto, fecha o número.
Solamente bastará con poner la clase en cada columna de la tabla para especificarle
para que tipo de columna se generará el filtro: `filter-text, filter-date o filter-number`.
En caso de que no se quiera que una columna sea filtrada, basta con agregar la clase `dont-filter`
y el filtro ignorará esa columna.

* * *

* ## Clientes

* **partners.clientes.inc**

De ahora en adelante, se hará el uso del autoload de composer para incluir las librerias necesarias.

Las funciones que necesiten mostrar información en la pantalla, ahora solamente harán uso de una función global
para poder renderizar el contenido deseado.

Aparte, se implemento una función para cargar todos los archivos
de las librerias de una manera mucho más rápida y eficiente.

Solamente los archivos que sean unicos de ese modulo, se seguirán cargando de la manera normal como se hacia previamente.

`basic_includes();`
`drupal_add_js($ruta_lib . 'modulos/clientes/js/clientes.js');`
`drupal_add_js($ruta_lib . 'modulos/clientes/js/ifvisible.js');`

En el caso de las funciones que necesiten tener alguna interacción con las bases de datos, la lógica ya no se manejará aquí,
sino en clases ubicadas dentro de las librerias. Dichas libreriras son especificamente utlizadas para realizar la lógica
de cada uno de los módulos.

* **class.clientes.php**

Clase con los métodos necesarios para generar vistas y realizar capturas a la base de datos.

* **class.reporte_clientes.php**

Clase utilizada para generar el panel principal del módulo de Clientes.

Ahora el reporte de clientes utiliza unas funciones de ayuda, una función para generar la paginación, y otra función
para permitir ordenar por columnas. Dichas funciones están en una clase llamada `class.sys_tools.php`

* **clientes.js**

Se mejoraron las funciones de `reporte_base()`, ahora no se tendrán los problemas de pasar correctamente los parametros.
Para ello, se implemento un uso de una variable global de opciones, la cual será modificada por cada uno de las diferentes
funciones que involucran el reporte_base, como por ejemplo, la paginación o el ordenamiento de columnas.

Ahora, se estará actualizando el reporte cada cierta cantidad de tiempo predefinida, y para mejorar el rendimiento y
no aumentar el consumo de datos, se actualizará el reporteador única y exclusivamente cuando el usuario esté dentro
del panel de clientes, en esa ventana.

```javascript
var r_options = {
        pagination: {
            page: 1
        },
        sort: {
            order: 'ASC',
            sort_by: 'nombre_cliente'
        },
        automatic_update: 1,
        updating: 0,
    };
```

Las opciones generales que utilizará el reporte base. En el caso de `sort` -> `sort_by` se necesita poner el nombre exactamente
igual al cual pertenece esa columna en la base de datos, de otra manera, no funcionará. La variable de opciones se crea con valores
por defecto, de los cuales, la mayoria se estarán actualizando dependiendo del uso del sistema.

Ahora todas las funciones para capturar datos funcionarán solamente con el método `POST`.

Se tendrá la opción de cancelar a los clientes, y en caso de ser necesario, se podrá deshacer esa decisión durante un corto
periodo de tiempo.

Se agregó la forma de deshabilitar el botón de submit al primer click, para prevenir que se guarde varias veces devido a multiples clicks por parte del usuario. Para ello, se hará uso del Plugin de PartnersPlugin

```javascript
var btn = $(this).find('button[type="submit"]');
btn.partnersBtnControl('start');
```

* * *

* ### Pendientes

* **partners.pendientes.inc**

Se mejoró el User Experience en general, para hacer más agradable a la vista y manteniendo siempre
la consistencia de colores que se manejan en todo el sistema.
Al igual que con los demás modulos, se hará uso de composer para un autoload de las librerias necesarias. Se sigue trabajando con una misma estructura en todos los archivos `.inc`
la cual consiste en usar este archivo solamente para acceder a los métodos de las clases en las cuales se manejan toda la lógica
y conexiones a la base de datos. Aparte de eso se tiene la función para renderizar los templates necesarios.

* **class.pendientes.php**

Clases con los métodos utilizados para hacer consultas a bases de datos.

* **pendientes.js**

Se trabaja todo dentro de este archivo. Se implemento en comparación de la versión anterior, la posibilidad de poder acceder al objeto del calendario desde
aquí y no desde otro archivo en especifico. Se mejoró el buscador de clientes y aparte ahora se implemento un nuevo seleccionador de fechas
que funciona más fácil y eficiente que el predeterminado del navegador.

* **pendientes_cancellation.js**

Archivo utilizado para manejar todo lo relacionado con el control de las solicitudes de cancelación
de pendientes.
* * *

* ### Servicios

* **partners.servicios.inc**

Se mejoró mucho en base a su versión anterior, se siguio trabajando de la misma
forma que en los otros modulos.inc. Sus cambios más notables son la apariencia de
tanto el reporteador como el formulario para registrar, ahora son mucho más
claros y ordenados, además de que se da la opción de deshacer la acción de borrar el servicio
por un tiempo determinado en caso de que se cometa un error.

* **class.servicios.php**

Clase con toda la lógica para el módulo de servicios, tanto consultas como para generar
las vistas de reporte, pero solamente la lógica (las vistas en si se generan en un tempalte).
Cada acción al igual que los otros módulos, queda registrada en el log de parters.

* **servicios.js*

Archivo con todo el javascript necesario para el módulo, tanto para al momento de
registrar así como para el reporteador.

* * *

* ### Caja

La funcionalidad de este módulo sigue siendo la misma que el anterior,
solamente se hicieron cambios notables en la apariencia y en el código, asi como
el estatus de control de las salidas de dinero que deben de ser autorizadas exclusivamente
por un supervisor.

* * *

* ### Mercancia

Se mejoró la apariencia en base a su versión anterior, siendo ahora todo mucho más claro y
accesible, detro de los cambios más notables está el de la vínculación de los registros de
centro de servicio con las salidas de almacén, la vinculación con los reportes de servicios para
los usuarios de Soporte y CCTV, una nueva forma más ordenada de ver los vales, ahora siendo en pdf
y mucho más ordenados. También mejoró el filtrado de los registros, así como el control del
reporteador en general.

* * *

* ### Centro de Servicio

Se mejoró el uso en general y la apariencia respecto a su versión anterior, se corrigieron varios
errores que se ocasionaban al momento de capturar y dar seguimiento a un registro, más información en
la descripción de la versión v0.6.-alpha de este repositorio.

* * *

* ### Renovaciones

Se mejoró el uso en general del módulo al igual que su apariencia, el formulario para capturar
ahora es mas compacto y claro que la versión anterior. Se eliminó la columna de ver renovación, ahora
para ver una renovación se hará click en cualquier lugar del renglón que no sea un estatus de control.
Se mantienen todas las relaciones que tenia con los pendientes que las renovaciones creaban y lo que sucedia
al momento de finalizar dichos pendientes. Se mejoró la forma de editar los datos de la renovación. Se corrigieron
unos errores que salian al momento de enviar los recordatorios automáticos por correo, ahora ya salen correctamente los
correos del creador de la renovación, esto es para que si los clientes llegan a responder al correo de recordatorio
que les llego, les llegue al usuario que creó la renovación, y no se quede en renovaciones@partnersinterno.com y haga un
solo forward.

* * *

* ### Cotizaciones

Se mejoró el uso en general del módulo al igual que su apariencia, se mejoró el formulario para capturar una nueva
cotización y también se mejoró el uso del reporteador, eliminando la columna de ver cotización, y ahora
se tendrá que dar click en el renglón para ver la cotización. Se mejoró la rápidez con la que se interactua
con los estatus de control simples (Si/No). Se sigue manteniendo todas las relaciones que tenia este módulo con
el de renovaciones, se pueden crear cotizaciones desde una renovación en especifico. Se agregó un body
al email que envia las cotizaciones, para que no salgan los correos solamente con el pdf de la cotización, sino que ahora
ya contienen un body en el mensaje del correo, aparte de que los correos con los que se envian ahora pertenecen
al correo del usuario, para que cuando el cliente responda una cotización por correo, le llegue directamente la respuesta al
creador de la cotización.

* * *

* ### Recibos Dinero

Se mejoró el uso del módulo en general, como en  la forma de ingresar un nuevo registro, también en el control en general del reporteador. Se
corrigieron algunos errores que permitian que usuarios cancelaran registros mientras no deberian. Se mejoró el estatus de reenviar
recibo tanto como el de cancelar recibo. Se elimino la columna de ver, poniendo la función para ver el recibo en un click dentro del tr.

* * *

* ### Solicitud Factura Cliente

Misma funcionalidad que la versión anterior, solamente se mejoró visualmente el formulario.

* * *

* ### Proyectos Web

Misma funcionalidad que la versión anterior, solamente se mejoró visualmente el formulario y el reporteador se completo, antes no funcionaba la columna de
costo y eliminar.

* * *

* ### Proyectos CCTV

Misma funcionalidad que la versión anterior, se solucionaron errores al momento de capturar una nueva cotización y después convertirla. También se
mejoró el control del reporteador, y se agregó la opción para eliminar los proyectos.

* * *

* ### Seguimiento de Facturas

Módulo sencillo utilizado para tener un registro de todos los pagos que se realizan por medio de factura en los paneles de administración.

* * *

* ### Cobranza

Módulo con conexiones a la base de datos interna de Administración utilizado para tener un control de información
más sencillo y aparte poder capturar observaiones.

* * *

* ### Reporte de Ventas

Módulo con conexiones a la base de datos interna de Administración, utilizado para presentar mejor la información y tener contorl
sobre algunos estatus para después poder trabajar la información en excel.
